@extends('layouts.app')
@push('meta')
    <title>{{ "$website_title | Информация о нашем сайте" }}</title>
    <meta name="description" content="{{ "$website_title помогает вам в ваших стратегиях инвестирования в криптовалюту. Благодаря нашим передовым инструментам и комплексной поддержке, вы достигнете своих торговых целей." }}" />
@endpush
@section('content')
<section class="banner">
    <div class="container">
        <h1 class="banner-title display-4 fw-bold text-center mb-4">{{aiTrans('О сайте')}} {{$website_title}}</h1>
        <h2 class="banner-desc display-7 text-center mb-5"></h2>
    </div>
</section>

<section class="py-5">
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <h2 class="display-5 fw-bold mb-4"> {{$website_title}} {{aiTrans('Команда')}}</h2>
                <div>
                    <p>{{aiTrans('Наш этос в')}} <a href="{{route('home',$country)}}" class="text-secondary"> {{$website_title}}</a> {{aiTrans('основан на принципе финансовой демократизации. Мы отстаиваем право каждого человека на доступ к тем же путям накопления богатства, которые исторически были игровой площадкой для богатых и опытных инвесторов.',$locale,['website_title'=>$website_title])}}</p>
                    <p>{{aiTrans('К сожалению, традиционные способы финансирования не протягивают свой приветственный коврик среднестатистическому инвестору. Навигация в мире традиционных инвестиций требует значительного уровня знаний. Более того, порог входа часто устанавливается высоким с предварительными требованиями к солидному капиталу.',$locale,['website_title'=>$website_title])}}</p>
                    <p>{{aiTrans('В основе криптовалютной революции лежит стремление преодолеть экономический разрыв. Тем не менее, устоявшиеся методы участия в криптовалюте продолжают создавать барьеры для обычного инвестора. Процесс приобретения и защиты цифровых активов через эти ортодоксальные каналы не только громоздкий, но и чреват опасностями.')}}</p>
                    <p>{{aiTrans('Для тех, кто хочет использовать дикие колебания криптовалютного рынка, традиционные спекулятивные стратегии могут быть пугающими. Такая торговля волатильностью организуется через нишевых финансовых посредников и, как правило, включает в себя сложные инструменты, такие как контракты на разницу цен (CFD).')}}</p>
                </div>
            </div>
            <div class="col-md-4 d-flex align-items-center">
                <picture>
                    <source srcset="{{asset('frontend/assets/ru')}}/dist/images/412_459__459_65e737bb03f05_about-half-1.webp" type="image/webp">
                    <source srcset="{{asset('frontend/assets/ru')}}/dist/images/_459_65e737bb03f05_about-half-1.webp" type="image/webp">
                    <img src="{{asset('frontend/assets/ru')}}/dist/images/_459_65e737bb03f05_about-half-1.webp" loading="lazy" width="459" height="412" alt="">
                </picture>
            </div>
        </div>
    </div>
</section>


<section class="py-5">
    <div class="container">
        <div class="row flex-md-row flex-column-reverse ">
            <div class="col-md-4 d-flex align-items-center">
                <picture>
                    <source srcset="{{asset('frontend/assets/ru/dist/images/_459_65e737dd92d14_about.webp')}}" type="image/webp">
                    <source srcset="{{asset('frontend/assets/ru/dist/images/_459_65e737dd92d14_about.webp')}}" type="image/webp">
                    <img src="{{asset('frontend/assets/ru/dist/images/_459_65e737dd92d14_about.webp')}}" loading="lazy" width="459" height="234" alt="">
                </picture>
            </div>
            <div class="col-md-8">
                <h2 class="display-5 fw-bold mb-4">{{aiTrans('Как мы обеспечиваем финансовую доступность')}}</h2>
                <div>
                    <p> {{$website_title}} {{aiTrans('упрощает искусство спекуляций криптовалютой, открывая двери для среднего инвестора, чтобы быстро встать на ноги и замахнуться на заборы. Наш набор инструментов позволяет вам усилить свои усилия по анализу рынка.')}}</p>
                    <p>{{aiTrans('С помощью этих ресурсов вы сможете создавать надежные стратегии, справляться с рисками, присущими торговле, и укреплять свой портфель за счет разумного реинвестирования. Свидетельства бесчисленных трейдеров являются свидетельством эффективности наших инструментов в их завоеваниях цифровой валюты.')}}</p>
                    <p>{{aiTrans('Наше стремление улучшить ваш торговый опыт непоколебимо; Мы постоянно стремимся использовать дополнительные ресурсы, чтобы ваше путешествие на криптовалютный рынок с платформой [website_title] было столь же полезным, сколь и захватывающим.',$locale,['website_title'=>$website_title])}}</p>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="banner">
    <div class="container">
        <h1 class="banner-title display-4 fw-bold text-center mb-4">{{aiTrans('Прокладывая путь к всеобщему обучению')}}</h1>
        <div class="text-center">
            <p> {{$website_title}} {{aiTrans('является свидетельством веры в то, что богатство инвестиционного образования должно быть доступно каждому. Благодаря приверженности новичкам, спектру языков и людям, заботящимся о своих финансах, платформа [website_title] сияет как навигационный свет в бескрайних морях инвестиционной мудрости. Его миссия состоит в том, чтобы дать пользователям глубокое понимание основных принципов инвестирования, гарантируя, что 2024 станет годом финансового просвещения. Изучите приложение [website_title], углубитесь в обзор [website_title] и посетите официальный веб-сайт [website_title] для беспрецедентного обучения.',$locale,['website_title'=>$website_title])}}</p>
        </div>

        <div class="text-center mt-3 mt-md-4 mb-4 mb-md-0">
            <button class="show-modal btn btn-primary text-white btn-lg shadow-lg px-3 px-md-5 fs-4">{{aiTrans('Подробнее')}}</button>
        </div>
    </div>
</section>
@endsection
