@extends('layouts.app')
@push('meta')
    <title>{{ "$website_title | Informações do site" }}</title>
    <meta name="description" content="{{ "Aprenda como $website_title te auxilia a aprimorar suas capacidades de investimento em criptoativos. Disponibilizamos ferramentas de ponta e total suporte." }}" />
@endpush
@section('content')
<div class="what-is w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/what-is-img.webp"  sizes="(max-width: 991px) 100vw, (max-width: 2870px) 50vw, 1435px" alt="{{$website_title}}  - O que exatamente é negociação on-line?" class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h1 class="about-title">{{aiTrans('Sobre nós')}}</h1>
        <h2 class="about-subtitle">{{aiTrans('O que exatamente é negociação on-line?')}}</h2>
        <p>{{aiTrans('A negociação online começou em 1971, quando o primeiro software de negociação, a National Association of Securities Dealers Automated Quotations (NASDAQ), foi lançado como o primeiro software de negociação online. Hoje em dia, a negociação online é o método mais popular de realizar a compra e venda de diversos ativos financeiros, como Forex, criptomoedas, ações, commodities e até contratos por diferenças (CFDs).')}}</p>
        <p>
            
            {{ aiTrans(
                "Com base nisso, nasceu o [website_title] .",
                $locale,
                ['website_title' => $website_title],
            ) }}</p>
        <p>{{aiTrans('O software de negociação poderoso e intuitivo é capaz de aproveitar as pequenas diferenças de preço das moedas digitais entre as diferentes bolsas. Em seguida, ele comprará criptos a um preço baixo e depois os venderá a um preço mais alto. O resultado final são pequenas quantias de lucro que resultam em grandes lucros para o usuário.')}}</p>
        <div class="button-wrapper margin-top-30">
            <a href="{{route('home',$country)}}#formTop" class="button w-button">{{aiTrans('Assista o vídeo')}}</a>
        </div>
    </div>
    <div class="what-is-bg-1"></div>
</div>

<div class="how-it-working wf-section">
    <div class="container w-container">
        <div class="how-it-working-text">
            
            {{ aiTrans(
                "As criptomoedas são ativos altamente voláteis e é importante tomar boas decisões ao negociá-las. É disso que se trata o [website_title] . O poderoso aplicativo garante que os investidores criptográficos possam acessar informações rápidas e relevantes ao negociar suas moedas e tokens favoritos no mercado. Dessa forma, eles podem acompanhar as melhores oportunidades nos mercados de criptomoedas e tomar decisões de negociação precisas e informadas o tempo todo. [website_title] basicamente garante que nenhum investidor cripto negocie cegamente. O aplicativo permite que você negocie com confiança e aproveite ao máximo sua atividade comercial.",
                $locale,
                ['website_title' => $website_title],
            ) }}</div>
    </div>
</div>

<div class="our-team w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/our-team-img.webp"  sizes="(max-width: 991px) 100vw, 50vw" alt="{{$website_title}}  - Equipe {{$website_title}} " class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h2 class="our-team-title">
            {{ aiTrans(
                "Equipe [website_title] ",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <p>
            {{ aiTrans(
                "A equipe [website_title]  consiste em profissionais de negociação dedicados que desejam fornecer às pessoas comuns, assim como você, a oportunidade de negociar Bitcoins e outras criptomoedas de forma eficaz e lucrativa. A equipe combinou seu conhecimento e experiência para criar uma solução de software de negociação capaz de escanear fácil e rapidamente as diferentes trocas de criptomoedas e identificar oportunidades lucrativas de negociação. Todo o processo foi automatizado, permitindo que qualquer pessoa negocie e obtenha sua fatia desse bolo lucrativo.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
        <p>
            {{ aiTrans(
                "O [website_title]  oferece muitos benefícios e vantagens e sempre nos comprometemos a contribuir positivamente para sua experiência comercial e jornada financeira.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
        <div class="button-wrapper margin-top-30">
            <a href="{{route('home',$country)}}#formTop" class="button w-button">{{aiTrans('Registrar agora')}}</a>
        </div>
    </div>
</div>
<div class="our-advantage w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/advantage-img.webp"  alt="{{$website_title}}  - Aproveite os mercados de criptografia e ganhe com o {{$website_title}} " class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h2 class="our-advantage-title">
            {{ aiTrans(
                "Aproveite os mercados de criptografia e ganhe com o [website_title] ",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <p>
            {{ aiTrans(
                "Na [website_title] , queremos ajudá-lo a alcançar a liberdade financeira e, à medida que o mercado de criptomoedas cresce e se desenvolve, não há dúvida de que mais oportunidades de negociação surgirão. Isso simplesmente significa mais lucros para você.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
        <p>
            {{ aiTrans(
                "Assuma o controle de seu futuro hoje e inscreva-se com o [website_title] . Seu sucesso mudará sua vida. Inscreva-se agora para sua conta gratuita agora e entre na ação de negociação hoje!",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
    </div>
</div>
@endsection
