@extends('layouts.app')
@push('meta')
    <title>{{ "$website_title | Tietoja sivustostamme" }}</title>
    <meta name="description" content="{{ "Kehitä kryptosijoitusstrategioitasi $website_title palvelun avulla. Tarjoamme laadukkaita työkaluja ja tukea kaupankäyntitaitojesi hiomiseen." }}" />
@endpush
@section('content')

    <!-- Hero -->
    <section class="uk-section uk-section-large hero-section">
        <div class="uk-container hero-container">
            <div class="hero-inner hero-about">

                <div class="uk-flex-middle" uk-grid>

                    <div class="uk-width-expand@s">
                        <div class="hero-meta">
                            <h1>{{ aiTrans('Lue lisää [website_title]:sta ja sen uusimmasta [website_title]-versiosta.', $locale, ['website_title' => $website_title]) }}
                            </h1>
                            <p class="desc">
                                {{ aiTrans('Astu dynaamiseen keskukseen, jossa kaiken tasoiset kauppiaat viihtyvät. Panemme etusijalle sen, että jokaiselle osallistujalle tarjotaan keskeistä tietoa, innovatiivisia taktiikoita ja hoitava yhteisö.') }}
                            </p>
                            <p class="desc">
                                {{ aiTrans('Astu dynaamiseen keskukseen, jossa kaiken tasoiset kauppiaat viihtyvät. Panemme etusijalle sen, että jokaiselle osallistujalle tarjotaan keskeistä tietoa, innovatiivisia taktiikoita ja hoitava yhteisö.') }}
                            </p>
                        </div>
                    </div>


                    <div class="uk-width-auto@s order-1">
                        <div class="hero-form">
                            <h3>{{ aiTrans('Tutustu alustaan – Ilmainen rekisteröinti') }}</h3>
                            @include('frontend.fi.components.form')
                        </div>
                    </div>

                </div>


            </div>
        </div>
        <div class="gb-shape gb-shape-1"><svg class="shape shape-bottom" xmlns="http://www.w3.org/2000/svg"
                viewBox="0 0 1200 350" preserveAspectRatio="none">
                <path d="M1200 336.7V350H0V0s22.4 276.4 1200 336.7z"></path>
            </svg></div>
    </section>

    <section class="uk-section">

        <div class="gb-shape gb-shape-1"><svg class="shape shape-top shape80 shapew" xmlns="http://www.w3.org/2000/svg"
                viewBox="0 0 1200 211.2" preserveAspectRatio="none">
                <path d="M600 188.4C321.1 188.4 84.3 109.5 0 0v211.2h1200V0c-84.3 109.5-321.1 188.4-600 188.4z"></path>
            </svg></div>

        <div class="uk-container">

            <div class="uk-text-center">
                <h2>Paranna kaupankäyntikokemustasi</h2>
                <p>Dynaamisessa yhteisössämme on erityisiä mahdollisuuksia olla vuorovaikutuksessa kokeneiden kauppiaiden ja
                    alan tärkeiden henkilöiden kanssa. He jakavat innokkaasti syvällistä tietoa ja asiantuntemusta, jota on
                    jalostettu useiden vuosien aikana rahoitusmarkkinoiden monimutkaisilla alueilla.</p>
            </div>

            <div class="garbox-2 uk-child-width-1-1 uk-child-width-1-2@s uk-child-width-1-4@m uk-text-center uk-margin-medium-top uk-grid-large"
                uk-grid>

                <div>
                    <div class="gar-box gar-active">
                        <h3>Asiantuntemusta palveluksessasi</h3>
                        <p>Nauti välittömästä yhteydestä osaaviin kauppiaisiin ja alan ammattilaisiin.</p>
                    </div>
                </div>

                <div>
                    <div class="gar-box">
                        <h3>Triumphille suotuisa ilmapiiri</h3>
                        <p>Suunniteltu parantamaan kauppiaan saavutuksia.</p>
                        <br>
                    </div>
                </div>

                <div>
                    <div class="gar-box">
                        <h3>Runsaat resurssit</h3>
                        <p>Valikoima opetusmateriaaleja ja -välineitä.</p>
                        <br>
                    </div>
                </div>

                <div>
                    <div class="gar-box">
                        <h3>Tukiverkko</h3>
                        <p>Yhteistyötä ja kasvua edistävä yhteisö.</p>
                        <br>
                        <br>
                        <br>
                    </div>
                </div>

            </div>

            <div class="uk-text-center uk-margin-medium-top">
                <p>Menetelmämme peruslähtökohta on tarjota kattava tukikehys. Olemme laajempia kuin pelkät oivallukset ja
                    strategiat, ja tarjoamme räätälöidyn kokoelman resursseja, jotka täyttävät eri kauppiaiden vaatimukset.
                    Palvelumme vaihtelevat laajoista koulutussisältötietokannoista, joissa keskitytään erilaisiin
                    kaupankäyntitaktiikoihin, huipputason analyysityökaluihin.</p>
                <a class="cu-button" href="{{ route('home', $country) }}"><strong>Sukella sisään</strong></a>
            </div>

        </div>
    </section>
    <div class="uk-container">

        <div class="uk-text-center">
            <h2>{{ aiTrans('Paranna kaupankäyntikokemustasi') }}</h2>
            <p>{{ aiTrans('Dynaamisessa yhteisössämme on erityisiä mahdollisuuksia olla vuorovaikutuksessa kokeneiden kauppiaiden ja alan tärkeiden henkilöiden kanssa. He jakavat innokkaasti syvällistä tietoa ja asiantuntemusta, jota on jalostettu useiden vuosien aikana rahoitusmarkkinoiden monimutkaisilla alueilla.') }}
            </p>
        </div>

        <div class="garbox-2 uk-child-width-1-1 uk-child-width-1-2@s uk-child-width-1-4@m uk-text-center uk-margin-medium-top uk-grid-large"
            uk-grid>

            <div>
                <div class="gar-box gar-active">
                    <h3>{{ aiTrans('Asiantuntemusta palveluksessasi') }}</h3>
                    <p>{{ aiTrans('Nauti välittömästä yhteydestä osaaviin kauppiaisiin ja alan ammattilaisiin.') }}</p>
                </div>
            </div>

            <div>
                <div class="gar-box">
                    <h3>{{ aiTrans('Triumphille suotuisa ilmapiiri') }}</h3>
                    <p>{{ aiTrans('Suunniteltu parantamaan kauppiaan saavutuksia.') }}</p>
                    <br>
                </div>
            </div>

            <div>
                <div class="gar-box">
                    <h3>{{ aiTrans('Runsaat resurssit') }}</h3>
                    <p>{{ aiTrans('Valikoima opetusmateriaaleja ja -välineitä.') }}</p>
                    <br>
                </div>
            </div>

            <div>
                <div class="gar-box">
                    <h3>{{ aiTrans('Tukiverkko') }}</h3>
                    <p>{{ aiTrans('Yhteistyötä ja kasvua edistävä yhteisö.') }}</p>
                    <br>
                    <br>
                    <br>
                </div>
            </div>

        </div>

        <div class="uk-text-center uk-margin-medium-top">
            <p>{{ aiTrans('Menetelmämme peruslähtökohta on tarjota kattava tukikehys. Olemme laajempia kuin pelkät oivallukset ja strategiat, ja tarjoamme räätälöidyn kokoelman resursseja, jotka täyttävät eri kauppiaiden vaatimukset. Palvelumme vaihtelevat laajoista koulutussisältötietokannoista, joissa keskitytään erilaisiin kaupankäyntitaktiikoihin, huipputason analyysityökaluihin.') }}
            </p>
            <a class="cu-button" href="{{ route('home', $country) }}"><strong>{{ aiTrans('Sukella sisään') }}</strong></a>
        </div>

    </div>


    <section class="uk-section sec6 sec6-e">
        <div class="uk-container">

            <div class="uk-text-center uk-margin-medium-bottom">
                <h2 class="uk-text-white">
                    {{ aiTrans('Miksi valita [website_title] ?', $locale, [
                        'website_title' => $website_title,
                    ]) }}
                    </h2>
                <p>{{aiTrans('Osallistuminen kaupankäyntiverkostoomme tarjoaa lukuisia näkymiä. Saat arvokasta tietoa, monipuolisia
                    näkökulmia ja kannustavan ympäristön, jossa keskitytään edistämään kehitystäsi. Keskustele kokeneiden
                    kauppiaiden kanssa, laajenna ymmärrystäsi ja paranna kaupankäyntikokemustasi kanssamme.')}}</p>
                <a class="cu-button" href="{{ route('home', $country) }}"><strong>Tule kyytiin!</strong></a>
            </div>

        </div>
    </section>

    <section class="uk-section sec99">
        <div class="uk-container">

            <div class="uk-text-center uk-margin-medium-bottom">
                <h2>
                    {{ aiTrans('[website_title] esittelee loputtomat sijoitusmahdollisuudet: Laaja kirjo omaisuuseriä
                    harkittavaksesi', $locale, [
                        'website_title' => $website_title,
                    ]) }}
                    </h2>
                <p class="gfa">{{aiTrans('Uppoudu laajaan ja dynaamiseen kaupankäyntiuniversumiin osoitteessa')}} <a
                        href="{{ route('home', $country) }}">{{ $website_title }}</a>

                        {{ aiTrans(', jossa laaja valikoima varoja
                    odottaa
                    sitoutumistasi. Alustamme on räätälöity palvelemaan kaikentyyppisiä sijoittajia, aina niistä, jotka
                    suosivat perinteisiä sijoituskohteita, kuten osakkeita ja hyödykkeitä, niihin, jotka haluavat tutustua
                    uusimpiin rahoitusinnovaatioihin, kuten kryptovaluuttoihin ja CFD:hen. Olivatpa tavoitteesi sitten
                    varallisuuden luominen, salkun laajentaminen tai monimutkaisten kaupankäyntistrategioiden toteuttaminen,
                    [website_title] tarjoaa sinulle tarvittavat työkalut ja resurssit sijoitustavoitteidesi
                    saavuttamiseksi. Aseistettuna huippuluokan kaupankäyntialgoritmeilla, reaaliaikaisella data-analyysillä
                    ja vankalla tukirakenteella varmistamme, että sinulla on kaikki mitä tarvitset kukoistamaan jatkuvasti
                    kehittyvässä kaupankäyntiympäristössä. Liity meihin [website_title] ja vapauta täysi
                    kaupankäyntipotentiaalisi jo tänään.', $locale, [
                        'website_title' => $website_title,
                    ]) }}
                        
                </p>
                <p>
                    {{ aiTrans('[website_title] on iloinen voidessaan tarjota saumattoman ja intuitiivisen kaupankäyntikokemuksen
                    sekä aloittelijoille että kokeneille kauppiaille. Omistautumisemme kaupankäynnin onnistumiselle näkyy
                    jatkuvassa tuessa ja kattavissa koulutusmateriaaleissa, jotka on kehitetty lisäämään kaupankäynnin
                    taitojasi ja luottamustasi.', $locale, [
                        'website_title' => $website_title,
                    ]) }}
                    
                </p>
            </div>

            <div class="garbox-2 garbox-3 uk-child-width-1-1 uk-child-width-1-2@s
uk-text-center uk-margin-medium-top uk-grid-large"
                uk-grid>

                <div>
                    <div class="gar-box">
                        <h3><span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img"
                                    height="1em" width="1em" viewBox="0 0 448 512">
                                    <path fill="currentColor"
                                        d="M400 480H48c-26.51 0-48-21.49-48-48V80c0-26.51 21.49-48 48-48h352c26.51 0 48 21.49 48 48v352c0 26.51-21.49 48-48 48zm-204.686-98.059l184-184c6.248-6.248 6.248-16.379 0-22.627l-22.627-22.627c-6.248-6.248-16.379-6.249-22.628 0L184 302.745l-70.059-70.059c-6.248-6.248-16.379-6.248-22.628 0l-22.627 22.627c-6.248 6.248-6.248 16.379 0 22.627l104 104c6.249 6.25 16.379 6.25 22.628.001z">
                                    </path>
                                </svg></span>{{aiTrans('Osakkeet')}}</h3>
                        <p>{{aiTrans('Paranna salkkuasi sijoittamalla varoja Applen ja Amazonin kaltaisten huippuyritysten osakkeisiin.
                            Osakkeiden omistaminen on kuin omistaisit osan näistä kukoistavista yrityksistä, mikä voi johtaa
                            varallisuuden kasvuun, kun ne menestyvät ja tuottavat voittoa.')}}</p>
                    </div>
                </div>

                <div>
                    <div class="gar-box">
                        <h3><span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img"
                                    height="1em" width="1em" viewBox="0 0 448 512">
                                    <path fill="currentColor"
                                        d="M400 480H48c-26.51 0-48-21.49-48-48V80c0-26.51 21.49-48 48-48h352c26.51 0 48 21.49 48 48v352c0 26.51-21.49 48-48 48zm-204.686-98.059l184-184c6.248-6.248 6.248-16.379 0-22.627l-22.627-22.627c-6.248-6.248-16.379-6.249-22.628 0L184 302.745l-70.059-70.059c-6.248-6.248-16.379-6.248-22.628 0l-22.627 22.627c-6.248 6.248-6.248 16.379 0 22.627l104 104c6.249 6.25 16.379 6.25 22.628.001z">
                                    </path>
                                </svg></span>ETF:t</h3>
                        <p>{{aiTrans('Pörssinoteeratut rahastot (ETF) toimivat osakkeiden tavoin, mutta ne sisältävät erilaisia
                            omaisuuseriä salkun hajauttamiseksi. Trade 500 Intal tarjoaa pääsyn laajaan valikoimaan
                            maailmanlaajuisia ETF-rahastoja, mukaan lukien eurooppalaiset, aasialaiset ja yhdysvaltalaiset
                            ETF-rahastot.')}}</p>
                    </div>
                </div>


                <div>
                    <div class="gar-box">
                        <h3><span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img"
                                    height="1em" width="1em" viewBox="0 0 448 512">
                                    <path fill="currentColor"
                                        d="M400 480H48c-26.51 0-48-21.49-48-48V80c0-26.51 21.49-48 48-48h352c26.51 0 48 21.49 48 48v352c0 26.51-21.49 48-48 48zm-204.686-98.059l184-184c6.248-6.248 6.248-16.379 0-22.627l-22.627-22.627c-6.248-6.248-16.379-6.249-22.628 0L184 302.745l-70.059-70.059c-6.248-6.248-16.379-6.248-22.628 0l-22.627 22.627c-6.248 6.248-6.248 16.379 0 22.627l104 104c6.249 6.25 16.379 6.25 22.628.001z">
                                    </path>
                                </svg></span>{{aiTrans('Futuurit')}}</h3>
                        <p>{{aiTrans('Futuurikaupan avulla voidaan ennustaa tulevia omaisuuserien hintoja. Tämä hienostunut valinta voi
                            vahvistaa monimutkaisia sijoitustaktiikoita.')}}</p>
                    </div>
                </div>

                <div>
                    <div class="gar-box">
                        <h3><span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img"
                                    height="1em" width="1em" viewBox="0 0 448 512">
                                    <path fill="currentColor"
                                        d="M400 480H48c-26.51 0-48-21.49-48-48V80c0-26.51 21.49-48 48-48h352c26.51 0 48 21.49 48 48v352c0 26.51-21.49 48-48 48zm-204.686-98.059l184-184c6.248-6.248 6.248-16.379 0-22.627l-22.627-22.627c-6.248-6.248-16.379-6.249-22.628 0L184 302.745l-70.059-70.059c-6.248-6.248-16.379-6.248-22.628 0l-22.627 22.627c-6.248 6.248-6.248 16.379 0 22.627l104 104c6.249 6.25 16.379 6.25 22.628.001z">
                                    </path>
                                </svg></span>{{aiTrans('Joukkovelkakirjalainat')}}</h3>
                        <p>{{aiTrans('Harkitse joukkovelkakirjalainoja, jotka ovat rahoitusalan luotettavia velkapapereita ja jotka
                            tuottavat tasaista sijoitustuottoa. Vaihteluiden lieventämiseksi hajauta optioilla.')}}</p>
                    </div>
                </div>
                <div>
                    <div class="gar-box">
                        <h3><span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img"
                                    height="1em" width="1em" viewBox="0 0 448 512">
                                    <path fill="currentColor"
                                        d="M400 480H48c-26.51 0-48-21.49-48-48V80c0-26.51 21.49-48 48-48h352c26.51 0 48 21.49 48 48v352c0 26.51-21.49 48-48 48zm-204.686-98.059l184-184c6.248-6.248 6.248-16.379 0-22.627l-22.627-22.627c-6.248-6.248-16.379-6.249-22.628 0L184 302.745l-70.059-70.059c-6.248-6.248-16.379-6.248-22.628 0l-22.627 22.627c-6.248 6.248-6.248 16.379 0 22.627l104 104c6.249 6.25 16.379 6.25 22.628.001z">
                                    </path>
                                </svg></span>{{aiTrans('ForEx')}}</h3>
                        <p>{{aiTrans('Kansainväliset valuuttamarkkinat (ForEx) tarjoavat mahdollisuuden vaihtaa maailmanlaajuisia
                            valuuttoja 24/7. Se mahdollistaa vivutetun kaupankäynnin, jolloin pienemmät sijoitukset voivat
                            hallita suurempia rahoituspositioita.')}}</p>
                    </div>
                </div>
                <div>
                    <div class="gar-box">
                        <h3><span class="gb-icon"><svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true"
                                    role="img" height="1em" width="1em" viewBox="0 0 448 512">
                                    <path fill="currentColor"
                                        d="M400 480H48c-26.51 0-48-21.49-48-48V80c0-26.51 21.49-48 48-48h352c26.51 0 48 21.49 48 48v352c0 26.51-21.49 48-48 48zm-204.686-98.059l184-184c6.248-6.248 6.248-16.379 0-22.627l-22.627-22.627c-6.248-6.248-16.379-6.249-22.628 0L184 302.745l-70.059-70.059c-6.248-6.248-16.379-6.248-22.628 0l-22.627 22.627c-6.248 6.248-6.248 16.379 0 22.627l104 104c6.249 6.25 16.379 6.25 22.628.001z">
                                    </path>
                                </svg></span>{{aiTrans('Kryptovaluutta lomakkeet')}}</h3>
                        <p>{{aiTrans('Tutustu kryptovaluuttojen, kuten Bitcoinin ja Ethereumin, dynaamiseen maailmaan. Nämä
                            digitaaliset varat tarjoavat turvallisia ja nopeita transaktioita, jotka mullistavat
                            rahoitusmaailman.')}}</p>
                    </div>
                </div>


            </div>

            <div class="uk-text-center uk-margin-medium-top">
                <p>
                    {{aiTrans('Kaupankäyntialustamme tarjoaa kattavan ja intuitiivisen kaupankäynnin useissa eri omaisuusluokissa. Sen
                    käyttäjälähtöinen muotoilu, tukevat työkalut ja laaja valikoima omaisuuseriä tekevät
                    sijoitustavoitteidesi mukaisen monipuolisen salkun rakentamisesta ja hallinnoinnista vaivatonta. Tutustu
                    eri omaisuusluokkien mahdollisuuksiin ja aloita kaupankäyntipotentiaalin hyödyntäminen nyt.')}}
                </p>
            </div>

        </div>
    </section>
@endsection
