@extends('layouts.app')
@push('meta')
    <title>{{ "$website_title | Πληροφορίες για τον ιστότοπό μας" }}</title>
    <meta name="description" content="{{ "Εξερευνήστε πώς το $website_title μπορεί να ενισχύσει την επενδυτική σας στρατηγική μέσα από τα προηγμένα εργαλεία του και την ολοκληρωμένη υποστήριξη του." }}" />
@endpush
@section('content')
    <section class="about-bg">
        <div class="container text-center" style="max-width: 1000px;">
            <h1 class="about-header white">
                {{ aiTrans(
                    'Σχετικά με το [website_title]',
                    $locale,
                    ['website_title' => $website_title],
                ) }}
                </h1>
        </div>
    </section>

    <section class="about-half-1">
        <div class="container">
            <div class="row">
                <div class="col-md-8">
                    <h2 class="title">
                        
                        {{ aiTrans(
                            'Η Ομάδα του [website_title]',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h2>
                    <p><b>{{aiTrans('Στους αντίστοιχους τομείς μας, αναρωτηθήκαμε πώς εξελίσσονταν τα πράγματα στη σφαίρα των
                            επενδύσεων. Σκεφτήκαμε επίσης πόσο αναζωογονητικό θα ήταν για τον χώρο των επενδύσεων να βιώσει
                            λογικότητα. Έτσι, ενώσαμε τις δυνάμεις μας με το πάθος να λύσουμε αυτά τα προβλήματα μέσω της
                            εκπαίδευσης.')}}</b></p>
                    <p>{{aiTrans('Γνωρίζουμε πόσο ισχυρή είναι η εκπαίδευση και πώς έχει βοηθήσει σε πολλές περιπτώσεις. Ήμασταν
                        βέβαιοι για το πόσο αποτελεσματικό εργαλείο θα ήταν για τη διαχείριση και τη σταδιακή εξάλειψη
                        συγκεκριμένων θεμάτων επενδύσεων.')}}</p>
                    <p>
                        {{ aiTrans(
                            'Για να γίνει αυτό, δημιουργήσαμε το [website_title]. Ο ιστότοπος αναδεικνύει τον όγκο της
                            εκπαίδευσης στις επενδύσεις και τους λόγους για τους οποίους οι άνθρωποι πρέπει να εκπαιδευτούν.
                            Δεδομένου ότι δεν είμαστε εκπαιδευτές, καταχωρίσαμε αρκετές επιδέξιες εταιρείες εκπαίδευσης στις
                            επενδύσεις. Το [website_title] λειτουργεί τώρα ως γέφυρα που συνδέει τους προοπτικούς μαθητές
                            επενδύσεων με εταιρείες εκπαίδευσης στις επενδύσεις.',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                    <p>{{aiTrans('Αυτές οι εταιρείες έχουν ένα αντίστροφο ρεκόρ που δεν έχει ανταγωνιστές και έχουν εκπαιδεύσει άτομα
                        που κάνουν θόρυβο στη βιομηχανία των επενδύσεων σήμερα.')}}</p>
                </div>
            </div>
        </div>
    </section>


    <section class="about-half-2">
        <div class="container">
            <div class="row">
                <div class="col-md-8 offset-md-4">
                    <h3 class="subtitle">
                        {{ aiTrans(
                            'ΠΟΥ ΒΡΙΣΚΕΤΑΙ ΤΟ [website_title] ΑΥΤΗΝ ΤΗΝ ΣΤΙΓΜΗ',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h3>
                    <p><b>
                        {{ aiTrans(
                            'Το [website_title] βρίσκεται σε σημείο όπου νιώθει ότι δεν έχει συνδέσει αρκετούς ανθρώπους
                            παρά τη σύνδεση χιλιάδων. Επομένως, προσπαθούμε συνεχώς να ενημερώσουμε περισσότερους ανθρώπους
                            για τον λόγο που πρέπει να γίνουν πληροφορημένοι για τις επενδύσεις και να τους συνδέσουμε με
                            την εταιρεία που μπορεί να το πραγματοποιήσει.',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </b></p>
                    <p>
                        {{ aiTrans(
                            'Θα συνεχίσουμε να καταχωρούμε περισσότερες εταιρείες εκπαίδευσης επενδύσεων για να βοηθήσουμε τους
                            ανθρώπους να μάθουν καλύτερα. Η ομάδα μας διασφάλισε ότι το [website_title] είναι εύκολο στην
                            πλοήγηση και θα συνεχίσει να προσθέτει περισσότερα χαρακτηριστικά και λειτουργίες για να βελτιώσει
                            την εμπειρία του χρήστη. Αυτό θα βοηθήσει σε έναν ταχύτερο διαδικασία εγγραφής και θα αυξήσει τον
                            αριθμό των εγγεγραμμένων μαθητών.',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>
        </div>
    </section>


    <section class="about-half-3">
        <div class="container">
            <div class="row">
                <div class="col-md-8">
                    <h3 class="subtitle">{{aiTrans('Η ΕΙΚΟΝΑ ΠΟΥ ΦΑΝΤΑΖΟΜΑΣΤΕ ΓΙΑ ΤΟ ΜΕΛΛΟΝ')}}</h3>
                    <p><b>
                        {{ aiTrans(
                            'Το [website_title] φαντάζεται ένα μέλλον όπου η βιομηχανία των επενδύσεων θα είναι γεμάτη με
                            έμπειρους ειδικούς αντί για ανθρώπους με ημίψητες γνώσεις. Προβλέπουμε έναν κόσμο όπου οι
                            άνθρωποι θα κάνουν τις σωστές προβλέψεις, θα κατανοούν τις τάσεις και τα μοτίβα επενδύσεων και
                            θα τα εφαρμόζουν αποτελεσματικά για τη διαχείριση των κινδύνων.',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </b></p>
                </div>
            </div>
            <div class="text-center mt-3 mt-md-4">
                <a href="{{ route('home', $country) }}" class="main-form-btn">{{aiTrans('ΕΓΓΡΑΦΕΙΤΕ ΔΩΡΕΑΝ')}}</a>
            </div>
        </div>
    </section>
@endsection
