@extends('layouts.app')

@push('meta')
    <title>{{ "$website_title $website_name | Über die Plattform" }}</title>
    <meta name="description" content="{{ "$website_title : Steigern Sie Ihr Kryptowährungsgeschäft dank unserer sorgfältig ausgewählten Tools und vielfältigen Informationsressourcen." }}" />
@endpush
@section('content')
    <section class="uk-section">
        <div class="uk-container">

            <h1 class="title-2 uk-text-center">{{ aiTrans('Über') }} <b>{{ $website_title }}</b> </h1>
            <div class="about__img">
                <img src="{{ asset('frontend/assets/de/dist') }}/images/about.webp" alt="">
            </div>
            <div class="uk-margin-medium-top" uk-grid>

                <div class="uk-width-2-5@s">
                    <h2 class="title-2">{{ aiTrans('Der Anfang von') }} <b class="accent">{{ $website_title }}</b></h2>
                    <p class="txt">
                        {{ aiTrans(
                            'Bei [website_title] haben wir uns immer als Innovatoren im Kryptomarkt gesehen, und unser Team
                            bringt Ihnen eine
                            Plattform, die
                            Dinge anders macht als alle anderen.',
                            $locale,
                            [
                                'website_title' => $website_title,
                            ],
                        ) }}
                    </p>
                </div>

                <div class="uk-width-expand@s">
                    <p>
                        {{ aiTrans(
                            'Wir haben mit dem Aufbau unserer Plattform begonnen, als wir eine Lücke im Markt sahen, in der wir den Krypto-Handel
                            für alle zugänglich machen wollten. Neben der Entwicklung von [website_title] sind wir leidenschaftliche Krypto-Enthusiasten und glauben an den Wert
                            der Blockchain-Technologie. Eines Tages wird sie die Welt wirklich revolutionieren, und wir hoffen, einen Beitrag dazu zu leisten.',
                            $locale,
                            [
                                'website_title' => $website_title,
                            ],
                        ) }}

                    </p>
                    <p>
                        {{ aiTrans('Nachdem wir den Markt gesehen haben und wie er sich verändert hat, glauben wir, dass die Zukunft des Krypto-Handels im Internet stattfinden wird. Wir arbeiten hart daran, sicherzustellen, dass Krypto wächst und für alle einen Wert darstellt.') }}
                    </p>
                </div>

            </div>

        </div>
    </section>


    <!-- holder -->
    <div class="holder">
        <div class="holder__content">
            <div class="holder__container">
                <div class="holder__body">
                    <h2 class="title-2">{{ aiTrans('Die Zukunft sieht vielversprechend aus') }}</h2>
                    <p class="txt">

                        {{ aiTrans(
                            'Bei [website_title] haben wir einen Punkt erreicht, an dem die Zukunft
                            vielversprechend aussieht. Wir können stolz sagen, dass sich unsere harte Arbeit ausgezahlt hat, und wir sehen viele Menschen, die die Plattform lieben, die wir entwickelt haben. Unser
                            Team kann es kaum erwarten, zu sehen, was als Nächstes passiert.',
                            $locale,
                            [
                                'website_title' => $website_title,
                            ],
                        ) }}
                        
                    </p>
                    <p>
                        {{ aiTrans('Einige unserer Ziele sind es, das Wissen über Kryptowährungen zu erweitern, damit die Menschen mit besserem Wissen handeln können. Dies gilt insbesondere für Anfänger, da wir ihnen helfen möchten, im Krypto erfolgreich zu sein.') }}
                    </p>
                    <p>
                        {{ aiTrans('Die Menschen über ihre Investitionen aufzuklären, ist eines unserer Ziele mit der Plattform. Wir möchten, dass die Menschen erfolgreich sind, und das tun wir, indem wir sie über ihre Möglichkeiten mit Kryptowährungen und deren Funktionsweise aufklären. Während wir die Menschen schulen, streben wir danach, an der Spitze unserer Branche zu bleiben.') }}
                    </p>
                    <p>
                        {{ aiTrans('Bitcoin hat weltweit an Popularität gewonnen, und wir möchten eines der Unternehmen sein, die zu dieser Revolution beitragen. Wir hoffen, die Plattform zu werden, die jeder sucht, um die Bewegung zu beobachten und profitable Trades zu machen.') }}
                    </p>
                </div>
            </div>
        </div>
        <div class="holder__image">
            <img src="{{ asset('frontend/assets/de/dist') }}/images/img-4.webp" alt="">
        </div>
    </div>

    <section class="uk-section uk-text-center">
        <div class="uk-container">

            <h2 class="title-2">
                {{ aiTrans(
                    '[website_title] Hält, was es verspricht',
                    $locale,
                    [
                        'website_title' => $website_title,
                    ],
                ) }}
                </h2>
            <p class="txt">
                {{ aiTrans(
                    'Bei [website_title] versprechen wir, transparent zu bleiben, genaue Daten bereitzustellen, praktisch zu bleiben und unsere Leidenschaft für',
                    $locale,
                    [
                        'website_title' => $website_title,
                    ],
                ) }}
                <br> {{aiTrans('Krypto, um eine großartige Handelsplattform zu bieten.')}}</p>
            <p class="center">
                {{ aiTrans(
                    'Wir unterscheiden uns darin, dass wir uns bemühen, das Beste im Krypto-Handel anzubieten, und wir streben an, ein unterstützendes und
                    integratives
                    Umfeld zu fördern, das Ihnen hilft, weiterhin über Kryptowährungen zu lernen. Im Gegensatz zu anderen Unternehmen, die zu viel versprechen
                    und
                    ihre Versprechen nicht einhalten, setzt [website_title] realistische Erwartungen, versucht jedoch immer, in allem, was es tut, mehr zu leisten.',
                    $locale,
                    [
                        'website_title' => $website_title,
                    ],
                ) }}
                </p>

            <a href="{{ route('home', $country) }}" class="btn uk-flex-inline">MEHR ERFAHREN</a>


        </div>
    </section>
@endsection
