@extends('layouts.app')
@push('meta')
    <title>{{ "$website_title - Ang Opisyal na (2025)" }}</title>
    <meta name="description" content="{{ "Tuklasin ang cutting-edge na automated trading platform, $website_title, na partikular na idinisenyo para sa cryptocurrency trading." }}" />
@endpush


@section('content')


<main class="content">
    <div class="main-section">
        <div class="container w-container">
            <div class="title-wrap">
                <h1 class="main-title">{{$website_title}}</h1>
                <h2 class="main-subtitle">
                   <span class="change-by-command">{{ "Matuto ng mga hindi kilalang kaalaman sa trading ng cryptocurrency sa $website_title" }}</span>
                    <br>
                </h2>
            </div>
            <div class="main-cols">
                <div class="video-col">
                    <div class="video-container">
                        <img class="main-image" src="{{ asset('frontend/assets/fil/dist') }}/images/poster_index.webp" width="884" height="442"
                            style="width: 100%; height: auto"
                            alt="
                            {{ aiTrans(
                                "[website_title] - Magrehistro ngayon at i-unlock ang iyong potensyal sa pangangalakal nang libre",
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            ">
                    </div>
                </div>
                <div class="form-col">
                    <div id="formTop" class="form-container">
                        <div class="form-title-box">
                            <h3 class="form-title">{{aiTrans('Magrehistro ngayon at i-unlock ang iyong potensyal sa pangangalakal nang libre')}}</h3>
                        </div>
                        <div class="form-box w-form-wrapper">
                            @include('frontend.fil.components.form')
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="container w-container">
            <div class="cols soft-cols">
                <div class="col-33">
                    <div class="soft">
                        <div class="soft-ico"><img loading="lazy" src="{{ asset('frontend/assets/fil/dist') }}/images/soft-ico-1.webp" width="24"
                                alt="
                                {{ aiTrans(
                                "[website_title] - Advanced na teknolohiya",
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                                "></div>
                        <h3 class="title soft-item-title">{{aiTrans('Advanced na teknolohiya')}}</h3>
                        <p class="p soft-p">
                            {{ aiTrans(
                                "Gamit ang kapangyarihan ng advanced na teknolohiya, binibigyang-daan
                                ng [website_title] ang mga mamumuhunan na i-maximize ang kanilang mga kita sa
                                pamamagitan ng pagtuklas ng maraming pagkakataon sa loob ng merkado ng
                                cryptocurrency. Sa aming tuluy-tuloy na pagsasama ng Virtual Private Server (VPS) na
                                teknolohiya, ang mga signal ng kalakalan ay naisasagawa nang walang kamali-mali.",
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                    </div>
                </div>
                <div class="col-33">
                    <div class="soft">
                        <div class="soft-ico"><img loading="lazy" src="{{ asset('frontend/assets/fil/dist') }}/images/soft-ico-2.webp" width="24"
                                alt="
                                {{ aiTrans(
                                "[website_title] - Award-winning na software",
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                                "></div>
                        <h3 class="title soft-item-title">{{aiTrans('Award-winning na software')}}</h3>
                        <p class="p soft-p">
                            {{ aiTrans(
                                "Kinikilala bilang nangungunang cryptocurrency trading software,
                                nag-aalok ang [website_title] ng komprehensibong pagsusuri at nagpapatupad ng mga
                                signal ng trading na lubos na kumikita. Ang aming software ay nagsasama ng mga
                                makabagong pag-andar na nagpapahusay sa kakayahang kumita para sa mga mamumuhunan.",
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                        </p>
                    </div>
                </div>
                <div class="col-33">
                    <div class="soft">
                        <div class="soft-ico"><img loading="lazy" src="{{ asset('frontend/assets/fil/dist') }}/images/soft-ico-3.webp" width="24"
                                alt="
                                {{ aiTrans(
                                "[website_title] - Mataas na seguridad",
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                                "></div>
                        <h3 class="title soft-item-title">{{aiTrans('Mataas na seguridad')}}</h3>
                        <p class="p soft-p">
                            {{ aiTrans(
                                "Sa [website_title], inilalagay namin ang lubos na kahalagahan sa
                                kaligtasan at seguridad ng aming mga kliyente. Sa pamamagitan ng paggamit ng mga
                                makabagong teknolohiya sa seguridad at pagsunod sa pinakamataas na pamantayan sa
                                pag-encrypt, tinitiyak namin na ang parehong mga pondo ng kliyente at sensitibong
                                impormasyon ay ganap na pinangangalagaan. Ang iyong mga transaksyon sa pananalapi ay
                                pinangangasiwaan nang may lubos na pangangalaga at ganap na protektado. Tinitiyak ng
                                aming hindi natitinag na pangako sa anti-money laundering at mga patakaran ng Know
                                Your Customer ang patuloy na kaligtasan at seguridad ng aming trading platform at
                                mga account ng kliyente.",
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <section class="sign-section">
        <div class="w-layout-blockcontainer container w-container">
            <h2 class="title sign-title">{{aiTrans('Yakapin ang hindi kapani-paniwalang pagkakataong sumali sa napakalaking kumikitang bitcoin trading network.')}}<br>
            </h2>
            <p class="p sign-p">
                {{ aiTrans(
                    "Sumakay sa isang kapanapanabik at rebolusyonaryong paglalakbay sa mundo ng mga
                    cryptocurrencies gamit ang [website_title]. Ang aming masiglang komunidad ay umuunlad sa walang
                    katapusang mga posibilidad na inaalok ng mga digital asset. Gamit ang aming makabagong software,
                    ang mga user ay hindi lamang makakaranas ng pang-araw-araw na kita ngunit nakikisali din sa
                    isang hindi pangkaraniwang modernong pakikipagsapalaran.",
                    $locale,
                    ['website_title' => $website_title],
                ) }}
                </p>
        </div>
    </section>
    <section class="users-section"></section>
    <section class="brokers-section">
        <div class="container w-container">
            <div class="cols brokers-cols">
                <div class="col-33">
                    <div class="broker">
                        <div class="broker-ico"><img loading="lazy" src="{{ asset('frontend/assets/fil/dist') }}/images/brokers-ico-1.webp"
                                width="24" alt="
                                {{ aiTrans(
                                    "[website_title] - Tumpak na pagsusuri",
                                    $locale,
                                    ['website_title' => $website_title],
                                ) }}
                    "></div>
                        <h3 class="title broker-title">Tumpak na pagsusuri</h3>
                        <p class="p broker-p">
                            {{ aiTrans(
                                "Ang mga algorithm ng [website_title] ay maingat na idinisenyo
                                upang sumunod sa mga nangungunang diskarte sa pangangalakal, na tinitiyak ang tumpak
                                na pagsusuri sa lahat ng oras. Ang advanced na software ay maingat na sinusubaybayan
                                ang higit sa 22 teknikal, pangunahing, at mga tool sa pagsusuri ng sentimento, na
                                nagbubunga lamang ng mataas na posibilidad at nangungunang mga signal ng kalakalan.
                                Higit pa rito, ang [website_title] ay gumagamit ng cutting-edge na artificial
                                intelligence para sa pagsubaybay sa pagpapalabas ng mga epektong data.",
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                    </div>
                </div>
                <div class="col-33">
                    <div class="broker">
                        <div class="broker-ico"><img loading="lazy" src="{{ asset('frontend/assets/fil/dist') }}/images/brokers-ico-2.webp"
                                width="24" alt="
                                {{ aiTrans(
                                "[website_title] - Awtomatikong software",
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                                "></div>
                        <h3 class="title broker-title">{{aiTrans('Awtomatikong software')}}</h3>
                        <p class="p broker-p">
                            
                            {{ aiTrans(
                                "Tuklasin ang mga makabagong feature ng [website_title], isang
                            advanced na automated trading platform na nagbabago ng industriya. Magpaalam sa
                            walang katapusang pagsubaybay sa kalakalan at walang kahirap-hirap na kumita.
                            Iangkop ang iyong mga parameter ng kalakalan upang i-unlock ang masusing pagsusuri
                            sa merkado na ibinigay ng [website_title], na nagbubunyag ng mga kumikitang
                            pagkakataon sa pangangalakal na naghihintay na makuha.",
                                $locale,
                                ['website_title' => $website_title],
                            ) }}</p>
                    </div>
                </div>
                <div class="col-33">
                    <div class="broker">
                        <div class="broker-ico"><img loading="lazy" src="{{ asset('frontend/assets/fil/dist') }}/images/brokers-ico-3.webp"
                                width="24"
                                alt="
                                {{ aiTrans(
                                "[website_title] - Itaguyod ang mga makabagong alyansa sa mga kagalang-galang na broker.",
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                                ">
                        </div>
                        <h3 class="title broker-title">{{aiTrans('Itaguyod ang mga makabagong alyansa sa mga kagalang-galang na broker.')}}</h3>
                        <p class="p broker-p">
                            {{ aiTrans(
                                "Sa pamamagitan ng aming eksklusibong pakikipagsosyo sa mga
                            kilalang global brokerage firm, nag-aalok ang [website_title] ng mga iniangkop na
                            solusyon upang matugunan ang mga teknikal na kinakailangan ng aming software. Ang
                            mga pinagkakatiwalaang broker na ito ay nagbibigay ng mga secure na opsyon sa
                            pagbabayad, user-friendly na mga interface, maaasahang serbisyo, at pambihirang
                            suporta sa customer. Yakapin ang mga kakayahan sa direktang pangangalakal at
                            i-access ang malawak na hanay ng mga asset na pinansyal, kabilang ang mga
                            cryptocurrencies. Makamit ang iyong mga layunin sa pananalapi nang may kumpiyansa
                            ngayon!",
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                    </div>
                </div>
            </div>
            <div class="brokers-btn-wrap">
                <a href="#formTop" class="btn white-btn anchor-js w-button">{{aiTrans('KUNIN ANG IYONG COMPLIMENTARY ACCOUNT NGAYON')}}</a>
            </div>
        </div>
    </section>
    <div class="steps-section">
        <div class="container w-container">
            <h2 class="title steps-title">
                {{ aiTrans(
                    "Simulan ang iyong paglalakbay kasama ang [website_title]",
                    $locale,
                    ['website_title' => $website_title],
                ) }}
                <br>
            </h2>
            <div class="steps">
                <div class="step">
                    <div class="step-header">
                        <p class="step-name">{{aiTrans('Hakbang 1')}} </p>
                        <div class="step-line"></div>
                    </div>
                    <h3 class="title step-title">{{aiTrans('Mag-sign up')}}</h3>
                    <p class="p white">
                        {{ aiTrans(
                            "Simulan ang iyong paglalakbay sa [website_title] sa pamamagitan ng
                            paglalagay ng mga detalye ng iyong pagpaparehistro sa form na ibinigay sa itaas. Kapag
                            naisumite na, tapusin ang proseso ng pag-sign up sa pamamagitan ng pagkumpirma sa
                            activation email na ipinadala sa iyong inbox. Sa isang mabilis na pamamaraan ng
                            pag-apruba, ang buong proseso ay karaniwang tumatagal ng mas mababa sa 5 minuto. Sa
                            [website_title], lubos naming pinahahalagahan ang iyong tiwala at walang bayad sa
                            pag-sign up.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
                <div class="step">
                    <div class="step-header">
                        <p class="step-name">{{aiTrans('Hakbang 2')}} </p>
                        <div class="step-line"></div>
                    </div>
                    <h3 class="title step-title">{{aiTrans('Pahusayin ang iyong portfolio ng kalakalan sa pamamagitan ng
                        pagbibigay ng suportang pinansyal.')}}</h3>
                    <p class="p white">
                        {{ aiTrans(
                            "Simulan ang pangangalakal gamit ang cutting-edge na [website_title]
                            software sa pamamagitan ng paglalaan ng mga pondo sa iyong trading account kapag
                            naaprubahan. Nag-aalok kami ng malawak na hanay ng mga mapagkakatiwalaang broker na
                            mapagpipilian mo. Upang makapagsimula, kinakailangan ang minimum na deposito na $250 sa
                            karamihan ng mga broker.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
                <div class="step">
                    <div class="step-header">
                        <p class="step-name">{{aiTrans('Hakbang 3')}} </p>
                        <div class="step-line"></div>
                    </div>
                    <h3 class="title step-title">{{aiTrans('Gumawa ng pera')}}</h3>
                    <p class="p white">
                        {{ aiTrans(
                            "Kapag matagumpay na napondohan ang iyong account, tuklasin ang walang
                        kapantay na potensyal ng [website_title] at maranasan ang kahanga-hangang kakayahan
                        nitong makabuo ng mga kumikitang resulta. Habang ang mga default na setting ay
                        naghahatid ng mga kahanga-hangang resulta, maaari mong i-customize ang iba't ibang mga
                        parameter ng kalakalan para sa pinakamainam na pagganap.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>
            <div class="steps-btn-wrap">
                <a href="#formTop" class="btn white-btn anchor-js w-button">{{aiTrans('SIMULAN ANG IYONG PAGLALAKBAY SA LIBRENG ACCOUNT NGAYON')}}</a>
            </div>
        </div>
    </div>
    <div class="like-section">
        <div class="container w-container">
            <div class="cols like-cols">
                <div class="col-50 like-text-col">
                    <h2 class="title like-title">
                        {{ aiTrans(
                            "Ano ang Aasahan Kapag Nakipagkalakalan sa [website_title]?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        <br>
                    </h2>
                    <p class="p like-p">
                        
                        {{ aiTrans(
                            "Tuklasin ang cutting-edge na automated trading platform, [website_title], na partikular na idinisenyo para sa cryptocurrency trading. Ang platform na ito ay
                            gumagamit ng mga advanced na algorithm upang matukoy ang mga kumikitang pagkakataon sa
                            pangangalakal sa dynamic na merkado ng crypto. Hindi tulad ng manu-manong pangangalakal,
                            mabilis na sinusuri ng [website_title] ang mga paggalaw ng presyo at nagsasagawa ng mga
                            signal ng kalakalan na may walang katulad na kahusayan. Higit pa sa isang regular na
                            software ng kalakalan, ang user-friendly na platform na ito ay maaaring ma-access sa
                            parehong mga mobile at desktop browser, na inaalis ang pangangailangan para sa mga
                            pag-download. I-optimize ang iyong mga aktibidad sa pangangalakal at palakasin ang iyong
                            kakayahang kumita gamit ang mga manu-manong opsyon sa pangangalakal at mga
                            nako-customize na feature.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
                <div class="col-50 like-img-col">
                    <div class="like-img-wrap"><img loading="lazy" src="{{ asset('frontend/assets/fil/dist') }}/images/like.webp"
                            sizes="(max-width: 479px) 100vw, (max-width: 991px) 50vw, 40vw"
                            srcset="{{ asset('frontend/assets/fil/dist') }}/images/like-p-500.webp 500w, {{ asset('frontend/assets/fil/dist') }}/images/like.webp 727w"
                            alt="
                            {{ aiTrans(
                                "[website_title] - Ano ang Aasahan Kapag Nakipagkalakalan sa [website_title]?",
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            "
                            class="like-img"></div>
                </div>
            </div>
        </div>
    </div>
    <div class="scam-section">
        <div class="container w-container">
            <div class="cols scam-cols">
                <div class="col-50 machine-img-col">
                    <div class="scam-img-wrap"><img loading="lazy" src="{{ asset('frontend/assets/fil/dist') }}/images/scam.webp"
                            sizes="(max-width: 479px) 100vw, (max-width: 991px) 50vw, 37vw"
                            srcset="{{ asset('frontend/assets/fil/dist') }}/images/scam-p-500.webp 500w, {{ asset('frontend/assets/fil/dist') }}/images/scam.webp 731w"
                            alt="
                            {{ aiTrans(
                                "[website_title] - Pagsusuri sa pagiging maaasahan ng [website_title]",
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            "
                            class="scam-img"></div>
                </div>
                <div class="col-50 machine-text-col">
                    <h2 class="title scam-title">
                        {{ aiTrans(
                            "Pagsusuri sa pagiging maaasahan ng [website_title]",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}<br>
                    </h2>
                    <p class="p">{{ aiTrans(
                        "Sa gitna ng maraming mapanlinlang na software sa merkado, napakahalagang
                        tugunan ang mga tunay na alalahanin tungkol sa [website_title]. Ang aming software ay
                        maingat na binuo ng isang pangkat ng mga kilalang ekonomista, mathematician, at
                        developer. Sinusuportahan ng malawak na pananaliksik, isinasama nito ang mga advanced na
                        diskarte sa pangangalakal at matatag na mga plano sa pamamahala ng peligro, na
                        nagbibigay ng kapangyarihan sa mga mamumuhunan na patuloy na makamit ang mga
                        kahanga-hangang kita sa araw-araw.",
                        $locale,
                        ['website_title' => $website_title],
                    ) }}</p>
                    <div class="scam-btn-wrap">
                        <a href="#formTop" class="btn anchor-js w-button">{{aiTrans('MAGSIMANG KUMITA NGAYON')}}</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <section class="hat-section">
        <div class="w-layout-blockcontainer container w-container">
            <h2 class="title hat-title">{{ aiTrans(
                "Tuklasin ang Core ng [website_title]",
                $locale,
                ['website_title' => $website_title],
            ) }}<br>
            </h2>
            <p class="p hat-p">{{ aiTrans(
                "Ipinakikilala ang [website_title], isang eksklusibong komunidad ng mamumuhunan
                na nakikinabang sa pabagu-bagong katangian ng mga presyo ng cryptocurrency. Sa mas mababa sa 20
                minutong kinakailangan araw-araw upang i-configure ang iyong mga ginustong parameter ng
                kalakalan, ang [website_title] ay walang putol na nag-scan, nagsusuri, at nagpapatupad ng
                pinakamainam na mga signal ng kalakalan sa ngalan mo. Anuman ang iyong karanasan sa
                pangangalakal, pinangangalagaan ng [website_title] ang lahat, na nagbibigay-daan sa iyong
                tumutok lamang sa pag-maximize ng iyong mga kita!",
                $locale,
                ['website_title' => $website_title],
            ) }}</p>
            <div class="hat-btn-wrap">
                <a href="#formTop" class="btn white-btn anchor-js w-button">
                    {{ aiTrans(
                        "Sumali sa komunidad ng [website_title] at i-unlock ang isang rebolusyonaryong software sa pangangalakal ng cryptocurrency, na
                    nagbibigay-kapangyarihan sa iyo na kumita ng pang-araw-araw na kita!",
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </a>
            </div>
        </div>
    </section>
    <div class="why-section">
        <div class="container w-container">
            <h2 class="title why-title">
                {{ aiTrans(
                    "Tuklasin ang Bentahe ng [website_title] para sa Iyong Pangangailangan
                sa Trading",
                    $locale,
                    ['website_title' => $website_title],
                ) }}
                <br>
            </h2>
            <p class="subtitle why-subtitle">
                {{ aiTrans(
                    "Damhin ang groundbreaking na [website_title] software na nagbabago
                ng crypto trading, na nagbubukas ng walang limitasyong mga posibilidad:",
                    $locale,
                    ['website_title' => $website_title],
                ) }}
                </p>
            <div class="why-items">
                <div class="why-item">
                    <div class="item-header">
                        <div class="why-num">1</div>
                        <h3 class="title why-item-title">{{aiTrans('Libreng Software')}}</h3>
                    </div>
                    <p class="p">
                        
                        {{ aiTrans(
                            "Yakapin ang mga eksklusibong benepisyo ng [website_title] bilang isang
                            pinagkakatiwalaang beta tester, na pinalaya mula sa mga nakatagong singil, bayarin, o
                            extra. Tinitiyak ng aming mga pakikipagsosyo sa broker ang tuluy-tuloy na mga deposito
                            at pag-withdraw, na nagbibigay-daan sa iyong panatilihin ang 100% ng iyong mga
                            pinaghirapang kita.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
                <div class="why-item">
                    <div class="item-header">
                        <div class="why-num">2</div>
                        <h3 class="title why-item-title">{{aiTrans('Mag-explore ng Kayamanan ng Mga Oportunidad sa Pinansyal')}}</h3>
                    </div>
                    <p class="p">
                        
                        {{ aiTrans(
                            "I-maximize ang potensyal ng mga iginagalang na alyansa ng brokerage ng [website_title] upang sumisid sa isang malawak na hanay ng mga nabibiling asset. Isawsaw ang
                        iyong sarili sa mga kilalang cryptocurrencies tulad ng Bitcoin, Ethereum, Ripple, BAT,
                        at Litecoin, habang natutuklasan din ang magkakaibang seleksyon ng mga kalakal tulad ng
                        Gold, mga pares ng pera tulad ng EURUSD, at mga indeks tulad ng S&P 500.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
                <div class="why-item">
                    <div class="item-header">
                        <div class="why-num">3</div>
                        <h3 class="title why-item-title">{{aiTrans('Walang mga Download')}}</h3>
                    </div>
                    <p class="p">
                        {{ aiTrans(
                            "Damhin ang kaginhawahan ng isang user-friendly na interface sa parehong desktop
                        at mobile browser na may [website_title]. Magpaalam sa mga kumplikado ng mga
                        pag-download, pag-install, o pag-update.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
                <div class="why-item">
                    <div class="item-header">
                        <div class="why-num">4</div>
                        <h3 class="title why-item-title">{{aiTrans('Mataas na Katumpakan')}}</h3>
                    </div>
                    <p class="p">
                        {{ aiTrans(
                            "I-unlock ang hindi pa nagagawang katumpakan sa market trading gamit ang mga
                        makabagong teknolohiya at napatunayang diskarte ng [website_title].",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
                <div class="why-item">
                    <div class="item-header">
                        <div class="why-num">5</div>
                        <h3 class="title why-item-title">{{aiTrans('Walang putol na Onboarding')}}</h3>
                    </div>
                    <p class="p">
                        
                        {{ aiTrans(
                            "Sumali sa komunidad ng [website_title] nang walang kahirap-hirap at walang
                            putol. Maaprubahan ang iyong membership sa loob ng ilang minuto at simulang makinabang
                            kaagad mula sa aming makapangyarihang software.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
                <div class="why-item">
                    <div class="item-header">
                        <div class="why-num">6</div>
                        <h3 class="title why-item-title">{{aiTrans('Araw-araw na Kita')}}</h3>
                    </div>
                    <p class="p">
                        {{ aiTrans(
                            "Sumakay sa isang pambihirang paglalakbay tungo sa tagumpay kasama ang [website_title]. Ang aming platform ay patuloy na lumalampas sa mga inaasahan ng mamumuhunan,
                        na naghahatid ng mga pang-araw-araw na kita na lumalampas sa mga inaasahang pagtatantya.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        
                    </p>
                </div>
                <div class="why-item">
                    <div class="item-header">
                        <div class="why-num">7</div>
                        <h3 class="title why-item-title">{{aiTrans('Streamline na Pag-verify ng Broker')}}</h3>
                    </div>
                    <p class="p">
                        
                        {{ aiTrans(
                            "I-unlock ang mga mapagkakakitaang pagkakataon sa pamamagitan ng
                        pakikipagtulungan sa mga broker ng [website_title]. Makaranas ng tuluy-tuloy na proseso
                        ng pag-verify bilang pagsunod sa mga pandaigdigang regulasyon ng KYC at anti-money
                        laundering.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
                <div class="why-item">
                    <div class="item-header">
                        <div class="why-num">8</div>
                        <h3 class="title why-item-title">{{aiTrans('Mahusay na Pagbabangko')}}</h3>
                    </div>
                    <p class="p">
                        {{ aiTrans(
                            "Walang kahirap-hirap na pamahalaan ang iyong trading account para sa mabilis at
                        secure na mga deposito at withdrawal. Gumamit ng iba't ibang maginhawang paraan ng
                        pagbabayad, kabilang ang mga sikat na credit/debit card, kilalang eWallet, at maaasahang
                        bank wire transfer.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
                <div class="why-item">
                    <div class="item-header">
                        <div class="why-num">9</div>
                        <h3 class="title why-item-title">{{aiTrans('Demo Account')}}</h3>
                    </div>
                    <p class="p">
                        {{ aiTrans(
                            "Sumakay sa isang kapakipakinabang na paglalakbay sa pangangalakal bilang isang
                        mahalagang miyembro ng [website_title]. Makakuha ng napakahalagang kalamangan sa isang
                        komplimentaryo at walang limitasyong demo account. Unahin ang hands-on na karanasan sa
                        pagganap ng aming software bago makipagsapalaran sa mga kumikitang kalakalan.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
                <div class="why-item">
                    <div class="item-header">
                        <div class="why-num">10</div>
                        <h3 class="title why-item-title">{{aiTrans('Serbisyo sa Customer')}}</h3>
                    </div>
                    <p class="p">
                        {{ aiTrans(
                            "Sa [website_title], ang pambihirang serbisyo sa customer ang aming
                        pinakapriyoridad. Ang aming nakatuong koponan ng suporta ay magagamit 24/7 upang kaagad
                        at propesyonal na matugunan ang anumang mga alalahanin o isyu na maaaring mayroon ka.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        
                    </p>
                </div>
            </div>
        </div>
    </div>
    <div class="features-section">
        <div class="container w-container">
            <h2 class="title features-title">
                {{ aiTrans(
                    "Mga Natatanging Katangian ng [website_title]",
                    $locale,
                    ['website_title' => $website_title],
                ) }}
                <br>
            </h2>
            <p class="subtitle features-subtitle">
                {{ aiTrans(
                    "Tuklasin ang transformative power ng [website_title] sa
                    pagbabago ng buong pandaigdigang industriya ng software ng trading ng cryptocurrency.<br>
                    I-unlock ang mga pambihirang kakayahan nito:",
                    $locale,
                    ['website_title' => $website_title],
                ) }}
                </p>
            <div class="features">
                <div class="feature">
                    <div class="feature-ico"><img loading="lazy" src="{{ asset('frontend/assets/fil/dist') }}/images/features-icon-1.webp"
                            width="24" alt="
                            {{ aiTrans(
                                "[website_title] - Pinagsama ang VPS",
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            "></div>
                    <h3 class="title feature-title">{{aiTrans('Pinagsama ang VPS')}}</h3>
                    <p class="p feature-p">
                        {{ aiTrans(
                            "Itaas ang iyong pinansyal na paglalakbay gamit ang cutting-edge VPS
                        (Virtual Private Server) hosting na ibinibigay ng [website_title]. Walang putol na
                        nagpapatupad ng mga signal sa mga dynamic na market, kahit na offline. Hayaan ang [website_title] na walang sawang kumita at pangalagaan ang iyong mga pamumuhunan.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
                <div class="feature">
                    <div class="feature-ico"><img loading="lazy" src="{{ asset('frontend/assets/fil/dist') }}/images/features-icon-2.webp"
                            width="24" alt="
                            
                            {{ aiTrans(
                            "[website_title] - Demo Account",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                            "></div>
                    <h3 class="title feature-title">{{aiTrans('Demo Account')}}</h3>
                    <p class="p feature-p">
                        {{ aiTrans(
                            "Sumali sa prestihiyosong komunidad ng [website_title] at maranasan
                        ang pagganap ng software sa isang simulate na kapaligiran bago ipagsapalaran ang mga
                        tunay na pondo sa mga live na trading account. Ang walang kapantay na pagkakataong ito
                        ay naglalagay ng kumpiyansa at tinitiyak ang tumpak na paggawa ng desisyon.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
                <div class="feature">
                    <div class="feature-ico"><img loading="lazy" src="{{ asset('frontend/assets/fil/dist') }}/images/features-icon-3.webp"
                            width="24" alt="
                            {{ aiTrans(
                            "[website_title] - Time Leap",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                            "></div>
                    <h3 class="title feature-title">{{aiTrans('Time Leap')}}</h3>
                    <p class="p feature-p">
                        
                        {{ aiTrans(
                            "Manatiling nauuna sa mga retail investment market sa pamamagitan ng
                            paggamit ng mga advanced na cloud-based na teknolohiya na inaalok ng [website_title].
                            Samantalahin ang pagkakataong makamit ang walang kapantay na katumpakan at i-maximize
                            ang mga kita gamit ang aming makabagong software.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
                <div class="feature">
                    <div class="feature-ico"><img loading="lazy" src="{{ asset('frontend/assets/fil/dist') }}/images/features-icon-4.webp"
                            width="24" alt="
                            
                            {{ aiTrans(
                            "[website_title] - Tagasuri ng Diskarte",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                            "></div>
                    <h3 class="title feature-title">{{aiTrans('Tagasuri ng Diskarte')}}</h3>
                    <p class="p feature-p">
                        
                        {{aiTrans("I-optimize ang pagganap ng iyong software sa pamamagitan ng masusing
                        pagsubok at pagpapatunay sa mga kakayahan nito sa pangangalakal sa iba't ibang hanay ng
                        mga asset. Mag-eksperimento sa iba't ibang mga parameter ng kalakalan at galugarin ang
                        komprehensibong mga mode ng pagsubok ng software upang mapahusay ang pangkalahatang
                        paggana nito.")}}</p>
                </div>
            </div>
            <div class="trade-btn-wrap">
                <a href="#formTop" class="btn white-btn anchor-js w-button">{{aiTrans('SUMALI SA ATING KOMUNIDAD NGAYON')}}</a>
            </div>
        </div>
    </div>
    <div class="faq-section">
        <div class="container w-container">
            <h2 class="title faq-title">
                {{ aiTrans(
                    "Pagsusuri sa Mga Karaniwang Tanong tungkol sa [website_title]",
                    $locale,
                    ['website_title' => $website_title],
                ) }}
                <br>
            </h2>
            <div class="faq-accordion">
                <div class="faq-accordion-item">
                    <div class="faq-accordion-title">
                        <h2 class="faq-question">
                            <span class="faq-accord-num">1</span>

                            {{ aiTrans(
                                "Paano ko ma-optimize ang aking mga kita sa
                                [website_title]?",
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            
                        </h2>
                        <div class="faq-arrow">
                            <div class="faq-a"></div>
                        </div>
                    </div>
                    <div class="faq-accordion-wrap">
                        <p class="faq-answer">
                            {{ aiTrans(
                                "Sumakay sa isang tuluy-tuloy at kapaki-pakinabang na paglalakbay
                                upang palakihin ang iyong kita sa [website_title]. Punan lamang ang form sa
                                pagpaparehistro, ibahagi ang iyong mga detalye, at maghintay ng pag-apruba. Asahan
                                ang pagtanggap ng mga komprehensibong tagubilin sa pamamagitan ng email.",
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            <br></p>
                    </div>
                </div>
                <div class="faq-accordion-item">
                    <div class="faq-accordion-title">
                        <h2 class="faq-question">
                            <span class="faq-accord-num">2</span>{{aiTrans('Ano ang potensyal para kumita?')}}
                        </h2>
                        <div class="faq-arrow">
                            <div class="faq-a"></div>
                        </div>
                    </div>
                    <div class="faq-accordion-wrap">
                        <p class="faq-answer">{{aiTrans('Ang potensyal na tubo para sa mga indibidwal na mamumuhunan ay
                            nag-iiba-iba at naiimpluwensyahan ng isang hanay ng mga salik, kabilang ang paunang
                            halaga ng kalakalan, laki ng stake, mga nabibiling asset, oras ng pangangalakal, at
                            ang pagpapatupad ng mga epektibong diskarte sa pamamahala ng peligro.')}}<br></p>
                    </div>
                </div>
                <div class="faq-accordion-item">
                    <div class="faq-accordion-title">
                        <h2 class="faq-question">
                            <span class="faq-accord-num">3</span>{{aiTrans('Ano ang tagal ng trial na account?')}}
                        </h2>
                        <div class="faq-arrow">
                            <div class="faq-a"></div>
                        </div>
                    </div>
                    <div class="faq-accordion-wrap">
                        <p class="faq-answer">
                            {{ aiTrans(
                                "Ang trial na account ay nananatiling laging naa-access ng lahat ng
                                miyembro ng [website_title] bilang isang komplimentaryo at walang limitasyong
                                alok.",
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            <br></p>
                    </div>
                </div>
                <div class="faq-accordion-item">
                    <div class="faq-accordion-title">
                        <h2 class="faq-question">
                            <span class="faq-accord-num">4</span>
                            {{ aiTrans(
                                "Ano ang pang-araw-araw na pangako ng oras para
                                sa [website_title]?",
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            
                        </h2>
                        <div class="faq-arrow">
                            <div class="faq-a"></div>
                        </div>
                    </div>
                    <div class="faq-accordion-wrap">
                        <p class="faq-answer">
                            {{ aiTrans(
                                "Ang mga indibidwal na hilig sa pag-customize ng mga default na
                                parameter ng kalakalan ay maaaring gumamit ng automated trading software ng [website_title], na nangangailangan ng mas mababa sa 20 minuto ng pang-araw-araw na
                                dedikasyon.",
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            <br></p>
                    </div>
                </div>
                <div class="faq-accordion-item">
                    <div class="faq-accordion-title">
                        <h2 class="faq-question">
                            <span class="faq-accord-num">5</span>
                            {{ aiTrans(
                                "Sino ang makikinabang sa pakikipagkalakalan sa
                                [website_title]?",
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            
                        </h2>
                        <div class="faq-arrow">
                            <div class="faq-a"></div>
                        </div>
                    </div>
                    <div class="faq-accordion-wrap">
                        <p class="faq-answer">
                            {{ aiTrans(
                                "Pahusayin ang iyong karanasan sa pangangalakal nang walang
                                kahirap-hirap gamit ang [website_title], isang cutting-edge na awtomatikong
                                solusyon sa pangangalakal na tumutugon sa lahat ng antas ng kasanayan at background,
                                na nagbubukas ng walang katapusang mga posibilidad para sa tagumpay.",
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            <br></p>
                    </div>
                </div>
                <div class="faq-accordion-item">
                    <div class="faq-accordion-title">
                        <h2 class="faq-question">
                            <span class="faq-accord-num">6</span>
                            
                            {{ aiTrans(
                                "Ang [website_title] software ba ay
                                nangangailangan ng anumang pagbabayad?",
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            
                        </h2>
                        <div class="faq-arrow">
                            <div class="faq-a"></div>
                        </div>
                    </div>
                    <div class="faq-accordion-wrap">
                        <p class="faq-answer">
                            {{ aiTrans(
                                "Sumali sa nangungunang cryptocurrency software sa mundo, [website_title], sa iyong paglalakbay sa pangangalakal nang walang anumang obligasyon sa
                            pananalapi, dahil ito ay ganap na walang bayad.",
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            <br></p>
                    </div>
                </div>
                <div class="faq-accordion-item">
                    <div class="faq-accordion-title">
                        <h2 class="faq-question">
                            <span class="faq-accord-num">7</span>
                            {{ aiTrans(
                                "Paano naiiba ang [website_title] sa MLM o
                            Affiliate Marketing?",
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            
                        </h2>
                        <div class="faq-arrow">
                            <div class="faq-a"></div>
                        </div>
                    </div>
                    <div class="faq-accordion-wrap">
                        <p class="faq-answer">
                            {{ aiTrans(
                                "Tuklasin ang kapangyarihan ng [website_title] habang ginagamit
                            nito ang potensyal ng pangangalakal ng cryptocurrency, na ginagamit ang mga
                            pagbabago sa Bitcoin at iba pang mga digital na pera upang mapakinabangan ang iyong
                            mga kita.",
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            <br></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
@endsection
