@extends('layouts.app')

@push('meta')
    <title>{{ "$website_title | Sul funzionamento della piattaforma" }}</title>
    <meta name="description" content="{{ "Rendi efficace l'uso delle criptovalute con $website_title: offriamo assistenza totale e strumenti avanzati per la tua vittoria." }}" />
@endpush
@section('content')

<section class="banner">
    <div class="container">
        <h1 class="banner-title display-4 fw-bold text-center mb-4">Informazioni su {{$website_title}} Sito web</h1>
        <h2 class="banner-desc display-7 text-center mb-5"></h2>
    </div>
</section>

<section class="py-5">
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <h2 class="display-5 fw-bold mb-4">{{$website_title}} {{aiTrans('Squadra')}}</h2>
                <div>
                    <div>
                        <p>A <strong><a href="{{route('home',$country)}}" class="text-secondary">{{$website_title}}</a></strong>, {{aiTrans('la nostra etica è ancorata al principio della democrazia finanziaria. Sosteniamo il diritto di ogni individuo, indipendentemente dal suo patrimonio, di accedere allo stesso livello di opzioni di investimento degli investitori facoltosi ed esperti.')}}</p>
                        <p>{{aiTrans('Purtroppo, l\'architettura finanziaria esistente non estende le sue cortesie all\'investitore medio. Navigare tra le complessità degli strumenti finanziari tradizionali richiede una notevole esperienza. Inoltre, entrare nell\'arena degli investimenti spesso richiede un notevole capitale iniziale, mettendolo fuori dalla portata di molti.')}}</p>
                        <p>{{aiTrans("La genesi del regno delle criptovalute è stata quella di sostenere la causa dell'inclusività economica. Ciononostante, le metodologie convenzionali per gli investimenti in criptovalute perpetuano l'esclusione dell'individuo comune. L'approccio ortodosso all'acquisto e alla salvaguardia delle criptovalute è pieno di complessità e pericoli.")}}</p>
                        <p>{{aiTrans("Allo stesso modo, una moltitudine di trader considera il processo di capitalizzazione della volatilità intrinseca delle criptovalute attraverso canali secolari come macchinoso. Tali attività speculative si verificano in genere nell'ambito di intermediari finanziari specializzati, impegnati nello scambio di derivati finanziari complessi, inclusi i contratti per differenza (CFD).")}}</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 d-flex align-items-center">
                <picture>
                    <source srcset="{{asset('frontend/assets/it/dist')}}/images/412_459__459_65e737bb03f05_about-half-1.webp" type="image/webp">
                    <source srcset="{{asset('frontend/assets/it/dist')}}/images/_459_65e737bb03f05_about-half-1.webp" type="image/webp">
                    <img src="{{asset('frontend/assets/it/dist')}}/images/_459_65e737bb03f05_about-half-1.webp" loading="lazy" width="459" height="412" alt="">
                </picture>
            </div>
        </div>
    </div>
</section>

<section class="py-5">
    <div class="container">
        <div class="row flex-md-row flex-column-reverse ">
            <div class="col-md-4 d-flex align-items-center">
                <picture>
                    <source srcset="{{asset('frontend/assets/it/dist')}}/images/234_459__459_65e737dd92d14_about-half-2.webp" type="image/webp">
                    <source srcset="{{asset('frontend/assets/it/dist')}}/images/_459_65e737dd92d14_about-half-2.webp" type="image/webp">
                    <img src="{{asset('frontend/assets/it/dist')}}/images/_459_65e737dd92d14_about-half-2.webp" loading="lazy" width="459" height="234" alt="">
                </picture>
            </div>
            <div class="col-md-8">
                <h2 class="display-5 fw-bold mb-4">{{aiTrans("Come realizziamo l'inclusione finanziaria")}}</h2>
                <div>
                    <p>
                        {{ aiTrans(
                            "La piattaforma [website_title] trasforma la complessità della speculazione sulle criptovalute in un'esperienza semplice. Consente all'investitore medio di oscillare rapidamente per le recinzioni e ottenere vittorie immediate. La nostra suite di miglioramenti è progettata per potenziare la tua abilità analitica nel trading.<br>Impiega il nostro arsenale per creare tattiche potenti, navigare nelle acque tumultuose dei rischi di mercato e far proliferare il tuo portafoglio attraverso reinvestimenti strategici. Una legione di trader attribuisce i loro trionfi alla valuta digitale al vantaggio ottenuto dai nostri strumenti.<br>Con vigore incessante, continuiamo a innovare, assicurandoci che il sito Web ufficiale [website_title] rimanga il tuo hub di riferimento per un'odissea di trading di criptovalute divertente, redditizia e semplificata mentre avanziamo in 2024.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="banner">
    <div class="container">
        <h1 class="banner-title display-4 fw-bold text-center mb-4">{{aiTrans("Forgiare il percorso per l'apprendimento universale")}}</h1>
        <div class="text-center">
            <p>
                {{ aiTrans(
                    "Al centro dell'etica di [website_title] c'è la convinzione che i tesori dell'educazione finanziaria dovrebbero essere alla portata di tutti. Con una forte attenzione ai neofiti, alla ricchezza della linguistica culturale e a coloro che sono consapevoli delle loro spese, questa piattaforma si erge come un faro in mezzo al vasto oceano della saggezza degli investimenti. Lanciato con l'intento di trasmettere una comprensione cristallina dei principi fondamentali dell'investimento, il sito web ufficiale di [website_title] rimane impegnato in questa nobile ricerca mentre il 2024 si svolge.",
                    $locale,
                    ['website_title' => $website_title],
                ) }}
                </p>
        </div>

        <div class="text-center mt-3 mt-md-4 mb-4 mb-md-0">
            <button class="show-modal btn btn-primary text-white btn-lg shadow-lg px-3 px-md-5 fs-4">{{aiTrans("Ulteriori informazioni")}}</button>
        </div>
    </div>
</section>
@endsection
