

<?php $__env->startPush('meta'); ?>
    <title><?php echo e("$website_title | Áttekintés az adatvédelemről"); ?></title>
    <meta name="description" content="<?php echo e("Hogyan védi az adatait a $website_title? A biztonsági és adatkezelési módszereinket az adatvédelmi szabályzatunkban találja."); ?>" />
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="contact-bg uk-text-center">
        <h1 class="f70">Adatvédelem</h1>
    </div>

    <section class="section2">
        <div class="uk-container">

            <div>
                <p class="p1">
                    <?php echo e(aiTrans('Mi (Mi), „Mi” vagy „Mi” elkötelezettek vagyunk az Ön személyes adatainak és magánéletének védelme mellett.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('Ez az adatvédelmi szabályzat azért jött létre, hogy tájékoztassa Önt arról, hogyan kezeljük, gyűjtjük, tároljuk és használjuk fel az info@' . $website_title . ' weboldallal (a „Webhely”) kapcsolatban megadott információkat.', $locale, ['website_title' => $website_title])); ?>

                </p>
                <p class="p1"><?php echo e(aiTrans('A következő elveket fogjuk fenntartani:', $locale)); ?></p>
                <ul class="ul1">
                    <li class="li2"><span
                            class="s1"><?php echo e(aiTrans('Legyen átlátható az Ön személyes adatainak gyűjtése és kezelése tekintetében:', $locale)); ?></span>
                    </li>
                </ul>
                <p class="p1">
                    <?php echo e(aiTrans('Számunkra fontos, hogy mindig rendelkezzen minden szükséges információval ahhoz, hogy megalapozott döntéseket hozhasson személyes adatainak feldolgozásával kapcsolatban, amikor felkeresi weboldalunkat, vagy ha beleegyezik abba, hogy harmadik fél kereskedési platformjával kezdjen kereskedni. Ennek érdekében különféle technikákat és intézkedéseket alkalmazunk, amelyek célja, hogy a megfelelő módon és időben megfelelő tájékoztatást nyújtsunk Önnek személyes adatainak kezeléséről.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('Ezen túlmenően, ha azt tapasztaljuk, hogy konkrét információkat kell megadni Önnek, akkor a megfelelő időben és helyen megadjuk azokat.', $locale)); ?>

                </p>
                <p class="gt-block p1">
                    <?php echo e(aiTrans('Szívesen válaszolunk minden felmerülő kérdésére, és a jogi korlátozások függvényében minden szükséges felvilágosítást adunk. Ennek érdekében felveheti velünk a kapcsolatot az alábbi e-mail címre:', $locale)); ?>&nbsp;<span
                        class="s2"><?php echo e($website_title); ?></span></p>
                <ul class="ul1">
                    <li class="li2"><span
                            class="s1"><?php echo e(aiTrans('Az Önre vonatkozó személyes adatok kizárólag a Szabályzatban meghatározott célokra történő feldolgozásához:', $locale)); ?></span>
                    </li>
                </ul>
                <p class="p1">
                    <?php echo e(aiTrans('Az Önre vonatkozó személyes adatok feldolgozásának céljai közé tartozik, de nem kizárólagosan, a Weboldal elérhetővé tétele az Ön számára, valamint harmadik felek kereskedési platformjaihoz (a „Szolgáltatások”) való kapcsolat biztosítása a Weboldal felhasználói élményének javítása érdekében. , a Szolgáltatások (beleértve a Weboldalt is) fejlesztésére, jogaink és érdekeink védelmére, olyan kereskedelmi és adminisztratív tevékenységek végzésére, amelyek támogatják a Szolgáltatások nyújtását a Weboldal felhasználóinak és/vagy az esetleges jogi és/vagy szabályozási követelményeknek való megfelelést.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('Ezen túlmenően az Ön személyes igényeinek és preferenciáinak megértése érdekében feldolgozzuk az Önre vonatkozó személyes adatokat.', $locale)); ?>

                </p>
                <ul class="ul1">
                    <li class="li2"><span
                            class="s1"><?php echo e(aiTrans('Fektessen be jelentős erőforrásokat a személyes adataival kapcsolatos jogainak tiszteletben tartásához:', $locale)); ?></span>
                    </li>
                </ul>
                <p class="p1">
                    <?php echo e(aiTrans('Jelentős erőforrásokat fordítunk arra, hogy az érintettként gyakorolhassa jogait. Ezért bármikor felveheti velünk a kapcsolatot, ha személyes adatait át kívánja tekinteni, módosítani kívánja, törölni kívánja, le szeretné állítani a meghatározott célokra vagy általánosságban történő felhasználását, vagy át kívánja adni azokat Önnek vagy harmadik félnek. Kívánságait a törvénynek megfelelően teljesítjük.', $locale)); ?>

                </p>
                <ul class="ul1">
                    <li class="li2"><span
                            class="s1"><?php echo e(aiTrans('Személyes adatainak védelme érdekében:', $locale)); ?></span></li>
                </ul>
                <p class="p1">
                    <?php echo e(aiTrans('Bár nem tudjuk megígérni Személyes adatainak abszolút védelmét, megígérhetjük, hogy az Ön személyes adatai biztonságának biztosítására szolgáló eszközök és intézkedések széles skáláját alkalmazzuk és fogjuk alkalmazni.', $locale)); ?>

                </p>
                <p class="p1"><?php echo e(aiTrans('Teljes adatvédelmi szabályzatunk', $locale)); ?></p>
                <p class="p1"><?php echo e(aiTrans('1. A hatókör?', $locale)); ?></p>
                <p class="p1">
                    <?php echo e(aiTrans('A jelen Szabályzat leírja, hogy a Társaság milyen típusú személyes adatokat gyűjt az egyénekről, és hogyan gyűjti, használja fel, osztja meg harmadik felekkel, védi, dolgozza fel stb.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('A jelen Szabályzatban a „Személyes adatok” bármely azonosított vagy azonosítható természetes személyre vonatkozó információra utalnak. Azonosítható természetes személy az, aki közvetlenül vagy olyan további információkkal kombinálva azonosítható, amelyek birtokában vagyunk, vagy amelyekhez hozzáférünk.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('A jelen Szabályzatban a Személyes adatok „feldolgozása” a Személyes adatokon végzett bármely műveletre vagy műveletsorra vonatkozik, ideértve a gyűjtést, rögzítést, rendszerezést, strukturálást, tárolást, adaptálást vagy megváltoztatást, visszakeresést, konzultációt, felhasználást, továbbítással, terjesztéssel vagy nyilvánosságra hozatalt. a Személyes adatok más módon történő hozzáférhetővé tétele, összehangolása vagy kombinálása, korlátozása, törlése vagy megsemmisítése.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('Szolgáltatásainkat a nagyközönségnek szánjuk, és nem 18 év alatti gyermekeknek szólnak. Tudatosan nem gyűjtünk vagy kérünk információkat 18 éven aluliaktól, és nem engedjük meg tudatosan az ilyen személyeknek a Szolgáltatásainkhoz való hozzáférést. Ha megtudjuk, hogy egy gyermekről információkat gyűjtöttek, megtesszük az ésszerű lépéseket az ilyen információk mielőbbi törlésére.', $locale)); ?>

                </p>
                <p class="p1"><?php echo e(aiTrans('2. Mikor gyűjtünk Önről személyes adatokat?', $locale)); ?></p>
                <p class="p1">
                    <?php echo e(aiTrans('Személyes adatokat gyűjtünk Önről, amikor használja a Szolgáltatásokat, használja a szolgáltatási csatornákat és használja a weboldalt. Egyes esetekben Ön aktívan bocsát rendelkezésünkre Személyes adatokat, más esetekben pedig úgy gyűjtjük személyes adatait, hogy megvizsgáljuk és elemezzük szolgáltatásaink és/vagy szolgáltatási csatornáink használatát, vagy harmadik féltől kapjuk meg adatait. partnerek.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('3. Nem kötelező személyes adatokat szolgáltatni a Társaságnak, és ennek következményei', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('Nem köteles megadni nekünk semmilyen személyes adatot magáról. Bizonyos esetekben azonban az ilyen személyes adatok megadásának elmulasztása megakadályoz minket abban, hogy a szolgáltatásokat nyújtsuk Önnek, megakadályozza a webhely használatát és/vagy a Szolgáltatások és a Webhely hibás működését okozza.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('4. Milyen típusú személyes adatokat gyűjtünk? Személyes adatok, amelyeket minden alkalommal gyűjtünk, amikor Ön a weboldalt böngészi:', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('Ezek az információk magukban foglalják az online tevékenységnaplókat, a forgalmi információkat (beleértve, de nem kizárólagosan az IP-címet, a hozzáférési időt, a hozzáférés dátumát, a meglátogatott web- és mobiloldalakat, a használt nyelvet, a szoftverösszeomlási jelentéseket és a használt böngésző típusát, az Ön által használt eszközzel kapcsolatos információkat Előfordulhat, hogy ezen információk némelyike ​​nem azonosítja Önt, ezért nem minősül személyes adatnak.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('Személyes adatok, amelyeket Öntől kapunk: minden olyan személyes adat, amelyet saját elhatározásából ad meg nekünk, amikor rajtunk keresztül kapcsolatba lép egy harmadik fél kereskedési platformjával.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('Személyes adatok, amelyeket kifejezetten harmadik fél platformjainak marketing célból történő benyújtása céljából ad meg: Ez az információ tartalmazza az Ön teljes nevét, telefonszámát és e-mail címét.', $locale)); ?>

                </p>
                <p class="p1"><?php echo e(aiTrans('5. A személyes adatok kezelésének céljai és jogalapja', $locale)); ?></p>
                <p class="p1">
                    <?php echo e(aiTrans('A Társaság az Ön Személyes Adatait a jelen szakaszban leírt egy vagy több célból és a megfelelő jogalappal összhangban kezeli.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('A Társaság nem kezeli az Önre vonatkozó személyes adatokat, kivéve, ha az ilyen kezelésnek jogalapja van. A jogalapok, amelyek alapján a Társaság az Ön személyes adatait kezelheti, a következők:', $locale)); ?>

                </p>
                <ul class="ul1">
                    <li class="li3"><span
                            class="s1"><?php echo e(aiTrans('Ön hozzájárult személyes adatainak egy vagy több meghatározott célból történő feldolgozásához. Ez azokra az esetekre vonatkozik, amikor Ön konkrétan megadja adatait a weboldalon keresztül, hogy elküldhessük azokat egy harmadik fél kereskedési platformjára.', $locale)); ?></span>
                    </li>
                    <li class="li3"><span
                            class="s1"><?php echo e(aiTrans('Az adatkezelésre a Társaság vagy harmadik fél által követett jogos érdekek érdekében van szükség. Például Szolgáltatásaink fejlesztése, vagy jogi igények érvényesítése vagy védelme céljából.', $locale)); ?></span>
                    </li>
                    <li class="li2"><span
                            class="s1"><?php echo e(aiTrans('Az adatkezelés a Társaságot terhelő jogi kötelezettség teljesítéséhez szükséges.', $locale)); ?></span>
                    </li>
                </ul>
                <p class="p1">
                    <?php echo e(aiTrans('Ha további tájékoztatást szeretne kapni arról, hogy az adatkezelés miként szükséges a Társaság vagy harmadik fél által követett jogos érdekek érvényesítéséhez, bármikor kapcsolatba léphet velünk az e-mail címre küldött értesítés útján.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('Az alábbi lista ismerteti azokat a célokat, amelyekből az Ön személyes adatait feldolgozhatjuk, és az ilyen adatkezelés jogalapját:', $locale)); ?>

                </p>
                <table class="t1" cellspacing="0" cellpadding="0">
                    <tbody>
                        <tr>
                            <td class="td1" valign="top">&nbsp;</td>
                            <td class="td2" valign="top">
                                <p class="p5"><?php echo e(aiTrans('Cél', $locale)); ?></p>
                            </td>
                            <td class="td3" valign="top">
                                <p class="p5"><?php echo e(aiTrans('Jogalap', $locale)); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td4" valign="top">
                                <p class="p5">1</p>
                            </td>
                            <td class="td5" valign="top">
                                <p class="p6">
                                    <?php echo e(aiTrans('Adatainak elküldése harmadik feleknek a digitális kereskedelem címére irányuló kérésére.', $locale)); ?>

                                </p>
                                <p class="p6">
                                    <?php echo e(aiTrans('Személyes adatokat gyűjthetünk Önről harmadik félnek történő elküldés céljából, ha Ön kifejezetten kéri.', $locale)); ?>

                                </p>
                            </td>
                            <td class="td6" valign="top">
                                <p class="p5">
                                    <?php echo e(aiTrans('Ön hozzájárult személyes adatainak egy vagy több meghatározott célból történő feldolgozásához.', $locale)); ?>

                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td7" valign="top">
                                <p class="p5">2</p>
                            </td>
                            <td class="td8" valign="top">
                                <p class="p6">
                                    <?php echo e(aiTrans('Kérdéseire, kéréseire és/vagy panaszaira válaszolni', $locale)); ?></p>
                                <p class="p6">
                                    <?php echo e(aiTrans('Az Önre vonatkozó személyes adatok feldolgozása a Szolgáltatások használatával kapcsolatos megkeresések megválaszolásához szükséges.', $locale)); ?>

                                </p>
                            </td>
                            <td class="td9" valign="top">
                                <p class="p5">
                                    <?php echo e(aiTrans('Az adatkezelésre a Társaság vagy harmadik fél jogos érdekei miatt van szükség.', $locale)); ?>

                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td10" valign="top">
                                <p class="p5">3</p>
                            </td>
                            <td class="td11" valign="top">
                                <p class="p6">
                                    <?php echo e(aiTrans('Bármilyen jogi kötelezettség vagy bírósági vagy közigazgatási rendelkezés teljesítése', $locale)); ?>

                                </p>
                                <p class="p6">
                                    <?php echo e(aiTrans('Az Ön személyes adatait különféle jogi kötelezettségeink teljesítése érdekében kezeljük.', $locale)); ?>

                                </p>
                            </td>
                            <td class="td12" valign="top">
                                <p class="p5">
                                    <?php echo e(aiTrans('Az adatkezelés a Társaságot terhelő jogi kötelezettség teljesítéséhez szükséges.', $locale)); ?>

                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td13" valign="top">
                                <p class="p5">4</p>
                            </td>
                            <td class="td14" valign="top">
                                <p class="p6"><?php echo e(aiTrans('Szolgáltatásaink fejlesztése érdekében', $locale)); ?></p>
                                <p class="p6">
                                    <?php echo e(aiTrans('Az Önre vonatkozó személyes adatokat szolgáltatásaink fejlesztésére használhatjuk fel. Az ilyen feldolgozás magában foglalja többek között a Szolgáltatásokkal kapcsolatban szerzett összeomlási naplókat vagy egyéb hibajelentéseket.', $locale)); ?>

                                </p>
                            </td>
                            <td class="td15" valign="top">
                                <p class="p5">
                                    <?php echo e(aiTrans('Az adatkezelésre a Társaság vagy harmadik fél jogos érdekei miatt van szükség.', $locale)); ?>

                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td16" valign="top">
                                <p class="p5">5</p>
                            </td>
                            <td class="td17" valign="top">
                                <p class="p6">
                                    <?php echo e(aiTrans('A csalás és Szolgáltatásaink visszaélésszerű használatának elkerülése érdekében', $locale)); ?>

                                </p>
                            </td>
                            <td class="td18" valign="top">
                                <p class="p5">
                                    <?php echo e(aiTrans('Az adatkezelésre a Társaság vagy harmadik fél jogos érdekei miatt van szükség.', $locale)); ?>

                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td19" valign="top">
                                <p class="p5">6</p>
                            </td>
                            <td class="td20" valign="top">
                                <p class="p6">
                                    <?php echo e(aiTrans('Különféle olyan tevékenységek végzésére és fenntartására, amelyek a Szolgáltatásaink nyújtását támogatják', $locale)); ?>

                                </p>
                                <p class="p6">
                                    <?php echo e(aiTrans('Ilyen tevékenységek közé tartoznak az adminisztratív funkciók, az üzletfejlesztési tevékenységek, a stratégiai döntéshozatal, a felügyeleti mechanizmusok stb.', $locale)); ?>

                                </p>
                            </td>
                            <td class="td21" valign="top">
                                <p class="p5">
                                    <?php echo e(aiTrans('Az adatkezelésre a Társaság vagy harmadik fél jogos érdekei miatt van szükség.', $locale)); ?>

                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td4" valign="top">
                                <p class="p5">7</p>
                            </td>
                            <td class="td5" valign="top">
                                <p class="p6">
                                    <?php echo e(aiTrans('Elemzés elvégzése, beleértve a statisztikai elemzést is.', $locale)); ?></p>
                                <p class="p6">
                                    <?php echo e(aiTrans('Különböző elemzési mérőszámokat (beleértve a statisztikákat is) alkalmazunk a különböző témákban történő döntések meghozatalához.', $locale)); ?>

                                </p>
                            </td>
                            <td class="td6" valign="top">
                                <p class="p5">
                                    <?php echo e(aiTrans('Az adatkezelésre a Társaság vagy harmadik fél jogos érdekei miatt van szükség.', $locale)); ?>

                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td22" valign="top">
                                <p class="p5">8</p>
                            </td>
                            <td class="td23" valign="top">
                                <p class="p6">
                                    <?php echo e(aiTrans('A saját, valamint harmadik felek érdekeinek, jogainak és vagyonának védelme érdekében, beleértve a jogi igények előterjesztését, gyakorlását vagy védelmét.', $locale)); ?>

                                </p>
                                <p class="p6">
                                    <?php echo e(aiTrans('Feldolgozhatjuk az Önre vonatkozó személyes adatokat, hogy megvédjük érdekeinket, jogainkat és vagyonunkat, vagy harmadik felek érdekeit, bármely törvénynek, rendeletnek vagy megállapodásnak megfelelően, beleértve bármely feltételeinket, feltételeinket és irányelveinket.', $locale)); ?>

                                </p>
                            </td>
                            <td class="td24" valign="top">
                                <p class="p5">
                                    <?php echo e(aiTrans('Az adatkezelésre a Társaság vagy harmadik fél jogos érdekei miatt van szükség.', $locale)); ?>

                                </p>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <p class="p1"><?php echo e(aiTrans('6. Személyes adatok továbbítása harmadik felek részére', $locale)); ?></p>
                <p class="p1">
                    <?php echo e(aiTrans('A Társaság megoszthatja az Ön személyes adatait harmadik felekkel is, amelyek szolgáltatásokat nyújtanak számunkra, például tárhely- és tárolási szolgáltatókkal, IP-címekkel, felhasználói élményelemzéssel, kutatási, elemzői, műszaki és diagnosztikai szolgáltatásokkal.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('Ezenkívül kifejezetten kérheti, hogy bizonyos személyes adatokat küldjünk el Önről harmadik fél kereskedési platformjainak. Ilyen esetekben megosztjuk az Ön által e célból rendelkezésünkre bocsátott Személyes adatokat az ilyen harmadik felekkel, és az Ön személyes adatainak felhasználására saját adatvédelmi irányelveik vonatkoznak. Megoszthatjuk személyes adatait több harmadik fél kereskedési platformjával.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('A Vállalat az Ön személyes adatait megoszthatja kapcsolódó szervezeteivel és üzleti partnereivel is, akik olyan erőforrásokat biztosítanak, amelyek lehetővé teszik a Társaság számára, hogy gazdagítsa és javítsa a felhasználóinak nyújtott szolgáltatások és termékek színvonalát.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('A Társaság megoszthatja az Ön személyes adatait a kormányzattal, a helyi, a hivatalos és a szabályozó hatóságokkal, valamint ha az ilyen nyilvánosságra hozatal a mi érdekeink, jogaink és vagyonunk, valamint harmadik felek vagyonának védelme érdekében szükséges, beleértve a jogi igények előterjesztését, érvényesítését vagy védelmét.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('Ezen túlmenően az Önre vonatkozó Személyes adatokat kiadhatjuk a Társaság és/vagy bármely olyan társaság potenciális vevőinek, befektetőinek vagy hitelezőinek, amelyeknek a cégcsoport tagja, vagy bármilyen hasonló ügylet (ideértve az eladást is) a Társaság és/vagy bármely azon társaságcsoporton belüli társaság, amelynek a Társaság része), és/vagy a Társaság és/vagy a társaságcsoporton belüli bármely társaság egyesülése, átszervezése, konszolidációja vagy csődje kapcsán. társaságok, amelyeknek a Társaság a része.', $locale)); ?>

                </p>
                <p class="p1"><?php echo e(aiTrans('7. Cookie-k és harmadik féltől származó szolgáltatások', $locale)); ?></p>
                <p class="p1">
                    <?php echo e(aiTrans('Használhatunk bizonyos harmadik féltől származó szolgáltatásokat, például elemzőcégeket vagy webhelyünkön hirdetéseket megjelenítő cégeket, amelyek cookie-kat vagy más technológiákat is használhatnak, és ezekre a gyakorlatokra és szolgáltatókra saját irányelveik vonatkoznak.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('A süti (amely egy kis szöveges fájl) arra az eszközre van telepítve, amelyen keresztül Ön felkeresi vagy eléri a webhelyet. A sütik lehetővé teszik számunkra, hogy információkat gyűjtsünk Önről és viselkedéséről annak érdekében, hogy javítsuk felhasználói élményét, emlékezzünk preferenciáira és beállításaira, valamint személyre szabjuk és olyan termékeket és szolgáltatásokat kínáljunk Önnek, amelyek érdekelhetik Önt. A cookie-k statisztikák gyűjtésére és elemzések elvégzésére is használhatók.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('Az általunk használt cookie-k egy része munkamenet-cookie-k, amelyek ideiglenesen letöltődnek az Ön készülékére, és a böngésző bezárásáig tartanak, míg mások állandó cookie-k, amelyek a webhely böngészésének leállítása után is az Ön készülékén maradnak. Segítség. a webhely visszatérő látogatóként fog emlékezni Önre, amikor visszatér a webhelyre.', $locale)); ?>

                </p>
                <p class="p1"><?php echo e(aiTrans('A sütik típusai:', $locale)); ?></p>
                <p class="p1">
                    <?php echo e(aiTrans('Az általunk használt sütiket funkciójuk szerint osztályozzuk, az alábbiak szerint:', $locale)); ?>

                </p>
                <table class="t1" cellspacing="0" cellpadding="0">
                    <tbody>
                        <tr>
                            <td class="td25" valign="top">
                                <p class="p5"><?php echo e(aiTrans('A süti típusa', $locale)); ?></p>
                            </td>
                            <td class="td26" valign="top">
                                <p class="p5"><?php echo e(aiTrans('Cél', $locale)); ?></p>
                            </td>
                            <td class="td27" valign="top">
                                <p class="p5"><?php echo e(aiTrans('további információ', $locale)); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td28" valign="top">
                                <p class="p5"><?php echo e(aiTrans('Szigorúan szükséges cookie-k', $locale)); ?></p>
                            </td>
                            <td class="td29" valign="top">
                                <p class="p6">
                                    <?php echo e(aiTrans('Ezek a cookie-k feltétlenül szükségesek ahhoz, hogy Ön navigálhasson a weboldalon és használhassa a kért funkciókat. Ezeket arra használjuk, hogy biztosítsuk Önnek az Ön által kért tartalmainkat, termékeinket és szolgáltatásainkat.', $locale)); ?>

                                </p>
                                <p class="p6">
                                    <?php echo e(aiTrans('Ezek a cookie-k elengedhetetlenek ahhoz, hogy az Ön eszköze információkat tölthessen le vagy továbbítson, hogy navigálhasson a weboldalon, használhassa annak funkcióit és visszatérhessen a korábban meglátogatott oldalakra.', $locale)); ?>

                                </p>
                            </td>
                            <td class="td30" valign="top">
                                <p class="p6">
                                    <?php echo e(aiTrans('Ezek a sütik személyes adatokat gyűjtenek Önről, például felhasználónevét és utolsó bejelentkezési dátumát, és azonosítják Önt, amikor bejelentkezett a webhelyre.', $locale)); ?>

                                </p>
                                <p class="p6">
                                    <?php echo e(aiTrans('Ezek a cookie-k törlődnek, amikor bezárja webböngészőjét (munkamenet cookie-k).', $locale)); ?>

                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td31" valign="top">
                                <p class="p5"><?php echo e(aiTrans('Funkcionális sütik', $locale)); ?></p>
                            </td>
                            <td class="td32" valign="top">
                                <p class="p5">
                                    <?php echo e(aiTrans('Ezeket a sütiket arra használjuk, hogy felismerjük Önt, amikor visszatér a webhelyre, és lehetővé teszik számunkra, hogy emlékezzünk választásaira és preferenciáira.', $locale)); ?>

                                </p>
                            </td>
                            <td class="td33" valign="top">
                                <p class="p5">
                                    <?php echo e(aiTrans('Ezek a sütik túlélik az Ön webböngészőjének bezárását, és a megfelelő lejárati időig tartanak.', $locale)); ?>

                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td34" valign="top">
                                <p class="p5"><?php echo e(aiTrans('Teljesítmény-sütik', $locale)); ?></p>
                            </td>
                            <td class="td35" valign="top">
                                <p class="p5">
                                    <?php echo e(aiTrans('Ezeket a sütiket arra használjuk, hogy összesített statisztikákat készítsenek a webhely teljesítményéről, valamint teszteljék és javítsák a teljesítményt a jobb felhasználói élmény biztosítása érdekében. Ezenkívül lehetővé teszik számunkra, hogy analitikai funkciókat hajtsunk végre a Weboldalon.', $locale)); ?>

                                </p>
                            </td>
                            <td class="td36" valign="top">
                                <p class="p6">
                                    <?php echo e(aiTrans('Ezek a cookie-k anonim adatokat gyűjtenek, amelyek nem kapcsolódnak azonosított vagy azonosítható természetes személyhez.', $locale)); ?>

                                </p>
                                <p class="p6">
                                    <?php echo e(aiTrans('Ezek a cookie-k különböző időszakokra érvényesek; egyesek törlődnek a böngésző bezárásakor, míg mások határozatlan ideig érvényesek.', $locale)); ?>

                                </p>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <p class="p1"><?php echo e(aiTrans('Cookie-k blokkolása és törlése', $locale)); ?></p>
                <p class="p1">
                    <?php echo e(aiTrans('Módosíthatja böngészője beállításait, hogy blokkolja vagy törölje néhány vagy az összes cookie-t. Tekintse meg az alábbi linkeket, hogy megtudja, hogyan teheti ezt meg néhány legnépszerűbb webböngészővel kapcsolatban:', $locale)); ?>

                </p>
                <ul class="ul1">
                    <li class="li3"><span class="s1"><?php echo e(aiTrans('Firefox', $locale)); ?></span></li>
                    <li class="li3"><span class="s1"><?php echo e(aiTrans('Microsoft Edge', $locale)); ?></span></li>
                    <li class="li3"><span class="s1"><?php echo e(aiTrans('Google Chrome', $locale)); ?></span></li>
                    <li class="li2"><span class="s1"><?php echo e(aiTrans('Safari', $locale)); ?></span></li>
                </ul>
                <p class="p1">
                    <?php echo e(aiTrans('Felhívjuk azonban figyelmét, hogy ha így tesz, előfordulhat, hogy a Webhely egyes vagy összes funkciója és funkciója nem fog megfelelően működni.', $locale)); ?>

                </p>
                <p class="p1"><?php echo e(aiTrans('ONLINE KÖVETÉSI ÉRTESÍTÉS', $locale)); ?></p>
                <p class="p1">
                    <?php echo e(aiTrans('JELENLEG EZ A SZOLGÁLTATÁS NEM TÁMOGATJA A NE NYOMOTT JELZÉSEKET.', $locale)); ?></p>
                <p class="p1"><?php echo e(aiTrans('8. Az Ön személyes adatainak megőrzése', $locale)); ?></p>
                <p class="p1">
                    <?php echo e(aiTrans('A Társaság az Ön személyes adatait addig őrzi meg, ameddig az a jelen Szabályzatban leírt személyes adatok kezelési céljainak teljesítéséhez szükséges, vagy a ránk vonatkozó törvények, rendeletek, szabályzatok és utasítások szerint szükséges hosszabb ideig.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('Az Ön adatait 12 hónapig megosztjuk harmadik fél kereskedési platformjaival, és beleegyezésünk alapján további 12 hónapig.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('Annak érdekében, hogy személyes adatait ne őrizzük meg a szükségesnél hosszabb ideig, rendszeres időközönként felülvizsgáljuk az általunk tárolt személyes adatokat, hogy megvizsgáljuk, törölhetők-e.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('9. Személyes adatok továbbítása harmadik országba vagy nemzetközi szervezetbe', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('Személyes adatai harmadik országba (azaz az Ön lakóhelyétől eltérő joghatóságokba) vagy nemzetközi szervezeteknek továbbíthatók. Ilyen körülmények között a Társaság megteszi a megfelelő biztonsági intézkedéseket annak érdekében, hogy biztosítsa az Ön személyes adatai védelmét, valamint hogy az érintettek érvényesíthető jogai és hatékony jogorvoslati lehetőségek álljanak az érintettek rendelkezésére.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('Ha Ön az EGT (Európai Gazdasági Térség) lakója, kérjük, vegye figyelembe, hogy ezek a biztosítékok és védelem akkor állnak rendelkezésre, ha az alábbi feltételek bármelyike ​​teljesül:', $locale)); ?>

                </p>
                <ul class="ul1">
                    <li class="li3"><span
                            class="s1"><?php echo e(aiTrans('Az adattovábbítás olyan harmadik országba vagy nemzetközi szervezetbe történik, amelyről az EU Bizottsága úgy döntött, hogy megfelelő szintű védelmet biztosít a számára továbbított Személyes adatok számára az (EU) 45/3 európai rendelet 2016. cikkének (679) bekezdésével összhangban. Unió. a Parlament és a Tanács 27. április 2016-i határozata (a „GDPR”).', $locale)); ?></span>
                    </li>
                    <li class="li3"><span
                            class="s1"><?php echo e(aiTrans('Az átvitel a GDPR 46. cikke (2) bekezdésének a) pontjával összhangban a hatóságok vagy szervek közötti, jogilag kötelező erejű és végrehajtható eszközzel történik; bármelyik', $locale)); ?></span>
                    </li>
                    <li class="li2"><span
                            class="s1"><?php echo e(aiTrans('Az átvitel az EU Bizottság által a GDPR 46. cikke (2) bekezdésének c) pontjával összhangban elfogadott szabványos adatvédelmi záradékokkal összhangban történik. Az EU Bizottsága által elfogadott záradékok a https://ec.europa.eu/info/law/law-topic/data-protection/data-transfers-outside-eu/model-contracts-transfer-personal -data oldalon tekinthetők meg -third-countries_in.', $locale)); ?></span>
                    </li>
                </ul>
                <p class="gt-block p1">
                    <?php echo e(aiTrans('Kérheti, hogy a Társaság részletezze a Társaság által harmadik országba vagy nemzetközi szervezetbe továbbított Személyes adatainak védelme érdekében alkalmazott biztonsági intézkedések részleteit az alábbi címre küldött e-mailben:', $locale)); ?>&nbsp;<span
                        class="s2"><?php echo e($website_title); ?></span></p>
                <p class="p1"><?php echo e(aiTrans('10. Az Ön személyes adatainak védelme', $locale)); ?></p>
                <p class="p1">
                    <?php echo e(aiTrans('Megfelelő technikai és szervezési intézkedéseket hajtunk végre a Személyes adatok megfelelő szintű biztonságának biztosítása érdekében, figyelembe véve a feldolgozásból eredő kockázatokat, különös tekintettel a személyes adatok megsemmisüléséből, elvesztéséből, megváltoztatásából, jogosulatlan nyilvánosságra hozatalából, illetve véletlen vagy jogellenes hozzáféréséből. továbbítani, tárolni vagy más módon feldolgozni.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('Nem tudjuk garantálni, és nem is vállaljuk, hogy az Ön Személyes adatainak védelme tekintetében hibamentesen fog működni, és nem vállalunk felelősséget semmilyen közvetett, véletlenszerű, következményi vagy büntető jellegű kárért, amely az adatok felhasználásával vagy nyilvánosságra hozatalával kapcsolatos. az Ön személyes adatait. Önre vonatkozó adatok, beleértve, de nem kizárólagosan, a személyes adatok továbbítási hibából, harmadik felek általi illetéktelen hozzáférésből vagy egyéb, rajtunk kívül álló okokból történő felfedését.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('Jogi vagy egyéb, rajtunk kívül álló kötelezettségek miatt előfordulhat, hogy az Ön személyes adatait harmadik feleknek, például hatóságoknak továbbítsuk. Ilyen körülmények között korlátozottan tudjuk ellenőrizni az Ön Személyes Adatainak harmadik felek által biztosított védelmi szintjét.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('A személyes adatok interneten keresztüli továbbítása nem lehet teljesen biztonságos. Ezért a Társaság nem tudja garantálni az Ön személyes adatainak védelmét, amikor azokat az interneten keresztül továbbítja nekünk.', $locale)); ?>

                </p>
                <p class="p1"><?php echo e(aiTrans('11. Hivatkozások harmadik felek webhelyeire', $locale)); ?></p>
                <p class="p1">
                    <?php echo e(aiTrans('A Weboldal hivatkozásokat tartalmazhat harmadik felek webhelyeire és/vagy alkalmazásaira. A Társaság nem ellenőrzi az ilyen webhelyeket és alkalmazásokat, sem az ilyen webhelyek és alkalmazások által Önről szóló személyes adatok gyűjtését és/vagy feldolgozását, és nem vállalunk felelősséget az ilyen webhelyek és alkalmazások, illetve azok adatvédelmi szabályzataiért és tevékenységeiért. Ez a szabályzat nem vonatkozik az ilyen webhelyeken és/vagy alkalmazásokon keresztül végrehajtott műveletekre.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('Amikor ilyen harmadik felek webhelyeit és/vagy alkalmazásait éri el, javasoljuk, hogy alaposan tekintse át az adatvédelmi szabályzatukat, mielőtt ilyen webhelyeket és/vagy alkalmazásokat használna, és mielőtt bármilyen személyes adatot nyilvánosságra hozna magáról.', $locale)); ?>

                </p>
                <p class="p1"><?php echo e(aiTrans('13. Az Ön személyes adataival kapcsolatos jogai', $locale)); ?></p>
                <p class="p1">
                    <?php echo e(aiTrans('Általában jogosult arra, hogy megerősítést kérjen tőlünk arról, hogy gyűjtünk-e Önről személyes adatokat, kérheti ezen adatok felülvizsgálatát, adott esetben a tartalom helyesbítését, valamint a számunkra már nem szükséges személyes adatok törlését. Ön is korlátozhatja hozzájárulását személyes adatainak bizonyos feldolgozásához.', $locale)); ?>

                </p>
                <p class="p1"><?php echo e(aiTrans('Ha Ön EGT-lakó, kérjük, olvassa el az alábbi részt:', $locale)); ?></p>
                <p class="p1">
                    <?php echo e(aiTrans('Személyes adataival kapcsolatban az alábbi jogokkal rendelkezik. E jogainak gyakorlásához a következő e-mail címre küldhet kérelmet jogai gyakorlására:', $locale)); ?>

                </p>
                <p class="p1"><?php echo e(aiTrans('Hozzáférési jog', $locale)); ?></p>
                <p class="p1">
                    <?php echo e(aiTrans('Ön jogosult arra, hogy a Társaságtól visszaigazolást kapjon arra vonatkozóan, hogy Önre vonatkozó személyes adatok kezelése folyamatban van-e, és ha igen, hozzáférést kaphat a személyes adatokhoz és a következő információkhoz: (1) az adatkezelés céljai; (2) a szóban forgó Személyes adatok kategóriái; (3) a címzettek vagy a címzettek kategóriái, akikkel a személyes adatokat közölték vagy közölni fogják, különösen az Európai Gazdasági Térségen (EGT) kívüli harmadik országokban vagy nemzetközi szervezetekben található címzettek; (4) lehetőség szerint a személyes adatok tárolásának várható időtartama, vagy ha ez nem lehetséges, az időtartam meghatározásához használt kritériumok; (5) az Önre vonatkozó személyes adatok helyesbítését vagy törlését, illetve az Önre vonatkozó személyes adatok kezelésének korlátozását kérheti a Társaságtól, vagy tiltakozhat az ilyen adatkezelés ellen; (6) a felügyeleti hatósághoz történő panasztétel joga; (7) ha Öntől nem gyűjtenek személyes adatokat, azok forrására vonatkozó bármely rendelkezésre álló információ; (8) profilok megléte; és (9) ha a Személyes Adatokat az EGT-n kívüli harmadik országba vagy nemzetközi szervezetbe továbbítják, az adattovábbítással kapcsolatos megfelelő biztosítékokat.',$locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('A Társaság másolatot biztosít a kezelt Személyes adatokról, és ésszerű díjat számíthat fel az Ön által kért további másolatokért. Ha kérését elektronikusan teszi meg, és ha másként nem kéri, az információkat egy általánosan használt elektronikus formátumban adjuk meg.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('A személyes adatok másolatának megszerzéséhez való jog nem érinti hátrányosan mások jogait és szabadságait. Ezért, ha a kérelem sérti mások jogait és szabadságait, előfordulhat, hogy a Társaság nem, vagy korlátozottan teljesíti az Ön kérését.', $locale)); ?>

                </p>
                <p class="p1"><?php echo e(aiTrans('Helyesbítés joga', $locale)); ?></p>
                <p class="p1">
                    <?php echo e(aiTrans('Önnek jogában áll kérni a Társaságtól az Önre vonatkozó pontatlan személyes adatok helyesbítését. Figyelembe véve az adatkezelés céljait, jogosult a hiányos személyes adatainak kiegészítésére, ideértve egy kiegészítő nyilatkozat benyújtását is.', $locale)); ?>

                </p>
                <p class="p1"><?php echo e(aiTrans('Törlési jog', $locale)); ?></p>
                <p class="p1">
                    <?php echo e(aiTrans('A következő indokok érvényesek: (a) a személyes adatokra már nincs szükség abból a célból, amelyből azokat gyűjtötték vagy más módon kezelték; (b) visszavonja az adatkezelés alapjául szolgáló hozzájárulását, és az adatkezelésnek nincs más jogalapja; (c) Ön az Ön sajátos helyzetével kapcsolatos okokból bármikor tiltakozik Személyes adatainak olyan kezelése ellen, amely a mi vagy egy harmadik fél által követett jogos érdekeken alapul, és nincs kényszerítő jogos indok a Feldolgozásra; (d) tiltakozik személyes adatainak közvetlen marketing célú kezelése ellen; (e) a Személyes adatot jogellenesen kezelték; vagy (f) Az Önre vonatkozó személyes adatokat törölni kell a Társaságra vonatkozó európai uniós vagy tagállami jogi kötelezettségek teljesítése érdekében.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('Ez a jog nem vonatkozik arra a mértékre, amennyiben az adatkezelés szükséges (a) olyan jogi kötelezettség teljesítéséhez, amely az európai uniós vagy tagállami jog szerint adatkezelést ír elő, és amely a Társaságra vonatkozik; vagy b) jogi igények előterjesztésére, érvényesítésére vagy védelmére.', $locale)); ?>

                </p>
                <p class="p1"><?php echo e(aiTrans('A feldolgozás korlátozásának joga', $locale)); ?></p>
                <p class="p1">
                    <?php echo e(aiTrans('Ön jogosult arra, hogy kérje a Társaságtól személyes adatai kezelésének korlátozását, ha az alábbiak valamelyike ​​fennáll: (a) Ön vitatja a személyes adatok pontosságát, olyan időtartamra, amely lehetővé teszi a Társaság számára a személyes adatok pontosságának ellenőrzését. Személyes adatok Önről; (b) az adatkezelés jogellenes, és Ön tiltakozik személyes adatainak törlése ellen, és ehelyett kéri azok felhasználásának korlátozását; (c) a Társaságnak már nincs szüksége az Ön Személyes Adataira adatkezelés céljából, de Ön igényli azokat jogi igények előterjesztéséhez, érvényesítéséhez vagy védelméhez; (d) ha az Önre vonatkozó személyes adatok kezelése a Társaság vagy harmadik fél jogos érdekeihez szükséges, kivéve, ha az adatkezelésre olyan kényszerítő erejű jogos indokokat bizonyítunk, amelyek elsőbbséget élveznek az Ön érdekeivel, jogaival és szabadságaival szemben, vagy alapításához, gyakorlásához vagy jogi igények védelme; vagy (e) ha az Ön személyes adatait direkt marketing célból dolgozzák fel, ideértve a profilalkotást is, amennyiben az ilyen direkt marketinghez kapcsolódik.',$locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('Ha az Önre vonatkozó személyes adatok feldolgozását kérését követően korlátozták, az ilyen személyes adatok a tárolás kivételével csak az Ön hozzájárulásával vagy jogi igények előterjesztéséhez, érvényesítéséhez vagy védelméhez, illetve a jogok védelme érdekében kezelhetők. más természetes vagy jogi személy, vagy az Európai Unió vagy egy tagállam fontos közérdeke miatt.', $locale)); ?>

                </p>
                <p class="p1"><?php echo e(aiTrans('Az adatok hordozhatóságához való jog', $locale)); ?></p>
                <p class="p1">
                    <?php echo e(aiTrans('Ön jogosult arra, hogy az Önről a Társaság rendelkezésére bocsátott Személyes Adatait tagolt, széles körben használt és géppel olvasható formátumban megkapja, valamint jogosult arra, hogy ezeket a Személyes adatokat egy másik adatkezelőnek továbbítsa, ha (a) az adatkezelés az Ön hozzájárulásán vagy olyan szerződésen alapul, amelyben Ön is részes fele, és (b) az adatkezelés automatizált módon történik.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('Az adathordozhatósághoz való jogának gyakorlásával Ön jogosult arra, hogy személyes adatait a Társaságtól közvetlenül egy másik adatkezelőhöz továbbítsa, amennyiben ez technikailag lehetséges. Az adathordozhatósághoz való jogának gyakorlása nem sérti az Ön és a Társaság törlési joga alá tartozó jogait. Továbbá az adathordozhatósághoz való jog nem érinti hátrányosan mások jogait és szabadságait.', $locale)); ?>

                </p>
                <p class="p1"><?php echo e(aiTrans('Tiltakozás joga', $locale)); ?></p>
                <p class="p1">
                    <?php echo e(aiTrans('Önnek joga van arra, hogy saját helyzetével kapcsolatos okokból bármikor tiltakozzon személyes adatainak a Társaság vagy harmadik fél által követett jogos érdekeken alapuló kezelése ellen, beleértve az ilyen jogos érdekeken alapuló profilalkotást is. . Ebben az esetben a továbbiakban nem dolgozzuk fel az Ön személyes adatait, kivéve, ha olyan kényszerítő erejű jogos indokokat bizonyítunk, amelyek felülírják az Ön érdekeit, jogait és szabadságait, vagy jogi igények előterjesztéséhez, gyakorlásához vagy védelméhez.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('Önnek jogában áll bármikor tiltakozni személyes adatainak direkt marketing célú kezelése ellen, ideértve a profilalkotást is, amennyiben az ilyen direkt marketinggel kapcsolatos.', $locale)); ?>

                </p>
                <p class="p1"><?php echo e(aiTrans('A hozzájárulás visszavonásának joga', $locale)); ?></p>
                <p class="p1">
                    <?php echo e(aiTrans('Ön bármikor visszavonhatja az Ön személyes adatainak kezeléséhez nekünk adott hozzájárulását anélkül, hogy ez befolyásolná a visszavonás előtti hozzájáruláson alapuló adatkezelés jogszerűségét.', $locale)); ?>

                </p>
                <p class="p1"><?php echo e(aiTrans('A felügyeleti hatósághoz benyújtott keresetjog', $locale)); ?></p>
                <p class="p1">
                    <?php echo e(aiTrans('Önnek joga van panaszt benyújtani egy tagállam által a természetes személyek alapvető jogainak és szabadságainak védelme érdekében létrehozott felügyeleti hatósághoz a személyes adatok Európai Unión belüli feldolgozásával kapcsolatban.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('Az Ön személyes adataival kapcsolatos, a jelen 13. pontban leírt jogait korlátozhatják a Társaságra vonatkozó európai uniós vagy tagállami jogszabályok.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('A 13. pontban leírt jogaival összhangban a kért információkat indokolatlan késedelem nélkül, de minden esetben a kérelem kézhezvételétől számított egy hónapon belül átadjuk Önnek. Ez az időszak szükség esetén további két hónappal meghosszabbítható, figyelembe véve a kérelmek összetettségét és számát. Minden ilyen meghosszabbításról a kérelem kézhezvételétől számított egy hónapon belül tájékoztatjuk Önt, a késedelem okaival együtt.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('A 13. szakaszban leírt jogaival összhangban kért információkat ingyenesen adjuk át, hacsak a 13. szakasz másként nem rendelkezik. Ha a kérések nyilvánvalóan megalapozatlanok vagy túlzóak, különösen ismétlődő jellegük miatt, (a) díjat számíthatunk fel. ésszerű díj, figyelembe véve az információnyújtás vagy a kommunikáció, illetve a kért intézkedés megtételének adminisztratív költségeit; vagy b) megtagadja a kérelem teljesítését.', $locale)); ?>

                </p>
                <p class="p1">
                    <?php echo e(aiTrans('A Társaság kérheti Önt, hogy adjon meg további információkat az Ön személyazonosságának megerősítéséhez, hogy kérésének teljesítse a jelen 13. pontban meghatározott jogait, ha megalapozott kétségeink vannak a kérelmet benyújtó természetes személy kilétét illetően.', $locale)); ?>

                </p>
                <p class="p1"><?php echo e(aiTrans('12. A szabályzat változásai', $locale)); ?></p>
                <p class="p1">
                    <?php echo e(aiTrans('A jelen Szabályzat feltételeit időről időre módosíthatjuk. A jelen Szabályzat megváltoztatásakor a frissített Szabályzat Weboldalon történő közzétételével értesítjük az ilyen változásokról. Ezen túlmenően, amikor lényeges változtatásokat hajtunk végre a jelen Szabályzaton, igyekszünk tájékoztatni Önt az ilyen változásokról olyan kommunikációs eszközök használatával, amelyekről úgy gondoljuk, hogy ésszerűen tájékoztatni Önt az ilyen változásokról, és az ilyen változásokról értesítést teszünk közzé a Weboldalon. Eltérő rendelkezés hiányában minden módosítás a frissített Szabályzat weboldalunkon történő közzétételekor lép hatályba.', $locale)); ?>

                </p>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sev666/public_html/alpha-spectre-app.com/resources/views/frontend/hu/privacy.blade.php ENDPATH**/ ?>