<?php $__env->startPush('meta'); ?>
    <title><?php echo e("$website_title $website_name | Web Kullanıcılar İçin Şartlar"); ?></title>
    <meta name="description" content="<?php echo e("Riktlinjer för Användning av $website_title: Detaljer om dina rättigheter och ansvar vid säker användning av våra tjänster."); ?>" />
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<div class="container page-inner pt-5">
    <h1><?php echo e(aiTrans('Användarvillkor')); ?></h1>
    <main>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Tillhandahållaren (”Företaget“, ”oss“, ”vårt“ eller ”vi“) erbjuder genom sin avsedda programvara och webbplats (”Webbplatsen“) vissa marknadsförings-, reklam-, promotions- och relaterade tjänster (”Tjänsten“; användarna av Tjänsten benämns ”Användare“, ”du“ eller ”ditt“). Dessa användarvillkor (”Villkoren“) reglerar Användarnas åtkomst och användning av Webbplatsen och Tjänsterna. Användare måste godkänna dessa Villkor innan de använder Webbplatsen.')); ?></span>
        </p>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Läs dessa Villkor noggrant. Dessa Villkor reglerar din åtkomst till och användning av Webbplatsen och Tjänsterna. Genom att få åtkomst till, registrera dig för att använda, ladda ner, dela eller på annat sätt använda Webbplatsen eller använda någon programvara eller skript som tillhandahålls av oss för att göra Webbplatsen tillgänglig eller användbar, ger du ditt samtycke till både dessa Villkor och vår Sekretesspolicy, som kan ändras från tid till annan enligt vårt eget omdöme. Din fortsatta användning av Webbplatsen kommer att betraktas som ett godkännande av sådana ändrade eller uppdaterade villkor.')); ?></span>
        <span style="font-weight: 400;"><?php echo e(aiTrans('Om du inte godtar något av dessa Villkor, klicka inte på ”ACCEPTERA” och använd inte Webbplatsen.')); ?></span>
        </p>
        <p><strong><?php echo e(aiTrans('Webbplats')); ?></strong> <?php echo e(aiTrans('avser [website_title], tillgänglig från', $locale, ['website_title' => $website_title])); ?> <a href="<?php echo e(route('home', $country)); ?>"><?php echo e($website_title); ?></a></p>
        <div id="toc_container" class="no_bullets">
            <ul class="toc_list">
                <ul>
                    <li><a href="#1_Use_of_Website_and_Services"><span class="toc_number toc_depth_2">0.1</span>
                            <?php echo e(aiTrans('1. Användning av Webbplats och Tjänster')); ?></a></li>
                </ul>
                <li><a href="#2_Restrictions"><span class="toc_number toc_depth_1">1</span>
                        <?php echo e(aiTrans('2. Begränsningar')); ?></a></li>
                <li><a href="#3_Promotional_Materials_and_Newsletters"><span class="toc_number toc_depth_1">2</span>
                        <?php echo e(aiTrans('3. Marknadsföringsmaterial och Nyhetsbrev')); ?></a></li>
                <li><a href="#4_Intellectual_Property"><span class="toc_number toc_depth_1">3</span>
                        <?php echo e(aiTrans('4. Immateriella rättigheter')); ?></a></li>
                <li><a href="#5_Privacy"><span class="toc_number toc_depth_1">4</span> <?php echo e(aiTrans('5. Sekretess')); ?></a>
                </li>
                <li><a href="#6_Links"><span class="toc_number toc_depth_1">5</span> <?php echo e(aiTrans('6. Länkar')); ?></a></li>
                <li><a href="#7_Prohibited_Uses"><span class="toc_number toc_depth_1">6</span>
                        <?php echo e(aiTrans('7. Förbjudna användningar')); ?></a></li>
                <li><a href="#8_Support"><span class="toc_number toc_depth_1">7</span> <?php echo e(aiTrans('8. Support')); ?></a>
                </li>
                <li><a href="#9_Disclaimers"><span class="toc_number toc_depth_1">8</span>
                        <?php echo e(aiTrans('9. Ansvarsfriskrivningar')); ?></a></li>
                <li><a href="#10_Limitation_of_Liability"><span class="toc_number toc_depth_1">9</span>
                        <?php echo e(aiTrans('10. Ansvarsbegränsning')); ?></a></li>
                <li><a href="#11_Indemnification"><span class="toc_number toc_depth_1">10</span>
                        <?php echo e(aiTrans('11. Skadeslöshet')); ?></a></li>
                <li><a href="#12_Miscellaneous"><span class="toc_number toc_depth_1">11</span>
                        <?php echo e(aiTrans('12. Diverse')); ?></a></li>
            </ul>
        </div>
        <h5><span id="1_Use_of_Website_and_Services"><b><?php echo e(aiTrans('1. Användning av Webbplats och Tjänster')); ?></b></span></h5>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Med förbehåll för de villkor och bestämmelser som anges häri, får du komma åt och använda Webbplatsen i syfte att använda Tjänsterna på en icke-exklusiv basis. Du erkänner att Företaget, efter eget omdöme och när som helst, kan ändra, uppdatera eller på annat sätt förändra Webbplatsen eller Tjänsterna, inklusive att upphöra med att tillhandahålla delar eller hela Webbplatsen och/eller Tjänsterna eller ändra eller ta bort något innehåll som är tillgängligt via Webbplatsen eller Tjänsterna, utan föregående meddelande.')); ?></span>
        </p>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Användningen av Webbplatsen och Tjänsterna är ogiltig där det är förbjudet. Genom att använda Webbplatsen och Tjänsterna bekräftar och garanterar du att: (a) all information du lämnar (om tillämpligt) är sann och korrekt; (b) du kommer att upprätthålla noggrannheten i sådan information; (c) du är minst myndig i din jurisdiktion; och (d) din användning av Webbplatsen eller Tjänsterna inte bryter mot eller främjar brott mot några tillämpliga lagar eller regler eller några juridiska eller kontraktsenliga skyldigheter som du kan ha gentemot en tredje part och du har och kommer att alltid följa alla tillämpliga lagar, regler och förordningar i samband med din användning av Tjänsterna och Webbplatsen, inklusive utan begränsning sådana tjänster som är kopplade på något sätt till Produkter eller Tredje Parter, som sådana termer definieras här.')); ?></span>
        </p>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Underavsnitt (a)-(d) ska gemensamt kallas för')); ?></span><b><?php echo e(aiTrans('”Användarens åtaganden och garantier“')); ?></b><span style="font-weight: 400;">.</span>
        </p>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Genom att använda Tjänsterna eller Webbplatsen förstår och godkänner du att Företaget kan, efter eget omdöme, men inte är skyldigt att, verifiera att något eller alla Användarens åtaganden och garantier uppfylls av någon Användare och du godkänner vidare att Företaget inte är ansvarigt för att säkerställa att Användarens åtaganden och garantier uppfylls eller för något misslyckande att avbryta, avsluta eller förhindra användningen av Tjänsterna eller Webbplatsen av Användare som inte uppfyller Användarens åtaganden och garantier. Du förstår att du är ensam ansvarig för att göra dina egna utvärderingar, beslut och bedömningar om huruvida du ska samarbeta med några Tredje Parter eller på annat sätt interagera med några Tredje Parter på något sätt. Om du blir medveten om något brott mot Användarens åtaganden och garantier uppmuntras du att rapportera det till Företaget.')); ?></span>
        </p>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Företaget förbehåller sig rätten att inte tillhandahålla dig några Tjänster med eller utan meddelande efter eget omdöme, oavsett om det blir medvetet om något brott mot Användarens åtaganden och garantier (antingen genom rapporter från andra Användare eller på annat sätt) av dig eller någon annan Användare, eller av någon annan anledning. Utan att inskränka på ovanstående förbehåller sig Företaget uttryckligen rätten, och du befriar uttryckligen Företaget från, något och alla ansvar på något sätt för eventuella kontroverser, krav, stämningar, skador, förluster, skador och/eller skador som uppstår från och/eller på något sätt relaterar till: (i) eventuell felaktighet, försenad eller ofullständig representation av en Användare eller Tredje Part; och (ii) felaktiga uppgifter och/eller felaktiga representationer som gjorts, antingen i samband med eller av någon av Tredje Parter eller andra Användare, Produkter eller på annat sätt. Genom att använda Webbplatsen och Tjänsterna förstår och godkänner du att Tjänsterna endast erbjuder en plattform avsedd att hjälpa Användare att nå, köpa och/eller använda olika produkter och tjänster som tillhandahålls av tredje part leverantörer och/eller tjänsteleverantörer, genom de annonser eller kampanjer som vi kör (respektive, ”Produkter” och ”Tredje Parter“, respektive).')); ?></span>
        </p>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Du förstår och godkänner att Företaget: (a) anställer, rekommenderar eller stöder inga Tredje Parter eller Produkter, i relevant mening, eller någon relaterad part och har ingen kontroll över de åtgärder eller underlåtenheter från någon Tredje Part, deras företag, deras produkter eller tjänster; (b) gör inga representationer eller garantier angående Tredje Parter och Produkter, inklusive deras kvalitet, prissättning, kompatibilitet, tillgänglighet eller några andra funktioner, eller angående dina interaktioner eller affärer med några Tredje Parter; (c) gör inga representationer eller garantier angående de äganderättigheter eller andra rättigheter eller funktioner eller reglerande aspekter relaterade till Produkterna, inklusive eventuell nödvändig auktorisation, tillstånd eller licenser för uppladdning, delning eller på annat sätt tillgängliggörande, samt för användning, försäljning och köp av sådana Produkter; och (d) inte är ansvarig för prestationen eller uppträdandet av någon Användare eller andra tredje parter på något sätt som använder eller har använt Tjänsterna och/eller på eller av Webbplatsen. Företaget är inte skyldigt att granska eller på annat sätt verifiera någon information angående Tredje Parter och/eller Användare, Produkterna eller någon annan funktion relaterad till Webbplatsen eller Tjänsterna och därför bör du utöva försiktighet och utföra dina egna undersökningar och kontroller innan du engagerar dig med någon genom Tjänsterna eller Webbplatsen eller på annat sätt interagerar med någon.')); ?></span>
        </p>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Företaget uttryckligen friskriver sig från, och du befriar uttryckligen Företaget från, något och allt ansvar för eventuella kontroverser, krav, stämningar, skador, förluster, skador och/eller skador som uppstår från och/eller på något sätt relaterar till Tredje Parter, Produkter, Tjänster och Webbplatsen eller dina interaktioner eller affärer med några Tredje Parter, inklusive utan begränsning några åtgärder och/eller underlåtenheter från Tredje Parter på något sätt som använder eller är kopplade till Tjänsterna eller Webbplatsen på något sätt. Genom att använda Tjänsterna eller Webbplatsen erkänner du att du är ensam ansvarig för sådan användning och de anslutningar, interaktioner, köp eller någon annan åtgärd du gör och att all användning av Tjänsterna eller Webbplatsen sker på egen risk. För att undvika tvivel säljer, licensierar eller på annat sätt gör Företaget inga Produkter eller tjänster (annat än Tjänsterna) tillgängliga för dig och skall inte ha något ansvar för några Produkter eller tjänster som du köper från någon Tredje Part, inklusive utan begränsning, med avseende på något stöd och underhåll, fel, brister, fel, skador eller kostnader av något slag.')); ?></span>
        </p>
        <h4><span id="2_Restrictions"><span style="font-weight: 400;"><?php echo e(aiTrans('2. Begränsningar')); ?></span></span>
        </h4>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Utan att inskränka på bestämmelserna i avsnitt 1 ovan, får du inte och ska inte tillåta någon tredje part att: (a) omvända ingenjör eller försöka hitta den underliggande koden för Webbplatsen eller Tjänsterna; (b) använda Webbplatsen eller Tjänsterna i strid med någon tillämplig lag eller förordning, inklusive men inte begränsat till, publicera, publicera, dela eller på annat sätt överföra något olagligt eller stötande material; (c) kopiera, ändra eller skapa härledda verk av Webbplatsen, Tjänster eller innehåll från någon av Webbplatsen eller Tjänsterna; (d) försöka inaktivera eller kringgå något säkerhets- eller åtkomstkontrollmekanism för Webbplatsen eller Tjänsterna; (e) utforma eller bistå i utformningen av fusk, exploatering, automatiseringsprogram, botar, hacks, lägen eller någon annan otillåten tredjepartsprogramvara för att ändra eller störa Webbplatsen eller Tjänsterna; (f) använda Webbplatsen eller Tjänsterna eller engagera sig med andra Användare för något syfte som strider mot någon tillämplig lag eller förordning; (g) försöka få obehörig åtkomst till Webbplatsen eller Tjänsterna, andra Användarkonton, som definieras nedan, eller annan enhet, datorsystem, telefonssystem eller nätverk kopplat till Webbplatsen eller Tjänsterna; och (h) skörda eller på annat sätt samla in information om Användare utan deras samtycke.')); ?></span>
        </p>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Om du publicerar, publicerar, delar eller på annat sätt överför innehåll genom Webbplatsen och/eller använder Tjänsterna, bekräftar och garanterar du att sådant innehåll ger en korrekt och fullständig bild av eventuella produkter eller tjänster som beskrivs där, följer dessa Villkor här och inte: (a) kränker immateriella rättigheter, moraliska rättigheter eller offentlighetsrättigheter hos någon tredje part; (b) innehåller något nedsättande, ärekränkande, obscena, sexuellt suggestivt eller på annat sätt stötande innehåll (inklusive material som främjar eller glorifierar hat, våld eller bigotteri); (c) innehåller några maskar, virus eller annan skadlig programvara; (d) bryter mot någon tillämplig lag eller förordning, inklusive någon lag eller förordning som rör reklam eller marknadsföring; och (e) vidta några åtgärder som innebär en orimlig eller oproportionerligt stor belastning på vår infrastruktur.')); ?></span>
        </p>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Genom att publicera, ladda upp, publicera, dela eller på annat sätt överföra något innehåll med hjälp av Webbplatsen eller Tjänsterna, ger du härmed oåterkalleligt Företaget och dess dotterbolag och/eller underlicenser en världsomspännande, icke-exklusiv, evig, royaltyfri licens att publicera, dela, visa och på annat sätt överföra sådant innehåll i en rimlig form som skall vara efter Företagets eget omdöme. Företaget förbehåller sig rätten att ta bort, suspenda åtkomst till eller permanent ta bort något innehåll enligt eget omdöme utan föregående meddelande, inklusive utan begränsning något innehåll som bryter mot de garantier som anges ovan eller Företagets affärsintressen, och du har ingen rätt eller krav beträffande några sådana beslut och åtgärder.')); ?></span>
        </p>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Företaget är inte, och ska inte vara, ansvarigt för något innehåll som tillhandahålls, publiceras, laddas upp, delas eller på annat sätt görs tillgängligt av Användare, några produkter eller tjänster relaterade till sådant innehåll som tillhandahålls, publiceras, laddas upp, delas eller på annat sätt görs tillgängligt av Användare. Varje Användare som använder Webbplatsen eller Tjänsterna bekräftar härmed att ta fullt ansvar för detta, och Företaget ska inte ha något ansvar i förhållande till det föregående.')); ?></span>
        </p>
        <h4><span id="3_Promotional_Materials_and_Newsletters"><span style="font-weight: 400;"><?php echo e(aiTrans('3. Marknadsföringsmaterial och Nyhetsbrev')); ?></span></span>
        </h4>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Förutom bestämmelserna i avsnitt 3 ovan, ger Användaren sitt uttryckliga samtycke till Företaget att tillhandahålla Användaren marknadsföringsmaterial och nyhetsbrev (”Marknadsföringsmaterial och Nyhetsbrev“) med alla tillgängliga medel, inklusive via e-post, text- och SMS-meddelanden, fax, post, automatiserade uppringningstjänster eller på något annat sätt, allt i enlighet med Företagets eget omdöme som ska vara från tid till annan, och att ta emot sådana Marknadsföringsmaterial och Nyhetsbrev.')); ?></span>
        </p>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Användaren erkänner vidare att Marknadsföringsmaterial och Nyhetsbrev kan innehålla annonsering från tredje parter, och han ger uttryckligt sitt samtycke till att ta emot sådana annonser som en del av Marknadsföringsmaterial och Nyhetsbrev. Användaren kan kontakta Företaget när som helst genom att skicka en begäran via e-post som meddelar Företaget om sitt vägran att ytterligare ta emot Marknadsföringsmaterial och Nyhetsbrev.')); ?></span>
        </p>
        <h4><span id="4_Intellectual_Property"><span style="font-weight: 400;"><?php echo e(aiTrans('4. Immateriella rättigheter')); ?></span></span></h4>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Företaget är ägare av alla globala rättigheter, titlar och intressen i: (a) Webbplatsen och Tjänsterna, förbättringar, härledningar, buggfixar eller förbättringar av Webbplatsen och Tjänsterna; och (b) handelsnamn, varumärken och logotyper från Företaget, och skall alltid förbli exklusivt med Företaget. Alla hänvisningar i dessa Villkor eller andra kommunikationer till försäljning, återförsäljning eller köp av ovanstående skall endast innebära rätten att använda Webbplatsen och Tjänsterna enligt dessa Villkor. Användare bär fullt ansvar för allt innehåll, inklusive alla immateriella rättigheter, som tillhandahålls, delas eller på annat sätt görs tillgängligt av Användarna som använder Webbplatsen och/eller Tjänsterna, och Företaget gör inga representationer med avseende på något sådant innehåll. Företaget kommer inte att vara ansvarigt för några förluster eller skador som uppstår genom sådant innehåll, och Användare godkänner att skadeslösa och hålla Företaget skadeslöst för eventuell skada eller förlust som uppstår från ovanstående.')); ?></span>
        </p>
        <h4><span id="5_Privacy"><span style="font-weight: 400;"><?php echo e(aiTrans('5. Sekretess')); ?></span></span></h4>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Du åtar dig att inte spara, samla eller på annat sätt upprätthålla i din ägo och använda något innehåll som tillhandahålls av Tjänsterna och Webbplatsen utan Företagets föregående skriftliga samtycke. Du erkänner vidare att Företaget förbehåller sig rätten, efter eget omdöme, att spara, samla eller på annat sätt upprätthålla och använda något innehåll och offentlig information, inklusive information som kan identifiera dig personligen eller någon annan Användare eller Tredje Part eller beskriva dina personliga intressen. Företaget förbehåller sig rätten att göra alla och varje tillåten användning enligt tillämplig lag av sådant innehåll och offentlig information som anges i Företagets Sekretesspolicy. Utan att inskränka på bestämmelserna i avsnitt 1 ovan, granskar, testar, bekräftar, godkänner eller på annat sätt verifierar Företaget ingen sådan information angående Tredje Parter och/eller Användare, Produkter eller någon annan funktion relaterad till Webbplatsen eller Tjänsterna. Varje Användare som publicerar, laddar upp, delar eller på annat sätt gör tillgängligt sådant innehåll eller offentlig information ska bära det fulla ansvaret för innehållet eller den offentliga informationen, inklusive alla och all tredje part information och nödvändiga samtycken. Företaget kommer inte att vara ansvarigt för någon förlust eller skada som uppstår genom att inte följa ovanstående, och du samtycker till att skadeslösa och hålla Företaget skadeslöst för eventuell skada eller förlust som uppstår av ovanstående. TROTS DET OVANSTÅENDE FÖRSTÅR OCH ERKÄNNER DU ATT FÖRETAGET INTE ÄR EN INNEHÅLLNINGSTJÄNST. FÖRETAGET SKA INTE HA NÅGOT ANSVAR FÖR FÖRLORAT ELLER RADERAT INNEHÅLL ELLER OFFENTLIG INFORMATION. DU BÖR VARA MEDVETEN OM ATT ALLT INNEHÅLL SOM PUBLICERAS, LADDAS UPP, DELAS ELLER PÅ ANNAT SÄTT GÖRS TILLGÄNGLIGT KAN LÄSAS, SAMLAS IN OCH ANVÄNDAS AV ANDRA ANVÄNDARE, OCH KAN ANVÄNDAS FÖR ATT SKICKA OBEGÄRDADE INNEHÅLL.')); ?></span>
        </p>
        <h4><span id="6_Links"><span style="font-weight: 400;"><?php echo e(aiTrans('6. Länkar')); ?></span></span></h4>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Webbplatsen eller Tjänsterna kan innehålla länkar eller annat innehåll relaterat till webbplatser, annonsörer, utgivare eller produkter som erbjuds av tredje parter. Företaget har ingen kontroll och gör inga representationer med avseende på detta eller någon information som tillhandahålls eller överförs via detta, eller på annat sätt tillhandahålls av någon sådan tredje part. DU FÖRSTÅR OCH GODKÄNNER ATT ANVÄNDNINGEN AV SÅDANA LÄNKAR ELLER ANNAT INNEHÅLL ÄR PÅ DIN EGEN RISK, ATT SÅDANA LÄNKAR ELLER ANNAT INNEHÅLL REGLERAS AV SÅDANA TREDJE PARTERS ANVÄNDARVILLKOR OCH SEKRETESSPOLICYS, OCH ATT FÖRETAGET INTE ÄR ANSVARIGT FÖR SEKRETESS ELLER AFFÄRSPRAXIS ELLER ANDRA POLICYER FÖR SÅDANA TREDJE PARTER. DU bör noggrant granska de tillämpliga villkoren och policyerna som gäller för någon sådan Tredje Part. FÖRETAGET ÄR INTE ANSVARIGT ELLER SKA INTE VARA ANSVARIGT PÅ NÅGOT SÄTT FÖR SÅDANA TREDJE PARTER, ELLER FÖR NÅGON FÖRLUST ELLER SKADA AV NÅGOT SLAG SOM UPPSTÅR SOM RESULTAT AV DETTA, OCH FÖRETAGET FRISKRIVER SIG UTTRYCKLIGEN, OCH DU FRISKRIVER FÖRETAGET FRÅN, ALLA OCH ALLA ANSVAR PÅ NÅGOT SÄTT FÖR NÅGRA KONTROVERSER, KRAV, STÄMNINGAR, SKADOR, FÖRLUST, SKADA OCH/ELLER SKADOR, SOM UPPSTÅR FRÅN OCH/ELLER PÅ NÅGOT SÄTT RELATERAR TILL SÅDANA TREDJE PARTER, INKLUSIVE UTAN BEGRÄNSNING SOM RÖR TILLGÅNG, ANVÄNDARVILLKOR, SEKRETESS, INFORMATION, INNEHÅLL, MATERIAL, ANNONSERING, AVGIFTER, PRODUKTER OCH/ELLER TJÄNSTER.')); ?></span>
        </p>
        <h4><span id="7_Prohibited_Uses"><span style="font-weight: 400;"><?php echo e(aiTrans('7. Förbjudna användningar')); ?></span></span></h4>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Webbplatsen och Tjänsterna får inte användas i samband med några kommersiella strävanden (såvida det inte uttryckligen tillåts av Företaget i samband med att Användare kopplas till några Tredje Parter) utan Företagets uttryckliga skriftliga samtycke. Webbplatsen och Tjänsterna får inte användas av någon person eller organisation för att rekrytera för en annan webbplats, begära, annonsera eller kontakta i någon form Användare för anställning, kontrakt eller något annat syfte för ett företag som inte är kopplat till Företaget utan uttryckligt skriftligt tillstånd från Företaget. Du godkänner att inte använda Tjänsterna och Webbplatsen för att kontakta, annonsera, begära eller sälja till någon annan Användare utan deras uttryckliga samtycke, såvida inte det uttryckligen tillåts under dessa Villkor.')); ?></span>
        </p>
        <h4><span id="8_Support"><span style="font-weight: 400;"><?php echo e(aiTrans('8. Support')); ?></span></span></h4>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Användare kan kontakta Företaget angående support för Webbplatsen och Tjänsterna genom att skicka ett e-postmeddelande.')); ?></span>
        </p>
        <h4><span id="9_Disclaimers"><span style="font-weight: 400;"><?php echo e(aiTrans('9. Ansvarsfriskrivningar')); ?></span></span></h4>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Företaget gör rimliga ansträngningar för att säkerställa att dess teknik håller Webbplatsen och Tjänsterna säkra och trygga. Ingen teknik är dock 100% säker. Därför, medan vi strävar efter att använda kommersiellt acceptabla metoder för att skydda din personliga information, kan vi inte garantera dess absoluta säkerhet. Förutom vad som uttryckligen anges här, sker din användning av Webbplatsen och Tjänsterna på egen risk. Webbplatsen och Tjänsterna tillhandahålls på en ”AS IS” och ”SOM TILLGÄNGLIG” basis utan några garantier av något slag. Företaget avsäger sig uttryckligen alla underförstådda eller lagstadgade garantier av något slag relaterade till Webbplatsen och Tjänsterna, inklusive utan begränsning garantier för äganderätt, säljbart skick, lämplighet för ett visst syfte, icke-kränkning av äganderättigheter, handelsmetoder eller prestanda. Företaget ger ingen rådgivning angående risk eller lämplighet för någon affär, transaktion eller engagemang. Företaget tar inget ansvar för några transaktioner eller engagemang som görs av dig och du bekräftar att du är ensam ansvarig för bedömningen av dina transaktioner och engagemang. Du ska inte hålla Företaget, dess tjänstemän, anställda eller dotterbolag ansvariga för några transaktions- eller engagemangsval gjorda av dig. Ingen rådgivning eller information, vare sig muntlig eller skriftlig, som du får från Företaget eller dess tjänstemän, anställda eller dotterbolag, ska skapa någon garanti som inte uttryckligen anges i dessa Villkor. Om du väljer att förlita dig på sådan information, gör du det helt på egen risk. Vissa stater eller jurisdiktioner tillåter inte uteslutning av vissa garantier. Följaktligen kanske vissa av ovanstående uteslutningar inte gäller för dig.')); ?></span>
        </p>
        <h4><span id="10_Limitation_of_Liability"><span style="font-weight: 400;"><?php echo e(aiTrans('10. Ansvarsbegränsning')); ?></span></span></h4>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Företaget garanterar inte värdet, kvaliteten, kompatibiliteten eller något annat drag hos Tredje Parter, Produkter eller någon annan information som tillhandahålls, konsumeras eller på annat sätt görs tillgänglig (nedan i detta avsnitt: ”Funktionerna“). Varje Funktion är under den enda ansvaret för den tillämpliga Tredje Parten eller Användaren som använder den, beroende på vad som är tillämpligt, eller använder Tjänsterna eller Webbplatsen. Företaget åtar sig inte att övervaka sådan efterlevnad och kan agera när icke-efterlevnad upptäckts som skall beslutas i enlighet med sitt eget omdöme, som beskrivs i dessa Villkor. Du förstår och godkänner att du kan bli utsatt för innehåll eller annan information som är felaktig, oönskad, olämplig för barn eller på annat sätt olämplig för dig.')); ?></span>
        </p>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Företaget ansvarar inte för några problem eller tekniska funktionsfel i något telefonnät eller linjer, datorsystem online, servrar eller leverantörer, datorkomponenter, programvara, fel i något e-postmeddelande på grund av tekniska problem eller trafikstockningar på Internet eller på något av Webbplatsen eller Tjänsterna eller i kombination därav, inklusive eventuella skador eller skador på Användare eller någon persons dator, mobiltelefon eller någon annan enhet relaterad till eller som resulterar av deltagande eller nedladdning av material i samband med Webbplatsen eller Tjänsterna. Under inga omständigheter ska Företaget vara ansvarigt för uppträdandet av tredje parter, inklusive Användare, oavsett om online eller offline, och operatörer av externa webbplatser.')); ?></span>
        </p>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('I inget fall ska Företaget eller någon av dess tjänstemän, direktörer, anställda eller agenter vara ansvariga för några indirekta, tillfälliga, speciella, bestraffande eller följdskador, som uppstår till följd av eller i samband med din användning av Webbplatsen eller Tjänsterna, oavsett om skadorna är förutsebara och oavsett om Företaget har blivit informerat om möjligheten av sådana skador. Den föregående ansvarsbegränsningen ska gälla i största möjliga utsträckning enligt lag i den tillämpliga jurisdiktionen.')); ?></span>
        </p>
        <h4><span id="11_Indemnification"><span style="font-weight: 400;"><?php echo e(aiTrans('11. Skadeslöshet')); ?></span></span></h4>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Du kommer att försvara, skadeslöst hålla och skydda Företaget från och mot alla och varje talan, processer, påståenden, skador, kostnader, skulder eller utgifter (inklusive rättegångskostnader och rimliga advokatarvoden) som Företaget kan lida eller drabbas av i samband med något verkligt krav, krav, åtgärd eller annan process från en tredje part som uppstår av eller relaterar till någon överträdelse av dessa Villkor av dig eller någon användning av Webbplatsen eller Tjänsterna som inte överensstämmer med tillämplig lag.')); ?></span>
        </p>
        <h4><span id="12_Miscellaneous"><span style="font-weight: 400;"><?php echo e(aiTrans('12. Diverse')); ?></span></span></h4>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Dessa Villkor ska regleras av lagarna i England, exklusive dess lagval regler, och utan hänsyn till Förenta Nationernas konvention om internationella försäljningar av varor. Ditt beteende kan också omfattas av andra lokala, statliga och nationella lagar. Eventuella tvister som uppstår under dessa Villkor eller rör Webbplatsen eller Tjänsten ska slutligen avgöras av de behöriga domstolarna i England. Du får inte driva några grupptalan mot Företaget, och genom att använda Webbplatsen eller Tjänsterna godkänner du att avstå från din rätt att driva några sådana grupptalan.')); ?></span>
        </p>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Varje talan mot Företaget måste föras inom ett (1) år från det datum då sådan talan uppstod. Om någon bestämmelse i dessa Villkor bedöms vara ogenomförbar, ska sådan bestämmelse ersättas med en genomförbar bestämmelse som närmast uppnår effekten av den ursprungliga bestämmelsen, och de återstående villkoren i dessa Villkor ska förbli i full kraft och verkan. Ingenting i dessa Villkor skapar något agentur-, anställnings-, joint venture- eller partnerskapsförhållande mellan dig och Företaget eller möjliggör att du agerar å Företagets vägnar. Utan vad som kan anges uttryckligen i dessa Villkor utgör dessa Villkor hela avtalet mellan Företaget och dig angående ämnet här.')); ?></span>
        </p>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Eventuella meddelanden som vi kan vara skyldiga att tillhandahålla dig, vare sig enligt lag eller enligt dessa Villkor, kan tillhandahållas av Företaget till vilken kontaktinformation du har angivit i din Kontoinformation eller på annat sätt, antingen direkt eller indirekt, inklusive via e-post. Du godkänner uttryckligen mottagandet av sådana meddelanden och kommunikationer på detta sätt.')); ?></span>
        </p>
        <p><span style="font-weight: 400;"><?php echo e(aiTrans('Du får inte överlåta några rättigheter härunder utan vår föregående skriftliga samtycke. Ingenting som anges i dessa Villkor ska tolkas som att begränsa de åtgärder eller rättsmedel som är tillgängliga för Företaget med avseende på någon otillåten aktivitet eller uppträdande. Icke-verkställighet av någon bestämmelse i dessa Villkor utgör inte samtycke eller avstående, och Företaget förbehåller sig rätten att verkställa sådan bestämmelse efter eget omdöme. Ingen avstående av något brott eller underlåtenhet härunder ska anses vara ett avstående av något föregående eller efterföljande brott eller underlåtenhet.')); ?></span>
        </p>
        <p> </p>
    </main>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sev666/public_html/alpha-spectre-app.com/resources/views/frontend/tr/terms.blade.php ENDPATH**/ ?>