<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>おめでとうございます!</title>
    <link rel="icon" type="image/png" href="<?php echo e(asset('frontend/assets/en/dist/fav.png')); ?>">
    <meta name="robots" content="noindex, nofollow">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700&display=swap');
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            background: #f5f5f5;
            font-family: 'Montserrat', sans-serif;
            color: #333;
            text-align: center;
            padding: 1rem;
        }
        .container {
            background: #fff;
            padding: 2rem;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            max-width: 500px;
        }
        .logo-img {
            width: 100px;
            margin-bottom: 1.2rem;
        }
        h2 {
            font-weight: 700;
            font-size: 1.8rem;
            margin-bottom: 1rem;
        }
        p {
            font-weight: 400;
            font-size: 1.2rem;
            margin-bottom: 1.2rem;
            line-height: 1.6;
        }
        .countdown {
            font-weight: bold;
            font-size: 1.5rem;
            display: inline-block;
            margin-top: 1rem;
            color: #d9534f;
            min-width: 30px;
        }
    </style>
</head>
<body>
    <div class="container">
        <script type="text/javascript">
            var timeleft = 5;
            var downloadTimer = setInterval(function(){
                timeleft--;
                document.getElementById("countdowntimer").textContent = timeleft;
                if(timeleft <= 0)
                    clearInterval(downloadTimer);
            },1000);
        </script>

        <h2>ご登録ありがとうございます！</h2>
        <p>まもなく、国際番号から個人マネージャーがプラットフォームへのアクセスに必要な情報をお伝えするためにお電話いたします。アカウントを有効にするために、電話にご対応ください。</p>
        <br><br>
        <i><p><span id="countdowntimer" class="countdown">5</span> 秒後にプラットフォームにリダイレクトされます...</p></i>
    </div>

    <script type="text/javascript">
        // Decode the URL in case it was URL-encoded by the server
        var url = decodeURIComponent('<?php echo e(request('redirect_url')); ?>');

        setTimeout(function() {
            if (url) {
                window.location.href = url;
            }
        }, 5000); // Redirect after 5 seconds
    </script>
</body>
</html>
<?php /**PATH /home/sev666/public_html/aisterbot.com/resources/views/frontend/ja/thank-you.blade.php ENDPATH**/ ?>