@extends('layouts.app')

@push('meta')
    <title>{{ "$website_title :  (About us 2025)" }}</title>
    <meta name="description" content="{{ "Enroll with $website_title to sharpen your cryptocurrency investment moves. Utilize high-end tools and proficient assistance to take strides." }}" />
@endpush

@section('content')
    <section class="banner">
        <div class="container">
            <h1 class="banner-title display-4 fw-bold text-center mb-4">{{ aiTrans('About [website_title] Website', $locale,['website_title'=>$website_title]) }}</h1>
            <h2 class="banner-desc display-7 text-center mb-5"></h2>
        </div>
    </section>
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-md-8">
                    <h2 class="display-5 fw-bold mb-4">{{$website_title}}  {{ aiTrans('Team', $locale) }}</h2>
                    <div>
                        <p>{{ aiTrans('At', $locale) }} <a href="{{route('home')}}" class="text-secondary">{{$website_title}}</a>, {{ aiTrans('our commitment to financial egalitarianism is unwavering. We champion the notion that the average Joe deserves access to the same elite investment prospects as the affluent and erudite market players.', $locale) }}</p>
                        <p>{{ aiTrans('Regrettably, the conventional bastions of finance do not cater to the modest investor. Navigating the complexities of traditional financial instruments demands substantial acumen. Moreover, the barrier of a hefty financial ante often precludes entry.', $locale) }}</p>
                        <p>{{ aiTrans('On a foundational level, the cryptocurrency realm was birthed with the pledge of democratizing finance. Nevertheless, the established methodologies of crypto engagement continue to marginalize the everyday enthusiast. The acquisition and custodianship of digital assets through orthodox channels are not only laborious but fraught with peril.', $locale) }}</p>
                        <p>{{ aiTrans('Furthermore, a multitude of traders perceive the art of prognosticating crypto market swings via conventional avenues as a cumbersome endeavor. Such volatility speculation unfolds through niche fiscal intermediaries, entailing the exchange of complex instruments like Contracts for Difference (CFDs).', $locale) }}</p>
                    </div>
                </div>
                <div class="col-md-4 d-flex align-items-center">
                    <picture>
                        <source srcset="{{asset('frontend/assets/en/dist')}}/images/412_459__459_65e737bb03f05_about-half-1.webp" type="image/webp">
                        <source srcset="{{asset('frontend/assets/en/dist')}}/images/_459_65e737bb03f05_about-half-1.webp" type="image/webp">
                        <img src="{{asset('frontend/assets/en/dist')}}/images/_459_65e737bb03f05_about-half-1.webp" loading="lazy" width="459" height="412" alt="">
                    </picture>
                </div>
            </div>
        </div>
    </section>

    <section class="py-5">
        <div class="container">
            <div class="row flex-md-row flex-column-reverse ">
                <div class="col-md-4 d-flex align-items-center">
                    <picture>
                        <source srcset="{{asset('frontend/assets/en/dist')}}/images/234_459__459_65e737dd92d14_about-half-2.webp" type="image/webp">
                        <source srcset="{{asset('frontend/assets/en/dist')}}/images/_459_65e737dd92d14_about-half-2.webp" type="image/webp">
                        <img src="{{asset('frontend/assets/en/dist')}}/images/_459_65e737dd92d14_about-half-2.webp" loading="lazy" width="459" height="234" alt="">
                    </picture>
                </div>
                <div class="col-md-8">
                    <h2 class="display-5 fw-bold mb-4">{{ aiTrans('How we bring about financial inclusion', $locale) }}</h2>
                    <div>
                        <p><em>{{ $website_title}}</em> {{ aiTrans('simplifies the intricacies of cryptocurrency speculation. It\'s a game-changer for the everyday investor, offering a swift passage to potential windfalls. Our suite of analytical enhancements elevates your market research capabilities.', $locale) }}</p>
                        <p>{{ aiTrans('These innovations empower you to craft robust tactics, navigate the ebbs and flows of market volatility, and amplify your portfolio through strategic reinvestment. In the 2025, legions of traders have linked their triumphs in digital currency dealings to our arsenal of resources.', $locale) }}</p>
                        <p>{{ aiTrans('Our commitment is unwavering as we continue to expand our repertoire of instruments, ensuring your voyage through the [url] is seamless, invigorating, and increasingly profitable.', $locale,['url'=>route('home', $country)]) }}</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="banner">
        <div class="container">
            <h1 class="banner-title display-4 fw-bold text-center mb-4">{{ aiTrans('Forging The Path For Universal Learning', $locale) }}</h1>
            <div class="text-center">
                <p>{{ aiTrans('At the heart of [website_title] lies a resolute belief that resources for educational investment must be open to everyone. Crafted with novices in mind, embracing a multitude of languages, and mindful of those watching their finances, [website_title] stands as an illuminating guide across the vast landscape of investment education. The initiative is designed to empower users with a solid grasp of investment principles, ensuring they step forward with confidence in the financial arena.', $locale,['website_title'=>$website_title]) }} </p>
            </div>


            <div class="text-center mt-3 mt-md-4 mb-4 mb-md-0">
                <button class="show-modal btn btn-primary text-white btn-lg shadow-lg px-3 px-md-5 fs-4"><a href="{{route('home')}}" class="text-secondary">Learn more</a></button>
            </div>
        </div>
    </section>
@endsection
