<?php

namespace App\Support\Dashboard\Datatables\Columns;

use App\Domain\Ship\Enums\ShipStatusEnum;

class ShipStatusColumn
{
    private $statusColor = [
        'success',
        'danger',
        'primary',
        'warning',
    ];

    public static function getStatusColorAttribute($status)
    {
        switch ($status) {
            case ShipStatusEnum::in_warehouse()->value:
            case ShipStatusEnum::returned()->value:
            case ShipStatusEnum::return_request()->value:
            case ShipStatusEnum::transfer()->value:
            case ShipStatusEnum::reverse_picked_up()->value:
                return 'warning';
            case ShipStatusEnum::failed_return_request()->value:
            case ShipStatusEnum::successful_return_request()->value:
            case ShipStatusEnum::canceled()->value:
                return 'danger';
            case ShipStatusEnum::new()->value:
            case ShipStatusEnum::picked_up()->value:
                return 'primary';
            default:
                return 'success';

        }
    }

    public static function render($model, $status): string
    {
        $color = self::getStatusColorAttribute($model->status);
        $status = ShipStatusEnum::from($status)->label;
        return "<span class='badge badge-$color fs-7 fw-bold'>$status</span>";
    }
}
