<?php

namespace App\Domain\User\Datatables;

use App\Domain\User\Models\Withdrawal;
use App\Support\Dashboard\Datatables\BaseDatatable;
use Illuminate\Database\Eloquent\Builder;
use Yajra\DataTables\Html\Column;

class WithdrawalDatatable extends BaseDatatable
{
    public function query(): Builder
    {
        return Withdrawal::query();
    }

    protected function columns(): array
    {
        return [
            Column::make('status')->title(__('Status')),
            Column::make('amount')->title(__('Amount')),
        ];
    }
}
