<?php

namespace App\Domain\Core\Models;

use App\Events\Core\BranchChanged;
use App\Support\Concerns\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;

class Branch extends Model
{
    use HasFactory, SoftDeletes, HasTranslations;


    protected $guarded = [];
    public $translatable = ['title'];

    public function city()
    {
        return $this->belongsTo(City::class);
    }
}
