
<?php $__env->startPush('meta'); ?>
    <title><?php echo e("$website_title ™ | Site-ul oficial al aplicației 2025"); ?></title>
    <meta name="description" content="<?php echo e("$website_title vă susține strategiile de investiții în criptomonede, oferind instrumente avansate și suport cuprinzător pentru a vă ajuta să atingeți obiectivele de tranzacționare."); ?>" />
<?php $__env->stopPush(); ?>



<?php $__env->startSection('content'); ?>
<!-- Hero -->
<section id="hero" class="hero-section">
    <div class="uk-container">
        <div class="hero-inner">

            <div class="hero-meta uk-text-center">
                <h1><?php echo e($website_title); ?></h1>
            </div>

            <div class="uk-grid-small" uk-grid>
                <div class="uk-width-expand@s">
                    <img class="hero-img" src="<?php echo e(asset('frontend/assets/ro/dist')); ?>/images/hero.jpg" alt="">
                </div>
                <div class="uk-width-1-2@s">
                    <div class="hero-form">
                        <div class="main-form-title">
                            <h2><?php echo e(aiTrans('A descoperi')); ?> <span><?php echo e($website_title); ?></span></h2>
                        </div>

                        <div class="form_panel">
                            <?php echo $__env->make('frontend.ro.components.form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                    </div>
                </div>
            </div>

        </div>
    </div>
</section>

<section class="section2">
    <div class="uk-container">

        <div class="uk-grid-large" uk-grid>
            <div class="uk-width-expand@s">

                <h2>
                    <?php echo e(aiTrans(
                        'Ce este [website_title]?',
                        $locale,
                        ['website_title' => $website_title],
                    )); ?>

                    </h2>
                <p class="gt-block">
                <span class="change-by-command"><?php echo e("$website_title , unde educația în investiții atinge noi culmi"); ?></span>
                <span class="change-by-command"><?php echo e("Bine ați venit pe  $website_title, platforma care îți deschide calea către investiții"); ?></span>
                </p>

                <a class="c-button" href="#"><span><?php echo e(aiTrans('Aflați mai multe')); ?></span><span class="uk-svg"><svg aria-hidden="true" class="e-font-icon-svg e-fas-arrow-right" viewBox="0 0 448 512" xmlns="http://www.w3.org/2000/svg">
                            <path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z"></path>
                        </svg></span></a>
            </div>
            <div class="uk-width-1-2@s">
                <img class="br20" src="<?php echo e(asset('frontend/assets/ro/dist')); ?>/images/woman-workin.jpg" alt="">
            </div>
        </div>

    </div>
</section>

<section class="section2 section-dark2">
    <div class="uk-container">

        <div class="uk-grid-small" uk-grid>
            <div class="uk-width-2-5@s">
                <img class="br20" src="<?php echo e(asset('frontend/assets/ro/dist')); ?>/images/exchange.jpg" alt="">
            </div>
            <div class="uk-width-expand@s">
                <h2><?php echo e(aiTrans('Educație pentru investiții: o activitate pe tot parcursul vieții')); ?></h2>
                <p>
                    <?php echo e(aiTrans(
                        'Educația pentru investiții este o călătorie continuă esențială pentru a rămâne în frunte în peisajul financiar în continuă evoluție. Piața este influențată de numeroși factori, precum politicile economice, progresele tehnologice și evenimentele globale, așa că este esențial ca investitorii să-și mențină cunoștințele la zi. [website_title] oferă o varietate de module de învățare destinate atât investitorilor începători, cât și cu experiență.',
                        $locale,
                        ['website_title' => $website_title],
                    )); ?>

                    </p>
                <p>
                    <?php echo e(aiTrans(
                        'Începătorii pot începe cu cursuri de bază pe subiecte precum managementul riscului și construcția portofoliului, în timp ce investitorii cu experiență pot explora subiecte avansate, cum ar fi analiza tehnică și tranzacționarea opțiunilor.',
                        $locale,
                        ['website_title' => $website_title],
                    )); ?>

                    </p>
                <p>
                    <?php echo e(aiTrans(
                        'Platforma noastră colaborează cu companii educaționale de top pentru a oferi conținut actualizat și încorporează instrumente interactive precum seminarii web, chestionare și simulări pentru a vă îmbunătăți experiența de învățare. Angajați-vă pentru învățarea pe tot parcursul vieții cu [website_title] Vă permite să luați decizii în cunoștință de cauză, să rămâneți înaintea tendințelor pieței și să vă atingeți obiectivele financiare.',
                        $locale,
                        ['website_title' => $website_title],
                    )); ?>

                    </p>
            </div>

        </div>

    </div>
</section>

<section class="section2 section-white">
    <div class="uk-container">

        <div class="uk-text-center padding-10">
            <h2>
                
                <?php echo e(aiTrans(
                    'Descoperirea diverselor rute de investiții cu [website_title]',
                    $locale,
                    ['website_title' => $website_title],
                )); ?>

                </h2>
            <p class="f20">
                <?php echo e(aiTrans(
                    '[website_title] oferă informații despre o varietate de opțiuni de investiții, ajutându-vă să vă diversificați portofoliul și să vă creșteți averea. Iată o privire asupra principalelor căi de investiții disponibile:',
                    $locale,
                    ['website_title' => $website_title],
                )); ?>

                </p>
        </div>

        <div class="uk-grid-medium uk-margin-medium-top" uk-grid>

            <div class="uk-width-1-2@s uk-grid-item-match">
                <div class="gird-box">
                    <h3><?php echo e(aiTrans('Acciones')); ?></h3>
                    <p><?php echo e(aiTrans('Investiția în acțiuni înseamnă cumpărarea de acțiuni la o companie, oferindu-ți o parte din profiturile acesteia prin dividende și câștiguri de capital. Prețurile acțiunilor fluctuează în funcție de cererea și oferta de acțiuni, influențate de performanța companiei și de sentimentul investitorilor. Investiția de succes la bursă implică efectuarea de cercetări ample și diversificarea portofoliului pentru a împrăștia riscul.')); ?></p>
                    <p><?php echo e(aiTrans('Este esențial să luați o perspectivă pe termen lung, să reinvestiți profiturile pentru creșterea compusă și să gestionați riscul prin stabilirea limitelor de investiții și utilizarea unor instrumente precum ordinele stop-loss. A fi informat cu privire la tendințele pieței și a învăța continuu este esențial pentru a lua decizii informate.')); ?></p>
                </div>
            </div>

            <div class="uk-width-1-2@s uk-grid-item-match">
                <div class="gird-box">
                    <h3><?php echo e(aiTrans('Imobiliare')); ?></h3>
                    <p><?php echo e(aiTrans('Investițiile imobiliare implică achiziționarea de proprietăți pentru a genera venituri sau pentru a beneficia de apreciere. Proprietățile pot oferi venituri stabile din chirie. Imobiliarele pot acționa ca o acoperire fiabilă a fluxului de numerar și a inflației, în timp ce proprietatea tinde să se aprecieze în timp, oferind potențiale câștiguri pe termen lung. În plus, efectul de levier ipotecar poate amplifica randamentele cu un capital inițial mai mic.')); ?></p>
                    <p><?php echo e(aiTrans('Imobilul oferă, de asemenea, beneficii fiscale importante, cum ar fi deduceri pentru dobânzile ipotecare și impozitele pe proprietate, iar amortizarea proprietății poate reduce venitul impozabil. Diversificarea în imobiliare adaugă un activ tangibil portofoliului dvs., echilibrând investițiile mai volatile, cum ar fi acțiunile.')); ?></p>
                </div>
            </div>

            <div class="uk-width-1-1@s">
                <div class="gird-box">
                    <h3><?php echo e(aiTrans('Tranzacționarea obligațiunilor')); ?></h3>
                    <p><?php echo e(aiTrans('Obligațiunile sunt un împrumut acordat guvernelor sau corporațiilor de către un investitor în schimbul plăților periodice ale dobânzii și rambursării principalului la scadență. Sunt un tip de investiții cu venit fix. Ele sunt adesea considerate o investiție mai puțin riscantă decât acțiunile și un bun excelent pentru a vă diversifica portofoliul.')); ?></p>
                </div>
            </div>

            <div class="uk-width-1-2@s uk-grid-item-match">
                <div class="gird-box">
                    <h3><?php echo e(aiTrans('Criptomonede')); ?></h3>
                    <p><?php echo e(aiTrans('Criptomonedele sunt descentralizate și se bazează pe tehnologia blockchain, un registru distribuit controlat de o rețea de calculatoare, pentru a asigura transparența și securitatea tranzacțiilor. Spre deosebire de monedele tradiționale emise de guverne, criptomonedele sunt create și gestionate digital.')); ?></p>
                    <p><?php echo e(aiTrans('Această piață în curs de dezvoltare oferă randamente semnificative, dar prezintă o volatilitate ridicată și riscuri. Pentru a investi în criptomonede, este esențial să efectuați cercetări ample, să diversificați investițiile pentru a răspândi riscul și să fiți informat cu privire la tendințele pieței și schimbările de reglementare.')); ?></p>
                </div>
            </div>

            <div class="uk-width-1-2@s uk-grid-item-match">
                <div class="gird-box">
                    <h3><?php echo e(aiTrans('Materii prime')); ?></h3>
                    <p><?php echo e(aiTrans('Mărfurile sunt materii prime esențiale care conduc economia globală, de la produse agricole precum grâul și cafeaua până la resurse naturale precum petrolul și aurul. Mărfurile deseori își mențin valoarea în perioadele inflaționiste, protejând puterea de cumpărare. Puteți investi direct în mărfuri fizice prin contracte futures pe mărfuri sau prin ETF-uri și fonduri mutuale pe mărfuri. Această abordare oferă expunere la tendințele pieței globale și poate îmbunătăți stabilitatea globală a portofoliului.')); ?></p>
                </div>
            </div>
        </div>

        <div class="uk-text-center"> <a class="c-button" href="#"><span><?php echo e(aiTrans('Aflați mai multe')); ?></span><span class="uk-svg"><svg aria-hidden="true" class="e-font-icon-svg e-fas-arrow-right" viewBox="0 0 448 512" xmlns="http://www.w3.org/2000/svg">
                        <path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z"></path>
                    </svg></span></a></div>

    </div>
</section>

<section class="section2 section-dark2">
    <div class="uk-container">

        <div class="uk-grid-large" uk-grid>
            <div class="uk-width-expand@s">

                <h2><?php echo e(aiTrans('Investiția în era digitală: oportunități și provocări')); ?></h2>
                <p><?php echo e(aiTrans('În era digitală de astăzi, investițiile au suferit schimbări semnificative, prezentând atât oportunități, cât și provocări pentru investitori. Accesibilitatea informațiilor financiare în timp real și a instrumentelor avansate de cercetare le-a permis oamenilor să ia decizii de investiții mai informate, care anterior erau accesibile doar profesioniștilor.')); ?></p>
                <p><?php echo e(aiTrans('În ciuda acestor progrese, provocările rămân. Volatilitatea pieței rămâne o preocupare din cauza răspândirii rapide a informațiilor și a tranzacționării algoritmice, care necesită o luare a deciziilor disciplinate pentru a gestiona eficient fluctuațiile. În plus, peisajul digital ridică probleme de confidențialitate și securitate cibernetică, necesitând măsuri de securitate solide și respectarea standardelor de reglementare pentru a proteja informațiile financiare sensibile ale investitorilor.')); ?></p>
                <p>
                    <?php echo e(aiTrans(
                        'Navigarea acestor oportunități și provocări în era digitală necesită o abordare echilibrată și o educație continuă. Această înțelegere este exact ceea ce [website_title] se străduiește să realizeze în fiecare zi.',
                        $locale,
                        ['website_title' => $website_title],
                    )); ?>

                    </p>
            </div>
            <div class="uk-width-2-5@s">
                <img class="br20" src="<?php echo e(asset('frontend/assets/ro/dist')); ?>/images/back-view-young-business.jpg" alt="">
            </div>
        </div>

    </div>
</section>


<section class="section2 section-white">
    <div class="uk-container">

        <div class="uk-text-center padding-10">
            <h2>
                <?php echo e(aiTrans(
                    'Descoperirea diverselor rute de investiții cu [website_title]',
                    $locale,
                    ['website_title' => $website_title],
                )); ?>

                </h2>
            <p class="f20">
                <?php echo e(aiTrans(
                    '[website_title] oferă informații despre o varietate de opțiuni de investiții, ajutându-vă să vă diversificați portofoliul și să vă creșteți averea. Iată o privire asupra principalelor căi de investiții disponibile:',
                    $locale,
                    ['website_title' => $website_title],
                )); ?>

                </p>
        </div>

        <div class="uk-grid-medium uk-margin-medium-top" uk-grid>

            <div class="uk-width-1-2@s uk-grid-item-match">
                <div class="gird-box">
                    <h3><?php echo e(aiTrans('Cercetare piețe internaționale')); ?></h3>
                    <p><?php echo e(aiTrans('Înțelegeți condițiile economice și perspectivele de creștere din diferite țări pentru a identifica oportunități promițătoare. Această perspectivă globală permite investitorilor să-și diversifice portofoliile dincolo de piețele interne, potențial profitând de piețele emergente cu rate de creștere mai mari sau economii stabile.')); ?></p>
                </div>
            </div>

            <div class="uk-width-1-2@s uk-grid-item-match">
                <div class="gird-box">
                    <h3><?php echo e(aiTrans('Rămâneți la curent cu evenimentele globale')); ?></h3>
                    <p><?php echo e(aiTrans('Fiți la curent cu evoluțiile politice și economice globale care pot afecta investițiile internaționale. Fiind informați despre aceste evenimente, investitorii pot anticipa schimbările pieței și își pot ajusta strategiile de investiții în consecință. Ei își protejează potențial portofoliile de riscurile geopolitice, valorificând în același timp oportunitățile care decurg din schimbările globale.')); ?></p>
                </div>
            </div>

            <div class="uk-width-1-2@s uk-grid-item-match">
                <div class="gird-box">
                    <h3><?php echo e(aiTrans('Înțelegeți implicațiile legale și fiscale')); ?></h3>
                    <p><?php echo e(aiTrans('Aflați mai multe despre mediile juridice și fiscale din diferite țări pentru a lua decizii de investiții informate. Aceste cunoștințe pot influența în mod semnificativ alegerile de investiții prin identificarea jurisdicțiilor cu politici fiscale favorabile sau cadre de reglementare. Prin urmare, informațiile vă pot ajuta să optimizați potențialele randamente și să minimizați complicațiile legale sau financiare inutile.')); ?></p>
                </div>
            </div>

            <div class="uk-width-1-2@s uk-grid-item-match">
                <div class="gird-box">
                    <h3><?php echo e(aiTrans('Diversificați geografic')); ?></h3>
                    <p><?php echo e(aiTrans('Răspândiți-vă investițiile în regiuni pentru a reduce riscul și a maximiza rentabilitatea potențială pe diverse piețe. Această diversificare geografică protejează portofoliul împotriva șocurilor economice specifice regiunii și permite investitorilor să beneficieze de diferite cicluri economice și modele de creștere.')); ?></p>
                </div>
            </div>


        </div>

        <div class="uk-text-center"> <a class="c-button" href="#"><span><?php echo e(aiTrans('Aflați mai multe')); ?></span><span class="uk-svg"><svg aria-hidden="true" class="e-font-icon-svg e-fas-arrow-right" viewBox="0 0 448 512" xmlns="http://www.w3.org/2000/svg">
                        <path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z"></path>
                    </svg></span></a></div>

    </div>
</section>

<section class="section2 section-dark2">
    <div class="uk-container">

        <div class="uk-grid-small" uk-grid>
            <div class="uk-width-1-2@s">
                <img class="br20" src="<?php echo e(asset('frontend/assets/ro/dist')); ?>/images/closeup-golden-bitcoins.jpg" alt="">
            </div>
            <div class="uk-width-expand@s">
                <h2><?php echo e(aiTrans('Evoluția investițiilor: de la obligațiuni la criptomonede')); ?></h2>
                <p><?php echo e(aiTrans('Opțiunile de investiții au evoluat semnificativ, de la forme tradiționale, cum ar fi obligațiuni, la inovații moderne, cum ar fi criptomonede. Obligațiunile, care oferă venit fix și securitate, au fost piatra de temelie a investițiilor conservatoare de secole. Dimpotrivă, criptomonedele, născute în era digitală, reprezintă active digitale descentralizate cu potențial de volatilitate ridicată și creștere rapidă. Această evoluție reflectă schimbări mai ample în preferințele investitorilor și progresele tehnologice care modelează viitorul finanțelor globale.')); ?></p>
            </div>
        </div>

        <div class="uk-grid-small uk-margin-large" uk-grid>

            <div class="uk-width-expand@s">
                <h2>
                    <?php echo e(aiTrans(
                        '[website_title]: Filosofia noastră privind educația pentru investiții',
                        $locale,
                        ['website_title' => $website_title],
                    )); ?>

                    </h2>
                <p>
                    <?php echo e(aiTrans(
                        'Filosofia de bază a [website_title] se învârte în jurul furnizării de educație cuprinzătoare și accesibilă pentru investiții. Ne angajăm să oferim oamenilor cunoștințele necesare pentru a naviga cu încredere în complexitățile piețelor financiare. Platforma noastră se străduiește să democratizeze accesul la resurse educaționale de înaltă calitate, asigurându-se că toți investitorii, indiferent de mediul sau nivelul de experiență, pot lua decizii în cunoștință de cauză și își pot atinge obiectivele financiare.”',
                        $locale,
                        ['website_title' => $website_title],
                    )); ?>

                    </p>
                <p>
                    <?php echo e(aiTrans(
                        'Prin invatare continua, [website_title] își propune să promoveze o comunitate de investitori informați și echipați pentru a prospera în lumea în continuă evoluție a finanțelor. Alăturați-vă nouă astăzi pentru a începe călătoria dvs. către succes și abilitare financiară.',
                        $locale,
                        ['website_title' => $website_title],
                    )); ?>

                    </p>
            </div>
            <div class="uk-width-1-2@s">
                <img class="br20" src="<?php echo e(asset('frontend/assets/ro/dist')); ?>/images/close-up-education-economy.jpg" alt="">
            </div>
        </div>

    </div>
</section>


<section class="section2 section-white">
    <div class="uk-container">

        <div class="uk-text-center padding-10">
            <h2>
                <?php echo e(aiTrans(
                    '[website_title]: cum să evitați investiția emoțională',
                    $locale,
                    ['website_title' => $website_title],
                )); ?>

                </h2>
            <p class="f20">
                <?php echo e(aiTrans(
                    'Aflați strategii pentru a menține luarea deciziilor raționale atunci când investiți cu [website_title]. Iată cum să rămâi concentrat:',
                    $locale,
                    ['website_title' => $website_title],
                )); ?>

                </p>
        </div>

        <div class="uk-grid-small uk-margin-medium-top" uk-grid>

            <div class="uk-width-1-2@s uk-grid-item-match">
                <div class="gird-box">
                    <h3><?php echo e(aiTrans('Creați și respectați un plan')); ?></h3>
                    <p><?php echo e(aiTrans('Dezvoltați o strategie de investiții clară, aliniată cu obiectivele dumneavoastră financiare și cu toleranța la risc. A avea un plan vă ajută să rămâneți disciplinat în timpul fluctuațiilor pieței.')); ?></p>
                </div>
            </div>

            <div class="uk-width-1-2@s uk-grid-item-match">
                <div class="gird-box">
                    <h3><?php echo e(aiTrans('Stabiliți așteptări realiste')); ?></h3>
                    <p><?php echo e(aiTrans('Stabiliți obiective realizabile și înțelegeți că investiția implică riscuri. Evitați să urmăriți profituri nerealiste pentru a menține o abordare echilibrată.')); ?></p>
                </div>
            </div>

            <div class="uk-width-1-2@s uk-grid-item-match">
                <div class="gird-box">
                    <h3><?php echo e(aiTrans('Evitați să vă verificați portofoliul în mod frecvent')); ?></h3>
                    <p><?php echo e(aiTrans('Limitați frecvența monitorizării portofoliului pentru a evita reacțiile emoționale la schimbările zilnice ale pieței. Ajustarea periodică a investițiilor pe baza fluctuațiilor pe termen scurt poate duce la decizii impulsive.')); ?></p>
                </div>
            </div>

            <div class="uk-width-1-2@s uk-grid-item-match">
                <div class="gird-box">
                    <h3><?php echo e(aiTrans('Diversificarea carterii')); ?></h3>
                    <p><?php echo e(aiTrans('Reduceți riscul și minimizați impactul volatilității pieței asupra portofoliului dvs. Prin răspândirea investițiilor în diferite clase de active, industrii și zone geografice, diversificarea portofoliului ajută la asigurarea faptului că o scădere a unui sector sau piață nu afectează în mod disproporționat performanța globală a investiției.')); ?></p>
                </div>
            </div>

            <div class="uk-width-1-1@s">
                <div class="gird-box">
                    <h3><?php echo e(aiTrans('Concentrați-vă pe obiective pe termen lung')); ?></h3>
                    <p><?php echo e(aiTrans('Investiția pe termen lung vă permite să depășiți fluctuațiile pieței și să beneficiați de randamente combinate. Această perspectivă pe termen lung încurajează răbdarea și rezistența, reduce tentația de a reacționa în grabă la mișcările pe termen scurt ale pieței și permite investițiilor dvs. să crească constant.')); ?></p>
                </div>
            </div>

        </div>

        <div class="uk-text-center"> <a class="c-button" href="#"><span>Aflați mai multe</span><span class="uk-svg"><svg aria-hidden="true" class="e-font-icon-svg e-fas-arrow-right" viewBox="0 0 448 512" xmlns="http://www.w3.org/2000/svg">
                        <path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z"></path>
                    </svg></span></a></div>

    </div>
</section>

<section class="section2 section-dark2">
    <div class="uk-container">


        <div class="uk-text-center padding-10">
            <h2>
                <?php echo e(aiTrans(
                    'Alatura-te [website_title] astazi!',
                    $locale,
                    ['website_title' => $website_title],
                )); ?>

                </h2>
            <p class="f20">
                <?php echo e(aiTrans(
                    'A te alatura [website_title] astăzi pentru a vă îmbunătăți cunoștințele și abilitățile de investiții. Beneficiați de resursele noastre educaționale cuprinzătoare și actualizate, concepute pentru a împuternici investitorii la toate nivelurile. Indiferent dacă sunteți un investitor începător sau experimentat, [website_title] promovează instrumentele și cunoștințele necesare pentru a naviga cu încredere în complexitățile piețelor financiare. Nu ratați ocazia de a vă îmbunătăți cunoștințele financiare și de a lua decizii de investiții informate.',
                    $locale,
                    ['website_title' => $website_title],
                )); ?>

                </p>
            <p class="f20">
                <?php echo e(aiTrans(
                    'Înregistrează-te acum și pornește-te în călătoria ta către împuternicirea financiară cu [website_title]!',
                    $locale,
                    ['website_title' => $website_title],
                )); ?>

                </p>
        </div>

    </div>
</section>


<section class="section-dark">
    <div class="uk-container uk-container-small">

        <h2 class="uk-text-center f70">
            
            <?php echo e(aiTrans(
                '[website_title]: cum să evitați investiția emoțională',
                $locale,
                ['website_title' => $website_title],
            )); ?>

            </h2>

        <div class="uk-container uk-container-xsmall">
            <ul uk-accordion="collapsible: false: ; active: false">

                <li>
                    <a class="uk-accordion-title" href><svg class="e-font-icon-svg e-fas-caret-right" viewBox="0 0 192 512" xmlns="http://www.w3.org/2000/svg">
                            <path d="M0 384.662V127.338c0-17.818 21.543-26.741 34.142-14.142l128.662 128.662c7.81 7.81 7.81 20.474 0 28.284L34.142 398.804C21.543 411.404 0 402.48 0 384.662z"></path>
                        </svg><?php echo e(aiTrans('Cum mă înscriu la Circuitul Educațional?')); ?></a>
                    <div class="uk-accordion-content">
                        <p>
                            <?php echo e(aiTrans(
                                'Inscrie-te [website_title] Este un proces simplu care implică doar trei pași simpli:',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                            </p>
                        <ol>
                            <li><strong><?php echo e(aiTrans('Inscrie-te:')); ?></strong> <?php echo e(aiTrans('Începeți prin a completa formularul nostru de pe pagina principală cu numele, adresa de e-mail și numărul de telefon.')); ?></li>
                            <li><strong><?php echo e(aiTrans('Conexiune:')); ?></strong> <?php echo e(aiTrans('Vă vom pune în legătură cu o companie educațională din apropierea zonei dvs. Acest pas vă oferă posibilitatea de a vorbi direct cu un expert care vă poate adresa orice întrebări inițiale pe care le aveți și vă poate ghida în continuare.')); ?></li>
                            <li><strong><?php echo e(aiTrans('Începe să înveți:')); ?></strong> <?php echo e(aiTrans('Explorează platforma companiei educaționale, alege-ți cursurile și începe-ți călătoria investițională cu resurse și asistență adaptate nevoilor tale.')); ?></li>
                        </ol>
                        <p><?php echo e(aiTrans('Acești pași vă fac să începeți să învățați despre investiții cât mai ușor și eficient posibil.')); ?></p>

                    </div>
                </li>
                <li>
                    <a class="uk-accordion-title" href><svg class="e-font-icon-svg e-fas-caret-right" viewBox="0 0 192 512" xmlns="http://www.w3.org/2000/svg">
                            <path d="M0 384.662V127.338c0-17.818 21.543-26.741 34.142-14.142l128.662 128.662c7.81 7.81 7.81 20.474 0 28.284L34.142 398.804C21.543 411.404 0 402.48 0 384.662z"></path>
                        </svg>
                        <?php echo e(aiTrans(
                            'Cum accesez resursele bibliotecii? [website_title]?',
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                        </a>
                    <div class="uk-accordion-content">
                        <p>
                            <?php echo e(aiTrans(
                                '[website_title] nu oferă direct resurse de bibliotecă sau materiale de curs. În schimb, platforma noastră servește ca punct de legătură cu companiile educaționale care furnizează aceste resurse. Odată ce vă înregistrați, vă vom facilita legătura cu o companie educațională, unde puteți accesa și explora biblioteca extinsă de oferte de cursuri și alte materiale educaționale pe care le oferă.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                            </p>

                    </div>
                </li>
                <li>
                    <a class="uk-accordion-title" href><svg class="e-font-icon-svg e-fas-caret-right" viewBox="0 0 192 512" xmlns="http://www.w3.org/2000/svg">
                            <path d="M0 384.662V127.338c0-17.818 21.543-26.741 34.142-14.142l128.662 128.662c7.81 7.81 7.81 20.474 0 28.284L34.142 398.804C21.543 411.404 0 402.48 0 384.662z"></path>
                        </svg><?php echo e(aiTrans('Care este un curs potrivit pentru nivelul meu de calificare?')); ?></a>
                    <div class="uk-accordion-content">
                        <p>
                            <?php echo e(aiTrans(
                                '[website_title] vă pune în legătură cu companii educaționale care oferă o gamă largă de cursuri adaptate diferitelor niveluri de calificare, de la începători la studenți avansați. Examinarea descrierilor detaliate ale cursurilor oferite de partenerii noștri educaționali vă poate ajuta să determinați dacă un curs este potrivit pentru nivelul dvs. de calificare.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                            </p>

                    </div>
                </li>

            </ul>
        </div>

    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mb/public_html/new.crizymp.xyz/resources/views/frontend/ro/home.blade.php ENDPATH**/ ?>