<link rel="canonical" href="<?php echo e(url()->current()); ?>">
<?php
    // Supported languages list
    $languages = ['en', 'es', 'de', 'fr', 'pl', 'nl', 'it', 'sv', 'no', 'ja', 'pt', 'ar', 'hr', 'hu', 'tr', 'is', 'da', 'cs', 'el', 'id', 'ko', 'fil', 'ro', 'ru', 'sk', 'fi', 'zh'];

    // Get current path segments
    $segments = request()->segments();

    // Remove current language if present
    if (in_array($segments[0] ?? '', $languages)) {
        array_shift($segments); // Remove the first segment (language code)
    }

    // Rebuild the path
    $currentPath = implode('/', $segments);
?>


<?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php if($lang === 'en'): ?>
        
        <link rel="alternate" hreflang="en" href="<?php echo e(url($currentPath)); ?>">
    <?php else: ?>
        
        <link rel="alternate" hreflang="<?php echo e($lang); ?>" href="<?php echo e(url($lang . ($currentPath ? '/' . $currentPath : ''))); ?>">
    <?php endif; ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <link rel="alternate" hreflang="x-default" href="<?php echo e(url($currentPath)); ?>">
        
<link rel="icon" type="image/x-icon" href="<?php echo e(asset('fav.png')); ?>" />
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
<link rel="preload" as="style"
    href="https://fonts.googleapis.com/css?family=Poppins:300,400,600,700,800&display=swap" />
<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,600,700,800&display=swap"
    media="print" onload="this.media = 'all';" />
<link rel="stylesheet" href=" <?php echo e(asset('frontend/assets/ru')); ?>/dist/css/style1.css">
<link rel="stylesheet" href=" <?php echo e(asset('frontend/assets/ru')); ?>/dist/css/style2.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@24.5.0/build/css/intlTelInput.css">
<link href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/3.4.6/css/flag-icon.min.css" rel="stylesheet"
    media="print" onload="this.media='all'">
<?php /**PATH /home/mb/public_html/new.crizymp.xyz/resources/views/frontend/ru/components/header/head.blade.php ENDPATH**/ ?>