@extends('layouts.app')

@push('meta')
    <title>{{ "$website_title : Regras Para Privacidade" }}</title>
    <meta name="description" content="{{ "Entenda como $website_title preserva seus dados pessoais. Nossa declaração de privacidade descreve as ações tomadas para certificar a segurança e a clareza das suas informações." }}" />
@endpush
@section('content')
<div class="privacy-policy wf-section">
    <div class="w-container">
        <h1>POLÍTICA DE PRIVACIDADE</h1>
        <div>
            <style>
                table {
                    width: 100%;
                }

                table,
                th,
                td {
                    border: 1px solid;
                    border-collapse: collapse;
                }

                th,
                td {
                    padding: 10px;
                }

                table td {
                    vertical-align: top;
                }

                .nested-list {
                    counter-reset: item;
                }

                .nested-list li {
                    display: block;
                }

                .nested-list li:before {
                    content: counters(item, '.') '. ';
                    counter-increment: item;
                }

                .legal-section {
                    text-align: left;
                }

                .legal-section h3 {
                    margin-top: 30px;
                    font-size: 24px;
                }

                .legal-section h4 {
                    font-size: 18px;
                }
            </style>
            <p>
                <b>Última atualização:</b> Setembro
            </p>
            <h3>{{ aiTrans('1. Introdução', $locale) }}</h3>
<p>
    {{ aiTrans('Esta declaração descreve a política de privacidade adotada por', $locale) }} {{ $website_title }} ("{{ aiTrans('nós', $locale) }}," "{{ aiTrans('nosso', $locale) }}," "{{ aiTrans('ou', $locale) }}")
    {{ aiTrans('referente aos nossos produtos e serviços (os "Serviços") e', $locale) }} <a href="{{route('home',$country)}}">{{ aiTrans('site', $locale) }}</a>
    {{ aiTrans('o ("Site")', $locale) }}. {{ aiTrans('Proteger sua privacidade e a confidencialidade das suas informações é crucial para nós ao fornecer nossos Serviços e operar o Site.', $locale) }}
</p>
<p>
    {{ aiTrans('Nossos Serviços e Site podem conter links para sites e serviços de terceiros. Não somos responsáveis pelas práticas de privacidade dessas entidades terceirizadas. Recomendamos que você reveja as políticas de privacidade deles antes de utilizá-los.', $locale) }}
</p>
<p>
    {{ aiTrans('Todas as informações obtidas por nós em conexão com nossos Serviços são tratadas como confidenciais. Utilizamos medidas técnicas, de segurança e organizacionais robustas para proteger os Dados Pessoais (conforme definido abaixo) contra processamento não autorizado, perda acidental, destruição, dano, roubo ou divulgação.', $locale) }}
</p>
<p>
    {{ aiTrans('Ao enviar suas informações através do nosso site, você pode ser solicitado a fornecer informações pessoais, como seu nome, e-mail, número de telefone, data de nascimento e vários detalhes de identificação. Essas informações podem ser utilizadas, entre outras finalidades, para verificar a identidade, administrar informações, oferecer suporte técnico e cumprir obrigações contratuais e legais. Podemos comunicar detalhes importantes por meio de notificações, e com seu consentimento, fornecer informações sobre produtos e serviços via SMS, e-mail, etc. Você tem a opção de gerenciar preferências de notificação e cancelar a inscrição em determinadas comunicações.', $locale) }}
</p>
<h3>{{ aiTrans('2. Site; Visitantes e Usuários', $locale) }}</h3>
<h4>{{ aiTrans('2.1. Geral', $locale) }}</h4>
<p>
    {{ aiTrans('Esta seção delineia as especificidades da coleta de dados de diferentes grupos: visitantes do site ("Visitantes"), usuários ("Usuários") e parceiros comerciais (coletivamente "Parceiros"). Dados Pessoais incluem endereço IP, nome, detalhes de contato e informações sobre o relacionamento conosco, conforme definido pelas regulamentações de proteção de dados aplicáveis.', $locale) }}
</p>
<h4>{{ aiTrans('2.2. Coleta e Uso', $locale) }}</h4>
<p>
    {{ aiTrans('Ao visitar o Site, você consente com a coleta e o uso de seus Dados Pessoais. A falta de concordância com esses termos deve impedir você de visitar o Site. Podemos coletar informações por meio de atividade de visualização de páginas, endereços IP e cookies. Além disso, processamos dados fornecidos voluntariamente em formulários e registros.', $locale) }}
</p>
<h4>{{ aiTrans('2.3. Finalidade do Processamento de Dados Pessoais', $locale) }}</h4>
<p>
    {{ aiTrans('Processamos Dados Pessoais para melhorar, entender e personalizar nosso Site e Serviços. Isso inclui melhorar a precisão, comunicação sobre Serviços, suporte, obrigações contratuais e colaboração com parceiros. O consentimento ou base legal é essencial para qualquer processamento.', $locale) }}
</p>
<p>{{ aiTrans('O seguinte descreve as finalidades e a base legal para o processamento de Dados Pessoais:', $locale) }}</p>
<table>
    <tbody>
        <tr>
            <td>{{ aiTrans('Registro como titular de conta', $locale) }}</td>
            <td>{{ aiTrans('Seu consentimento; Execução de Serviços ou obrigações contratuais', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Fornecimento e uso de Serviços', $locale) }}</td>
            <td>{{ aiTrans('Execução de Serviços ou obrigações contratuais', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Atualizações operacionais', $locale) }}</td>
            <td>{{ aiTrans('Execução de Serviços ou obrigações contratuais', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Responder a consultas e fornecer suporte', $locale) }}</td>
            <td>{{ aiTrans('Interesses legítimos ou execução de Serviços', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Serviços, publicidade e marketing sob medida', $locale) }}</td>
            <td>{{ aiTrans('Interesses legítimos ou seu consentimento', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Melhoria e oferta de novos Serviços', $locale) }}</td>
            <td>{{ aiTrans('Consentimento e interesses legítimos', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Envio de materiais publicitários e de marketing', $locale) }}</td>
            <td>{{ aiTrans('Seu consentimento', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Análise da eficácia de campanhas de marketing', $locale) }}</td>
            <td>{{ aiTrans('Interesses legítimos ou consentimento', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Execução de várias atividades de suporte', $locale) }}</td>
            <td>{{ aiTrans('Interesses legítimos ou execução de Serviços', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Análise, incluindo análise estatística', $locale) }}</td>
            <td>{{ aiTrans('Interesses legítimos', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Proteção de interesses, direitos e bens', $locale) }}</td>
            <td>{{ aiTrans('Interesses legítimos ou obrigações legais', $locale) }}</td>
        </tr>
    </tbody>
</table>
<h4>{{ aiTrans('2.4. Compartilhamento de Dados Pessoais', $locale) }}</h4>
<p>
    {{ aiTrans('Podemos compartilhar informações com fornecedores de serviços, Parceiros e contratados. Para Visitantes e Usuários na Região de Dados Europeia, o processamento de dados está em conformidade com o GDPR e as Leis de Proteção de Dados aplicáveis.', $locale) }}
</p>
<h3>{{ aiTrans('3. Parceiros', $locale) }}</h3>
<h4>{{ aiTrans('3.1. Geral', $locale) }}</h4>
<p>
    {{ aiTrans('Para fornecer Serviços e colaborar com Parceiros, coletamos e processamos tipos específicos de dados. Os Parceiros são responsáveis por seus dados, e podemos acessá-los por meios seguros.', $locale) }}
</p>
<h4>{{ aiTrans('3.2. Processamento de Dados Pessoais', $locale) }}</h4>
<p>
    {{ aiTrans('Confiamos no consentimento dos Parceiros ou nos interesses legítimos para processar Dados Pessoais. Agregações de Dados podem ser criadas para desenvolvimento e melhoria da qualidade.', $locale) }}
</p>
<h4>{{ aiTrans('3.3. Controlador/Processador', $locale) }}</h4>
<p>{{ aiTrans('Podemos atuar como Controlador ou Processador, dependendo do tipo de dado:', $locale) }}</p>
<ul>
    <li>{{ aiTrans('Dados de Visitante/Usuário: Controlador', $locale) }}</li>
    <li>{{ aiTrans('Dados de Parceiro: Processador', $locale) }}</li>
    <li>{{ aiTrans('Todos os dados são hospedados com segurança, seguindo os mais altos padrões de segurança. Implementamos salvaguardas físicas, técnicas e organizacionais.', $locale) }}</li>
</ul>
<h4>{{ aiTrans('3.4. Proteção de Dados de Terceiros', $locale) }}</h4>
<p>{{ aiTrans('Se os Serviços envolverem o processamento de Dados Pessoais em uma plataforma de terceiros:', $locale) }}</p>
<ul>
    <li>{{ aiTrans('Atuamos como Processador', $locale) }}</li>
    <li>{{ aiTrans('Cumprir as instruções do terceiro', $locale) }}</li>
    <li>{{ aiTrans('Implementar medidas de segurança', $locale) }}</li>
    <li>{{ aiTrans('Informar sobre violações de dados', $locale) }}</li>
    <li>{{ aiTrans('Não subcontratar sem consentimento', $locale) }}</li>
    <li>{{ aiTrans('Não processar dados fora do Espaço Econômico Europeu sem consentimento', $locale) }}</li>
    <li>{{ aiTrans('Para comunicações de marketing eletrônico, garantimos consentimento e opções de cancelamento.', $locale) }}</li>
</ul>
<h3>{{ aiTrans('4. Segurança', $locale) }}</h3>
<p>
    {{ aiTrans('Utilizamos salvaguardas administrativas, organizacionais e técnicas para proteger os Dados Pessoais contra acesso, divulgação, alteração, perda, uso indevido ou danos não autorizados. Ao compartilhar dados com terceiros, garantimos que eles mantenham os mesmos padrões de proteção de dados, e são estabelecidas obrigações contratuais para processamento exclusivo e seguro, alinhado com esta Política.', $locale) }}
</p>
<p>
    {{ aiTrans('Se houver a crença de que a interação conosco foi comprometida, Visitantes, Usuários ou Parceiros devem nos notificar prontamente. É importante observar que, apesar de nossas medidas de segurança, não podemos garantir imunidade completa contra ataques de terceiros. Os Usuários reconhecem os riscos inerentes e as possíveis violações.', $locale) }}
</p>
<h3>{{ aiTrans('5. Cookies', $locale) }}</h3>
<p>
    {{ aiTrans('Consulte nossa', $locale) }} <a href="{{route('home',$country)}}">{{ aiTrans('Política de Cookies', $locale) }}</a> {{ aiTrans('para obter informações detalhadas sobre os tipos de cookies e tecnologias de rastreamento utilizados no Site, razões de uso e como aceitá-los ou rejeitá-los.', $locale) }}
</p>
<h3>{{ aiTrans('6. Links para Outros Sites', $locale) }}</h3>
<p>
    {{ aiTrans('Durante a navegação no Site, os Usuários podem encontrar links para sites externos que estão fora do nosso controle. Não nos responsabilizamos pelo conteúdo ou pelas políticas de privacidade desses sites. Os Usuários são aconselhados a revisar as políticas de privacidade de tais sites e serviços de terceiros antes de divulgar quaisquer Dados Pessoais.', $locale) }}
</p>
<h3>{{ aiTrans('7. Retenção e Exclusão', $locale) }}</h3>
<p>
    {{ aiTrans('Os dados, incluindo os Dados Pessoais, não serão mantidos por mais tempo do que o necessário. Visitantes e/ou Usuários com contas ativas são responsáveis pela exclusão pontual dos dados. Após a rescisão de uma conta ou parceria, os Dados Pessoais coletados através do Site e/ou Serviços serão excluídos de acordo com as leis aplicáveis e nossas políticas internas.', $locale) }}
</p>
<p>
    {{ aiTrans('A retirada do consentimento para o processamento de Dados Pessoais pode limitar o acesso a alguns ou todos os Serviços solicitados, sem que sejam cabíveis reclamações ou contenções.', $locale) }}
</p>
<h3>{{ aiTrans('8. Seus Direitos', $locale) }}</h3>
<p>{{ aiTrans('Os Usuários têm direitos específicos em relação aos seus Dados Pessoais:', $locale) }}</p>
<h4>{{ aiTrans('8.1. Direito de Acesso', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Confirmar se os Dados Pessoais são processados', $locale) }}</li>
    <li>{{ aiTrans('Acessar Dados Pessoais e informações relacionadas', $locale) }}</li>
    <li>{{ aiTrans('Informações sobre finalidades de processamento, categorias, destinatários, duração do armazenamento, direitos e existência de perfis', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.2. Direito à Retificação', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Retificar Dados Pessoais imprecisos', $locale) }}</li>
    <li>{{ aiTrans('Completar Dados Pessoais incompletos', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.3. Direito ao Apagamento', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Solicitar o apagamento de Dados Pessoais em circunstâncias específicas', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.4. Direito de Restrição ao Processamento', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Obter a restrição do processamento em circunstâncias específicas', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.5. Direito à Portabilidade de Dados', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Receber Dados Pessoais em um formato estruturado e legível por máquina', $locale) }}</li>
    <li>{{ aiTrans('Transmitir Dados Pessoais a outro controlador', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.6. Direito de Oposição', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Opor-se ao processamento com base em interesses legítimos ou marketing direto', $locale) }}</li>
    <li>{{ aiTrans('Interromper o processamento, a menos que haja motivos convincentes e/ou legais aplicáveis', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.7. Direito de Retirar Consentimento', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Retirar o consentimento para o processamento de Dados Pessoais a qualquer momento', $locale) }}</li>
</ul>
<h3>{{ aiTrans('9. Materiais Publicitários e de Marketing', $locale) }}</h3>
<p>
    {{ aiTrans('O consentimento é obtido para o uso de Dados Pessoais e detalhes de contato para fornecer materiais publicitários e de marketing. A retirada do consentimento é possível enviando um aviso por escrito para o endereço de e-mail fornecido.', $locale) }}
</p>
<h3>{{ aiTrans('10. Aceitação desta Política', $locale) }}</h3>
<p>
    {{ aiTrans('Ao usar o Site e/ou os Serviços, Visitantes, Usuários e/ou Parceiros são presumidos como tendo lido e concordado com esta Política. Qualquer discordância implica abstenção do uso da plataforma. Reservamo-nos o direito de modificar a Política, e os Usuários são incentivados a verificar atualizações periodicamente. O uso contínuo após as alterações indica aceitação.', $locale) }}
</p>
<h3>{{ aiTrans('11. Obrigação Legal de Divulgar Dados Pessoais', $locale) }}</h3>
<p>
    {{ aiTrans('Os Dados Pessoais podem ser divulgados sem permissão prévia se houver uma crença de que é necessário estabelecer a identidade, entrar em contato ou iniciar procedimentos legais contra indivíduos suspeitos de infringir direitos ou propriedades. A divulgação será feita quando exigida por lei.', $locale) }}
</p>
<h3>{{ aiTrans('12. Encarregado de Proteção de Dados', $locale) }}</h3>
            <p>
                Para questões de privacidade e proteção de dados, um "Encarregado de Proteção de Dados" designado pode ser
                contatado pelo e-mail <span >info{{ '@'.$website_title }}</span>
            </p>
            <script>
                const emails = document.getElementsByClassName('email');
                for (const email of emails) {
                    email.innerText = `info@${location.hostname}`;
                }
            </script>
        </div>
    </div>
</div>
@endsection
