<?php

namespace App\Http\Resources\API\Job;

use App\Support\Traits\WithPagination;
use Illuminate\Http\Resources\Json\JsonResource;

class JobResource extends JsonResource
{
    use WithPagination;

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {

        return [
            'id' => $this->id,
            'name' => $this->name ?? '',
            'description' => $this->description ?? '',
        ];
    }
}
