<?php

namespace App\Http\Requests\Marketing\Vouchers;

use Illuminate\Foundation\Http\FormRequest;

class VoucherRequest extends FormRequest
{
    public function rules()
    {
        $rules = [
            'code' => 'required|alpha_dash|unique:vouchers,code',
            'name' => 'required|string',
            'description' => 'required|string',
            'max_uses' => 'required|integer',
            'max_uses_user' => 'required|integer',
            'is_fixed' => 'required|string',
            'discount_percentage' => 'required_if:is_fixed,0',
            'discount_fixed' => 'required_if:is_fixed,1',
            'starts_at' => 'required|date|before:expires_at',
            'expires_at' => 'required|date|after:starts_at',
        ];

        if (request()->isMethod('PUT')) {
            $rules['code'] = 'required|alpha_dash|unique:vouchers,code,' . request()->route('voucher');
        }

        return $rules;
    }
}
