<?php

namespace App\Http\Controllers\Dashboard\User;

use App\Domain\Car\Models\Brand;
use App\Domain\Car\Models\CarType;
use App\Domain\Core\Enums\CorePermissions;
use App\Domain\User\Datatables\UserCarDatatable;
use App\Domain\User\Models\UserCar;
use App\Http\Controllers\Dashboard\DashboardController;
use App\Support\Dashboard\Crud\WithDatatable;
use App\Support\Dashboard\Crud\WithDestroy;
use App\Support\Dashboard\Crud\WithForm;
use App\Support\Dashboard\Crud\WithStore;
use App\Support\Dashboard\Crud\WithUpdate;
use Illuminate\Database\Eloquent\Model;

class UserCarController extends DashboardController
{
    use WithDatatable, WithForm, WithStore, WithUpdate, WithDestroy;

    protected string $name = 'UserCar';
    protected string $path = 'dashboard.user.user-cars';
    protected string $datatable = UserCarDatatable::class;
    protected string $model = UserCar::class;
    protected array $permissions = [CorePermissions::class, 'user_cars'];
    protected function rules()
    {
        return [
            'brand_id' => 'required|integer|exists:brands,id',
            'car_type_id' => 'required|integer|exists:car_types,id',
            'manufacture_year' => ['required', 'numeric'],
            'chassis_number' => ['required', "regex:/^[A-Za-z0-9-]+$/", 'size:17'],
        ];
    }

    protected function formData(?Model $model = null): array
    {
        return [
            'brands' => toMap(Brand::get(), 'id', 'title'),
            'carTypes' => toMap(CarType::get(), 'id', 'title'),
        ];
    }
}
