<?php

namespace App\Http\Controllers\Dashboard\Core;

use App\Domain\Core\Datatables\SliderDatatable;
use App\Domain\Core\Enums\CorePermissions;
use App\Domain\Core\Models\Slider;
use App\Http\Controllers\Dashboard\DashboardController;
use App\Support\Dashboard\Crud\WithDatatable;
use App\Support\Dashboard\Crud\WithDestroy;
use App\Support\Dashboard\Crud\WithForm;
use App\Support\Dashboard\Crud\WithStore;
use App\Support\Dashboard\Crud\WithUpdate;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Arr;

class SliderController extends DashboardController
{
    use WithDatatable, WithForm, WithStore, WithUpdate, WithDestroy;

    protected string $name = 'Slider';
    protected string $path = 'dashboard.core.sliders';
    protected string $datatable = SliderDatatable::class;
    protected string $model = Slider::class;
    protected array $permissions = [CorePermissions::class, 'sliders'];


    protected function rules()
    {
        $validation = [
            'end_at' => 'required|date',
            'start_at' => 'required|date',
            'type' => 'required|string',
            'image' => 'required|file|mimes:jpeg,png,jpg|max:4048',
        ];
        if (request()->isMethod('put')) {
            $validation['image'] = 'sometimes|nullable|file|mimes:jpeg,png,jpg|max:4048';
        }
        return $validation;
    }


    protected function storeAction(array $validated)
    {
        $image = Arr::pull($validated, 'image');
        $model = ($this->model)::create($validated);
        $image && $model->addMedia($image)->toMediaCollection('image');
    }

    protected function updateAction(array $validated, Model $model)
    {
        $image = Arr::pull($validated, 'image');
        $model->update($validated);
        if (request('image_remove')) {
            $model->clearMediaCollection('image');
        }
        if ($image instanceof UploadedFile) {
            $model->clearMediaCollection();
            $model->addMedia($image)->toMediaCollection('image');
        }
    }


    protected function formData(?Model $model = null): array
    {

        return [
        ];
    }
}
