@extends('layouts.app')
@push('meta')
    <title>{{ "$website_title $website_name | Sitemiz hakkında bilgiler" }}</title>
    <meta name="description" content="{{ "Platformumuz, $website_title , kripto para ticaret hedeflerinize ulaşmanızı kolaylaştırır. Gelişmiş araçlar ve destekle yatırımlarınızı güçlendirin." }}" />
@endpush
@section('content')

<section class="banner">
    <div class="container">
        <h1 class="banner-title display-4 fw-bold text-center mb-4">{{$website_title}} Web Sitesi Hakkında</h1>
        <h2 class="banner-desc display-7 text-center mb-5"></h2>
    </div>
</section>

<section class="py-5">
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <h2 class="display-5 fw-bold mb-4">{{$website_title}} {{aiTrans("Takım")}}</h2>
                <div>
                    <p>{{ aiTrans('Kendini işine adamış bir ekibin kolektif vizyonundan doğan', $locale) }} <a href="{{ route('home', $country) }}" class="text-secondary">{{$website_title}}</a>, {{ aiTrans('finansal yatırımların karmaşık dünyasında bir netlik işareti olarak duruyor.', $locale) }}</p>
                    <p>{{ aiTrans('Bir dizi profesyonel disiplinden gelen kurucu beyinler, yatırım teorisinin genellikle hevesli acemileri caydıran labirent doğasını kabul ettiler. Evrensel yatırım okuryazarlığına giden bir yol oluşturmaya karar verdiler.', $locale) }}</p>
                    <p>{{ aiTrans('Özetin özeti olarak tasarlanan', $locale) }} {{$website_title}}, {{ aiTrans('acemi finansörleri endüstri gazilerinin sağduyulu içgörüleriyle birleştirerek karmaşık finansal ortamda gezinir.', $locale) }}</p>
                    <p>{{$website_title}} {{ aiTrans('titizlikle bir öğrenme kaynakları kütüphanesi düzenler, eğitim serüvenini bireye göre uyarlar, zengin bilgilendirici ve dönüştürücü bir deneyim sağlar.', $locale) }}</p>
                    <p>{{ aiTrans('Özünde,', $locale) }} {{$website_title}} {{ aiTrans('platformu, kullanıcıları yatırım portföylerini düzenleme ve mali yolculuklarına çıkan bilgili tüccara veya gelişmekte olan yatırımcıya yakışır şekilde akıllıca seçimler yapma güvencesiyle donatan finansal güçlendirme için bir mihenk taşıdır.', $locale) }}</p>
                </div>
            </div>
            <div class="col-md-4 d-flex align-items-center">
                <picture>
                    <source srcset="{{asset('frontend/assets/tr/dist')}}/images/412_459__459_659fea57e03e6_about-half-1.webp" type="image/webp">
                    <source srcset="{{asset('frontend/assets/tr/dist')}}/images/_459_659fea57e03e6_about-half-1.webp" type="image/webp">
                    <img src="{{asset('frontend/assets/tr/dist')}}/images/_459_659fea57e03e6_about-half-1.webp" loading="lazy" width="459" height="412" alt="">
                </picture>
            </div>
        </div>
    </div>
</section>

<section class="py-5">
    <div class="container">
        <div class="row flex-md-row flex-column-reverse ">
            <div class="col-md-4 d-flex align-items-center">
                <picture>
                    <source srcset="{{asset('frontend/assets/tr/dist')}}/images/234_459__459_659fea66da558_about-half-2.webp" type="image/webp">
                    <source srcset="{{asset('frontend/assets/tr/dist')}}/images/_459_659fea66da558_about-half-2.webp" type="image/webp">
                    <img src="{{asset('frontend/assets/tr/dist')}}/images/_459_659fea66da558_about-half-2.webp" loading="lazy" width="459" height="234" alt="">
                </picture>
            </div>
            <div class="col-md-8">
                <h2 class="display-5 fw-bold mb-4">{{ aiTrans('[website_title] neden oluşturuldu?',$locale,
                            ['website_title' => $website_title]) }}</h2>
                <div>
                    <p>{{ aiTrans('[website_title]\'nin doğuşu bariz bir ihtiyaçtan kaynaklandı: yoğun yatırım eğitimi çalılıklarında gezinmek, hevesli yatırımcıları genellikle karmaşık jargon ve kafa karıştırıcı diyagramlarla bombardımana tutulan bir kafa karışıklığı bataklığına sürükleyebilir. Bu boşluktan, modern bir eğitim portalının tohumu ekildi.',$locale,
                            ['website_title' => $website_title]) }}</p>
                    <p>{{ aiTrans('Acemileri güçlendirme misyonuyla [website_title], karmaşık finansal kavramların gizemini net bir şekilde çözmede usta kaynaklara bir köprü sunan bir netlik işareti olarak ortaya çıkıyor. Buradaki ethos, bilgi ile boğulmak yerine yükseltmek ve aydınlatmaktır.',$locale,
                            ['website_title' => $website_title]) }}</p>
                    <p>{{ aiTrans('Rüya, hevesli acemiler ve saygıdeğer eğitim güç merkezleri arasındaki bağı beslemek için tasarlanmış, 2024\'de açılan zarif bir şekilde hazırlanmış bir merkez olan [website_title] şeklinde gerçekleştirildi. Bunu yaparak, yatırım bilgisinin demokratikleşmesini savunur ve onu arayan herkes için ulaşılabilir kılar.',$locale,
                            ['website_title' => $website_title]) }}</p>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="banner">
    <div class="container">
        <h1 class="banner-title display-4 fw-bold text-center mb-4">{{aiTrans("Evrensel Öğrenme İçin Yolu Şekillendirmek")}}</h1>
        <div class="text-center">
            <p>{{$website_title}}'{{aiTrans("daki ethos, yatırımlar hakkında bilgi edinmek için kullanılan araçların herkesin kolayca erişebileceği bir yerde olması gerektiği inancına dayanmaktadır. Acemileri yetiştirmek, çok sayıda dili kucaklayan ve ekonomi konusunda bilgili akademisyenlere karşı düşünceli olmak için tasarlanan bu portal, finansal eğitimin karmaşık yollarını aydınlatıyor. Bu misyonun peşinde koşarken,")}} {{$website_title}} {{aiTrans("platformu, yatırımın temel ilkelerinin sağlam bir şekilde anlaşılmasını sağlamaya ve 2024'deki finansal öğrenme ortamında bir mihenk taşı olarak statüsünü sağlamlaştırmaya kendini adamıştır.")}}</p>
        </div>

        <div class="text-center mt-3 mt-md-4 mb-4 mb-md-0">
            <button class="show-modal btn btn-primary text-white btn-lg shadow-lg px-3 px-md-5 fs-4">{{aiTrans("Daha fazla bilgi edinin")}}</button>
        </div>
    </div>
</section>
@endsection
