@extends('layouts.app')
@push('meta')
    <title>{{ "$website_title | Politica privind confidențialitatea" }}</title>
    <meta name="description" content="{{ "Descoperiți modul în care $website_title își asigură protecția datelor dumneavoastră personale. Politica noastră de confidențialitate vă explică măsurile pe care le adoptăm." }}" />
@endpush
@section('content')
    <section class="section2 sec3">
        <div class="uk-container">

            <div class="uk-text-center uk-margin-large-top uk-margin-large-bottom">
                <h1 class="f70">Politica de confidențialitate</h1>
            </div>

            <div>
                <p class="p1">
                    {{ aiTrans('Noi (Noi), „Noi” sau „Noștri” ne angajăm să vă protejăm datele personale și confidențialitatea.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Această Politică de confidențialitate a fost creată pentru a vă informa cum gestionăm, colectăm, stocăm și utilizăm informațiile pe care le furnizați în legătură cu site-ul web', $locale) }}
                    {{ $website_title }} ({{ aiTrans('„Site-ul”).', $locale) }}</p>
                <p class="p1">{{ aiTrans('Vom susține următoarele principii:', $locale) }}</p>
                <ul class="ul1">
                    <li class="li2"><span
                            class="s1">{{ aiTrans('Fiți transparent în ceea ce privește colectarea și prelucrarea datelor cu caracter personal despre dvs.:', $locale) }}</span>
                    </li>
                </ul>
                <p class="p1">
                    {{ aiTrans('Pentru Noi este important să aveți în permanență toate informațiile necesare pentru a lua decizii în cunoștință de cauză cu privire la prelucrarea Datelor dumneavoastră cu caracter personal atunci când vizitați site-ul nostru web sau când sunteți de acord să începeți tranzacționarea cu o platformă de tranzacționare terță parte. Pentru a face acest lucru, vom folosi diverse tehnici și măsuri menite să vă furnizeze informații relevante despre prelucrarea Datelor dumneavoastră cu caracter personal, în mod adecvat și la momentul potrivit.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('În plus, dacă descoperim că trebuie furnizate informații specifice, vi le vom furniza la momentul și locul potrivit.', $locale) }}
                </p>
                <p class="gt-block p1">
                    {{ aiTrans('De asemenea, vom fi bucuroși să răspundem la orice întrebări pe care le aveți și să vă oferim orice clarificări de care aveți nevoie, sub rezerva limitărilor legale. Pentru a face acest lucru, ne puteți contacta trimițând un e-mail la următoarea adresă:', $locale) }}&nbsp;<span
                        class="s2">info{{ '@' . $website_title }}</span></p>
                <ul class="ul1">
                    <li class="li2"><span
                            class="s1">{{ aiTrans('Pentru a prelucra Date personale despre dvs. numai în scopurile descrise în Politică:', $locale) }}</span>
                    </li>
                </ul>
                <p class="p1">
                    {{ aiTrans('Scopurile pentru care putem prelucra Datele cu caracter personal despre dvs. includ, dar nu se limitează la, punerea la dispoziție a site-ului web și furnizarea unei conexiuni la platforme de tranzacționare terțe („Serviciile”), pentru a îmbunătăți experiența utilizatorului pe site. , pentru a îmbunătăți Serviciile (inclusiv Site-ul), pentru a proteja drepturile și interesele noastre, pentru a desfășura activități comerciale și administrative care sprijină furnizarea de Servicii către utilizatorii Site-ului și/sau pentru a respecta orice cerințe legale și/sau de reglementare.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('În plus, vom procesa Date personale despre dumneavoastră pentru a înțelege nevoile și preferințele dumneavoastră personale.', $locale) }}
                </p>
                <ul class="ul1">
                    <li class="li2"><span
                            class="s1">{{ aiTrans('Investiți resurse semnificative pentru a vă respecta drepturile în legătură cu datele dumneavoastră cu caracter personal:', $locale) }}</span>
                    </li>
                </ul>
                <p class="p1">
                    {{ aiTrans('Aplicăm resurse semnificative pentru a vă permite să vă exercitați drepturile în calitate de persoană vizată. Prin urmare, ne puteți contacta oricând dacă doriți să vă revizuiți Datele personale, să ne cereți să le modificăm, să le ștergem, să nu le mai folosiți în scopuri specifice sau în general, sau să vi le transferăm dvs. sau unei terțe părți. Vă vom îndeplini dorințele în conformitate cu legea.', $locale) }}
                </p>
                <ul class="ul1">
                    <li class="li2"><span
                            class="s1">{{ aiTrans('Pentru a vă proteja datele personale:', $locale) }}</span></li>
                </ul>
                <p class="p1">
                    {{ aiTrans('Deși nu putem promite protecția absolută a datelor dumneavoastră cu caracter personal, vă putem promite că folosim și vom continua să folosim o gamă largă de mijloace și măsuri menite să ne asigurăm că datele dumneavoastră cu caracter personal sunt în siguranță.', $locale) }}
                </p>
                <p class="p1">{{ aiTrans('Politica noastră completă de confidențialitate', $locale) }}</p>
                <p class="p1">{{ aiTrans('1. Domeniul de aplicare?', $locale) }}</p>
                <p class="p1">
                    {{ aiTrans('Această politică descrie ce tip de date cu caracter personal colectează Compania despre persoane fizice și modul în care acestea sunt colectate, utilizate, partajate cu terți, securizate, prelucrate etc.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('În această politică, „Date personale” se referă la orice informație legată de o persoană fizică identificată sau identificabilă. O persoană fizică identificabilă este aceea care poate fi identificată, direct sau în combinație cu informații suplimentare pe care le avem sau la care avem acces.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('În această politică, „prelucrarea” datelor cu caracter personal se referă la orice operațiune sau set de operațiuni efectuate asupra datelor cu caracter personal, inclusiv colectarea, înregistrarea, organizarea, structurarea, stocarea, adaptarea sau modificarea, extragerea, consultarea, utilizarea, dezvăluirea prin transmitere, diseminare sau punerea la dispoziție în alt mod, alinierea sau combinarea, restricționarea, ștergerea sau distrugerea datelor cu caracter personal.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Serviciile noastre sunt destinate publicului larg și nu sunt adresate copiilor sub 18 ani. Nu colectăm sau solicităm cu bună știință informații de la nimeni sub 18 ani și nici nu permitem cu bună știință acestor persoane să acceseze Serviciile noastre. Dacă aflăm că au fost colectate informații despre un copil, vom lua măsuri rezonabile pentru a șterge astfel de informații cât mai curând posibil.', $locale) }}
                </p>
                <p class="p1">{{ aiTrans('2. Când colectăm date personale despre dumneavoastră?', $locale) }}</p>
                <p class="p1">
                    {{ aiTrans('Colectăm date personale despre dvs. ori de câte ori utilizați Serviciile, folosiți canalele de servicii și utilizați site-ul web. În unele cazuri, ne veți furniza în mod activ Date cu caracter personal, iar în alte cazuri, vom colecta datele dumneavoastră cu caracter personal examinând și analizând utilizarea serviciilor noastre și/sau a canalelor noastre de servicii sau vom primi datele dumneavoastră de la terțul nostru. parteneri.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('3. Nicio obligație de a furniza date cu caracter personal companiei și implicațiile acesteia', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Nu sunteți obligat să ne furnizați date personale despre dvs. Cu toate acestea, în unele cazuri, eșecul de a furniza astfel de Date cu caracter personal ne va împiedica să vă oferim Serviciile, să împiedicăm utilizarea site-ului web și/sau să provoace funcționarea defectuoasă a Serviciilor și a Site-ului.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('4. Ce tipuri de date cu caracter personal colectăm? Datele personale pe care le colectăm de fiecare dată când navigați pe site:', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Aceste informații includ jurnalele de activitate online, informații despre trafic (inclusiv, dar fără a se limita la, adresa IP, ora de acces, data accesului, paginile web și mobile vizitate, limba utilizată, rapoartele de blocare a software-ului și tipul de browser utilizat, informații despre dispozitivul pe care l-ați folosit Este posibil ca unele dintre aceste informații să nu vă identifice personal și, prin urmare, să nu constituie date personale.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Date personale pe care le primim de la dvs.: orice date personale pe care ni le furnizați din proprie voință atunci când contactați o platformă de tranzacționare terță parte prin intermediul nostru.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Date personale pe care le furnizați în mod special pentru transmiterea către platforme terțe în scopuri de marketing: Aceste informații includ numele dumneavoastră complet, numărul de telefon și adresa de e-mail.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('5. Scopurile prelucrării datelor cu caracter personal și temeiul legal al acesteia', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Compania prelucrează datele dumneavoastră cu caracter personal pentru unul sau mai multe dintre scopurile descrise în această secțiune și în conformitate cu temeiul legal corespunzător.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Compania nu va prelucra Date personale despre dumneavoastră decât dacă există o bază legală pentru o astfel de prelucrare. Bazele legale în baza cărora Compania poate prelucra Date cu caracter personal despre dumneavoastră sunt următoarele:', $locale) }}
                </p>
                <ul class="ul1">
                    <li class="li3"><span
                            class="s1">{{ aiTrans('Ați fost de acord cu prelucrarea datelor dumneavoastră cu caracter personal pentru unul sau mai multe scopuri specifice. Aceasta se referă la cazurile în care vă furnizați în mod specific datele prin intermediul site-ului web, astfel încât să le putem trimite către o platformă de tranzacționare terță parte.', $locale) }}</span>
                    </li>
                    <li class="li3"><span
                            class="s1">{{ aiTrans('Prelucrarea este necesară în scopul intereselor legitime urmărite de Companie sau de un terț. De exemplu, în scopul îmbunătățirii Serviciilor noastre, sau pentru exercitarea sau apărarea unor pretenții legale.', $locale) }}</span>
                    </li>
                    <li class="li2"><span
                            class="s1">{{ aiTrans('Prelucrarea este necesară pentru respectarea unei obligații legale căreia îi este supusă Compania.', $locale) }}</span>
                    </li>
                </ul>
                <p class="p1">
                    {{ aiTrans('Dacă doriți să primiți informații suplimentare care detaliază modul în care prelucrarea este necesară în scopul intereselor legitime urmărite de Companie sau de o terță parte, ne puteți contacta oricând trimițând o notificare la adresa de e-mail.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Următoarea listă descrie scopurile pentru care putem prelucra Date personale despre dumneavoastră și temeiul legal pentru o astfel de prelucrare:', $locale) }}
                </p>
                <table class="t1" cellspacing="0" cellpadding="0">
                    <tbody>
                        <tr>
                            <td class="td1" valign="top">&nbsp;</td>
                            <td class="td2" valign="top">
                                <p class="p5">{{ aiTrans('Scop', $locale) }}</p>
                            </td>
                            <td class="td3" valign="top">
                                <p class="p5">{{ aiTrans('Temei legal', $locale) }}</p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td4" valign="top">
                                <p class="p5">1</p>
                            </td>
                            <td class="td5" valign="top">
                                <p class="p6">
                                    {{ aiTrans('Pentru a trimite datele dumneavoastră către terți la solicitarea dumneavoastră pentru a vă adresa comerțului digital.', $locale) }}
                                </p>
                                <p class="p6">
                                    {{ aiTrans('Este posibil să colectăm date personale despre dvs. pentru a le trimite unor terți, dacă o solicitați în mod expres.', $locale) }}
                                </p>
                            </td>
                            <td class="td6" valign="top">
                                <p class="p5">
                                    {{ aiTrans('Ați fost de acord cu prelucrarea datelor dumneavoastră cu caracter personal pentru unul sau mai multe scopuri specifice.', $locale) }}
                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td7" valign="top">
                                <p class="p5">2</p>
                            </td>
                            <td class="td8" valign="top">
                                <p class="p6">
                                    {{ aiTrans('Pentru a răspunde întrebărilor, solicitărilor și/sau reclamațiilor dvs', $locale) }}
                                </p>
                                <p class="p6">
                                    {{ aiTrans('Prelucrarea datelor cu caracter personal despre dumneavoastră este necesară pentru a răspunde întrebărilor pe care le aveți cu privire la utilizarea Serviciilor.', $locale) }}
                                </p>
                            </td>
                            <td class="td9" valign="top">
                                <p class="p5">
                                    {{ aiTrans('Prelucrarea este necesară pentru interesele legitime urmărite de Companie sau de un terț.', $locale) }}
                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td10" valign="top">
                                <p class="p5">3</p>
                            </td>
                            <td class="td11" valign="top">
                                <p class="p6">
                                    {{ aiTrans('Pentru a respecta orice obligații legale sau ordine judiciare sau administrative', $locale) }}
                                </p>
                                <p class="p6">
                                    {{ aiTrans('Prelucrăm date personale despre dumneavoastră pentru a ne conforma diferitelor obligații legale.', $locale) }}
                                </p>
                            </td>
                            <td class="td12" valign="top">
                                <p class="p5">
                                    {{ aiTrans('Prelucrarea este necesară pentru respectarea unei obligații legale căreia îi este supusă Compania.', $locale) }}
                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td13" valign="top">
                                <p class="p5">4</p>
                            </td>
                            <td class="td14" valign="top">
                                <p class="p6">{{ aiTrans('Pentru a ne îmbunătăți serviciile', $locale) }}</p>
                                <p class="p6">
                                    {{ aiTrans('Putem folosi date personale despre dumneavoastră pentru a îmbunătăți serviciile noastre. O astfel de prelucrare va include, printre altele, orice jurnal de blocare sau alte rapoarte de defecțiuni obținute în legătură cu Serviciile.', $locale) }}
                                </p>
                            </td>
                            <td class="td15" valign="top">
                                <p class="p5">
                                    {{ aiTrans('Prelucrarea este necesară pentru interesele legitime urmărite de Companie sau de un terț.', $locale) }}
                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td16" valign="top">
                                <p class="p5">5</p>
                            </td>
                            <td class="td17" valign="top">
                                <p class="p6">
                                    {{ aiTrans('Pentru a evita frauda și utilizarea abuzivă a Serviciilor noastre', $locale) }}
                                </p>
                            </td>
                            <td class="td18" valign="top">
                                <p class="p5">
                                    {{ aiTrans('Prelucrarea este necesară pentru interesele legitime urmărite de Companie sau de un terț.', $locale) }}
                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td19" valign="top">
                                <p class="p5">6</p>
                            </td>
                            <td class="td20" valign="top">
                                <p class="p6">
                                    {{ aiTrans('Pentru a desfășura și întreține diverse activități care sprijină furnizarea Serviciilor noastre', $locale) }}
                                </p>
                                <p class="p6">
                                    {{ aiTrans('Astfel de activități includ funcții administrative, activități de dezvoltare a afacerii, luarea deciziilor strategice, mecanisme de supraveghere etc.', $locale) }}
                                </p>
                            </td>
                            <td class="td21" valign="top">
                                <p class="p5">
                                    {{ aiTrans('Prelucrarea este necesară pentru interesele legitime urmărite de Companie sau de un terț.', $locale) }}
                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td4" valign="top">
                                <p class="p5">7</p>
                            </td>
                            <td class="td5" valign="top">
                                <p class="p6">
                                    {{ aiTrans('Pentru a efectua analize, inclusiv analize statistice.', $locale) }}</p>
                                <p class="p6">
                                    {{ aiTrans('Folosim diverse măsuri analitice (inclusiv statistici) pentru a lua decizii pe diverse subiecte.', $locale) }}
                                </p>
                            </td>
                            <td class="td6" valign="top">
                                <p class="p5">
                                    {{ aiTrans('Prelucrarea este necesară pentru interesele legitime urmărite de Companie sau de un terț.', $locale) }}
                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td22" valign="top">
                                <p class="p5">8</p>
                            </td>
                            <td class="td23" valign="top">
                                <p class="p6">
                                    {{ aiTrans('Pentru a ne proteja interesele, drepturile și bunurile și pe cele ale terților, inclusiv stabilirea, exercitarea sau apărarea unor pretenții legale.', $locale) }}
                                </p>
                                <p class="p6">
                                    {{ aiTrans('Putem prelucra Date cu caracter personal despre dvs. pentru a ne proteja interesele, drepturile și bunurile, sau pe cele ale terților, în conformitate cu orice lege, regulament sau acord, inclusiv cu oricare dintre termenii, condițiile și politicile noastre.', $locale) }}
                                </p>
                            </td>
                            <td class="td24" valign="top">
                                <p class="p5">
                                    {{ aiTrans('Prelucrarea este necesară pentru interesele legitime urmărite de Companie sau de un terț.', $locale) }}
                                </p>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <p class="p1">{{ aiTrans('6. Transferul datelor cu caracter personal către terți', $locale) }}</p>
                <p class="p1">
                    {{ aiTrans('Compania poate, de asemenea, să partajeze Date cu caracter personal despre dumneavoastră cu terțe părți care ne oferă servicii, cum ar fi furnizorii de găzduire și stocare, informații despre adresa IP, analiza experienței utilizatorului și servicii de cercetare, analitice, tehnice și de diagnosticare.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('În plus, puteți solicita în mod special să trimitem anumite date personale despre dvs. către platforme de tranzacționare terță parte. În astfel de cazuri, vom partaja Datele cu caracter personal pe care ni le furnizați în acest scop acestor terțe părți, iar utilizarea lor a Datelor dumneavoastră cu caracter personal va fi supusă propriilor politici de confidențialitate. Putem partaja datele dumneavoastră cu caracter personal cu mai multe platforme de tranzacționare terțe.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Compania poate, de asemenea, să partajeze Date personale despre dumneavoastră cu entitățile afiliate și partenerii săi de afaceri, care oferă resurse care permit Companiei să îmbogățească și să îmbunătățească nivelul serviciilor și produselor pe care le oferă utilizatorilor săi.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Compania poate partaja Date cu caracter personal despre dvs. autorităților guvernamentale, locale, oficiale și de reglementare, precum și dacă o astfel de dezvăluire este necesară pentru a ne proteja interesele, drepturile și bunurile și pe cele ale terților, inclusiv stabilirea, exercitarea sau apărarea revendicărilor legale.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('În plus, putem dezvălui Date personale despre dumneavoastră către potențiali cumpărători, investitori sau creditori ai Companiei și/sau oricărei companii din grupul de companii din care Compania face parte sau în cazul oricărei tranzacții similare (inclusiv vânzarea). a activelor Societății și/sau oricărei companii din grupul de companii din care Compania face parte) și/sau în legătură cu orice fuziune, reorganizare, consolidare sau faliment a Societății și/sau a oricărei companii din grupul de companii din care face parte Societatea.', $locale) }}
                </p>
                <p class="p1">{{ aiTrans('7. Cookie-uri și servicii ale terților', $locale) }}</p>
                <p class="p1">
                    {{ aiTrans('Este posibil să folosim anumite servicii terțe, cum ar fi companii de analiză sau companii care afișează reclame pe site-ul nostru web, care pot folosi, de asemenea, cookie-uri sau alte tehnologii, iar acele practici și furnizori sunt supuse propriilor politici.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Cookie-ul (care este un fișier text mic) este instalat pe dispozitivul prin care vizitați sau accesați site-ul web. Cookie-urile ne vor permite să colectăm informații despre dvs. și despre comportamentul dvs., pentru a vă îmbunătăți experiența utilizatorului, pentru a vă aminti preferințele și setările și pentru a vă personaliza și a vă oferi produse și servicii care vă pot interesa. Cookie-urile pot fi folosite și pentru a colecta statistici și pentru a efectua analize.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Unele dintre cookie-urile pe care le putem folosi sunt cookie-uri de sesiune, care sunt descărcate temporar pe dispozitivul dvs. și durează până când închideți browserul web, în ​​timp ce altele sunt cookie-uri persistente, care rămân pe dispozitivul dvs. după ce opriți navigarea pe site și pot fi folosite pentru a Ajutor. site-ul vă va aminti ca vizitator care revine atunci când vă întoarceți pe site.', $locale) }}
                </p>
                <p class="p1">{{ aiTrans('Tipuri de cookie-uri:', $locale) }}</p>
                <p class="p1">
                    {{ aiTrans('Cookie-urile pe care le putem utiliza sunt clasificate în funcție de funcționalitatea lor, după cum urmează:', $locale) }}
                </p>
                <table class="t1" cellspacing="0" cellpadding="0">
                    <tbody>
                        <tr>
                            <td class="td25" valign="top">
                                <p class="p5">{{ aiTrans('Tipul cookie-ului', $locale) }}</p>
                            </td>
                            <td class="td26" valign="top">
                                <p class="p5">{{ aiTrans('Scop', $locale) }}</p>
                            </td>
                            <td class="td27" valign="top">
                                <p class="p5">{{ aiTrans('informatii suplimentare', $locale) }}</p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td28" valign="top">
                                <p class="p5">{{ aiTrans('Cookie-uri strict necesare', $locale) }}</p>
                            </td>
                            <td class="td29" valign="top">
                                <p class="p6">
                                    {{ aiTrans('Aceste cookie-uri sunt strict necesare pentru a vă permite să navigați pe site și să utilizați funcțiile pe care le-ați solicitat. Sunt folosite pentru a vă furniza conținutul, produsele și serviciile noastre pe care le-ați solicitat.', $locale) }}
                                </p>
                                <p class="p6">
                                    {{ aiTrans('Aceste cookie-uri sunt esențiale pentru a ajuta dispozitivul să descarce sau să transmită informații, astfel încât să puteți naviga pe site, să utilizați funcțiile acestuia și să vă întoarceți la paginile pe care le-ați vizitat anterior.', $locale) }}
                                </p>
                            </td>
                            <td class="td30" valign="top">
                                <p class="p6">
                                    {{ aiTrans('Aceste cookie-uri colectează date personale despre dvs., cum ar fi numele dvs. de utilizator și data ultimei autentificare, și vă identifică atunci când v-ați conectat pe site.', $locale) }}
                                </p>
                                <p class="p6">
                                    {{ aiTrans('Aceste cookie-uri sunt șterse atunci când închideți browserul web (cookie-uri de sesiune).', $locale) }}
                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td31" valign="top">
                                <p class="p5">{{ aiTrans('Cookie-uri de funcționalitate', $locale) }}</p>
                            </td>
                            <td class="td32" valign="top">
                                <p class="p5">
                                    {{ aiTrans('Aceste cookie-uri sunt folosite pentru a vă recunoaște atunci când reveniți pe site și ne permit să ne amintim alegerile și preferințele dvs.', $locale) }}
                                </p>
                            </td>
                            <td class="td33" valign="top">
                                <p class="p5">
                                    {{ aiTrans('Aceste cookie-uri supraviețuiesc închiderii browserului dvs. web și durează până la timpul de expirare corespunzător.', $locale) }}
                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td34" valign="top">
                                <p class="p5">{{ aiTrans('Cookie-uri de performanță', $locale) }}</p>
                            </td>
                            <td class="td35" valign="top">
                                <p class="p5">
                                    {{ aiTrans('Aceste cookie-uri sunt folosite pentru a furniza statistici agregate privind performanța site-ului web și pentru a testa și îmbunătăți astfel de performanțe, pentru a oferi o experiență mai bună a utilizatorului. În plus, Ne permit să îndeplinim funcții analitice pe site-ul web.', $locale) }}
                                </p>
                            </td>
                            <td class="td36" valign="top">
                                <p class="p6">
                                    {{ aiTrans('Aceste cookie-uri colectează date anonime care nu au legătură cu o persoană fizică identificată sau identificabilă.', $locale) }}
                                </p>
                                <p class="p6">
                                    {{ aiTrans('Aceste cookie-uri sunt valabile pentru perioade diferite; unele sunt șterse atunci când închideți browserul, în timp ce altele au o perioadă de valabilitate nedeterminată.', $locale) }}
                                </p>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <p class="p1">{{ aiTrans('Blocarea și eliminarea cookie-urilor', $locale) }}</p>
                <p class="p1">
                    {{ aiTrans('Puteți modifica setările browserului pentru a bloca și șterge unele sau toate cookie-urile. Consultați linkurile de mai jos pentru instrucțiuni despre cum să faceți acest lucru cu privire la unele dintre cele mai populare browsere web:', $locale) }}
                </p>
                <ul class="ul1">
                    <li class="li3"><span class="s1">Firefox</span></li>
                    <li class="li3"><span class="s1">Microsoft Edge</span></li>
                    <li class="li3"><span class="s1">Google Chrome</span></li>
                    <li class="li2"><span class="s1">Safari</span></li>
                </ul>
                <p class="p1">
                    {{ aiTrans('Cu toate acestea, vă rugăm să rețineți că, dacă faceți acest lucru, este posibil ca unele sau toate caracteristicile și funcționalitățile site-ului web să nu funcționeze așa cum este prevăzut.', $locale) }}
                </p>
                <p class="p1">{{ aiTrans('ANUNȚ ONLINE DE URMĂRIRE', $locale) }}</p>
                <p class="p1">
                    {{ aiTrans('ÎN ACESTA MOMENT, ACEST SERVICIU NU PERMITE SEMNE FĂRĂ URMĂRIRE.', $locale) }}</p>
                <p class="p1">{{ aiTrans('8. Păstrarea datelor personale despre dumneavoastră', $locale) }}</p>
                <p class="p1">
                    {{ aiTrans('Compania va păstra datele dumneavoastră cu caracter personal atât timp cât este necesar pentru a îndeplini scopurile prelucrării datelor cu caracter personal, așa cum este descris în această Politică, sau pentru o perioadă mai lungă, după cum este necesar, în conformitate cu legile, reglementările, politicile și ordinele care ni se aplică.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Vom partaja informațiile dvs. cu platforme de tranzacționare terțe pentru o perioadă de 12 luni și, cu acordul nostru, vom face acest lucru pentru încă 12 luni.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Pentru a ne asigura că datele dumneavoastră cu caracter personal nu sunt păstrate mai mult decât este necesar, revizuim periodic datele personale pe care le deținem pentru a verifica dacă pot fi șterse.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('9. Transferuri de date cu caracter personal către o țară terță sau o organizație internațională', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Datele dumneavoastră cu caracter personal pot fi transferate într-o țară terță (adică alte jurisdicții decât cea în care locuiți) sau către organizații internaționale. În astfel de circumstanțe, Compania va lua măsuri de securitate adecvate pentru a asigura protecția datelor dumneavoastră cu caracter personal și pentru a se asigura că drepturile aplicabile ale persoanelor vizate și căile de atac eficiente sunt disponibile pentru persoanele vizate.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Dacă sunteți rezident al SEE (Spațiul Economic European), vă rugăm să rețineți că aceste garanții și protecție vor fi disponibile dacă sunt îndeplinite oricare dintre următoarele condiții:', $locale) }}
                </p>
                <ul class="ul1">
                    <li class="li3"><span
                            class="s1">{{ aiTrans('Transferul se efectuează către o țară terță sau către o organizație internațională despre care Comisia UE a decis că oferă un nivel adecvat de protecție a datelor cu caracter personal transferate acesteia în conformitate cu articolul 45 alineatul (3) din Regulamentul (UE) 2016/679 al Uniunii Europene. Uniune. Parlamentul și Consiliul din 27 aprilie 2016 („GDPR”).', $locale) }}</span>
                    </li>
                    <li class="li3"><span
                            class="s1">{{ aiTrans('Transferul se face prin intermediul unui instrument juridic obligatoriu și executoriu între autorități sau organisme publice în conformitate cu articolul 46, alineatul 2, lit. a) din GDPR; fie', $locale) }}</span>
                    </li>
                    <li class="li2"><span
                            class="s1">{{ aiTrans('Transferul se efectuează în conformitate cu clauzele standard de protecție a datelor adoptate de Comisia UE în conformitate cu articolul 46 (2) (c) din GDPR. Clauzele adoptate de Comisia UE pot fi consultate la https://ec.europa.eu/info/law/law-topic/data-protection/data-transfers-outside-eu/model-contracts-transfer-personal -data -terțe-țări_în.', $locale) }}</span>
                    </li>
                </ul>
                <p class="gt-block p1">
                    {{ aiTrans('Puteți solicita Companiei să vă furnizeze detalii cu privire la măsurile de securitate utilizate de Companie pentru a vă proteja Datele cu Caracter Personal care sunt transferate într-o țară terță sau organizație internațională, trimițând un e-mail la următoarea adresă:', $locale) }}&nbsp;<span
                        class="s2">info{{ '@' . $website_title }}</span></p>
                <p class="p1">{{ aiTrans('10. Protecția datelor personale despre dumneavoastră', $locale) }}</p>
                <p class="p1">
                    {{ aiTrans('Implementăm măsuri tehnice și organizatorice adecvate pentru a asigura un nivel adecvat de securitate a Datelor cu caracter personal, ținând cont de riscurile prezentate de prelucrare, în special de la distrugerea, pierderea, modificarea, dezvăluirea neautorizată sau accesul accidental sau ilegal la datele cu caracter personal. transmise, stocate sau prelucrate în alt mod.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Nu putem garanta și nici nu reprezentăm că va exista o performanță fără erori în ceea ce privește confidențialitatea datelor dumneavoastră cu caracter personal și nu vom fi răspunzători pentru nicio daune indirecte, incidentale, consecutive sau punitive legate de utilizarea sau dezvăluirea Datele dumneavoastră personale. Datele despre dvs., inclusiv, dar fără a se limita la, dezvăluirea datelor cu caracter personal din cauza erorilor de transmitere, accesului neautorizat de către terți sau altor cauze care nu pot fi controlate în mod rezonabil.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Este posibil să ni se solicite, din cauza unor obligații legale sau de altă natură care nu sunt controlate, să transferăm date cu caracter personal despre dumneavoastră către terți, cum ar fi autoritățile publice. În astfel de circumstanțe, avem un control limitat asupra nivelului de protecție oferit datelor dumneavoastră cu caracter personal de către astfel de terți.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Orice transfer de date cu caracter personal pe internet nu poate fi complet sigur. Prin urmare, Compania nu poate garanta protecția datelor dumneavoastră cu caracter personal atunci când sunt transferate către noi prin Internet.', $locale) }}
                </p>
                <p class="p1">{{ aiTrans('11. Link-uri către site-uri web ale terților', $locale) }}</p>
                <p class="p1">
                    {{ aiTrans('Site-ul web poate furniza link-uri către site-uri web și/sau aplicații ale terților. Compania nu controlează astfel de site-uri web și aplicații, nici colectarea și/sau prelucrarea datelor cu caracter personal despre dvs. de către astfel de site-uri web și aplicații și nu suntem responsabili pentru astfel de site-uri web și aplicații, sau politicile și activitățile lor de confidențialitate și protecția datelor. Această politică nu se aplică niciunei acțiuni întreprinse prin astfel de site-uri web și/sau aplicații.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Ori de câte ori accesați site-uri web și/sau aplicații ale unor astfel de terți, vă recomandăm să revizuiți cu atenție politicile lor de confidențialitate înainte de a utiliza astfel de site-uri web și/sau aplicații și înainte de a dezvălui orice date personale despre dvs.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('13. Drepturile dumneavoastră cu privire la datele dumneavoastră personale', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('În general, aveți dreptul de a ne solicita confirmarea dacă colectăm date cu caracter personal despre dvs., de a solicita revizuirea acestor date, de a rectifica conținutul dacă este cazul și de a șterge datele personale de care nu mai avem nevoie. Puteți, de asemenea, să vă restricționați consimțământul pentru o anumită prelucrare a informațiilor dumneavoastră personale.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Dacă sunteți rezident în SEE, vă rugăm să citiți această secțiune de mai jos:', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Aveți următoarele drepturi cu privire la datele dumneavoastră personale. Pentru exercitarea acestor drepturi, puteți trimite o cerere de exercitare a drepturilor dumneavoastră la următoarea adresă de e-mail:', $locale) }}
                </p>
                <p class="p1">{{ aiTrans('Dreptul de acces', $locale) }}</p>
                <p class="p1">
                    {{ aiTrans('Aveți dreptul de a primi de la Companie confirmarea dacă sunt sau nu prelucrate date cu caracter personal despre dumneavoastră și, dacă este cazul, acces la datele personale și următoarele informații: (1) scopurile prelucrării; (2) categoriile de Date cu caracter personal în cauză; (3) destinatarii sau categoriile de destinatari cărora le-au fost sau vor fi dezvăluite datele cu caracter personal, în special destinatarii din țări terțe din afara Spațiului Economic European (SEE) sau organizații internaționale; (4) dacă este posibil, perioada anticipată pentru care vor fi stocate datele cu caracter personal sau, dacă nu este posibil, criteriile utilizate pentru a determina perioada respectivă; (5) existența dreptului de a solicita de la Companie rectificarea sau ștergerea Datelor cu caracter personal sau restricționarea prelucrării Datelor cu caracter personal despre dumneavoastră sau de a vă opune unei astfel de prelucrări; (6) dreptul de a depune o plângere la o autoritate de supraveghere; (7) în cazul în care nu sunt colectate date personale de la dvs., orice informații disponibile despre sursa acesteia; (8) existența profilurilor; și (9) în cazul în care Datele cu caracter personal sunt transferate către o țară terță din afara SEE sau către o organizație internațională, garanțiile corespunzătoare legate de transfer.',$locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Compania va furniza o copie a datelor cu caracter personal care sunt procesate și poate percepe o taxă rezonabilă pentru orice copii suplimentare pe care le solicitați. Dacă faceți cererea dumneavoastră electronic și dacă nu solicitați altfel, informațiile vor fi furnizate într-un format electronic utilizat în mod obișnuit.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Dreptul de a obține o copie a Datelor cu caracter personal nu va afecta în mod negativ drepturile și libertățile altora. Prin urmare, dacă cererea încalcă drepturile și libertățile altora, este posibil ca Compania să nu se conformeze solicitării dumneavoastră sau să o facă într-o manieră limitată.', $locale) }}
                </p>
                <p class="p1">{{ aiTrans('Dreptul de rectificare', $locale) }}</p>
                <p class="p1">
                    {{ aiTrans('Aveți dreptul de a obține de la Companie rectificarea Datelor personale inexacte despre dvs. Ținând cont de scopurile prelucrării, aveți dreptul ca datele dumneavoastră cu caracter personal incomplete să fie completate, inclusiv prin depunerea unei declarații suplimentare.', $locale) }}
                </p>
                <p class="p1">{{ aiTrans('Dreptul de ștergere', $locale) }}</p>
                <p class="p1">
                    {{ aiTrans('Se aplică următoarele motive: (a) Datele cu caracter personal nu mai sunt necesare în raport cu scopul pentru care au fost colectate sau prelucrate în alt mod; (b) vă retrageți consimțământul pe care se bazează prelucrarea și nu există niciun alt temei legal pentru prelucrare; (c) vă opuneți în orice moment, din motive legate de situația dumneavoastră particulară, la prelucrarea Datelor dumneavoastră cu caracter personal care se bazează pe interesele legitime urmărite de Noi sau de un terț și nu există motive legitime convingătoare pentru Prelucrare; (d) vă opuneți prelucrării datelor dumneavoastră cu caracter personal în scopuri de marketing direct; (e) datele cu caracter personal au fost prelucrate ilegal; sau (f) Datele cu caracter personal despre dumneavoastră trebuie să fie șterse pentru a respecta o obligație legală a Uniunii Europene sau a unui stat membru căreia îi este supusă Compania.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Acest drept nu se aplică în măsura în care prelucrarea este necesară (a) pentru respectarea unei obligații legale care impune prelucrarea conform legislației Uniunii Europene sau a statelor membre cărora Compania este supusă; sau (b) pentru stabilirea, exercitarea sau apărarea unor pretenții legale.', $locale) }}
                </p>
                <p class="p1">{{ aiTrans('Dreptul de a limita prelucrarea', $locale) }}</p>
                <p class="p1">
                    {{ aiTrans('Aveți dreptul de a obține de la Companie restricționarea prelucrării datelor dumneavoastră cu caracter personal dacă se aplică una dintre următoarele: (a) contestați acuratețea datelor cu caracter personal, pentru o perioadă care permite Companiei să verifice acuratețea datelor cu caracter personal. Date personale despre dvs.; (b) prelucrarea este ilegală și vă opuneți ștergerii datelor dumneavoastră cu caracter personal și solicitați în schimb restricționarea utilizării acestora; (c) Compania nu mai are nevoie de Datele dumneavoastră cu caracter personal în scopul prelucrării, dar le solicitați pentru stabilirea, exercitarea sau apărarea unor pretenții legale; (d) în cazul în care prelucrarea datelor cu caracter personal despre dumneavoastră este necesară pentru interesele legitime urmărite de Companie sau de un terț, cu excepția cazului în care demonstrăm motive legitime convingătoare pentru prelucrare care prevalează asupra intereselor, drepturilor și libertăților dumneavoastră sau pentru stabilirea, exercitarea sau apărarea pretențiilor legale; sau (e) dacă datele dumneavoastră cu caracter personal sunt prelucrate în scopuri de marketing direct, inclusiv crearea de profiluri, în măsura în care acestea sunt legate de un astfel de marketing direct.',$locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Dacă prelucrarea datelor cu caracter personal despre dvs. a fost restricționată după solicitarea dvs., aceste date cu caracter personal, cu excepția stocării, vor fi prelucrate numai cu acordul dvs. sau pentru stabilirea, exercitarea sau apărarea unor pretenții legale sau pentru protecția drepturilor. al altei persoane fizice sau juridice sau din motive de interes public important al Uniunii Europene sau al unui stat membru.', $locale) }}
                </p>
                <p class="p1">{{ aiTrans('Dreptul la portabilitatea datelor', $locale) }}</p>
                <p class="p1">
                    {{ aiTrans('Aveți dreptul de a primi Datele personale despre dvs., pe care le-ați furnizat Companiei, într-un format structurat, utilizat în mod obișnuit și care poate fi citit de mașină, precum și dreptul de a transmite astfel de Date personale către alt operator, dacă (a) prelucrarea se bazează pe consimțământul dumneavoastră sau pe un contract la care sunteți parte și (b) prelucrarea este efectuată prin mijloace automate.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Prin exercitarea dreptului dumneavoastră la portabilitatea datelor, aveți dreptul ca datele dumneavoastră cu caracter personal să fie transmise direct de la Companie către un alt operator, acolo unde este fezabil din punct de vedere tehnic. Exercitarea dreptului dumneavoastră la portabilitatea datelor nu aduce atingere drepturilor dumneavoastră și celor ale Companiei în temeiul dreptului dumneavoastră de ștergere. În plus, dreptul la portabilitatea datelor nu va afecta în mod negativ drepturile și libertățile altora.', $locale) }}
                </p>
                <p class="p1">{{ aiTrans('Dreptul de a obiecta', $locale) }}</p>
                <p class="p1">
                    {{ aiTrans('Aveți dreptul de a vă opune în orice moment, din motive legate de situația dumneavoastră particulară, la prelucrarea Datelor dumneavoastră cu caracter personal care se bazează pe interesele legitime urmărite de Companie sau de un terț, inclusiv crearea de profiluri bazate pe astfel de interese legitime. . În acest caz, nu vom mai prelucra datele dumneavoastră cu caracter personal decât dacă demonstrăm motive legitime convingătoare pentru prelucrare care prevalează asupra intereselor, drepturilor și libertăților dumneavoastră sau pentru stabilirea, exercitarea sau apărarea unor pretenții legale.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Aveți dreptul de a vă opune în orice moment prelucrării datelor dumneavoastră cu caracter personal în scopuri de marketing direct, inclusiv de profilare, în măsura în care aceasta are legătură cu un astfel de marketing direct.', $locale) }}
                </p>
                <p class="p1">{{ aiTrans('Dreptul de a retrage consimțământul', $locale) }}</p>
                <p class="p1">
                    {{ aiTrans('Puteți retrage oricând consimțământul pe care ni l-ați dat în scopul prelucrării Datelor cu caracter personal despre dumneavoastră, fără a afecta legalitatea prelucrării bazate pe consimțământul dumneavoastră înainte de retragerea acestuia.', $locale) }}
                </p>
                <p class="p1">{{ aiTrans('Dreptul de a depune o cerere la o autoritate de supraveghere', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Aveți dreptul de a depune o plângere la o autoritate de supraveghere instituită de un stat membru pentru a proteja drepturile și libertățile fundamentale ale persoanelor fizice în legătură cu prelucrarea datelor cu caracter personal în cadrul Uniunii Europene.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Drepturile dumneavoastră cu privire la Datele dumneavoastră cu caracter personal, așa cum sunt descrise în această secțiune 13, pot fi restricționate de legislația Uniunii Europene sau a statului membru la care se supune Compania.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Vă vom furniza informațiile solicitate în conformitate cu drepturile dumneavoastră descrise în această secțiune 13 fără întârzieri nejustificate și, în orice caz, în termen de o lună de la primirea cererii. Această perioadă poate fi prelungită cu încă două luni atunci când este necesar, ținând cont de complexitatea și numărul de cereri. Vă vom informa cu privire la orice astfel de prelungire în termen de o lună de la primirea solicitării dumneavoastră, împreună cu motivele întârzierii.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Informațiile solicitate în conformitate cu drepturile dumneavoastră descrise în această secțiune 13 vor fi furnizate gratuit, cu excepția cazului în care se prevede altfel în această secțiune 13. În cazul în care cererile sunt în mod vădit nefondate sau excesive, în special din cauza naturii lor repetitive, putem (a) să taxăm o taxă rezonabilă, ținând cont de costurile administrative de furnizare a informațiilor sau comunicării sau acțiunii solicitate; sau (b) refuză să dea curs cererii.', $locale) }}
                </p>
                <p class="p1">
                    {{ aiTrans('Compania vă poate cere să furnizați informații suplimentare necesare pentru a vă confirma identitatea pentru a vă îndeplini cererea în conformitate cu drepturile dumneavoastră descrise în această secțiune 13, dacă avem îndoieli rezonabile cu privire la identitatea persoanei fizice care face cererea.', $locale) }}
                </p>
                <p class="p1">{{ aiTrans('12. Modificări ale acestei politici', $locale) }}</p>
                <p class="p1">
                    {{ aiTrans('Putem modifica din când în când termenii acestei Politici. Ori de câte ori modificăm această Politică, vă vom anunța cu privire la astfel de modificări prin publicarea Politicii actualizate pe Site. În plus, atunci când aducem modificări materiale acestei Politici, ne vom strădui să vă informăm despre astfel de modificări utilizând mijloacele de comunicare pe care le considerăm rezonabile adecvate pentru a vă informa despre astfel de modificări și prin publicarea unei notificări cu privire la astfel de modificări pe site. Dacă nu se indică altfel, toate modificările vor intra în vigoare la postarea Politicii actualizate pe site-ul nostru web.', $locale) }}
                </p>
            </div>
        </div>
    </section>
@endsection
