@extends('layouts.app')
@push('meta')
    <title>{{ "$website_title | πολιτική απορρήτου" }}</title>
    <meta name="description" content="{{ "Ανακαλύψτε πώς το $website_title διατηρεί την ασφάλεια των πληροφοριών σας. Η πολιτική μας για το απόρρητο εξηγεί τις διαδικασίες για την ασφάλεια και τη διαφάνεια." }}" />
@endpush
@section('content')
    <div class="container terms py-4">
        <h1 class="bold text-center">{{ aiTrans('Ειδοποίηση Προστασίας Δεδομένων') }}</h1>
        <h2 class="bold">{{ aiTrans('Σκοπός της Ειδοποίησης') }}</h2>
        <p>{{ aiTrans('Ο σκοπός αυτής της Ειδοποίησης Προστασίας Δεδομένων (η "Ειδοποίηση") είναι να εξηγήσει πώς ("" ή "Εμείς" ή "Εμάς") θα επεξεργαστεί, ως υπεύθυνος επεξεργασίας δεδομένων, τα προσωπικά σας δεδομένα που μας παρέχετε όταν επισκέπτεστε τον ιστότοπο [website_title] (η "Ιστοσελίδα"), ή που λαμβάνουμε από τρίτους, προκειμένου να σας συνδέσουμε με επαγγελματίες που μπορεί να σας ενδιαφέρουν.', $locale, ['website_title' => $website_title]) }}
        </p>
        <h2 class="bold">{{ aiTrans('Ποιες κατηγορίες προσωπικών δεδομένων θα επεξεργαστούν;') }}</h2>
        <p>{{ aiTrans('Συλλέγουμε και επεξεργαζόμαστε τις παρακάτω κατηγορίες προσωπικών δεδομένων για εσάς:') }}</p>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <td><b>{{ aiTrans('Κατηγορία προσωπικών δεδομένων') }}</b></td>
                    <td><b>{{ aiTrans('Ορισμός') }}</b></td>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>{{ aiTrans('Δεδομένα Ταυτοποίησης') }}</td>
                    <td>{{ aiTrans('Πλήρες όνομα και πληροφορίες επαφής (τηλέφωνο και διεύθυνση email).') }}</td>
                </tr>
                <tr>
                    <td>{{ aiTrans('Πληροφορίες Πλοήγησης') }}</td>
                    <td>{{ aiTrans('Διεύθυνση IP, ώρα πρόσβασης, ημερομηνία πρόσβασης, ιστότοποι και σελίδες κινητών που επισκεφθήκατε, γλώσσα που χρησιμοποιήθηκε, αναφορές σφαλμάτων λογισμικού και τύπος προγράμματος περιήγησης που χρησιμοποιήθηκε, πληροφορίες σχετικά με τη συσκευή που χρησιμοποιήσατε, οι διαδικτυακές σας ενέργειες που συλλέγονται αυτόματα, όπως cookies, web servers, pixels και web beacons.') }}
                    </td>
                </tr>
            </tbody>
        </table>
        <h2 class="bold">{{ aiTrans('Πώς συλλέγονται τα δεδομένα σας;') }}</h2>
        <p>{{ aiTrans('Θα συλλέξουμε τα προσωπικά σας δεδομένα:') }}</p>
        <ul>
            <li>{{ aiTrans('Άμεσα από εσάς, όταν παρέχετε τα Δεδομένα Ταυτοποίησης σας στην Ιστοσελίδα μας; και/ή') }}</li>
            <li>{{ aiTrans('Έμμεσα:') }}
                <ul>
                    <li>{{ aiTrans('όταν λαμβάνουμε Δεδομένα Ταυτοποίησης για εσάς από τρίτους (συμπεριλαμβανομένων εταιρειών εκπαίδευσης επενδύσεων, συνεργατών/συνεργατών/μάρκετινγκ/ψηφιακών πρακτορείων); και/ή') }}
                    </li>
                    <li>{{ aiTrans('όταν συλλέγουμε δεδομένα σχετικά με την πλοήγησή σας στην Ιστοσελίδα μας μέσω της χρήσης cookies ή παρόμοιων τεχνολογιών (όπως ορίζεται στην Πολιτική Cookies).') }}
                    </li>
                </ul>
            </li>
        </ul>
        <p>{{ aiTrans('Δεν είστε υποχρεωμένοι να μας παρέχετε τα προσωπικά σας δεδομένα. Ωστόσο, η μη παροχή των προσωπικών σας δεδομένων θα μας εμποδίσει να σας συνδέσουμε με επαγγελματίες που μπορεί να σας ενδιαφέρουν.') }}
        </p>
        <h2 class="bold">{{ aiTrans('Ποιους είναι οι σκοποί και η νομική βάση της επεξεργασίας μας;') }}</h2>
        <p>{{ aiTrans('Επεξεργαζόμαστε τα προσωπικά σας δεδομένα για τους παρακάτω σκοπούς:') }}</p>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <td><b>{{ aiTrans('Σκοπός') }}</b></td>
                    <td><b>{{ aiTrans('Νομική βάση') }}</b></td>
                    <td><b>{{ aiTrans('Κατηγορίες προσωπικών δεδομένων που επεξεργάζονται') }}</b></td>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>{{ aiTrans('Μοιραζόμαστε τα προσωπικά σας δεδομένα με επαγγελματίες που προσφέρουν υπηρεσίες που μπορεί να σας ενδιαφέρουν') }}
                    </td>
                    <td>{{ aiTrans('Η συγκατάθεσή σας') }}</td>
                    <td>{{ aiTrans('Δεδομένα Ταυτοποίησης') }}</td>
                </tr>
                <tr>
                    <td>{{ aiTrans('Ανταπόκριση και συμμόρφωση με αιτήματα και νομικές απαιτήσεις από ρυθμιστικές αρχές ή άλλες αρχές εντός ή εκτός της χώρας σας.') }}
                    </td>
                    <td>{{ aiTrans('Συμμόρφωση με τις ισχύουσες νομικές και κανονιστικές απαιτήσεις.') }}</td>
                    <td>{{ aiTrans('Δεδομένα Ταυτοποίησης') }}<br>{{ aiTrans('Πληροφορίες Πλοήγησης') }}</td>
                </tr>
                <tr>
                    <td>{{ aiTrans('Επιβολή και υπεράσπιση των δικαιωμάτων μας') }}</td>
                    <td>{{ aiTrans('Το νόμιμο συμφέρον μας να υπερασπιστούμε τον εαυτό μας απέναντι στους χρήστες μας (συμπεριλαμβανομένου εσάς), δικαστικές, διοικητικές και/ή αρχές επιβολής του νόμου.') }}
                    </td>
                    <td>{{ aiTrans('Δεδομένα Ταυτοποίησης') }}<br>{{ aiTrans('Πληροφορίες Πλοήγησης') }}</td>
                </tr>
                <tr>
                    <td>{{ aiTrans('Διασφάλιση της λειτουργίας της Ιστοσελίδας μας και της ασφάλειάς της') }}</td>
                    <td>{{ aiTrans('Το νόμιμο συμφέρον μας να διασφαλίσουμε μια καλά λειτουργούσα και ασφαλή Ιστοσελίδα.') }}</td>
                    <td>{{ aiTrans('Πληροφορίες Πλοήγησης') }}</td>
                </tr>
            </tbody>
        </table>
        <h2 class="bold">{{ aiTrans('Με ποιον θα μοιραστούν τα προσωπικά μου δεδομένα;') }}</h2>
        <p>{{ aiTrans('Θα μοιραστούμε τα προσωπικά σας δεδομένα:') }}</p>
        <ul>
            <li>{{ aiTrans('Εντός της ομάδας μας;') }}</li>
            <li>{{ aiTrans('Με τους συνεργάτες μας, για δικούς τους σκοπούς επεξεργασίας, συμπεριλαμβανομένης της παροχής πληροφοριών για τις υπηρεσίες και τα προϊόντα τους που μπορεί να σας ενδιαφέρουν, υπό την προϋπόθεση ότι έχετε δώσει τη συγκατάθεσή σας για μια τέτοια κοινοποίηση. Τέτοιοι συνεργάτες περιλαμβάνουν εταιρείες εκπαίδευσης επενδύσεων, μεσίτες δεδομένων και μεσάζοντες;') }}
            </li>
            <li>{{ aiTrans('Με τρίτους που μας παρέχουν υπηρεσίες όπως αποθήκευση και πάροχοι φιλοξενίας αναλυτικών, τεχνικών και διαγνωστικών υπηρεσιών;') }}
            </li>
            <li>{{ aiTrans('Με τους συμβούλους μας, κυρίως για τη συμμόρφωση με τις νομικές υποχρεώσεις μας, ιδίως σε σχέση με την λογιστική, τον έλεγχο και την εσωτερική διαχείριση;') }}
            </li>
            <li>{{ aiTrans('Ως μέρος της πώλησης όλης ή μέρους της εταιρείας μας και των περιουσιακών στοιχείων της σε τρίτο μέρος ή ως μέρος αναδιοργάνωσης ή αναδιάρθρωσης επιχείρησης (συμπεριλαμβανομένης της διάλυσης ή εκκαθάρισης); και') }}
            </li>
            <li>{{ aiTrans('Όπου απαιτείται ή επιτρέπεται από την ισχύουσα νομοθεσία, σε κυβερνητικές αρχές, δικαστήρια, εξωτερικούς συμβούλους και παρόμοιους τρίτους.') }}
            </li>
        </ul>
        <h2 class="bold">{{ aiTrans('Διασυνοριακές μεταφορές δεδομένων') }}</h2>
        <p>{{ aiTrans('Μεταφέρουμε τα προσωπικά σας δεδομένα εκτός της Ευρωπαϊκής Οικονομικής Περιοχής (“ΕΟΧ”). Ορισμένοι παραλήπτες βρίσκονται σε χώρες για τις οποίες η Ευρωπαϊκή Επιτροπή έχει εκδώσει αποφάσεις επάρκειας, δηλαδή στο Ισραήλ. Η μεταφορά αναγνωρίζεται έτσι ως παροχή επαρκούς επιπέδου προστασίας δεδομένων από την οπτική γωνία της ευρωπαϊκής νομοθεσίας προστασίας δεδομένων (Άρθρο 45 GDPR).') }}
        </p>
        <p>{{ aiTrans('Ορισμένοι παραλήπτες των προσωπικών σας δεδομένων μπορεί να βρίσκονται σε άλλη χώρα για την οποία η Ευρωπαϊκή Επιτροπή δεν έχει εκδώσει απόφαση ότι αυτή η χώρα διασφαλίζει επαρκές επίπεδο προστασίας δεδομένων.') }}
        </p>
        <p>{{ aiTrans('Δίνοντας τη δυνατότητα να εισέλθουμε σε κατάλληλες συμφωνίες μεταφοράς δεδομένων βάσει τυποποιημένων συμβατικών ρητρών (2021/914/EU) όπως αναφέρεται στο Άρθρο 46 (2) (c) GDPR ή άλλων επαρκών μέσων, τα οποία είναι προσβάσιμα μέσω των στοιχείων επικοινωνίας παρακάτω, έχουμε διασφαλίσει ότι όλοι οι άλλοι παραλήπτες που βρίσκονται εκτός της ΕΟΧ θα παρέχουν επαρκές επίπεδο προστασίας δεδομένων για τα προσωπικά δεδομένα και ότι έχουν ληφθεί κατάλληλα τεχνικά και οργανωτικά μέτρα ασφαλείας για την προστασία των προσωπικών δεδομένων από τυχαία ή παράνομη καταστροφή, τυχαία απώλεια ή τροποποίηση, μη εξουσιοδοτημένη γνωστοποίηση ή πρόσβαση, και κατά όλων των άλλων παράνομων μορφών επεξεργασίας. Κάθε επόμενη μεταφορά (συμπεριλαμβανομένων των θυγατρικών μας εκτός της ΕΟΧ) υπόκειται σε κατάλληλες απαιτήσεις επόμενης μεταφοράς όπως απαιτείται από την ισχύουσα νομοθεσία.') }}
        </p>
        <h2 class="bold">{{ aiTrans('Διατήρηση') }}</h2>
        <p>{{ aiTrans('Θα αποθηκεύσουμε τα συλλεχθέντα προσωπικά δεδομένα μόνο για όσο διάστημα είναι απολύτως απαραίτητο για την επίτευξη των σκοπών επεξεργασίας που αναφέρονται σε αυτή την Ειδοποίηση και σύμφωνα με την ισχύουσα νομοθεσία προστασίας δεδομένων. Όταν δεν χρειαζόμαστε πλέον να χρησιμοποιούμε τα προσωπικά σας δεδομένα, θα διαγραφούν και/ή θα ανωνυμοποιηθούν ώστε τα άτομα να μην μπορούν πλέον να αναγνωριστούν από αυτά (εκτός αν απαιτείται διατήρηση για συμμόρφωση με νομικές ή κανονιστικές υποχρεώσεις ή για την υποβολή ή υπεράσπιση νομικών απαιτήσεων).') }}
        </p>
        <h2 class="bold">{{ aiTrans('Δικαιώματά σας') }}</h2>
        <p>{{ aiTrans('Σύμφωνα με την ισχύουσα νομοθεσία προστασίας δεδομένων, έχετε τα παρακάτω δικαιώματα:') }}</p>
        <ol>
            <li>
                <p><b>{{ aiTrans('Δικαίωμα πρόσβασης:') }}</b>
                    {{ aiTrans('Έχετε το δικαίωμα να λάβετε από εμάς επιβεβαίωση σχετικά με το αν τα προσωπικά δεδομένα που σας αφορούν υποβάλλονται σε επεξεργασία και, εάν ναι, να ζητήσετε πρόσβαση στα προσωπικά δεδομένα. Οι πληροφορίες πρόσβασης περιλαμβάνουν – ενδεικτικά – τους σκοπούς της επεξεργασίας, τις κατηγορίες των προσωπικών δεδομένων που αφορούν, και τους παραλήπτες ή τις κατηγορίες παραληπτών στους οποίους τα προσωπικά δεδομένα έχουν αποκαλυφθεί ή θα αποκαλυφθούν.') }}
                </p>
                <p>{{ aiTrans('Έχετε το δικαίωμα να λάβετε ένα αντίγραφο των προσωπικών δεδομένων που υποβάλλονται σε επεξεργασία. Για πρόσθετα αντίγραφα που ζητάτε, μπορεί να χρεώσουμε μια λογική αμοιβή που βασίζεται σε διοικητικά έξοδα.') }}
                </p>
            </li>
            <li>
                <p><b>{{ aiTrans('Δικαίωμα διόρθωσης:') }}</b>
                    {{ aiTrans('Έχετε το δικαίωμα να ζητήσετε από εμάς τη διόρθωση ανακριβών προσωπικών δεδομένων που σας αφορούν. Ανάλογα με τους σκοπούς της επεξεργασίας, έχετε το δικαίωμα να έχετε ολοκληρωμένα προσωπικά δεδομένα, συμπεριλαμβανομένου του να παρέχετε μια συμπληρωματική δήλωση.') }}
                </p>
            </li>
            <li>
                <p><b>{{ aiTrans('Δικαίωμα διαγραφής (δικαίωμα στη λήθη):') }}</b>
                    {{ aiTrans('Έχετε το δικαίωμα να ζητήσετε από εμάς να διαγράψουμε τα προσωπικά σας δεδομένα.') }}</p>
            </li>
            <li>
                <p><b>{{ aiTrans('Δικαίωμα περιορισμού της επεξεργασίας:') }}</b>
                    {{ aiTrans('Έχετε το δικαίωμα να ζητήσετε τον περιορισμό της επεξεργασίας των προσωπικών σας δεδομένων. Σε αυτή την περίπτωση, τα αντίστοιχα δεδομένα θα επισημανθούν και μπορεί να υποβάλλονται σε επεξεργασία μόνο από εμάς για συγκεκριμένους σκοπούς.') }}
                </p>
            </li>
            <li>
                <p><b>{{ aiTrans('Δικαίωμα φορητότητας δεδομένων:') }}</b>
                    {{ aiTrans('Έχετε το δικαίωμα να λαμβάνετε τα προσωπικά δεδομένα που σας αφορούν που έχετε παράσχει σε εμάς σε μια δομημένη, κοινώς χρησιμοποιούμενη και αναγνώσιμη από μηχανές μορφή και έχετε το δικαίωμα να μεταφέρετε αυτά τα Προσωπικά Δεδομένα σε μια άλλη οντότητα χωρίς εμπόδια από εμάς.') }}
                </p>
            </li>
            <li>
                <p><b>{{ aiTrans('Δικαίωμα αντίρρησης:') }}</b>
                    {{ aiTrans('Έχετε το δικαίωμα να αντιταχθείτε, για λόγους που σχετίζονται με την ιδιαίτερη κατάστασή σας, ανά πάσα στιγμή στην επεξεργασία των Προσωπικών Δεδομένων σας από εμάς και μπορούμε να απαιτηθεί να μην επεξεργαστούμε τα προσωπικά σας δεδομένα. Εάν έχετε δικαίωμα αντίρρησης και ασκήσετε αυτό το δικαίωμα, τα προσωπικά σας δεδομένα δεν θα υποβάλλονται σε επεξεργασία για τέτοιους σκοπούς από εμάς. Η άσκηση αυτού του δικαιώματος δεν θα επιφέρει κανένα κόστος. Τέτοιο δικαίωμα αντίρρησης μπορεί να μην υπάρχει, ιδίως, εάν η επεξεργασία των προσωπικών σας δεδομένων είναι αναγκαία για να λάβετε μέτρα πριν από την είσοδο σε σύμβαση ή για να εκτελέσετε μια σύμβαση που έχει ήδη συναφθεί.') }}
                </p>
            </li>
            <li>
                <p><b>{{ aiTrans('Δικαίωμα ανάκλησης της συγκατάθεσής σας:') }}</b>
                    {{ aiTrans('Όπου η επεξεργασία των προσωπικών σας δεδομένων βασίζεται στη συγκατάθεσή σας, έχετε το δικαίωμα να ανακαλέσετε τη συγκατάθεσή σας οποιαδήποτε στιγμή. Τέτοιο δικαίωμα ανάκλησης της συγκατάθεσής σας δεν επηρεάζει τη νομιμότητα της επεξεργασίας που βασίζεται στη συγκατάθεση που έχετε προηγουμένως δώσει σε εμάς, πριν από την ανάκληση.') }}
                </p>
            </li>
            <li>
                <p><b>{{ aiTrans('Δικαίωμα στα δεδομένα σας μετά το θάνατό σας:') }}</b>
                    {{ aiTrans('Έχετε το δικαίωμα να δώσετε οδηγίες σχετικές με τη διατήρηση, διαγραφή και επικοινωνία των προσωπικών δεδομένων που σας αφορούν μετά το θάνατό σας.') }}
                </p>
            </li>
        </ol>
        <p>{{ aiTrans('Σημειώστε ότι αυτά τα δικαιώματα μπορεί να είναι περιορισμένα σύμφωνα με την ισχύουσα τοπική νομοθεσία προστασίας δεδομένων.') }}</p>
        <p>{{ aiTrans('Εάν επιθυμείτε να ασκήσετε οποιοδήποτε από αυτά τα δικαιώματα, παρακαλώ επικοινωνήστε μαζί μας όπως αναφέρεται στην ενότητα Επικοινωνία παρακάτω.') }}
        </p>
        <p>{{ aiTrans('Έχετε επίσης το δικαίωμα να υποβάλετε καταγγελία στην αρμόδια αρχή εποπτείας προστασίας δεδομένων της Γαλλίας, η οποία είναι η CNIL.') }}
        </p>
        <h2 class="bold">{{ aiTrans('Επικοινωνήστε μαζί μας') }}</h2>
        <p>{{ aiTrans('Ατόμα που έχουν οποιαδήποτε ερώτηση σχετικά με αυτή την Ειδοποίηση θα πρέπει') }} <a
                href="{{ route('contact', $country) }}">{{ aiTrans('να επικοινωνήσουν μαζί μας') }}</a></p>
        <h2 class="bold">{{ aiTrans('Αλλαγές στην Ειδοποίηση Προστασίας Δεδομένων') }}</h2>
        <p>{{ aiTrans('Αυτή η Ειδοποίηση Προστασίας Δεδομένων υπόκειται σε αλλαγές. Θα σας ειδοποιήσουμε επαρκώς για οποιαδήποτε τέτοια αλλαγή.') }}
        </p>
        <p><b>{{ aiTrans('Τελευταία ενημέρωση: 29.10.2024') }}</b></p>
    </div>
@endsection
