@extends('layouts.app')

@push('meta')
    <title>{{ "$website_title : سياسة الخصوصية" }}</title>
    <meta name="description" content="{{ "$website_title : بكل دقة واحترافية, نحمي خصوصية بياناتك الشخصية. نقدم لك معلومات عالية الجودة تُعرف بالبساطة والنزاهة التامة. $website_name" }}" />
@endpush

@section('content')

    <div class="container page-inner pt-5">
        <h1>{{ aiTrans('سياسة الخصوصية') }}</h1>
        <main>
            <p><span class="b">{{ aiTrans('مزود الخدمة') }}</span> {{ aiTrans('("نحن", "نا", أو "خاصتنا") يدير') }}
                <span class="u">{{$website_title}}</span>
                {{ aiTrans('الموقع الإلكتروني (“الخدمة”).') }}</p>
            <p>{{ aiTrans('توضح هذه الصفحة سياساتنا بشأن جمع واستخدام والإفصاح عن البيانات الشخصية عندما تستخدم خدمتنا والخيارات المتاحة لك فيما يتعلق بتلك البيانات.') }}
            </p>
            <p>{{ aiTrans('توضح هذه الصفحة سياساتنا بشأن جمع واستخدام والإفصاح عن البيانات الشخصية عندما تستخدم خدمتنا والخيارات المتاحة لك فيما يتعلق بتلك البيانات.') }}
            </p>
            <p>{{ aiTrans('نحن,') }} <a href="{{ route('home', $country) }}"> {{ $website_title }}</a>,
                {{ aiTrans('نستخدم بياناتك لتقديم وتحسين الخدمة. باستخدام الخدمة، فإنك توافق على جمع واستخدام المعلومات وفقًا لهذه السياسة. ما لم يُعرف خلاف ذلك في سياسة الخصوصية هذه، فإن المصطلحات المستخدمة في سياسة الخصوصية هذه تحمل نفس المعاني كما هو مذكور في شروطنا وأحكامنا، المتاحة من') }}
                <span class="u">{{$website_title}}</span></p>
            <div id="toc_container" class="no_bullets">
                <ul class="toc_list">
                    <ul>
                        <li>
                            <ul>
                                <li><a href="#Definitions"><span class="toc_number toc_depth_3">0.0.1</span>
                                        {{ aiTrans('التعريفات') }}</a>
                                    <ul>
                                        <li><a href="#Service"><span class="toc_number toc_depth_4">0.0.1.1</span>
                                                {{ aiTrans('الخدمة') }}</a></li>
                                    </ul>
                                </li>
                                <li><a href="#Personal_Data"><span class="toc_number toc_depth_3">0.0.2</span>
                                        {{ aiTrans('البيانات الشخصية') }}</a></li>
                                <li><a href="#Usage_Data"><span class="toc_number toc_depth_3">0.0.3</span>
                                        {{ aiTrans('بيانات الاستخدام') }}</a></li>
                                <li><a href="#Cookies"><span class="toc_number toc_depth_3">0.0.4</span>
                                        {{ aiTrans('ملفات تعريف الارتباط') }}</a></li>
                                <li><a href="#Data_Controller"><span class="toc_number toc_depth_3">0.0.5</span>
                                        {{ aiTrans('مراقب البيانات') }}</a></li>
                                <li><a href="#Data_Processors_or_Service_Providers"><span
                                            class="toc_number toc_depth_3">0.0.6</span>
                                        {{ aiTrans('معالجو البيانات (أو مزودو الخدمة)') }}</a></li>
                                <li><a href="#Data_Subject_or_User"><span class="toc_number toc_depth_3">0.0.7</span>
                                        {{ aiTrans('موضوع البيانات (أو المستخدم)') }}</a></li>
                            </ul>
                        </li>
                    </ul>
                    <li><a href="#Information_Collection_And_Use"><span class="toc_number toc_depth_1">1</span>
                            {{ aiTrans('جمع المعلومات واستخدامها') }}</a>
                        <ul>
                            <li>
                                <ul>
                                    <li><a href="#Types_of_Data_Collected"><span class="toc_number toc_depth_3">1.0.1</span>
                                            {{ aiTrans('أنواع البيانات المجمعة') }}</a></li>
                                    <li><a href="#Personal_Data-2"><span class="toc_number toc_depth_3">1.0.2</span>
                                            {{ aiTrans('البيانات الشخصية') }}</a></li>
                                    <li><a href="#Usage_Data-2"><span class="toc_number toc_depth_3">1.0.3</span>
                                            {{ aiTrans('بيانات الاستخدام') }}</a></li>
                                    <li><a href="#Tracking_Cookies_Data"><span class="toc_number toc_depth_3">1.0.4</span>
                                            {{ aiTrans('بيانات ملفات تعريف الارتباط للتتبع') }}</a></li>
                                    <li><a href="#Use_of_Data"><span class="toc_number toc_depth_3">1.0.5</span>
                                            {{ aiTrans('استخدام البيانات') }}</a></li>
                                    <li><a
                                            href="#Legal_Basis_for_Processing_Personal_Data_Under_General_Data_Protection_Regulation_GDPR"><span
                                                class="toc_number toc_depth_3">1.0.6</span>
                                            {{ aiTrans('الأساس القانوني لمعالجة البيانات الشخصية بموجب اللائحة العامة لحماية البيانات (GDPR)') }}</a>
                                    </li>
                                    <li><a href="#Retention_of_Data"><span class="toc_number toc_depth_3">1.0.7</span>
                                            {{ aiTrans('الاحتفاظ بالبيانات') }}</a></li>
                                </ul>
                            </li>
                        </ul>
                    </li>

                    
                                        <li><a href="#Transfer_Of_Data"><span class="toc_number toc_depth_1">2</span>
                            {{ aiTrans('نقل البيانات') }}</a>
                        <ul>
                            <li>
                                <ul>
                                    <li><a href="#Disclosure_Of_Data"><span class="toc_number toc_depth_3">2.0.1</span>
                                            {{ aiTrans('الإفصاح عن البيانات') }}
                                            <ul>
                                                <li><a href="#Business_Transaction"><span
                                                            class="toc_number toc_depth_4">2.0.1.1</span>
                                                        {{ aiTrans('صفقة تجارية') }}</a></li>
                                            </ul>
                                    </li>
                                    <li><a href="#Legal_Requirements"><span class="toc_number toc_depth_3">2.0.2</span>
                                            {{ aiTrans('المتطلبات القانونية') }}</a></li>
                                    <li><a href="#Security_Of_Data"><span class="toc_number toc_depth_3">2.0.3</span>
                                            {{ aiTrans('أمان البيانات') }}</a></li>
                                    <li><a
                                            href="#Your_Data_Protection_Rights_Under_General_Data_Protection_Regulation_GDPR"><span
                                                class="toc_number toc_depth_3">2.0.4</span>
                                            {{ aiTrans('حقوق حماية بياناتك بموجب اللائحة العامة لحماية البيانات (GDPR)') }}</a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="#Service_Providers"><span class="toc_number toc_depth_1">3</span>
                            {{ aiTrans('مزودو الخدمة') }}</a>
                        <ul>
                            <li>
                                <ul>
                                    <li><a href="#Analytics"><span class="toc_number toc_depth_3">3.0.1</span>
                                            {{ aiTrans('التحليلات') }}</a></li>
                                    <li><a href="#Advertising"><span class="toc_number toc_depth_3">3.0.2</span>
                                            {{ aiTrans('الإعلانات') }}</a></li>
                                    <li><a href="#Behavioral_Remarketing"><span class="toc_number toc_depth_3">3.0.3</span>
                                            {{ aiTrans('إعادة التسويق السلوكي') }}</a></li>
                                    <li><a href="#Links_To_Other_Sites"><span class="toc_number toc_depth_3">3.0.4</span>
                                            {{ aiTrans('روابط لمواقع أخرى') }}</a></li>
                                    <li><a href="#Children8217s_Privacy"><span class="toc_number toc_depth_3">3.0.5</span>
                                            {{ aiTrans('خصوصية الأطفال') }}</a></li>
                                    <li><a href="#Changes_To_This_Privacy_Policy"><span
                                                class="toc_number toc_depth_3">3.0.6</span>
                                            {{ aiTrans('التغييرات على سياسة الخصوصية هذه') }}</a></li>
                                    <li><a href="#Contact_Us"><span class="toc_number toc_depth_3">3.0.7</span>
                                            {{ aiTrans('اتصل بنا') }}</a></li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
            <h4><span id="Definitions">{{ aiTrans('التعريفات') }}</span></h4>
            <h5><span id="Service">{{ aiTrans('الخدمة') }}</span></h5>
            <p>{{ aiTrans('الخدمة هي') }} <span class="u">{{$website_title}}</span>
                {{ aiTrans('الموقع الذي تديره') }} <span class="b">{{ aiTrans('مزود الخدمة') }}</span></p>
            <h4><span id="Personal_Data">{{ aiTrans('البيانات الشخصية') }}</span></h4>
            <p>{{ aiTrans('البيانات الشخصية تعني البيانات عن فرد حي يمكن التعرف عليه من تلك البيانات (أو من تلك وغيرها من المعلومات سواء في حوزتنا أو من المحتمل أن تدخل في حوزتنا).') }}
            </p>
            <h4><span id="Usage_Data">{{ aiTrans('بيانات الاستخدام') }}</span></h4>
            <p>{{ aiTrans('بيانات الاستخدام هي بيانات تُجمع تلقائيًا إما نتيجة استخدام الخدمة أو من بنية الخدمة نفسها (على سبيل المثال، مدة زيارة صفحة).') }}
            </p>
            <h4><span id="Cookies">{{ aiTrans('ملفات تعريف الارتباط') }}</span></h4>
            <p>{{ aiTrans('ملفات تعريف الارتباط هي قطع صغيرة من البيانات مخزنة على جهازك (الكمبيوتر أو الجهاز المحمول).') }}</p>
            <h4><span id="Data_Controller">{{ aiTrans('مراقب البيانات') }}</span></h4>
            <p>{{ aiTrans('مراقب البيانات يعني الشخص الطبيعي أو الاعتباري الذي (سواء بمفرده أو بالاشتراك أو مع أشخاص آخرين) يحدد الأغراض التي من أجلها وطريقة معالجة أي معلومات شخصية، أو ستتم معالجتها. لأغراض سياسة الخصوصية هذه، نحن مراقب بياناتك الشخصية.') }}
            </p>
            <h4><span
                    id="Data_Processors_or_Service_Providers">{{ aiTrans('معالجو البيانات (أو مزودو الخدمة)') }}</span>
            </h4>



            <p>{{ aiTrans('معالج البيانات (أو مزود الخدمة) يعني أي شخص طبيعي أو اعتباري يقوم بمعالجة البيانات نيابة عن مراقب البيانات. قد نستخدم خدمات مزودي خدمة مختلفين من أجل معالجة بياناتك بشكل أكثر فعالية.') }}
            </p>
            <h4><span id="Data_Subject_or_User">{{ aiTrans('موضوع البيانات (أو المستخدم)') }}</span></h4>
            <p>{{ aiTrans('موضوع البيانات هو أي فرد حي يستخدم خدمتنا ويكون موضوع البيانات الشخصية.') }}
            </p>
            <h2><span id="Information_Collection_And_Use">{{ aiTrans('جمع المعلومات واستخدامها') }}</span></h2>
            <p>{{ aiTrans('نجمع عدة أنواع مختلفة من المعلومات لأغراض متنوعة لتقديم وتحسين خدمتنا لك.') }}
            </p>
            <h4><span id="Types_of_Data_Collected">{{ aiTrans('أنواع البيانات المجمعة') }}</span></h4>
            <h4><span id="Personal_Data-2">{{ aiTrans('البيانات الشخصية') }}</span></h4>
            <p>{{ aiTrans('أثناء استخدام خدمتنا، قد نطلب منك تزويدنا بمعلومات شخصية يمكن استخدامها للتواصل معك أو التعرف عليك (“البيانات الشخصية”). قد تشمل المعلومات الشخصية، على سبيل المثال لا الحصر:') }}
            </p>
            <ul>
                <li>{{ aiTrans('عنوان البريد الإلكتروني') }}</li>
                <li>{{ aiTrans('الاسم الأول واسم العائلة') }}</li>
                <li>{{ aiTrans('رقم الهاتف') }}</li>
                <li>{{ aiTrans('العنوان، الولاية، المقاطعة، الرمز البريدي، المدينة') }}</li>
                <li>{{ aiTrans('ملفات تعريف الارتباط وبيانات الاستخدام') }}</li>
            </ul>
            <p>{{ aiTrans('قد نستخدم بياناتك الشخصية للتواصل معك من خلال النشرات الإخبارية، والمواد التسويقية أو الترويجية وغيرها من المعلومات التي قد تهمك. يمكنك إلغاء الاشتراك في تلقي أي، أو جميع، هذه الاتصالات منا عن طريق اتباع رابط إلغاء الاشتراك أو التعليمات المقدمة في أي بريد إلكتروني نرسله أو عن طريق الاتصال بنا.') }}
            </p>
            <h4><span id="Usage_Data-2">{{ aiTrans('بيانات الاستخدام') }}</span></h4>
            <p>{{ aiTrans('قد نقوم أيضًا بجمع معلومات حول كيفية الوصول إلى الخدمة واستخدامها (“بيانات الاستخدام”). قد تشمل بيانات الاستخدام معلومات مثل عنوان بروتوكول الإنترنت لجهاز الكمبيوتر الخاص بك (على سبيل المثال، عنوان IP)، نوع المتصفح، إصدار المتصفح، الصفحات التي تزورها في خدمتنا، تاريخ ووقت زيارتك، الوقت الذي قضيته على تلك الصفحات، معرفات الأجهزة الفريدة وبيانات تشخيصية أخرى.') }}
            </p>
            <h4><span id="Tracking_Cookies_Data">{{ aiTrans('بيانات ملفات تعريف الارتباط للتتبع') }}</span></h4>
            <p>{{ aiTrans('نستخدم ملفات تعريف الارتباط والتقنيات المشابهة لتتبع النشاط على خدمتنا والاحتفاظ بمعلومات معينة.') }}
            </p>
            <p>{{ aiTrans('ملفات تعريف الارتباط هي ملفات تحتوي على كمية صغيرة من البيانات التي قد تشمل معرفًا فريدًا غير معروف. تُرسل ملفات تعريف الارتباط إلى متصفحك من موقع ويب ويتم تخزينها على جهازك. تستخدم التقنيات المتعقبة الأخرى مثل العلامات، والتاجات، والبرمجيات لجمع وتسجيل المعلومات ولتحسين وتحليل خدمتنا.') }}
            </p>
            <p>{{ aiTrans('يمكنك توجيه متصفحك لرفض جميع ملفات تعريف الارتباط أو للإشارة عندما يتم إرسال ملف تعريف الارتباط. ومع ذلك، إذا كنت لا تقبل ملفات تعريف الارتباط، فقد لا تتمكن من استخدام بعض أجزاء خدمتنا.') }}
            </p>
            <p>{{ aiTrans('أمثلة على ملفات تعريف الارتباط التي نستخدمها:') }}</p>
            <ul>
                <li><strong>{{ aiTrans('ملفات تعريف الارتباط الجلسة.') }}</strong>
                    {{ aiTrans('نستخدم ملفات تعريف الارتباط الجلسة لتشغيل خدمتنا.') }}</li>
                <li><strong>{{ aiTrans('ملفات تعريف الارتباط التفضيلية.') }}</strong>
                    {{ aiTrans('نستخدم ملفات تعريف الارتباط التفضيلية لتذكر تفضيلاتك والإعدادات المختلفة.') }}</li>
                <li><strong>{{ aiTrans('ملفات تعريف الارتباط الأمنية.') }}</strong>
                    {{ aiTrans('نستخدم ملفات تعريف الارتباط الأمنية لأغراض الأمان.') }}</li>
                <li><strong>{{ aiTrans('ملفات تعريف الارتباط الإعلانية.') }}</strong>
                    {{ aiTrans('تستخدم ملفات تعريف الارتباط الإعلانية لتقديم الإعلانات التي قد تكون ذات صلة بك واهتماماتك.') }}
                </li>
            </ul>
            <h4><span id="Use_of_Data">{{ aiTrans('استخدام البيانات') }}</span></h4>

            <p><span class="b">{{ aiTrans('مزود الخدمة') }}</span>
                {{ aiTrans('يستخدم البيانات المجمعة لأغراض متنوعة:') }}</p>
            <ul>
                <li>{{ aiTrans('لتقديم وصيانة خدمتنا') }}</li>
                <li>{{ aiTrans('لإبلاغك بالتغييرات في خدمتنا') }}</li>
                <li>{{ aiTrans('للسماح لك بالمشاركة في الميزات التفاعلية لخدمتنا عند اختيارك القيام بذلك') }}</li>
                <li>{{ aiTrans('لتقديم الدعم الفني') }}</li>
                <li>{{ aiTrans('لجمع التحليلات أو المعلومات القيمة حتى نتمكن من تحسين خدمتنا') }}</li>
                <li>{{ aiTrans('لمراقبة استخدام خدمتنا') }}</li>
                <li>{{ aiTrans('لكشف ومنع ومعالجة المشكلات التقنية') }}</li>
                <li>{{ aiTrans('لتزويدك بالأخبار، والعروض الخاصة، والمعلومات العامة حول سلع، وخدمات، وفعاليات أخرى نقدمها والتي قد تكون مشابهة لتلك التي اشتريتها أو استفسرت عنها بالفعل ما لم تكن قد اخترت عدم تلقي هذه المعلومات') }}</li>
            </ul>
            <h4><span
                    id="Legal_Basis_for_Processing_Personal_Data_Under_General_Data_Protection_Regulation_GDPR">{{ aiTrans('الأساس القانوني لمعالجة البيانات الشخصية بموجب اللائحة العامة لحماية البيانات (GDPR)') }}</span>
            </h4>
            <p>{{ aiTrans('إذا كنت من المنطقة الاقتصادية الأوروبية (EEA)،') }} <span
                    class="b">{{ aiTrans('مزود الخدمة') }}</span>
                {{ aiTrans('الأساس القانوني لجمع واستخدام المعلومات الشخصية الموضحة في سياسة الخصوصية هذه يعتمد على البيانات الشخصية التي نجمعها والسياق المحدد الذي نجمعها فيه.') }}
            </p>
            <p><span class="b">{{ aiTrans('مزود الخدمة') }}</span>
                {{ aiTrans('قد يقوم بمعالجة بياناتك الشخصية لأن:') }}</p>
            <ul>
                <li>{{ aiTrans('نحتاج إلى تنفيذ عقد معك') }}</li>
                <li>{{ aiTrans('لقد منحتنا إذنًا للقيام بذلك') }}</li>
                <li>{{ aiTrans('المعالجة تتماشى مع مصالحنا المشروعة وليس لها تأثير سلبي على حقوقك') }}</li>
                <li>{{ aiTrans('للامتثال للقانون') }}</li>
            </ul>
            <h4><span id="Retention_of_Data">{{ aiTrans('الاحتفاظ بالبيانات') }}</span></h4>
            <p><span class="b">{{ aiTrans('مزود الخدمة') }}</span>
                {{ aiTrans('سوف يحتفظ ببياناتك الشخصية فقط طالما كان ذلك ضروريًا للأغراض المنصوص عليها في سياسة الخصوصية هذه. سنحتفظ ونستخدم بياناتك الشخصية بالقدر اللازم للامتثال لالتزاماتنا القانونية (على سبيل المثال، إذا كنا مطالبين بالاحتفاظ ببياناتك للامتثال للقوانين السارية)، وحل النزاعات، وإنفاذ اتفاقياتنا القانونية وسياساتنا.') }}
            </p>
            <p><span class="b">{{ aiTrans('مزود الخدمة') }}</span>
                {{ aiTrans('سيحتفظ أيضًا ببيانات الاستخدام لأغراض التحليل الداخلي. يتم الاحتفاظ ببيانات الاستخدام بشكل عام لفترة زمنية أقصر، باستثناء عندما تُستخدم هذه البيانات لتعزيز الأمان أو لتحسين وظائف خدمتنا، أو نحن ملزمون قانونًا بالاحتفاظ بهذه البيانات لفترات زمنية أطول.') }}
            </p>
            <h2><span id="Transfer_Of_Data">{{ aiTrans('نقل البيانات') }}</span></h2>
            <p>{{ aiTrans('قد يتم نقل معلوماتك، بما في ذلك البيانات الشخصية، إلى — والمحافظة عليها على — أجهزة كمبيوتر تقع خارج ولايتك أو مقاطعتك أو بلدك أو أي اختصاص حكومي آخر حيث قد تختلف قوانين حماية البيانات عن تلك التي تخضع لها.') }}
            </p>
            <p>{{ aiTrans('إذا كنت موجودًا خارج بلغاريا واخترت تزويدنا بمعلومات، يرجى ملاحظة أننا ننقل البيانات، بما في ذلك البيانات الشخصية، إلى بلغاريا ونعالجها هناك.') }}
            </p>
            <p>{{ aiTrans('إن موافقتك على سياسة الخصوصية هذه تليها تقديمك لمثل هذه المعلومات تمثل اتفاقك على هذا النقل.') }}
            </p>
            <p><span class="b">{{ aiTrans('مزود الخدمة') }}</span>
                {{ aiTrans('سيتخذ جميع الخطوات المعقولة لضمان معالجة بياناتك بشكل آمن ووفقًا لهذه السياسة، ولن يتم نقل بياناتك الشخصية إلى منظمة أو دولة ما لم تكن هناك ضوابط كافية في المكان بما في ذلك أمان بياناتك والمعلومات الشخصية الأخرى.') }}
            </p>
            <h4><span id="Disclosure_Of_Data">{{ aiTrans('الإفصاح عن البيانات') }}</span></h4>
            <h5><span id="Business_Transaction">{{ aiTrans('صفقة تجارية') }}</span></h5>
            <p>{{ aiTrans('إذا كان') }} <span class="b">{{ aiTrans('مزود الخدمة') }}</span>
                {{ aiTrans('مشاركًا في اندماج أو استحواذ أو بيع أصول، قد يتم نقل بياناتك الشخصية. سنقوم بإخطارك قبل نقل بياناتك الشخصية لتصبح خاضعة لسياسة خصوصية مختلفة.') }}
            </p>
            <h4><span id="Legal_Requirements">{{ aiTrans('المتطلبات القانونية') }}</span></h4>

            <p><span class="b">{{ aiTrans('مزود الخدمة') }}</span>
                {{ aiTrans('قد يكشف عن بياناتك الشخصية بناءً على اعتقاد حسن النية بأن هذا الإجراء ضروري لـ:') }}
            </p>
            <ul>
                <li>{{ aiTrans('للامتثال لالتزام قانوني') }}</li>
                <li>{{ aiTrans('لحماية والدفاع عن حقوق أو ممتلكات') }} <span
                        class="b">{{ aiTrans('مزود الخدمة') }}</span></li>
                <li>{{ aiTrans('لمنع أو التحقيق في أي سوء سلوك محتمل يتعلق بالخدمة') }}</li>
                <li>{{ aiTrans('لحماية السلامة الشخصية لمستخدمي الخدمة أو الجمهور') }}</li>
                <li>{{ aiTrans('لحماية ضد المسؤولية القانونية') }}</li>
            </ul>
            <h4><span id="Security_Of_Data">{{ aiTrans('أمان البيانات') }}</span></h4>
            <p>{{ aiTrans('أمان بياناتك مهم بالنسبة لنا، لكن تذكر أنه لا توجد طريقة نقل عبر الإنترنت، أو طريقة تخزين إلكتروني آمنة بنسبة 100%. بينما نسعى جاهدين لاستخدام وسائل مقبولة تجاريًا لحماية بياناتك الشخصية، لا يمكننا ضمان أمانها المطلق.') }}
            </p>
            <h4><span
                    id="Your_Data_Protection_Rights_Under_General_Data_Protection_Regulation_GDPR">{{ aiTrans('حقوق حماية بياناتك بموجب اللائحة العامة لحماية البيانات (GDPR)') }}</span>
            </h4>
            <p>{{ aiTrans('إذا كنت مقيمًا في المنطقة الاقتصادية الأوروبية (EEA)، لديك حقوق معينة لحماية البيانات.') }}
                <span class="b">{{ aiTrans('مزود الخدمة') }}</span>
                {{ aiTrans('يهدف إلى اتخاذ خطوات معقولة للسماح لك بتصحيح أو تعديل أو حذف أو تقييد استخدام بياناتك الشخصية.') }}
            </p>
            <p>{{ aiTrans('إذا كنت ترغب في معرفة البيانات الشخصية التي نحتفظ بها عنك وإذا كنت تريد إزالتها من أنظمتنا، يرجى الاتصال بنا.') }}
            </p>
            <p>{{ aiTrans('في ظل ظروف معينة، لديك حقوق حماية البيانات التالية:') }}</p>
            <p><strong>{{ aiTrans('الحق في الوصول، وتحديث، أو حذف المعلومات التي لدينا عنك.') }}</strong>
                {{ aiTrans('كلما كان ذلك ممكنًا، يمكنك الوصول إلى بياناتك الشخصية، وتحديثها، أو طلب حذفها مباشرةً من قسم إعدادات حسابك. إذا كنت غير قادر على تنفيذ هذه الإجراءات بنفسك، يرجى الاتصال بنا لنساعدك.') }}<br>
                <strong>{{ aiTrans('حق التصحيح.') }}</strong>
                {{ aiTrans('لديك الحق في تصحيح معلوماتك إذا كانت هذه المعلومات غير دقيقة أو غير مكتملة.') }}<br>
                <strong>{{ aiTrans('حق الاعتراض.') }}</strong>
                {{ aiTrans('لديك الحق في الاعتراض على معالجتنا لبياناتك الشخصية.') }}<br>
                <strong>{{ aiTrans('حق التقييد.') }}</strong>
                {{ aiTrans('لديك الحق في طلب تقييد معالجة معلوماتك الشخصية.') }}<br>
                <strong>{{ aiTrans('حق نقل البيانات.') }}</strong>
                {{ aiTrans('لديك الحق في الحصول على نسخة من المعلومات التي لدينا عنك بتنسيق منظم، يمكن قراءته آليًا، وشائع الاستخدام.') }}<br>
                <strong>{{ aiTrans('حق سحب الموافقة.') }}</strong>
                {{ aiTrans('لديك أيضًا الحق في سحب موافقتك في أي وقت حيث اعتمدت') }} <span
                    class="b">{{ aiTrans('مزود الخدمة') }}</span>
                {{ aiTrans('على موافقتك لمعالجة معلوماتك الشخصية.') }}</p>
            <p>{{ aiTrans('يرجى ملاحظة أنه قد نطلب منك التحقق من هويتك قبل الرد على مثل هذه الطلبات.') }}
            </p>
            <p>{{ aiTrans('لديك الحق في تقديم شكوى إلى هيئة حماية البيانات بشأن جمعنا واستخدامنا لبياناتك الشخصية. لمزيد من المعلومات، يرجى الاتصال بسلطة حماية البيانات المحلية الخاصة بك في المنطقة الاقتصادية الأوروبية (EEA).') }}
            </p>
            <h2><span id="Service_Providers">{{ aiTrans('مزودو الخدمة') }}</span></h2>
            <p>{{ aiTrans('قد نستخدم شركات وأفراد من الطرف الثالث لتسهيل خدمتنا (“مزودو الخدمة”)، لتقديم الخدمة باسمنا، لأداء خدمات تتعلق بالخدمة أو لمساعدتنا في تحليل كيفية استخدام خدمتنا.') }}
            </p>
            <p>{{ aiTrans('لدى هؤلاء الأطراف الثالثة الوصول إلى بياناتك الشخصية فقط لأداء هذه المهام نيابة عنا، وهم ملزمون بعدم الكشف عنها أو استخدامها لأي غرض آخر.') }}
            </p>
            <h4><span id="Analytics">{{ aiTrans('التحليلات') }}</span></h4>
            <p>{{ aiTrans('قد نستخدم مزودي خدمة الطرف الثالث لمراقبة وتحليل استخدام خدمتنا.') }}
            </p>
            <p><strong>{{ aiTrans('تحليلات جوجل') }}</strong><br>
                {{ aiTrans('تحليلات جوجل هي خدمة تحليلات ويب تقدمها جوجل تتعقب وتقارير حركة مرور الموقع. تستخدم جوجل البيانات المجمعة لتتبع ومراقبة استخدام خدمتنا. يتم مشاركة هذه البيانات مع خدمات جوجل الأخرى. قد تستخدم جوجل البيانات المجمعة لتوفير السياق والشخصنة للإعلانات في شبكتها الإعلانية الخاصة. يمكنك إلغاء الاشتراك في جعل نشاطك على الخدمة متاحًا لتحليلات جوجل عن طريق تثبيت ملحق المتصفح الخاص بإلغاء الاشتراك في تحليلات جوجل. يمنع الملحق JavaScript الخاص بتحليلات جوجل (ga.js وanalytics.js وdc.js) من مشاركة المعلومات مع تحليلات جوجل حول نشاط الزيارات. لمزيد من المعلومات حول ممارسات الخصوصية لجوجل، يرجى زيارة صفحة شروط الخصوصية لجوجل:') }}
                http://www.google.com/intl/en/policies/privacy/</p>
            <h4><span id="Advertising">{{ aiTrans('الإعلانات') }}</span></h4>
            <p>{{ aiTrans('قد نستخدم مزودي خدمة من الطرف الثالث لعرض الإعلانات عليك للمساعدة في دعم وصيانة خدمتنا.') }}
            </p>
            <p><strong>{{ aiTrans('ملف تعريف الارتباط من Google AdSense DoubleClick') }}</strong><br>
                {{ aiTrans('تستخدم جوجل، كبائع طرف ثالث، ملفات تعريف الارتباط لخدمة الإعلانات على خدمتنا. يمكّن استخدام ملف تعريف الارتباط DoubleClick جوجل وشركائها من عرض الإعلانات لمستخدمينا بناءً على زياراتهم لخدمتنا أو لمواقع ويب أخرى على الإنترنت. يمكنك إلغاء الاشتراك في استخدام ملف تعريف الارتباط DoubleClick للإعلانات الموجهة من خلال زيارة صفحة إعدادات إعلانات جوجل:') }}
                http://www.google.com/ads/preferences
            <h4><span id="Behavioral_Remarketing">{{ aiTrans('إعادة التسويق السلوكي') }}</span></h4>
            <p><span class="b">{{ aiTrans('مزود الخدمة') }}</span>
                {{ aiTrans('يستخدم خدمات إعادة التسويق للإعلان على مواقع الويب التابعة لأطراف ثالثة لك بعد زيارتك لخدمتنا. نحن ومزودو الخدمة لدينا نستخدم ملفات تعريف الارتباط لإبلاغ وتحسين وتقديم الإعلانات بناءً على زياراتك السابقة لخدمتنا.') }}
            </p>
            <p><strong>{{ aiTrans('Google AdWords') }}</strong><br>
                {{ aiTrans('خدمة إعادة التسويق من Google AdWords مقدمة من Google Inc. يمكنك إلغاء الاشتراك في تحليلات جوجل للإعلانات المعروضة وتخصيص إعلانات شبكة جوجل من خلال زيارة صفحة إعدادات إعلانات جوجل:') }}
                <a href="http://www.google.com/settings/ads" target="_blank"
                    rel="noopener">{{ aiTrans('http://www.google.com/settings/ads') }}</a>
                {{ aiTrans('كما توصي جوجل بتثبيت ملحق المتصفح الخاص بإلغاء الاشتراك في تحليلات جوجل –') }} <a
                    href="https://tools.google.com/dlpage/gaoptout" target="_blank"
                    rel="noopener">https://tools.google.com/dlpage/gaoptout</a> –
                {{ aiTrans('لمتصفح الويب الخاص بك. يوفر ملحق إلغاء الاشتراك في تحليلات جوجل للزوار إمكانية منع جمع بياناتهم واستخدامها بواسطة تحليلات جوجل. لمزيد من المعلومات حول ممارسات الخصوصية لجوجل، يرجى زيارة صفحة شروط الخصوصية لجوجل:') }}
                <a href="https://www.google.com/intl/en/policies/privacy/" target="_blank"
                    rel="noopener">http://www.google.com/intl/en/policies/privacy</a></p>
            <p><strong>{{ aiTrans('فيسبوك') }}</strong><br>
                {{ aiTrans('خدمة إعادة التسويق من فيسبوك مقدمة من Facebook Inc. يمكنك معرفة المزيد عن الإعلانات المستندة إلى الاهتمام من فيسبوك من خلال زيارة هذه الصفحة:') }}
                <a href="{{ route('home', $country) }}" target="_blank"
                    rel="noopener">{{ route('home', $country) }}</a>
           لإلغاء الاشتراك من الإعلانات المستندة إلى الاهتمام من فيسبوك، اتبع هذه التعليمات من فيسبوك:
                    https://www.facebook.com/help/568137493302217
                {{ aiTrans('يلتزم فيسبوك بالمبادئ التنظيمية الذاتية للإعلانات السلوكية عبر الإنترنت التي وضعتها تحالف الإعلانات الرقمية. يمكنك أيضًا إلغاء الاشتراك من فيسبوك ومن الشركات المشاركة الأخرى من خلال التحالف الرقمي للإعلانات في الولايات المتحدة') }}
               التحالف الرقمي للإعلانات في كندا 
                أو التحالف الأوروبي للإعلانات الرقمية في أوروبا
                أو إلغاء الاشتراك باستخدام إعدادات جهازك المحمول. لمزيد من المعلومات حول ممارسات الخصوصية لفيسبوك، يرجى زيارة سياسة بيانات فيسبوك
            <h4><span id="Links_To_Other_Sites">{{ aiTrans('روابط لمواقع أخرى') }}</span></h4>
            <p>{{ aiTrans('قد تحتوي خدمتنا على روابط لمواقع أخرى لا نقوم بتشغيلها. إذا قمت بالنقر على رابط طرف ثالث، سيتم توجيهك إلى موقع ذلك الطرف الثالث. ننصحك بشدة بمراجعة سياسة الخصوصية لكل موقع تزوره.') }}
            </p>
            <p>{{ aiTrans('ليس لدينا سيطرة على، ولا نفترض أي مسؤولية عن محتوى أو سياسات الخصوصية أو ممارسات أي مواقع أو خدمات طرف ثالث.') }}
            </p>
            <h4><span id="Children8217s_Privacy">{{ aiTrans('خصوصية الأطفال') }}</span></h4>
            <p>{{ aiTrans('خدمتنا لا تتوجه إلى أي شخص تحت سن 18 (“الأطفال”).') }}</p>
            <p>{{ aiTrans('لا نجمع معلومات شخصية قابلة للتحديد عن قصد من أي شخص تحت سن 18. إذا كنت أحد الوالدين أو الوصي وتعلم أن طفلك قد زودنا ببيانات شخصية، يرجى الاتصال بنا. إذا أصبحنا على علم بأننا جمعنا بيانات شخصية من الأطفال دون التحقق من موافقة الوالدين، نتخذ خطوات لإزالة تلك المعلومات من خوادمنا.') }}
            </p>
            <h4><span id="Changes_To_This_Privacy_Policy">{{ aiTrans('التغييرات على سياسة الخصوصية هذه') }}</span></h4>
            <p>{{ aiTrans('قد نقوم بتحديث سياسة الخصوصية الخاصة بنا من وقت لآخر. سنخطرك بأي تغييرات من خلال نشر سياسة الخصوصية الجديدة على هذه الصفحة.') }}
            </p>
            <p>{{ aiTrans('سنقوم بإخطارك عبر البريد الإلكتروني و/أو إشعار بارز على خدمتنا، قبل أن تصبح التغييرات سارية، وسنقوم بتحديث "تاريخ السريان" في أعلى سياسة الخصوصية هذه.') }}
            </p>
            <p>{{ aiTrans('يُنصح بمراجعة سياسة الخصوصية هذه بشكل دوري لأي تغييرات. تعتبر التغييرات في سياسة الخصوصية هذه سارية عندما يتم نشرها على هذه الصفحة.') }}
            </p>
            <h4><span id="Contact_Us">{{ aiTrans('اتصل بنا') }}</span></h4>
            <p>{{ aiTrans('إذا كانت لديك أي أسئلة حول سياسة الخصوصية هذه، يرجى الاتصال بنا  .') }}</p>
        </main>
    </div>

@endsection
