@extends('layouts.app')

@push('meta')
    <title>{{ "$website_title - Un Aperçu De La Plateforme" }}</title>
    <meta name="description" content="{{ "$website_name - Optimisez votre crypto-trading avec l'expertise et les fonctionnalités exclusives fournies par $website_title." }}" />
@endpush

@section('content')
<section class="about-bg">
    <div class="container">
        <h1 class="about-header text-center white">{{ aiTrans('A propos de la [website_title]', $locale, ['website_title' => $website_title]) }}</h1>
    </div>
</section>
<section class="about-half-1">
    <div class="container">
        <div class="row">
            <div class="col-md-9">
                <p><b>{{ aiTrans('[website_title] a été fondée par un groupe dévoué et passionné d\'experts en crypto-monnaies qui ont mis à profit leur expérience, leur expertise et leurs connaissances pour développer une plateforme intuitive, évolutive et sécurisée.', $locale, ['website_title' => $website_title]) }}</b></p>
                <p>{{ aiTrans('L\'équipe de [website_title] se consacre et s\'engage à respecter ses valeurs d\'honnêteté et d\'excellence en fournissant à tous les utilisateurs et traders une expérience de trading sûre, transparente, axée sur l\'utilisateur et innovante.', $locale, ['website_title' => $website_title]) }}</p>
                <p>{{ aiTrans('La plateforme de trading crée une blockchain et une économie cryptographique plus sûres et promeut l\'inclusion financière en étant au centre de l\'analyse, du trading et de la conformité des crypto-monnaies.') }}</p>
            </div>
        </div>
    </div>
</section>

<section class="about-half-2">
    <div class="container">
        <div class="row">
            <div class="col-md-8 offset-md-4">
                <h2 class="title">{{ aiTrans('Équipe') }}</h2>
                <p><b>{{ aiTrans('La plateforme d\'analyse et de trading crypto est fière d\'avoir réuni une équipe talentueuse, passionnée et expérimentée de professionnels et d\'experts issus de divers horizons, tels que la fintech, la cybersécurité et la finance.') }}</b></p>
                <p>{{ aiTrans('L\'équipe de [website_title] est composée de traders, de développeurs, d\'ingénieurs, d\'analystes et de spécialistes des services qui se consacrent tous à offrir la meilleure expérience possible à tous les utilisateurs. [website_title] continue de répondre aux besoins et aux préférences changeants et uniques des traders.', $locale, ['website_title' => $website_title]) }}</p>
            </div>
        </div>
    </div>
</section>

<section class="padding-60 pb-3">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-9">
                <h2 class="title">{{ aiTrans('Vision') }}</h2>
                <p><b>{{ aiTrans('La vision de l\'équipe est de faire de [website_title] une plateforme de gestion et de négociation d\'actifs et de crypto-monnaies en ligne de premier plan en fournissant des outils de négociation autogérés et automatisés et des fonctionnalités innovantes.', $locale, ['website_title' => $website_title]) }}</b></p>
            </div>
            <div class="col-md-3 text-center">
                <picture>
                    <source type="image/webp" srcset="{{ asset('frontend/assets/fr/assets') }}/about-img-1.webp">
                    <source type="image/png" srcset="{{ asset('frontend/assets/fr/assets') }}/about-img-1.jpg">
                    <img src="{{ asset('frontend/assets/fr/assets') }}/about-img-1.jpg" width="287" height="285" alt="{{ $website_title }}">
                </picture>
            </div>
        </div>
    </div>
</section>

<section class="padding-60">
    <div class="container text-center mb-md-5" style="max-width: 1200px;">
        <h2 class="title">{{aiTrans("Valeurs de l'équipe")}}</h2>
        <p><b>{{aiTrans("L'équipe de la plateforme de trading estime que les traders expérimentés et avisés ainsi que les débutants curieux ont le droit de prendre part à la révolution crypto selon leurs propres termes. ")}}</b></p>
        <p>{{aiTrans('C\'est pourquoi l\'équipe travaille dur pour développer des produits, des solutions et des outils de trading accessibles et sécurisés, simples à utiliser.')}}</p>
    </div>
    <div class="container">
        <div class="row">
            <div class="col-md-6">
                <div class="box-blue">
                    <h3 class="sub-title">{{aiTrans("La sécurité avant tout")}}</h3>
                    <hr class="hr-blue">
                    <p><b>{{aiTrans("L'équipe de la plateforme donne la priorité à la sécurité, en utilisant des méthodes de cryptage modernes pour garantir le plus haut niveau de sécurité.")}}</b></p>
                </div>
            </div>
            <div class="col-md-6">
                <div class="box-blue">
                    <h3 class="sub-title">{{aiTrans("Expérience utilisateur inégalée")}}</h3>
                    <hr class="hr-blue">
                    <p><b>{{aiTrans("La plateforme de trading accorde une grande importance à l'expérience de l'utilisateur et donne la priorité à la création d'une interface fluide et intuitive qui est simple à naviguer et à utiliser.")}}</b></p>
                </div>
            </div>
        </div>
        <div class="text-center mt-3 mt-md-5">
            <a href="{{ route('home', $country) }}" class="main-form-btn" style="max-width: 320px;">{{aiTrans('EN SAVOIR PLUS')}}</a>
        </div>
    </div>
</section>
@endsection
