@extends('layouts.app')
@push('meta')
    <title>{{ "$website_title ™ | الموقع الرسمي والمحدث 2025 🥇" }}</title>
    <meta name="description" content="{{ "افتح عالم تداول العملات المشفرة باستخدام $website_title منصة موثوقة للتعرف على تداول العملات المشفرة ، تتجه عالميا." }}" />
@endpush

@section('content')
    <section class="banner py-5">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <h1 class="display-4 fw-bold mb-4">{{ $website_title }}</h1>
                    <div class="fs-4 mb-5">
                        <h2><strong class="change-by-command">{{ "$website_title استكشاف الطرق المميزة لزيادة الربح في عالم الكريبتو: تطور مهاراتك في الاستراتيجيات والأنظمة المفضلة للمحترفين!" }}</strong>
                        </h2>
                        <p class="change-by-command">{{ "$website_title فتح الطرق المميزة لتعزيز الربحية في سوق العملات المشفرة: تمارس مهاراتك في التكتيكات والطرق المحببة للنخبة!" }}</p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="shadow position-relative banner-form form-height">
                        @include('frontend.ar.components.form')
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-md-8">
                    <h2 class="display-5 fw-bold mb-4">
                        {{ aiTrans('ما هو [website_title]?', $locale, ['website_title' => $website_title]) }}</h2>
                    <div>
                        <div>
                            <p><strong>
                                    {{ aiTrans(
                                        'في [website_title] ، نقف كرفيق رئيسي لأي شخص يغامر في عالم استثمارات العملات
                                                                                                                                                                                                                                                            المشفرة. تم افتتاح مؤسستنا منذ أكثر من عقد من الزمان ، وهي منارة للتميز في التعليم
                                                                                                                                                                                                                                                            الاستثماري.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                </strong>
                            </p>
                            <p>
                                {{ aiTrans(
                                    'من خلال التفاعل مع منصتنا ، يمكن للمتداول الوليد استيعاب التقنيات والرؤى الأساسية للتداول
                                    الحي في فترة تقل عن سبعة أيام. _[website_title] يسهل بشكل أكبر الاتصالات بين عشاق
                                    العملات
                                    الرقمية وأجهزة التداول الرئيسية المتاحة في السوق اليوم. تزود هذه الأدوات المتداولين
                                    بالمكونات اللازمة لوضع وتنفيذ استراتيجيات قوية.',
                                    $locale,
                                    ['website_title' => $website_title],
                                ) }}
                            </p>
                            <p>
                                {{ aiTrans(
                                    'علاوة على ذلك ، فإن أدوات الطرف الثالث التي نقدمها دون أي تكلفة عادة ما تكون مصحوبة بسعر
                                    باهظ في مكان آخر. بالإضافة إلى ذلك ، تقدم منصتنا للمستخدمين خدمات وساطة تشفير محترمة
                                    وفعالة من حيث التكلفة. تفتخر هذه الكيانات بالترخيص الدولي ، إلى جانب محافظ العملات
                                    المشفرة الأكثر توسعا في هذا القطاع.',
                                ) }}
                            </p>
                            <p></p>
                            <p>
                                {{ aiTrans(
                                    'تعدد استخدامات تطبيق [website_title] لا مثيل له ، مما يوفر راحة التداول أثناء التنقل
                                    باستخدام أي جهاز محمول يعمل بنظام Android أو Windows أو iOS. نحن نلبي أيضا هواة التداول
                                    المكتبي من خلال تطبيقاتنا الأنيقة المتوافقة مع أنظمة Windows و Linux و Mac. بالإضافة إلى
                                    ذلك ، يمنح متداول الويب الخاص بنا وصولا غير مقيد إلى جميع الموارد والأدوات اللازمة لنجاح
                                    التداول.',
                                    $locale,
                                    ['website_title' => $website_title],
                                ) }}
                            </p>
                        </div>
                    </div>
                    <div class="text-md-start text-center mt-3 mt-md-4 mb-4 mb-md-0">
                        <button class="show-modal btn  text-white btn-secondary btn-lg shadow-lg px-3 px-md-5 fs-4">
                            {{ aiTrans('التعرف على المزيد') }}</button>
                    </div>
                </div>
                <div class="col-md-4 d-flex align-items-center">
                    <picture>
                        <source
                            srcset="{{ asset('frontend/assets/ar/dist') }}/images/459_459__459_661f91d19e9b9_Immediate-Core.webp"
                            type="image/webp">
                        <source
                            srcset="{{ asset('frontend/assets/ar/dist') }}/images/_459_661f91d19e9b9_Immediate-Core.jpg"
                            type="image/jpeg">
                        <img src="{{ asset('frontend/assets/ar/dist') }}/images/_459_661f91d19e9b9_Immediate-Core.jpg"
                            loading="lazy" width="459" height="459" alt="">
                    </picture>
                </div>
            </div>
        </div>
    </section>

    <section class="py-5 bg-light">
        <div class="container mb-5">
            <h2 class="display-5 fw-bold mb-4 text-center">
                {{ aiTrans('[website_title] التطبيق يجعلك متداولا محترفا', $locale, ['website_title' => $website_title]) }}
            </h2>
            <div class="text-center">
                <p><strong>
                        {{ aiTrans(
                            'بالنسبة لأولئك الذين يتطلعون إلى المناورات المالية السريعة ، تظهر العملة المشفرة كخيار رئيسي
                            للاستثمار قصير الأجل واستغلال التقلبات. الانخراط في الاستثمار قصير الأجل يعني انتزاع الأصول
                            لتسخير الارتفاعات السريعة في القيمة السوقية.',
                        ) }}</strong>
                </p>
                <p>
                    {{ aiTrans(
                        'على النقيض من الأسهم ، يزدهر عالم التشفير على الأمواج المضطربة ، مما ينتقص منه كمنارة للمستثمر الثابت
                        طويل المدى. وبسبب حرمانها من توزيعات الأرباح، فإنها تفشل في توفير تدفق دخل ثابت لأولئك الذين يلعبون
                        اللعبة الطويلة. ومع ذلك ، فإن اضطراب العملة المشفرة هو دعوة صفارة إنذار للعديد من المتداولين ، الذين
                        يتنقلون ببراعة في هذه المياه المتقلبة باستخدام مشتقاتها. ___0_ يسلحك بمجموعة من الأدوات والتنوير ،
                        مما يمكنك من التنقل في عالم التشفير بفطنة موهوب متمرس.',
                    ) }}
                </p>
            </div>
        </div>

        <div class="container">
            <div class="row">
                <div class="col-md-4 d-flex align-items-stretch mb-5">
                    <div class="card shadow rounded-3 border-0 border-bottom border-4 border-secondary">
                        <picture>
                            <source
                                srcset="{{ asset('frontend/assets/ar/dist') }}/images/330_449__473_65e6f645b5d6a_img-1.webp"
                                type="image/webp">
                            <source srcset="{{ asset('frontend/assets/ar/dist') }}/images/_473_65e6f645b5d6a_img-1.jpg"
                                type="image/jpeg">
                            <img src="{{ asset('frontend/assets/ar/dist') }}/images/_473_65e6f645b5d6a_img-1.jpg"
                                style="max-height: 320px" loading="lazy" class="w-100 shadow-lg" width="449"
                                height="330" alt="">
                        </picture>
                        <div class="card-body">
                            <h3 class="card-title">
                                {{ aiTrans('التداول ممتع') }}
                            </h3>
                            <input type="checkbox" id="parameter-checkbox0">
                            <div class="card-text">
                                <p><strong>✨</strong>
                                    {{ aiTrans(
                                        'يصبح فن الاستثمار في العملات المشفرة مبهجا مع الترسانة المناسبة من
                                        الأدوات والخبرات. في [website_title] ، نبث الإثارة في رحلة التعليم ، ونحول التجارة
                                        إلى مهمة مرحة من خلال أدوات التداول المبتكرة والمستوحاة من الألعاب.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                </p>
                                <p><strong>✨</strong>
                                    {{ aiTrans(
                                        'بالتعاون مع مقدمي أدوات الاستثمار البارزين ، تقوم ___0_ بشراء
                                        مجموعة واسعة من الأدوات عالية الجودة. عادة ، تتطلب هذه الأدوات المتميزة مبلغا ضخما
                                        من خلال شركائنا. ومع ذلك ، من خلال تحالفنا الاستراتيجي ، يسعدنا أن نقدم لهم مجانا
                                        على منصة [website_title] ، مما يعزز رحلتك المالية في 2025.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                </p>
                                <label for="parameter-checkbox0" class="text-decoration-underline fw-bold fs-5">
                                    {{ aiTrans('قراءة الكل') }}</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 d-flex align-items-stretch mb-5">
                    <div class="card shadow rounded-3 border-0 border-bottom border-4 border-secondary">
                        <picture>
                            <source
                                srcset="{{ asset('frontend/assets/ar/dist') }}/images/349_449__473_65e6f68559411_img-2.webp"
                                type="image/webp">
                            <source srcset="{{ asset('frontend/assets/ar/dist') }}/images/_473_65e6f68559411_img-2.jpg"
                                type="image/jpeg">
                            <img src="{{ asset('frontend/assets/ar/dist') }}/images/_473_65e6f68559411_img-2.jpg"
                                style="max-height: 320px" loading="lazy" class="w-100 shadow-lg" width="449"
                                height="349" alt="">
                        </picture>
                        <div class="card-body">
                            <h3 class="card-title">{{ aiTrans('إدارة المخاطر ممكنة') }}</h3>
                            <input type="checkbox" id="parameter-checkbox1">
                            <div class="card-text">
                                <p><strong>✔️ </strong>
                                    {{ aiTrans(
                                        'يتطلب الخوض في تضاريس الاستثمار في التشفير لمنصة
                                        [website_title]
                                        قلبا قويا. يمكن للتقلبات سيئة السمعة أن تهز حتى عزم المتداول المخضرم. ومع ذلك ، مع
                                        المهارة والأدوات المناسبة ، يمكن للمرء أن يتقن فن تخفيف المخاطر.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                </p>
                                <p><strong>✔️ </strong>
                                    {{ aiTrans(
                                        'يسلح تطبيق [website_title] الخاص بنا حتى أكثر المتداولين خضرة
                                        بالترسانة اللازمة للتنقل في المياه الغادرة لمخاطر السوق. استغل قوة أدواتنا وتحول إلى
                                        موهوب في إدارة المخاطر هذا 2025.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                </p>
                                <label for="parameter-checkbox1" class="text-decoration-underline fw-bold fs-5">
                                    {{ aiTrans('قراءة الكل') }}</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 d-flex align-items-stretch mb-5">
                    <div class="card shadow rounded-3 border-0 border-bottom border-4 border-secondary">
                        <picture>
                            <source
                                srcset="{{ asset('frontend/assets/ar/dist') }}/images/313_449__473_65e6f6b28389a_img-3.webp"
                                type="image/webp">
                            <source srcset="{{ asset('frontend/assets/ar/dist') }}/images/_473_65e6f6b28389a_img-3.jpg"
                                type="image/jpeg">
                            <img src="{{ asset('frontend/assets/ar/dist') }}/images/_473_65e6f6b28389a_img-3.jpg"
                                style="max-height: 320px" loading="lazy" class="w-100 shadow-lg" width="449"
                                height="313" alt="">
                        </picture>
                        <div class="card-body">
                            <h3 class="card-title">{{ aiTrans('يمكنك التداول أثناء التنقل') }}</h3>
                            <input type="checkbox" id="parameter-checkbox2">
                            <div class="card-text">
                                <p><strong>✅ </strong>
                                    {{ aiTrans(
                                        'انطلق في رحلة تجارية استكشافية في أي وقت وفي أي مكان باستخدام
                                        تطبيق [website_title].',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                </p>
                                <p><strong>✅ </strong>
                                    {{ aiTrans('تخلص من سلاسل سطح المكتب الخاص بك ؛ تكمن حرية التعامل مع الأسواق
                                    والمراهنة على أصولك الرقمية الموقرة في متناول يدك ، مباشرة من جهازك المحمول.') }}
                                </p>
                                <p><strong>✅ </strong>
                                    {{ aiTrans('تعمق في المجموعة الكاملة من خدماتنا ، بما في ذلك منصة التعليم
                                    الاستثماري من الدرجة الأولى ، كل ذلك من خلال الواجهة السلسة للتطبيق.') }}
                                </p>
                                <label for="parameter-checkbox2"
                                    class="text-decoration-underline fw-bold fs-5">{{ aiTrans('قراءة الكل') }}</label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="text-center mt-3 mt-md-4">
                <button class="show-modal btn  text-white btn-primary btn-lg text-uppercase shadow-lg px-3 px-md-5 fs-4">
                    {{ aiTrans('اكتشف المزيد') }}</button>
            </div>
        </div>
    </section>

    <section class="py-5">
        <div class="container mb-5">
            <div class="row">
                <div class="col-md-10">
                    <h2 class="display-5 fw-bold mb-4">
                        {{ aiTrans('إتقان أهم 4 أشياء يجب أن يعرفها كل مستثمر في العملات المشفرة!') }}
                    </h2>
                    <h4><strong>
                            {{ aiTrans('التقنيات الثورية تبسط استراتيجيات الاستثمار') }}
                        </strong></h4>
                    <p>
                        {{ aiTrans('احتضن إثارة الاستثمار في العملات المشفرة بخبرة وأفضل الأدوات المتاحة لك. المتداولون الماهرون هم
                        أولئك الذين يمكنهم تحديد فرص السوق والاستفادة منها بأقل قدر من التعرض للمخاطر. ومع ذلك ، فإن
                        التنقل في الموجات المضطربة لسوق العملات المشفرة للعثور على هذه الفتحات يمثل تحديا هائلا.') }}
                    </p>
                    <p>
                        {{ aiTrans('إن وجود مجموعة أدوات شاملة أمر ضروري لإيقاع مثل هذه الفرص العابرة. الأدوات المتميزة هي حليفك ،
                        مما يتيح لك انتزاع الفرص عند ظهورها من تقلبات السوق والأخبار الرائدة. للمبتدئين الذين يتوقون إلى
                        التغلب على فن التداول بناء على هذه المؤشرات ، نقدم مجموعة شاملة من الأدوات.') }}
                    </p>
                    <p>
                        {{ aiTrans('علاوة على ذلك ، تتعاون ___0_ مع نخبة مزودي تقنيات التداول لتوفير أدوات تحليل سوق لا مثيل لها. هذه
                            الأدوات المتطورة محصنة بتكنولوجيا الذكاء الاصطناعي ، واعدة بنتائج تداول ممتازة. نحن نوفر دروسا
                            تعليمية شاملة مصممة للمبتدئين ، مما يسرع من إتقانهم لهذه الأجهزة. توفر بيئتنا التجريبية صندوق
                            رمل لاختبار جميع الصفقات التي تمت صياغتها باستخدام هذه الأدوات بدقة قبل إطلاقها في ساحة التداول
                            المباشر.') }}
                    </p>
                    <h4><strong>
                            {{ aiTrans('مواءمة تطلعات التداول مع عتبة المخاطرة الخاصة بك') }}
                        </strong></h4>

                    <p>
                        {{ aiTrans(
                            'يتطلب بناء مخطط تداول فعال والالتزام به مهارة وضبط النفس. يجب أن تعكس هذه الخطة تطلعاتك في
                            التداول وأن تكون مصممة خصيصا لتحملك للمخاطر. تحمل المخاطر هو درجة عدم اليقين التي أنت على
                            استعداد لاحتضانها في مشاريعك التجارية.  [website_title] يقيم بدقة عوامل لا تعد ولا تحصى للتأكد
                            من
                            ملف تعريف المخاطر الفردي الخاص بك.',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </p>
                    <h4><strong>
                            {{ aiTrans('النمو من خلال إعادة الاستثمار: الاستراتيجية المثلى') }}
                        </strong></h4>
                    <p>
                        {{ aiTrans('يمكن تحقيق تضخيم محفظة العملات المشفرة الخاصة بك عن طريق ضخ المزيد من رأس المال أو عن طريق البدء
                            بشكل متواضع وتوجيه المكاسب مرة أخرى إلى استثمارك. ومع ذلك ، ليس من الحكمة تخصيص جزء كبير من
                            مدخراتك للعملات المشفرة ، مع الأخذ في الاعتبار المخاطر الكامنة. الطريق الأكثر حكمة لتوسيع
                            المحفظة هو من خلال إعادة الاستثمار الذكي للأرباح. ___0_ تمكنك من تنمية تدفق الإيرادات وزيادة
                            حساب التداول الخاص بك بشكل تدريجي عن طريق إعادة الاستثمار الاستراتيجي.') }}
                    </p>
                    <h4><strong>
                            {{ aiTrans('إتقان إدارة مخاطر التشفير بدقة الخبراء') }}
                        </strong></h4>
                    <p>
                        {{ aiTrans('من الضروري لجميع أشكال الاستثمار فن إدارة المخاطر ، وهو نظام مصمم خصيصا لملف تعريف المخاطر الخاص
                            بك ، والصحة المالية ، والأدوات المالية المختارة. تختلف قدرة المستثمرين على تحمل المخاطر اختلافا
                            كبيرا.') }}
                    </p>
                    <p>
                        {{ aiTrans('يجب أن تملي الصحة المالية للمستثمر حجم استثماراته. الحكمة تكمن في ارتكاب ما يمكن للمرء أن يتحمل
                            خسارته. يجب ألا تشكل المشاريع عالية المخاطر مثل تداول العملات المشفرة أكثر من عشر إجمالي محفظتك
                            الاستثمارية. نحن نوفر لك الموارد اللازمة لتنمية وتقييم تحملك للمخاطر.') }}
                    </p>
                </div>
            </div>
        </div>

        <div class="container">
            <div class="row">
                <div class="col-md-6  mb-4">
                    <div class="h-100 card border-0 shadow-lg border border-4 border-bottom border-primary">
                        <div class="card-body p-4">
                            <h3 class="fw-bold text-uppercase">
                                {{ aiTrans('عملية تسجيل بسيطة') }}</h3>
                            <input type="checkbox" id="howworks-checkbox0">
                            <div>
                                <p>
                                    {{ aiTrans(
                                        'تمهد بنية الويب المبسطة ل  [website_title] مسارا سلسا للمسجلين ، مما يبشرهم بسهولة
                                        في
                                        عالم السعي الأكاديمي.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                </p>
                                <p>
                                    {{ aiTrans(
                                        'بعد التسجيل ، ينتظر معقل المعرفة في فن تعليم الاستثمار في [website_title]. يلتزم
                                        هذا
                                        الكادر من المدربين المخضرمين بتقديم ملحمة تعليمية غنية وشخصية ، تلبي التطلعات
                                        المتميزة والعقول الفضولية لكل فرد.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                </p>
                                <label for="howworks-checkbox0"
                                    class="text-decoration-underline fw-bold fs-5">{{ aiTrans('قراءة الكل') }}</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6  mb-4">
                    <div class="h-100 card border-0 shadow-lg border border-4 border-bottom border-primary">
                        <div class="card-body p-4">
                            <h3 class="fw-bold text-uppercase">{{ aiTrans('اتصالات الجودة') }}</h3>
                            <input type="checkbox" id="howworks-checkbox1">
                            <div>
                                <p>
                                    {{ aiTrans('_[website_title] يتجاوز الدور الأساسي لربط المتعلمين بالمؤسسات الدراسية.', $locale, [
                                        'website_title' => $website_title,
                                    ]) }}
                                </p>
                                <p>
                                    {{ aiTrans('إنه يوفر تنقلا مخصصا ، يتماشى مع التطلعات الشخصية والأهداف التعليمية ، بحيث يتنقل
                                    المستخدمون في خياراتهم دون الشعور بالحيرة أو الغمر. تضمن هذه المنهجية المدروسة أن
                                    يقيم المتعلمون روابط مع الكيانات التعليمية التي تتجاوز طموحاتهم الأكاديمية ،
                                    وبالتالي تعزيز التجربة الشاملة.') }}
                                </p>
                                <label for="howworks-checkbox1"
                                    class="text-decoration-underline fw-bold fs-5">{{ aiTrans('قراءة الكل') }}</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6  mb-4">
                    <div class="h-100 card border-0 shadow-lg border border-4 border-bottom border-primary">
                        <div class="card-body p-4">
                            <h3 class="fw-bold text-uppercase">{{ aiTrans('التمكين من خلال التعليم') }}</h3>
                            <input type="checkbox" id="howworks-checkbox2">
                            <div>
                                <p>
                                    {{ aiTrans('يزخر مشهد الاستثمارات بجوانب معقدة قد تخيف في البداية أولئك الجدد في المجال.') }}
                                </p>
                                <p>
                                    {{ aiTrans(
                                        'ومع ذلك ، فإن تفاني [website_title] في ربط المستخدمين بالمواد التعليمية يضمن
                                        إمكانية
                                        التغلب على هذه التحديات من قبل الجميع في 2025. من خلال [website_title] ، يتم تجهيز
                                        الأفراد للانغماس في مجال الاستثمار ، وفهم التفاصيل الدقيقة لتدفق السوق ، والمشاركة
                                        بكل إخلاص في الرحلة التعليمية. يعمل تطبيق [website_title] على توسيع قاعدة المعرفة
                                        هذه
                                        ، مما يتيح للمستخدمين التنقل في رحلتهم المالية بثقة. علاوة على ذلك ، تكشف مراجعة
                                        [website_title] الشاملة عن فعالية منصة [website_title] في إزالة الغموض عن
                                        الاستثمار.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}

                                </p>
                                <label for="howworks-checkbox2"
                                    class="text-decoration-underline fw-bold fs-5">{{ aiTrans('قراءة الكل') }}</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6  mb-4">
                    <div class="h-100 card border-0 shadow-lg border border-4 border-bottom border-primary">
                        <div class="card-body p-4">
                            <h3 class="fw-bold text-uppercase">

                                {{ aiTrans('التنقل في منحنى التعلم باستخدام [website_title]', $locale, ['website_title' => $website_title]) }}
                            </h3>
                            <input type="checkbox" id="howworks-checkbox3">
                            <div>
                                <p>{{ aiTrans('فن الاستثمار معقد ، ويتطلب فهما متعمقا للفروق الدقيقة والاستعداد الاستراتيجي.') }}
                                </p>
                                <p>
                                    {{ aiTrans(
                                        'اعترافا بهذه الأساسيات ، تم تكريس [website_title] لتوجيه كل مشارك نحو بداية واعدة
                                        لملحمته المالية. من خلال سد الفجوة بين المستخدمين والمحتوى التعليمي الأكثر صلة ،
                                        يقدم [website_title] مغامرة دراسية غامرة ومفيدة. انطلق في رحلة استكشافية معنا ،
                                        حيث
                                        يتم تنسيق المعرفة بدقة لتلبية احتياجاتك الفردية.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                </p>
                                <label for="howworks-checkbox3"
                                    class="text-decoration-underline fw-bold fs-5">{{ aiTrans('قراءة الكل') }}</label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="text-center mt-3 mt-md-4">
                <button class="show-modal btn  text-white btn-primary btn-lg text-uppercase shadow-lg px-3 px-md-5 fs-4">
                    {{ aiTrans('التعرف على المزيد') }}

                </button>
            </div>
        </div>
    </section>

    <section class="py-5 bg-light">
        <div class="container">
            <div class="row flex-md-row flex-column-reverse ">
                <div class="col-md-4 d-flex align-items-center">
                    <picture>
                        <source
                            srcset="{{ asset('frontend/assets/ar/dist') }}/images/459_459__459_661f91e8b9cb2_immediate_core.webp"
                            type="image/webp">
                        <source
                            srcset="{{ asset('frontend/assets/ar/dist') }}/images/_459_661f91e8b9cb2_immediate_core.jfif"
                            type="image/jpeg">
                        <img src="{{ asset('frontend/assets/ar/dist') }}/images/_459_661f91e8b9cb2_immediate_core.jfif"
                            loading="lazy" width="459" height="459" alt="">
                    </picture>
                </div>
                <div class="col-md-8">
                    <input type="checkbox" id="about2-checkbox">
                    <div>
                        <h3><strong>
                                {{ aiTrans(
                                    'فتح أسرار الازدهار في عالم التشفير الذي لا يمكن التنبؤ به باستخدام تطبيق [website_title]',
                                    $locale,
                                    ['website_title' => $website_title],
                                ) }}
                            </strong></h3>
                        <p>
                            {{ aiTrans(
                                'في مجال تداول الأصول ، يشتهر مشهد العملات المشفرة بتقلباته الاستثنائية. يتجلى هذا التقلب من
                                خلال تقلبات الأسعار الدراماتيكية ، حيث ترتفع عملات مثل البيتكوين أو تنخفض بمقدار 5000 دولار
                                في يوم واحد.',
                            ) }}
                        </p>
                        <p>
                            {{ aiTrans(
                                'العملات البديلة ، بما في ذلك أمثال DOGE ، ليست محصنة ضد هذا الاضطراب ، حيث تصل تغيرات الأسعار
                                اليومية في بعض الأحيان إلى 500٪. يقدم هذا السلوك غير المنتظم سيفا ذا حدين: فرصة للربح وخطر
                                الخسارة. إن التنقل في هذه الرقصة المعقدة لأبحاث التداول للاستيلاء على الأول مع التهرب من
                                الأخير يمثل تحديا هائلا.',
                            ) }}
                        </p>
                        <p>
                            {{ aiTrans(
                                'يضيء تطبيق [website_title] الطريق عبر متاهة تداول تقلبات العملات المشفرة. هنا ، نكشف النقاب
                                عن
                                العناصر المحورية الثلاثة للانتصار في أسواق المضاربة العاصفة.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                        </p>
                        <p><strong>✅ {{ aiTrans('الدقة في تحليل التجارة') }} </strong></p>
                        <p>
                            {{ aiTrans('يرتبط عيار تداولاتك ارتباطا وثيقا ببراعة قدراتك التحليلية وترسانة الأدوات الموجودة تحت تصرفك.
                            لتشريح أنماط الأسعار والتداول على الأخبار بدقة ، يحتاج المرء إلى أدوات من أعلى المستويات.
                            مهمتنا هي تسليح المتداولين بمهارات لا مثيل لها وسد الفجوة إلى الأدوات التحليلية المتميزة من
                            طرف ثالث.') }}
                        </p>
                        <p><strong>✅ {{ aiTrans('السرعة في الوفاء بالنظام') }}</strong></p>
                        <p>
                            {{ aiTrans('حتى رؤى التداول الأكثر ذكاء تصبح موضع نقاش إذا لم يتم التصرف بناء عليها بسرعة. أسواق العملات
                            المشفرة في حالة تغير دائم ، وأي تأخير في التنفيذ يمكن أن يؤدي إلى الانزلاق السلبي المخيف.
                            لتجنب مثل هذه الخسائر ، يجب على المرء ضمان التنفيذ الفوري للتجارة.') }}
                        </p>
                        <p><strong>✅ {{ aiTrans(' استراتيجية التخفيف من المخاطر') }}</strong></p>
                        <p>
                            {{ aiTrans(
                                'إن الإطار الفعال لإدارة المخاطر هو حجر الأساس لنجاح الاستثمار على المدى الطويل والقصير. تعد
                                صياغة مثل هذه الاستراتيجية مسعى معقدا للعديد من المستثمرين ، وغالبا ما تتطلب أدوات متقدمة
                                لإدارة مخاطر التداول بمهارة. يمنحك تطبيق [website_title] الخبرة والحافة التكنولوجية للتنقل
                                في
                                مخاطر التداول ببراعة محترف متمرس.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                        </p>
                        <label for="about2-checkbox"
                            class="text-decoration-underline fw-bold fs-5">{{ aiTrans('قراءة الكل') }}</label>
                    </div>
                    <div class="text-md-start text-center mt-3 mt-md-4 mb-4 mb-md-0">
                        <button class="show-modal btn  text-white btn-secondary btn-lg shadow-lg px-3 px-md-5 fs-4">
                            {{ aiTrans('التعرف على المزيد') }}
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="py-5">
        <div class="container mb-5">
            <h2 class="display-5 text-center fw-bold mb-4">
                {{ aiTrans('أهم 3 أخطاء مكلفة يرتكبها معظم مستثمري التشفير!') }}</h2>
            <div>
                <p><strong>
                        {{ aiTrans('تكشف الدراسات أن الغالبية المذهلة ، أكثر من النصف ، من متداولي العملات المشفرة يفشلون في جني
                        الأرباح. وهذا يثير تساؤلا مثيرا للاهتمام: ما الذي يفصل القلة المنتصرة عن العديد من أصحاب الأداء
                        الضعيف؟ يشير خبراء تقلبات السوق إلى وجود ثالوث من الأخطاء الضارة في صميم إخفاقات معظم
                        المستثمرين.') }}
                    </strong></p>
                <p><strong>

                        {{ aiTrans(
                            'إن اكتساب الفطنة اللازمة إلى جانب ضبط النفس الصارم أمر حيوي لتجنب هذه الأخطاء الفادحة. يتعمق
                            المعرض التالي في هذه الأخطاء المالية. تم تصميم تطبيق [website_title] لتزويدك باستراتيجيات ذكية
                            لتجنب هذه الأخطاء. مستنيرا بشأن هذه المزالق ، فأنت على استعداد لاجتياز التضاريس الغادرة لبورصات
                            العملات المشفرة ببراعة موهوب متمرس.',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </strong></p>
            </div>
        </div>

        <div class="container">
            <div class="row p-4 align-items-center rounded-3 border shadow mb-5">
                <div class="col-lg-7 ">
                    <h3 class=" fw-bold lh-1">{{ aiTrans('الشراء لمجرد أن السعر منخفض') }} </h3>
                    <input type="checkbox" id="mustknow-checkbox0">
                    <div class="lead">
                        <p>{{ aiTrans(' الطبيعة المتقلبة للعملات المشفرة تعني أن الأسعار تتأرجح بشكل كبير.') }} </p>
                        <p>

                            {{ aiTrans(
                                'المضاربة على مسار ثوري عابر هي وصفة لخيبة الأمل. يعد التحليل الدؤوب للمبادئ الأساسية أمرا
                                بالغ الأهمية قبل اتخاذ أي قرار استثماري. [website_title] يوفر مجموعة من الأدوات التي تمكنك
                                من
                                إجراء أبحاث التداول الأساسية على مستوى الخبراء ، مما يضمن أنك مجهز جيدا لاتخاذ قرارات
                                مستنيرة.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                        </p>
                        <label for="mustknow-checkbox0"
                            class="text-decoration-underline fw-bold fs-5">{{ aiTrans('قراءة الكل') }}</label>
                    </div>
                </div>
                <div class="col-lg-4 offset-lg-1 p-0 overflow-hidden shadow h-100">
                    <picture>
                        <source
                            srcset="{{ asset('frontend/assets/ar/dist') }}/images/330_449__473_65e71686887bb_img-4.webp"
                            type="image/webp">
                        <source srcset="{{ asset('frontend/assets/ar/dist') }}/images/_473_65e71686887bb_img-4.jpg"
                            type="image/jpeg">
                        <img src="{{ asset('frontend/assets/ar/dist') }}/images/_473_65e71686887bb_img-4.jpg"
                            loading="lazy" class="w-100 rounded-3" width="449" height="330" alt="">
                    </picture>
                </div>
            </div>
            <div class="row p-4 align-items-center rounded-3 border shadow mb-5">
                <div class="col-lg-7 ">
                    <h3 class=" fw-bold lh-1">{{ aiTrans('استثمار جميع المدخرات في العملات المشفرة') }}</h3>
                    <input type="checkbox" id="mustknow-checkbox1">
                    <div class="lead">
                        <p> {{ aiTrans('في مجال أدوات الاستثمار ، تقف العملات المشفرة على أنها الأكثر خطورة. ') }}</p>
                        <p> {{ aiTrans('يتميز القطاع بتقلبات شديدة. إن تخصيص بيضة العش بأكملها لسوق معروف باضطرابه هو عمل من أعمال الحماقة .') }}
                        </p>
                        <label for="mustknow-checkbox1"
                            class="text-decoration-underline fw-bold fs-5">{{ aiTrans('قراءة الكل') }}</label>
                    </div>
                </div>
                <div class="col-lg-4 offset-lg-1 p-0 overflow-hidden shadow h-100">
                    <picture>
                        <source
                            srcset="{{ asset('frontend/assets/ar/dist') }}/images/349_449__473_65e7169208597_img-5.webp"
                            type="image/webp">
                        <source srcset="{{ asset('frontend/assets/ar/dist') }}/images/_473_65e7169208597_img-5.jpg"
                            type="image/jpeg">
                        <img src="{{ asset('frontend/assets/ar/dist') }}/images/_473_65e7169208597_img-5.jpg"
                            loading="lazy" class="w-100 rounded-3" width="449" height="349" alt="">
                    </picture>
                </div>
            </div>
            <div class="row p-4 align-items-center rounded-3 border shadow mb-5">
                <div class="col-lg-7 ">
                    <h3 class=" fw-bold lh-1">{{ aiTrans('الوقوع في عمليات الاحتيال في المضخات والتفريغ') }} </h3>
                    <input type="checkbox" id="mustknow-checkbox2">
                    <div class="lead">
                        <p> 
                            {{ aiTrans(
                                'في [website_title] المتطورة باستمرار للعملة المشفرة ، تزدهر مخططات الضخ والتفريغ بانتظام ينذر بالخطر.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                        </p>
                        <p>

                            {{ aiTrans(
                                'ضمن هذه الخدع ، يلوح اللاعبون الأذكياء في السوق بحيازات كبيرة ، وينظمون طلبات شراء وهمية تضخم
                                تقييمات العملات الرقمية ببراعة. وكثيرا ما يتورط المشاركون المطمئنون في منصة
                                [website_title] ،
                                الذين يغريهم سراب أسعار السوق المتصاعدة ، في شرك شبكة الخداع هذه.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                        </p>
                        <label for="mustknow-checkbox2"
                            class="text-decoration-underline fw-bold fs-5">{{ aiTrans('قراءة الكل') }}</label>
                    </div>
                </div>
                <div class="col-lg-4 offset-lg-1 p-0 overflow-hidden shadow h-100">
                    <picture>
                        <source
                            srcset="{{ asset('frontend/assets/ar/dist') }}/images/313_449__473_65e7169e5461a_img-6.webp"
                            type="image/webp">
                        <source srcset="{{ asset('frontend/assets/ar/dist') }}/images/_473_65e7169e5461a_img-6.jpg"
                            type="image/jpeg">
                        <img src="{{ asset('frontend/assets/ar/dist') }}/images/_473_65e7169e5461a_img-6.jpg"
                            loading="lazy" class="w-100 rounded-3" width="449" height="313" alt="">
                    </picture>
                </div>
            </div>
            <div class="text-center mt-3 mt-md-4">
                <button class="show-modal btn  text-white btn-primary text-uppercase btn-lg shadow-lg px-3 px-md-5 fs-4">
                    {{ aiTrans('استكشف [website_title]', $locale, ['website_title' => $website_title]) }}
                </button>
            </div>
        </div>
    </section>

    <section class="py-5 bg-phone text-white">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <h2 class="display-5 fw-bold mb-4">

                        {{ aiTrans('أفضل 3 تنبؤات للعملات المشفرة - مراجعة [website_title]', $locale, [
                            'website_title' => $website_title,
                        ]) }}

                    </h2>
                    <p class="fw-bold fs-4 test-uppercase">
                    <p><strong>
                            {{ aiTrans('استفد من أحدث تقنيات الاستثمار لكسب المال من تقلبات سوق التشفير المتزايدة!') }}</strong>
                    </p>
                    </p>
                </div>
                <div class="col-lg-4 d-flex flex-column">
                    <div class="mb-4 position-relative px-5">
                        <div class="position-absolute start-0">
                            <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor"
                                class="bi bi-check-circle-fill text-success" viewBox="0 0 16 16">
                                <path
                                    d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-3.97-3.03a.75.75 0 0 0-1.08.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-.01-1.05z" />
                            </svg>
                        </div>
                        <div>
                            <p><em><strong>
                                        {{ aiTrans('توقع أن يؤدي حكم صناديق الاستثمار المتداولة في Bitcoin إلى دفع الأسواق ، مما
                                        يؤدي إلى ارتفاع BTC إلى ما بعد عتبة 67000 دولار في الأسابيع
                                        المقبلة.') }}</strong></em>
                            </p>
                        </div>
                    </div>
                    <div class="mb-4 position-relative px-5">
                        <div class="position-absolute start-0">
                            <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor"
                                class="bi bi-check-circle-fill text-success" viewBox="0 0 16 16">
                                <path
                                    d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-3.97-3.03a.75.75 0 0 0-1.08.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-.01-1.05z" />
                            </svg>
                        </div>
                        <div>
                            <p><i><strong>{{ aiTrans('ستقدم أكبر 5 اقتصادات أطرا تنظيمية للعملات المشفرة وبالتالي تؤدي إلى التبني السائد.') }}</strong></i>
                            </p>
                        </div>
                    </div>
                    <div class="mb-4 position-relative px-5">
                        <div class="position-absolute start-0">
                            <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor"
                                class="bi bi-check-circle-fill text-success" viewBox="0 0 16 16">
                                <path
                                    d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-3.97-3.03a.75.75 0 0 0-1.08.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-.01-1.05z" />
                            </svg>
                        </div>
                        <div>
                            <p><i><strong>
                                        {{ aiTrans('سيؤدي تنصيف البيتكوين إلى طفرة هائلة ستدفع تداول BTC إلى ما بعد 100000 دولار') }}</strong></i>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="py-5">
        <div class="container">
            <h2 class="display-5 fw-bold mb-5 text-center">
                {{ aiTrans('الأسئلة الشائعة') }}
            </h2>
            <div class="row">
                <div class="accordion mx-auto">
                    <div class="accordion-item mb-4">
                        <h3 class="accordion-header" id="heading0">
                            <button class="accordion-button collapsed rounded-3 fs-4 shadow-lg p-4" type="button"
                                data-bs-toggle="collapse" data-bs-target="#collapse0" aria-expanded="false"
                                aria-controls="collapse0">

                                {{ aiTrans('هل تطبيق [website_title] آمن؟', $locale, ['website_title' => $website_title]) }}

                            </button>
                        </h3>
                        <div id="collapse0" class="accordion-collapse collapse" aria-labelledby="heading0"
                            data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p>
                                    {{ aiTrans(
                                        'تظل حماية الملاذات الرقمية لزبائننا مصدر قلقنا الأكبر. [website_title] الموقع
                                        الرسمي ،
                                        معقل الأمن السيبراني 2025 ، يأتي محصنا بتدابير وقائية نخبوية.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item mb-4">
                        <h3 class="accordion-header" id="heading1">
                            <button class="accordion-button collapsed rounded-3 fs-4 shadow-lg p-4" type="button"
                                data-bs-toggle="collapse" data-bs-target="#collapse1" aria-expanded="false"
                                aria-controls="collapse1">
                                {{ aiTrans('ما هي الأدوات التي تقدمها منصة الاستثمار [website_title]؟', $locale, [
                                    'website_title' => $website_title,
                                ]) }}

                            </button>
                        </h3>
                        <div id="collapse1" class="accordion-collapse collapse" aria-labelledby="heading1"
                            data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p>
                                    {{ aiTrans(
                                        'تسخر منصة [website_title] ، وهي منارة للابتكار ل 2025 ، براعة الذكاء الاصطناعي
                                        لتوفير
                                        تحليل استثماري متطور ، وتحكم صارم في المخاطر ، وموارد إعادة استثمار ذكية.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item mb-4">
                        <h3 class="accordion-header" id="heading2">
                            <button class="accordion-button collapsed rounded-3 fs-4 shadow-lg p-4" type="button"
                                data-bs-toggle="collapse" data-bs-target="#collapse2" aria-expanded="false"
                                aria-controls="collapse2">
                                {{ aiTrans('هل يدعم  [website_title] بطاقات الخصم والائتمان؟', $locale, ['website_title' => $website_title]) }}

                            </button>
                        </h3>
                        <div id="collapse2" class="accordion-collapse collapse" aria-labelledby="heading2"
                            data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p><strong>{{ $website_title }}</strong>
                                    {{ aiTrans(
                                        'بمثابة قناة مجانية ، تربط المستثمرين بوسطاء العقود
                                        مقابل الفروقات للعملات المشفرة المحترمين. يتم تسهيل ضخ رأس المال من خلال كيانات
                                        الوساطة التابعة لنا. يستوعب كل من شركائنا مجموعة منتقاة من آليات المعاملات ، مما
                                        يضمن تفاعلات مالية سلسة للمستخدمين في 2025.',
                                    ) }}
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item mb-4">
                        <h3 class="accordion-header" id="heading3">
                            <button class="accordion-button collapsed rounded-3 fs-4 shadow-lg p-4" type="button"
                                data-bs-toggle="collapse" data-bs-target="#collapse3" aria-expanded="false"
                                aria-controls="collapse3">

                                {{ aiTrans('كيف يمكنني إيقاف حساب [website_title] الخاص بي مؤقتا؟', $locale, [
                                    'website_title' => $website_title,
                                ]) }}

                            </button>
                        </h3>
                        <div id="collapse3" class="accordion-collapse collapse" aria-labelledby="heading3"
                            data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p>
                                    {{ aiTrans(
                                        'في [website_title] ، نتفهم الحاجة إلى المرونة في مساعيك المالية. لوضع حد لأنشطة
                                        السوق
                                        الخاصة بك ، ما عليك سوى الانتقال إلى قسم الإعدادات على موقعنا الرسمي
                                        [website_title].',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}

                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="text-center mt-3 mt-md-4">
                <button class="show-modal btn  text-white btn-primary text-uppercase btn-lg shadow-lg px-3 px-md-5 fs-4">
                    {{ aiTrans('تعرف على المزيد حول خدمات المنصة') }}

                </button>
            </div>
        </div>
    </section>

    <section class="py-5">
        <div class="container">
            <h2 class="display-5 fw-bold mb-5 text-center">
                {{ aiTrans('[website_title] يسلط الضوء', $locale, ['website_title' => $website_title]) }}

            </h2>
            <div class="row">
                <figure class="table">
                    <table>
                        <tbody>
                            <tr>
                                <td><strong>🤖 {{ aiTrans('منصة التداول') }}</strong></td>
                                <td><strong>{{ aiTrans('التشفير') }}</strong></td>
                            </tr>
                            <tr>
                                <td><strong>💰 {{ aiTrans('إيداع التداول') }}</strong></td>
                                <td><strong>{{ aiTrans('250 ر.س.') }}</strong></td>
                            </tr>
                            <tr>
                                <td><strong>💰 {{ aiTrans('تكلفة البرنامج') }} </strong></td>
                                <td><strong>{{ aiTrans('خال') }}</strong></td>
                            </tr>
                            <tr>
                                <td><strong>💰 {{ aiTrans('رسوم السحب') }} </strong></td>
                                <td><strong>{{ aiTrans('اي') }}</strong></td>
                            </tr>
                            <tr>
                                <td><strong>📊 {{ aiTrans('نوع المنصة') }} </strong></td>
                                <td><strong>{{ aiTrans('منصة قائمة على الويب والملكية وأندرويد من Google و iOS من Apple') }}</strong>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>💱 {{ aiTrans('العملات المشفرة المدعومة') }} </strong></td>
                                <td><strong>{{ aiTrans('بيتكوين، إل تي سي، إيثريوم، بي كي إتش') }}</strong></td>
                            </tr>
                            <tr>
                                <td><strong>🌎{{ aiTrans('البلدان') }} </strong></td>
                                <td><strong>{{ aiTrans('الكل - باستثناء الولايات المتحدة الأمريكية') }}</strong></td>
                            </tr>
                        </tbody>
                    </table>
                </figure>
            </div>
        </div>
    </section>
@endsection
