@extends('layouts.app')

@push('meta')
    <title>{{ "Document of Privacy Agreement at $website_title" }}</title>
    <meta name="description" content="{{ "Transparency and Security: $website_title's Privacy Policy elucidates our data protection measures" }}" />
@endpush

@section('content')
    <div class="container page-inner pt-5">
        <h1>{{ aiTrans('Privacy Policy') }}</h1>
        <main>
            <p><span class="b">{{ aiTrans('Provider') }}</span> {{ aiTrans('("us", "we", or "our") operates the') }} <span class="u">{{$website_title}}</span> {{ aiTrans('website (the “Service”).') }}</p>
            <p>{{ aiTrans('This page informs you of our policies regarding the collection, use, and disclosure of personal data when you use our Service and the choices you have associated with that data.') }}</p>
            <p>{{ aiTrans('This page informs you of our policies regarding the collection, use, and disclosure of personal data when you use our Service and the choices you have associated with that data.') }}</p>
            <p>{{ aiTrans('We,') }} <a href="{{route('home',$country)}}"> {{ $website_title }}</a>, {{ aiTrans('use your data to provide and improve the Service. By using the Service, you agree to the collection and use of information in accordance with this policy. Unless otherwise defined in this Privacy Policy, terms used in this Privacy Policy have the same meanings as in our Terms and Conditions, accessible from') }} <span class="u">{{$website_title}}</span></p>
            <div id="toc_container" class="no_bullets">
                <ul class="toc_list">
                    <ul>
                        <li>
                            <ul>
                                <li><a href="#Definitions"><span class="toc_number toc_depth_3">0.0.1</span> {{ aiTrans('Definitions') }}</a>
                                    <ul>
                                        <li><a href="#Service"><span class="toc_number toc_depth_4">0.0.1.1</span> {{ aiTrans('Service') }}</a></li>
                                    </ul>
                                </li>
                                <li><a href="#Personal_Data"><span class="toc_number toc_depth_3">0.0.2</span> {{ aiTrans('Personal Data') }}</a></li>
                                <li><a href="#Usage_Data"><span class="toc_number toc_depth_3">0.0.3</span> {{ aiTrans('Usage Data') }}</a></li>
                                <li><a href="#Cookies"><span class="toc_number toc_depth_3">0.0.4</span> {{ aiTrans('Cookies') }}</a></li>
                                <li><a href="#Data_Controller"><span class="toc_number toc_depth_3">0.0.5</span> {{ aiTrans('Data Controller') }}</a></li>
                                <li><a href="#Data_Processors_or_Service_Providers"><span class="toc_number toc_depth_3">0.0.6</span> {{ aiTrans('Data Processors (or Service Providers)') }}</a></li>
                                <li><a href="#Data_Subject_or_User"><span class="toc_number toc_depth_3">0.0.7</span> {{ aiTrans('Data Subject (or User)') }}</a></li>
                            </ul>
                        </li>
                    </ul>
                    <li><a href="#Information_Collection_And_Use"><span class="toc_number toc_depth_1">1</span> {{ aiTrans('Information Collection And Use') }}</a>
                        <ul>
                            <li>
                                <ul>
                                    <li><a href="#Types_of_Data_Collected"><span class="toc_number toc_depth_3">1.0.1</span> {{ aiTrans('Types of Data Collected') }}</a></li>
                                    <li><a href="#Personal_Data-2"><span class="toc_number toc_depth_3">1.0.2</span> {{ aiTrans('Personal Data') }}</a></li>
                                    <li><a href="#Usage_Data-2"><span class="toc_number toc_depth_3">1.0.3</span> {{ aiTrans('Usage Data') }}</a></li>
                                    <li><a href="#Tracking_Cookies_Data"><span class="toc_number toc_depth_3">1.0.4</span> {{ aiTrans('Tracking Cookies Data') }}</a></li>
                                    <li><a href="#Use_of_Data"><span class="toc_number toc_depth_3">1.0.5</span> {{ aiTrans('Use of Data') }}</a></li>
                                    <li><a href="#Legal_Basis_for_Processing_Personal_Data_Under_General_Data_Protection_Regulation_GDPR"><span class="toc_number toc_depth_3">1.0.6</span> {{ aiTrans('Legal Basis for Processing Personal Data Under General Data Protection Regulation (GDPR)') }}</a></li>
                                    <li><a href="#Retention_of_Data"><span class="toc_number toc_depth_3">1.0.7</span> {{ aiTrans('Retention of Data') }}</a></li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="#Transfer_Of_Data"><span class="toc_number toc_depth_1">2</span> {{ aiTrans('Transfer Of Data') }}</a>
                        <ul>
                            <li>
                                <ul>
                                    <li><a href="#Disclosure_Of_Data"><span class="toc_number toc_depth_3">2.0.1</span> {{ aiTrans('Disclosure Of Data') }}
                                            <ul>
                                                <li><a href="#Business_Transaction"><span class="toc_number toc_depth_4">2.0.1.1</span> {{ aiTrans('Business Transaction') }}</a></li>
                                            </ul>
                                    </li>
                                    <li><a href="#Legal_Requirements"><span class="toc_number toc_depth_3">2.0.2</span> {{ aiTrans('Legal Requirements') }}</a></li>
                                    <li><a href="#Security_Of_Data"><span class="toc_number toc_depth_3">2.0.3</span> {{ aiTrans('Security Of Data') }}</a></li>
                                    <li><a href="#Your_Data_Protection_Rights_Under_General_Data_Protection_Regulation_GDPR"><span class="toc_number toc_depth_3">2.0.4</span> {{ aiTrans('Your Data Protection Rights Under General Data Protection Regulation (GDPR)') }}</a></li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="#Service_Providers"><span class="toc_number toc_depth_1">3</span> {{ aiTrans('Service Providers') }}</a>
                        <ul>
                            <li>
                                <ul>
                                    <li><a href="#Analytics"><span class="toc_number toc_depth_3">3.0.1</span> {{ aiTrans('Analytics') }}</a></li>
                                    <li><a href="#Advertising"><span class="toc_number toc_depth_3">3.0.2</span> {{ aiTrans('Advertising') }}</a></li>
                                    <li><a href="#Behavioral_Remarketing"><span class="toc_number toc_depth_3">3.0.3</span> {{ aiTrans('Behavioral Remarketing') }}</a></li>
                                    <li><a href="#Links_To_Other_Sites"><span class="toc_number toc_depth_3">3.0.4</span> {{ aiTrans('Links To Other Sites') }}</a></li>
                                    <li><a href="#Children8217s_Privacy"><span class="toc_number toc_depth_3">3.0.5</span> {{ aiTrans('Children’s Privacy') }}</a></li>
                                    <li><a href="#Changes_To_This_Privacy_Policy"><span class="toc_number toc_depth_3">3.0.6</span> {{ aiTrans('Changes To This Privacy Policy') }}</a></li>
                                    <li><a href="#Contact_Us"><span class="toc_number toc_depth_3">3.0.7</span> {{ aiTrans('Contact Us') }}</a></li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
            <h4><span id="Definitions">{{ aiTrans('Definitions') }}</span></h4>
            <h5><span id="Service">{{ aiTrans('Service') }}</span></h5>
            <p>{{ aiTrans('Service is the') }} <span class="u">{{$website_title}}</span> {{ aiTrans('website operated by') }} <span class="b">{{ aiTrans('Provider') }}</span></p>
            <h4><span id="Personal_Data">{{ aiTrans('Personal Data') }}</span></h4>
            <p>{{ aiTrans('Personal Data means data about a living individual who can be identified from those data (or from those and other information either in our possession or likely to come into our possession).') }}</p>
            <h4><span id="Usage_Data">{{ aiTrans('Usage Data') }}</span></h4>
            <p>{{ aiTrans('Usage Data is data collected automatically either generated by the use of the Service or from the Service infrastructure itself (for example, the duration of a page visit).') }}</p>
            <h4><span id="Cookies">{{ aiTrans('Cookies') }}</span></h4>
            <p>{{ aiTrans('Cookies are small pieces of data stored on your device (computer or mobile device).') }}</p>
            <h4><span id="Data_Controller">{{ aiTrans('Data Controller') }}</span></h4>
            <p>{{ aiTrans('Data Controller means the natural or legal person who (either alone or jointly or in common with other persons) determines the purposes for which and the manner in which any personal information are, or are to be, processed. For the purpose of this Privacy Policy, we are a Data Controller of your Personal Data.') }}</p>
            <h4><span id="Data_Processors_or_Service_Providers">{{ aiTrans('Data Processors (or Service Providers)') }}</span></h4>
            <p>{{ aiTrans('Data Processor (or Service Provider) means any natural or legal person who processes the data on behalf of the Data Controller. We may use the services of various Service Providers in order to process your data more effectively.') }}</p>
            <h4><span id="Data_Subject_or_User">{{ aiTrans('Data Subject (or User)') }}</span></h4>
            <p>{{ aiTrans('Data Subject is any living individual who is using our Service and is the subject of Personal Data.') }}</p>
            <h2><span id="Information_Collection_And_Use">{{ aiTrans('Information Collection And Use') }}</span></h2>
            <p>{{ aiTrans('We collect several different types of information for various purposes to provide and improve our Service to you.') }}</p>
            <h4><span id="Types_of_Data_Collected">{{ aiTrans('Types of Data Collected') }}</span></h4>
            <h4><span id="Personal_Data-2">{{ aiTrans('Personal Data') }}</span></h4>
            <p>{{ aiTrans('While using our Service, we may ask you to provide us with certain personally identifiable information that can be used to contact or identify you (“Personal Data”). Personally identifiable information may include, but is not limited to:') }}</p>
            <ul>
                <li>{{ aiTrans('Email address') }}</li>
                <li>{{ aiTrans('First name and last name') }}</li>
                <li>{{ aiTrans('Phone number') }}</li>
                <li>{{ aiTrans('Address, State, Province, ZIP/Postal code, City') }}</li>
                <li>{{ aiTrans('Cookies and Usage Data') }}</li>
            </ul>
            <p>{{ aiTrans('We may use your Personal Data to contact you with newsletters, marketing or promotional materials and other information that may be of interest to you. You may opt out of receiving any, or all, of these communications from us by following the unsubscribe link or instructions provided in any email we send or by contacting us.') }}</p>
            <h4><span id="Usage_Data-2">{{ aiTrans('Usage Data') }}</span></h4>
            <p>{{ aiTrans('We may also collect information how the Service is accessed and used (“Usage Data”). This Usage Data may include information such as your computer’s Internet Protocol address (e.g. IP address), browser type, browser version, the pages of our Service that you visit, the time and date of your visit, the time spent on those pages, unique device identifiers and other diagnostic data.') }}</p>
            <h4><span id="Tracking_Cookies_Data">{{ aiTrans('Tracking Cookies Data') }}</span></h4>
            <p>{{ aiTrans('We use cookies and similar tracking technologies to track the activity on our Service and hold certain information.') }}</p>
            <p>{{ aiTrans('Cookies are files with small amount of data which may include an anonymous unique identifier. Cookies are sent to your browser from a website and stored on your device. Tracking technologies also used are beacons, tags, and scripts to collect and track information and to improve and analyze our Service.') }}</p>
            <p>{{ aiTrans('You can instruct your browser to refuse all cookies or to indicate when a cookie is being sent. However, if you do not accept cookies, you may not be able to use some portions of our Service.') }}</p>
            <p>{{ aiTrans('Examples of Cookies we use:') }}</p>
            <ul>
                <li><strong>{{ aiTrans('Session Cookies.') }}</strong> {{ aiTrans('We use Session Cookies to operate our Service.') }}</li>
                <li><strong>{{ aiTrans('Preference Cookies.') }}</strong> {{ aiTrans('We use Preference Cookies to remember your preferences and various settings.') }}</li>
                <li><strong>{{ aiTrans('Security Cookies.') }}</strong> {{ aiTrans('We use Security Cookies for security purposes.') }}</li>
                <li><strong>{{ aiTrans('Advertising Cookies.') }}</strong> {{ aiTrans('Advertising Cookies are used to serve you with advertisements that may be relevant to you and your interests.') }}</li>
            </ul>
            <h4><span id="Use_of_Data">{{ aiTrans('Use of Data') }}</span></h4>
            <p><span class="b">{{ aiTrans('Provider') }}</span> {{ aiTrans('uses the collected data for various purposes:') }}</p>
            <ul>
                <li>{{ aiTrans('To provide and maintain our Service') }}</li>
                <li>{{ aiTrans('To notify you about changes to our Service') }}</li>
                <li>{{ aiTrans('To allow you to participate in interactive features of our Service when you choose to do so') }}</li>
                <li>{{ aiTrans('To provide customer support') }}</li>
                <li>{{ aiTrans('To gather analysis or valuable information so that we can improve our Service') }}</li>
                <li>{{ aiTrans('To monitor the usage of our Service') }}</li>
                <li>{{ aiTrans('To detect, prevent and address technical issues') }}</li>
                <li>{{ aiTrans('To provide you with news, special offers and general information about other goods, services and events which we offer that are similar to those that you have already purchased or enquired about unless you have opted not to receive such information') }}</li>
            </ul>
            <h4><span id="Legal_Basis_for_Processing_Personal_Data_Under_General_Data_Protection_Regulation_GDPR">{{ aiTrans('Legal Basis for Processing Personal Data Under General Data Protection Regulation (GDPR)') }}</span></h4>
            <p>{{ aiTrans('If you are from the European Economic Area (EEA),') }} <span class="b">{{ aiTrans('Provider') }}</span> {{ aiTrans('legal basis for collecting and using the personal information described in this Privacy Policy depends on the Personal Data we collect and the specific context in which we collect it.') }}</p>
            <p><span class="b">{{ aiTrans('Provider') }}</span> {{ aiTrans('may process your Personal Data because:') }}</p>
            <ul>
                <li>{{ aiTrans('We need to perform a contract with you') }}</li>
                <li>{{ aiTrans('You have given us permission to do so') }}</li>
                <li>{{ aiTrans('The processing is in our legitimate interests and it’s not overridden by your rights') }}</li>
                <li>{{ aiTrans('To comply with the law') }}</li>
            </ul>
            <h4><span id="Retention_of_Data">{{ aiTrans('Retention of Data') }}</span></h4>
            <p><span class="b">{{ aiTrans('Provider') }}</span> {{ aiTrans('will retain your Personal Data only for as long as is necessary for the purposes set out in this Privacy Policy. We will retain and use your Personal Data to the extent necessary to comply with our legal obligations (for example, if we are required to retain your data to comply with applicable laws), resolve disputes, and enforce our legal agreements and policies.') }}</p>
            <p><span class="b">{{ aiTrans('Provider') }}</span> {{ aiTrans('will also retain Usage Data for internal analysis purposes. Usage Data is generally retained for a shorter period of time, except when this data is used to strengthen the security or to improve the functionality of our Service, or we are legally obligated to retain this data for longer time periods.') }}</p>
            <h2><span id="Transfer_Of_Data">{{ aiTrans('Transfer Of Data') }}</span></h2>
            <p>{{ aiTrans('Your information, including Personal Data, may be transferred to — and maintained on — computers located outside of your state, province, country or other governmental jurisdiction where the data protection laws may differ than those from your jurisdiction.') }}</p>
            <p>{{ aiTrans('If you are located outside Bulgaria and choose to provide information to us, please note that we transfer the data, including Personal Data, to Bulgaria and process it there.') }}</p>
            <p>{{ aiTrans('Your consent to this Privacy Policy followed by your submission of such information represents your agreement to that transfer.') }}</p>
            <p><span class="b">{{ aiTrans('Provider') }}</span> {{ aiTrans('will take all steps reasonably necessary to ensure that your data is treated securely and in accordance with this Privacy Policy and no transfer of your Personal Data will take place to an organization or a country unless there are adequate controls in place including the security of your data and other personal information.') }}</p>
            <h4><span id="Disclosure_Of_Data">{{ aiTrans('Disclosure Of Data') }}</span></h4>
            <h5><span id="Business_Transaction">{{ aiTrans('Business Transaction') }}</span></h5>
            <p>{{ aiTrans('If') }} <span class="b">{{ aiTrans('Provider') }}</span> {{ aiTrans('is involved in a merger, acquisition or asset sale, your Personal Data may be transferred. We will provide notice before your Personal Data is transferred and becomes subject to a different Privacy Policy.') }}</p>
            <h4><span id="Legal_Requirements">{{ aiTrans('Legal Requirements') }}</span></h4>
            <p><span class="b">{{ aiTrans('Provider') }}</span> {{ aiTrans('may disclose your Personal Data in the good faith belief that such action is necessary to:') }}</p>
            <ul>
                <li>{{ aiTrans('To comply with a legal obligation') }}</li>
                <li>{{ aiTrans('To protect and defend the rights or property of') }} <span class="b">{{ aiTrans('Provider') }}</span></li>
                <li>{{ aiTrans('To prevent or investigate possible wrongdoing in connection with the Service') }}</li>
                <li>{{ aiTrans('To protect the personal safety of users of the Service or the public') }}</li>
                <li>{{ aiTrans('To protect against legal liability') }}</li>
            </ul>
            <h4><span id="Security_Of_Data">{{ aiTrans('Security Of Data') }}</span></h4>
            <p>{{ aiTrans('The security of your data is important to us, but remember that no method of transmission over the Internet, or method of electronic storage is 100% secure. While we strive to use commercially acceptable means to protect your Personal Data, we cannot guarantee its absolute security.') }}</p>
            <h4><span id="Your_Data_Protection_Rights_Under_General_Data_Protection_Regulation_GDPR">{{ aiTrans('Your Data Protection Rights Under General Data Protection Regulation (GDPR)') }}</span></h4>
            <p>{{ aiTrans('If you are a resident of the European Economic Area (EEA), you have certain data protection rights.') }} <span class="b">{{ aiTrans('Provider') }}</span> {{ aiTrans('aims to take reasonable steps to allow you to correct, amend, delete, or limit the use of your Personal Data.') }}</p>
            <p>{{ aiTrans('If you wish to be informed what Personal Data we hold about you and if you want it to be removed from our systems, please contact us.') }}</p>
            <p>{{ aiTrans('In certain circumstances, you have the following data protection rights:') }}</p>
            <p><strong>{{ aiTrans('The right to access, update or to delete the information we have on you.') }}</strong> {{ aiTrans('Whenever made possible, you can access, update or request deletion of your Personal Data directly within your account settings section. If you are unable to perform these actions yourself, please contact us to assist you.') }}<br> <strong>{{ aiTrans('The right of rectification.') }}</strong> {{ aiTrans('You have the right to have your information rectified if that information is inaccurate or incomplete.') }}<br> <strong>{{ aiTrans('The right to object.') }}</strong> {{ aiTrans('You have the right to object to our processing of your Personal Data.') }}<br> <strong>{{ aiTrans('The right of restriction.') }}</strong> {{ aiTrans('You have the right to request that we restrict the processing of your personal information.') }}<br> <strong>{{ aiTrans('The right to data portability.') }}</strong> {{ aiTrans('You have the right to be provided with a copy of the information we have on you in a structured, machine-readable and commonly used format.') }}<br> <strong>{{ aiTrans('The right to withdraw consent.') }}</strong> {{ aiTrans('You also have the right to withdraw your consent at any time where') }} <span class="b">{{ aiTrans('Provider') }}</span> {{ aiTrans('relied on your consent to process your personal information.') }}</p>
            <p>{{ aiTrans('Please note that we may ask you to verify your identity before responding to such requests.') }}</p>
            <p>{{ aiTrans('You have the right to complain to a Data Protection Authority about our collection and use of your Personal Data. For more information, please contact your local data protection authority in the European Economic Area (EEA).') }}</p>
            <h2><span id="Service_Providers">{{ aiTrans('Service Providers') }}</span></h2>
            <p>{{ aiTrans('We may employ third party companies and individuals to facilitate our Service (“Service Providers”), to provide the Service on our behalf, to perform Service-related services or to assist us in analyzing how our Service is used.') }}</p>
            <p>{{ aiTrans('These third parties have access to your Personal Data only to perform these tasks on our behalf and are obligated not to disclose or use it for any other purpose.') }}</p>
            <h4><span id="Analytics">{{ aiTrans('Analytics') }}</span></h4>
            <p>{{ aiTrans('We may use third-party Service Providers to monitor and analyze the use of our Service.') }}</p>
            <p><strong>{{ aiTrans('Google Analytics') }}</strong><br> {{ aiTrans('Google Analytics is a web analytics service offered by Google that tracks and reports website traffic. Google uses the data collected to track and monitor the use of our Service. This data is shared with other Google services. Google may use the collected data to contextualize and personalize the ads of its own advertising network. You can opt-out of having made your activity on the Service available to Google Analytics by installing the Google Analytics opt-out browser add-on. The add-on prevents the Google Analytics JavaScript (ga.js, analytics.js, and dc.js) from sharing information with Google Analytics about visits activity. For more information on the privacy practices of Google, please visit the Google Privacy Terms web page:') }} <a href="{{route('home',$country)}}" target="_blank" rel="noopener">{{ aiTrans('http://www.google.com/intl/en/policies/privacy/') }}</a></p>
            <h4><span id="Advertising">{{ aiTrans('Advertising') }}</span></h4>
            <p>{{ aiTrans('We may use third-party Service Providers to show advertisements to you to help support and maintain our Service.') }}</p>
            <p><strong>{{ aiTrans('Google AdSense DoubleClick Cookie') }}</strong><br> {{ aiTrans('Google, as a third party vendor, uses cookies to serve ads on our Service. Google’s use of the DoubleClick cookie enables it and its partners to serve ads to our users based on their visit to our Service or other websites on the Internet. You may opt out of the use of the DoubleClick Cookie for interest-based advertising by visiting the Google Ads Settings web page:') }} <a href="{{route('home',$country)}}" target="_blank" rel="noopener">http://www.google.com/ads/preferences</a></p>
            <h4><span id="Behavioral_Remarketing">{{ aiTrans('Behavioral Remarketing') }}</span></h4>
            <p><span class="b">{{ aiTrans('Provider') }}</span> {{ aiTrans('uses remarketing services to advertise on third party websites to you after you visited our Service. We and our third-party vendors use cookies to inform, optimize and serve ads based on your past visits to our Service.') }}</p>
            <p><strong>{{ aiTrans('Google AdWords') }}</strong><br> {{ aiTrans('Google AdWords remarketing service is provided by Google Inc. You can opt-out of Google Analytics for Display Advertising and customize the Google Display Network ads by visiting the Google Ads Settings page:') }} <a href="http://www.google.com/settings/ads" target="_blank" rel="noopener">{{ aiTrans('http://www.google.com/settings/ads') }}</a> {{ aiTrans('Google also recommends installing the Google Analytics Opt-out Browser Add-on –') }} <a href="https://tools.google.com/dlpage/gaoptout" target="_blank" rel="noopener">https://tools.google.com/dlpage/gaoptout</a> – {{ aiTrans('for your web browser. Google Analytics Opt-out Browser Add-on provides visitors with the ability to prevent their data from being collected and used by Google Analytics. For more information on the privacy practices of Google, please visit the Google Privacy Terms web page:') }} <a href="https://www.google.com/intl/en/policies/privacy/" target="_blank" rel="noopener">http://www.google.com/intl/en/policies/privacy</a></p>
            <p><strong>{{ aiTrans('Facebook') }}</strong><br> {{ aiTrans('Facebook remarketing service is provided by Facebook Inc. You can learn more about interest-based advertising from Facebook by visiting this page:') }} <a href="{{route('home',$country)}}" target="_blank" rel="noopener">{{route('home',$country)}}</a> {{ aiTrans('To opt-out from Facebook’s interest-based ads follow these instructions from Facebook:') }} <a href="{{route('home',$country)}}" target="_blank" rel="noopener">{{ aiTrans('https://www.facebook.com/help/568137493302217') }}</a> {{ aiTrans('Facebook adheres to the Self-Regulatory Principles for Online Behavioral Advertising established by the Digital Advertising Alliance. You can also opt-out from Facebook and other participating companies through the Digital Advertising Alliance in the USA') }} <a href="{{route('home',$country)}}" target="_blank" rel="noopener">{{route('home',$country)}}</a>, {{ aiTrans('the Digital Advertising Alliance of Canada in Canada') }} <a href="{{route('home',$country)}}" target="_blank" rel="noopener">{{route('home',$country)}}</a> {{ aiTrans('or the European Interactive Digital Advertising Alliance in Europe') }} <a href="{{route('home',$country)}}" target="_blank" rel="noopener">{{ route('home',$country)}} </a>, {{ aiTrans('or opt-out using your mobile device settings. For more information on the privacy practices of Facebook, please visit Facebook’s Data Policy:') }} <a href="{{route('home',$country)}}" target="_blank" rel="noopener">{{route('home',$country)}}</a></p>
            <h4><span id="Links_To_Other_Sites">{{ aiTrans('Links To Other Sites') }}</span></h4>
            <p>{{ aiTrans('Our Service may contain links to other sites that are not operated by us. If you click on a third party link, you will be directed to that third party’s site. We strongly advise you to review the Privacy Policy of every site you visit.') }}</p>
            <p>{{ aiTrans('We have no control over and assume no responsibility for the content, privacy policies or practices of any third party sites or services.') }}</p>
            <h4><span id="Children8217s_Privacy">{{ aiTrans('Children’s Privacy') }}</span></h4>
            <p>{{ aiTrans('Our Service does not address anyone under the age of 18 (“Children”).') }}</p>
            <p>{{ aiTrans('We do not knowingly collect personally identifiable information from anyone under the age of 18. If you are a parent or guardian and you are aware that your Children has provided us with Personal Data, please contact us. If we become aware that we have collected Personal Data from children without verification of parental consent, we take steps to remove that information from our servers.') }}</p>
            <h4><span id="Changes_To_This_Privacy_Policy">{{ aiTrans('Changes To This Privacy Policy') }}</span></h4>
            <p>{{ aiTrans('We may update our Privacy Policy from time to time. We will notify you of any changes by posting the new Privacy Policy on this page.') }}</p>
            <p>{{ aiTrans('We will let you know via email and/or a prominent notice on our Service, prior to the change becoming effective and update the “effective date” at the top of this Privacy Policy.') }}</p>
            <p>{{ aiTrans('You are advised to review this Privacy Policy periodically for any changes. Changes to this Privacy Policy are effective when they are posted on this page.') }}</p>
            <h4><span id="Contact_Us">{{ aiTrans('Contact Us') }}</span></h4>
            <p>{{ aiTrans('If you have any questions about this Privacy Policy, please contact us by email.') }}</p>
        </main>
    </div>
@endsection
