@extends('layouts.app')
@push('meta')
    <title>{{ "$website_title $website_name | Kryptoměna: Ověřená obchodní platforma" }}</title>
    <meta name="description" content="{{ "$website_title Otevřete si cestu k úspěchu v obchodování s kryptoměnami na naší uznávané platformě" }}" />
@endpush
@section('content')
    <section class="banner py-5">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <h1 class="display-4 fw-bold mb-4">{{ $website_title }}</h1>
                    <div class="fs-4 mb-5">
                        <h2><strong class="change-by-command">{{ "$website_title Jak porazit konkurenci efektivním investováním do kryptoměn?" }}</strong>
                        </h2>
                        <p><strong class="change-by-command">{{ "$website_title Odměněno: Tajemství efektivních investic do kryptoměn" }}</strong>
                        </p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="shadow position-relative banner-form form-height">
                        @include('frontend.cs.components.form')
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-md-8">
                    <h2 class="display-5 fw-bold mb-4">
                        {{ aiTrans(
                            'Co je [website_title]?',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h2>
                    <div>
                        <p><strong>
                            {{ aiTrans(
                                'Představte si platformu [website_title] jako sofistikovaného prostředníka, maják
                                pomoci, který spojuje ty, kteří touží po znalostech, s těmi, kdo se zabývají investičním
                                vzděláváním. Umění investování přesahuje zjednodušující akt prosévání čísel a zkoumání
                                grafů.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </strong></p>
                        <p>{{aiTrans('Abychom skutečně pochopili podstatu investičních strategií, musíme rozluštit složitost dynamiky
                            trhu, katalyzátory cenových pohybů a dominové efekty mezinárodních událostí na nesčetné sektory.
                            Mnohým se to může zdát jako nepřekonatelná výzva.')}}</p>
                        <p>
                            {{ aiTrans(
                                'Přesto je to právě v této aréně, kde [website_title] září a navazuje spojení s obratnými
                            pedagogy, kteří vrhají světlo na tato mnohostranná témata. Pro investiční nadšence, kteří touží
                            rozebrat záhadu trhů, je tento portál vaším přístupovým bodem ke vzdělávacímu obsahu na míru.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            
                        </p>
                        <p>
                            {{ aiTrans(
                                'Poslání je jasné: demokratizovat znalosti a zajistit, aby se jednotlivci ze všech společenských
                            vrstev mohli napojit na pramen vhledu. Oficiální webové stránky [website_title] jsou ve
                            svém jádru erudovaným spojencem, který nováčkům i veteránům představuje dodavatele investiční
                            moudrosti.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                        <p>
                            {{ aiTrans(
                                'Aplikace [website_title] navíc prosazuje nepostradatelnou roli vzdělávání v obrovské mořské
                            krajině investičních možností. V oblasti, kde jsou prvořadá včasná a dobře informovaná
                            rozhodnutí, je na jednotlivcích, aby investovali do svého intelektuálního kapitálu
                            prostřednictvím pečlivého učení a analytického přemítání.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                        <p>
                            {{ aiTrans(
                                'Vzdělávání je kompasem na této odyseji a recenze [website_title] ohlašuje závazek vést
                            uživatele k prémiovým vzdělávacím nástrojům. Bez ohledu na to, zda jste na začátku své
                            investiční cesty nebo usilujete o zvýšení odbornosti, [website_title] je připravena vás
                            navigovat k pedagogům, kteří rezonují s vašimi jedinečnými vzdělávacími cíli.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                    </div>
                    <div class="text-md-start text-center mt-3 mt-md-4 mb-4 mb-md-0">
                        <button class="show-modal btn  text-white btn-secondary btn-lg shadow-lg px-3 px-md-5 fs-4">{{aiTrans('Víc se uč')}}</button>
                    </div>
                </div>
                <div class="col-md-4 d-flex align-items-center">
                    <picture>
                        <source
                            srcset="{{ asset('frontend/assets/cs/dist') }}/images/459_459__459_66a384fe3e21d_Quantum-Rox.webp"
                            type="image/webp">
                        <source srcset="{{ asset('frontend/assets/cs/dist') }}/images/_459_66a384fe3e21d_Quantum-Rox.jpeg"
                            type="image/jpeg">
                        <img src="{{ asset('frontend/assets/cs/dist') }}/images/_459_66a384fe3e21d_Quantum-Rox.jpeg"
                            loading="lazy" width="459" height="459" alt="">
                    </picture>
                </div>
            </div>
        </div>
    </section>

    <section class="py-5 bg-light">
        <div class="container mb-5">
            <h2 class="display-5 fw-bold mb-4 text-center">
                {{ aiTrans(
                    'Odkrywanie tajemnicy [website_title]',
                    $locale,
                    ['website_title' => $website_title],
                ) }}
                </h2>
            <div class="text-center">
                <p><strong>
                    {{ aiTrans(
                        'Rozpocznij wszechogarniającą odyseję edukacyjną z [website_title], odkrywając
                        wieloaspektowe
                        królestwa inwestycji. Ta inicjatywa ma na celu zwiększenie Twojej przenikliwości, rzucając
                        światło na subtelne, ale istotne zawiłości nieodłącznie związane z domeną inwestycji.',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </strong>
                </p>
                <p><strong>
                    {{ aiTrans(
                        'Dzięki niezłomnemu skupieniu się na oświeceniu, [website_title] zapewnia, że opanujesz
                        podstawowe
                        elementy, zanim zrobisz postęp w swojej finansowej podróży. ',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </strong></p>
            </div>
        </div>

        <div class="container">
            <div class="row">
                <div class="col-md-4 d-flex align-items-stretch mb-5">
                    <div class="card shadow rounded-3 border-0 border-bottom border-4 border-secondary">
                        <picture>
                            <source
                                srcset="{{ asset('frontend/assets/cs/dist') }}/images/330_449__473_659eb2e974365_img-1.webp"
                                type="image/webp">
                            <source srcset="{{ asset('frontend/assets/cs/dist') }}/images/_473_659eb2e974365_img-1.jpg"
                                type="image/jpeg">
                            <img src="{{ asset('frontend/assets/cs/dist') }}/images/_473_659eb2e974365_img-1.jpg"
                                style="max-height: 320px" loading="lazy" class="w-100 shadow-lg" width="449"
                                height="330" alt="">
                        </picture>
                        <div class="card-body">
                            <h3 class="card-title">{{aiTrans('Razení cest k investičnímu vzdělávání')}}</h3>
                            <input type="checkbox" id="parameter-checkbox0">
                            <div class="card-text">
                                <p>
                                    {{ aiTrans(
                                        '✔ Jako kanál pro finanční osvícení [website_title] překlenuje propast mezi
                                    nadšenými studenty a váženými společnostmi, které jsou vybaveny k předávání kritické
                                    investiční moudrosti.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                    </p>
                                <p>
                                    {{ aiTrans(
                                        '✔ Hlavním cílem [website_title] je učinit získávání investičních znalostí všeobecně
                                    dostupným a odstranit bariéry, jako jsou náklady nebo jazykové překážky.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                    </p>
                                <p>
                                    {{ aiTrans(
                                        '✔ [website_title] se zaměřuje na důležitost posílení postavení ve vzdělávání a
                                    zdůrazňuje nutnost získat komplexní porozumění, než se ponoříte do složitého
                                    investičního prostředí.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                    </p>
                                <label for="parameter-checkbox0" class="text-decoration-underline fw-bold fs-5">{{aiTrans('Přečtěte si vše')}}</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 d-flex align-items-stretch mb-5">
                    <div class="card shadow rounded-3 border-0 border-bottom border-4 border-secondary">
                        <picture>
                            <source
                                srcset="{{ asset('frontend/assets/cs/dist') }}/images/349_449__473_659eb30360ca5_img-2.webp"
                                type="image/webp">
                            <source srcset="{{ asset('frontend/assets/cs/dist') }}/images/_473_659eb30360ca5_img-2.jpg"
                                type="image/jpeg">
                            <img src="{{ asset('frontend/assets/cs/dist') }}/images/_473_659eb30360ca5_img-2.jpg"
                                style="max-height: 320px" loading="lazy" class="w-100 shadow-lg" width="449"
                                height="349" alt="">
                        </picture>
                        <div class="card-body">
                            <h3 class="card-title">{{aiTrans('Odemykání potenciálu prostřednictvím strukturovaného učení')}}</h3>
                            <input type="checkbox" id="parameter-checkbox1">
                            <div class="card-text">
                                <p>✔️ {{aiTrans('Interakce s akademickými subjekty prostřednictvím')}} <span>{{ $website_title }}</span>
                                    {{aiTrans('slibuje komplexní a metodickou taktiku pro zvládnutí nuancí investičního vzdělávání.')}}</p>
                                <p>✔️ {{aiTrans('Využití moudrosti dokonalých odborníků prostřednictvím')}}
                                    <span>{{ $website_title }}</span> {{aiTrans('Rozptýlí nejednoznačnost a i z těch nejspletitějších témat se stanou stravitelné vhledy.')}}</p>
                                <p>✔️ {{aiTrans('Řízená vzdělávací cesta na')}} <span>{{ $website_title }}</span> {{aiTrans('Platforma pokládá základy a zajišťuje, že pevné uchopení základních principů předchází průzkumu sofistikovanějších finančních terénů.')}}</p>
                                <label for="parameter-checkbox1" class="text-decoration-underline fw-bold fs-5">{{aiTrans('Přečtěte si vše')}}</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 d-flex align-items-stretch mb-5">
                    <div class="card shadow rounded-3 border-0 border-bottom border-4 border-secondary">
                        <picture>
                            <source
                                srcset="{{ asset('frontend/assets/cs/dist') }}/images/313_449__473_659eb31ade698_img-3.webp"
                                type="image/webp">
                            <source srcset="{{ asset('frontend/assets/cs/dist') }}/images/_473_659eb31ade698_img-3.jpg"
                                type="image/jpeg">
                            <img src="{{ asset('frontend/assets/cs/dist') }}/images/_473_659eb31ade698_img-3.jpg"
                                style="max-height: 320px" loading="lazy" class="w-100 shadow-lg" width="449"
                                height="313" alt="">
                        </picture>
                        <div class="card-body">
                            <h3 class="card-title">{{aiTrans('Vydejte se na misi založenou na znalostech')}}</h3>
                            <input type="checkbox" id="parameter-checkbox2">
                            <div class="card-text">
                                <p><strong>✔️</strong> {{aiTrans('Ponořit se do investic znamená ponořit se do bohaté tapiserie pohybu
                                    trhů a fiskálních transformací – což je cesta, na kterou by se všichni měli vydat s
                                    živým zájmem.')}}</p>
                                <p><strong>✔️</strong>
                                    {{ aiTrans(
                                        'S [website_title] jako průvodcem získáte vhled do dekódování
                                    těchto složitých příběhů tím, že překlenete propast s předními vzdělávacími subjekty.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                    
                                </p>
                                <label for="parameter-checkbox2" class="text-decoration-underline fw-bold fs-5">{{aiTrans('Přečtěte si vše')}}</label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="text-center mt-3 mt-md-4">
                <button class="show-modal btn  text-white btn-primary btn-lg text-uppercase shadow-lg px-3 px-md-5 fs-4">
                    {{aiTrans('Zjistit více')}}
                </button>
            </div>
        </div>
    </section>

    <section class="py-5">
        <div class="container mb-5">
            <div class="row">
                <div class="col-md-10">
                    <h2 class="display-5 fw-bold mb-4">{{aiTrans('Odhalení jádra investičního vzdělávání')}}</h2>
                    <meta charset="UTF-8">
                    <h3>
                        {{ aiTrans(
                            'Investiční průvodce - [website_title]',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h3>
                    <meta name="description"
                        content="
                        {{ aiTrans(
                            'Navigate the investment landscape with [website_title], your ultimate guide to mastering the market in 2024.',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        ">
                    <meta name="keywords"
                        content="
                        {{ aiTrans(
                            '[website_title], 2024, [website_title], [website_title] app, [website_title] review, [website_title] platform, [website_title] official website',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        ">
                    <section>
                        <p>{{aiTrans('Ponořit se do investiční oblasti vyžaduje bystré rozhodování, které je ovlivněno nesčetnými
                            faktory. Člověk by mohl zhodnotit hodnotu společnosti, zvážit misky vah mezi rizikem a výnosem
                            nebo držet krok s celosvětovými událostmi, které formují puls trhu – což je pro mnohé impozantní
                            výzva.')}}</p>
                        <p>
                            {{ aiTrans(
                                'Vstupte do [website_title], vašeho majáku v bouřlivém moři investic, který se zavázal
                                demystifikovat komplex pro nováčky. Tento portál překlenuje propast mezi nováčky a zkušenými
                                subjekty a poskytuje přístup k arzenálu zdrojů a pedagogického obsahu.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                        <p>
                            {{ aiTrans(
                                'Ve spojenectví se školními orgány otevírá [website_title] uživatelům bránu k získávání
                                poznatků od stálic v oboru. Ať už se pustíte do inauguračního finančního podniku nebo zlepšíte
                                svou prozíravost, podpoří vaši cestu za poznáním a proženete se spletitými koridory investic.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            
                        </p>
                        <p>
                            {{ aiTrans(
                                'Investiční nástroje jsou rozmanité a mnohostranné, z nichž každý podléhá svému vlastnímu souboru
                                zásad a toku. Investiční spektrum, které zahrnuje akcie, dluhopisy, nemovitosti a suroviny, je
                                široké a matoucí. Platforma [website_title] zakotví jako váš navigátor, dešifruje tyto
                                možnosti a mapuje kurz obrovským oceánem dat.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                    </section>
                </div>
            </div>
        </div>

        <div class="container">
            <div class="row">
                <div class="col-md-6  mb-4">
                    <div class="h-100 card border-0 shadow-lg border border-4 border-bottom border-primary">
                        <div class="card-body p-4">
                            <h3 class="fw-bold text-uppercase">{{aiTrans('Základ je základ zásadní')}}</h3>
                            <input type="checkbox" id="howworks-checkbox0">
                            <div>
                                <p>{{aiTrans('Podobně jako robustní budova závisí na pevných základech, pochopení složitosti investic
                                    závisí na pevném pochopení elementárních principů.')}}</p>
                                <p>
                                    {{ aiTrans(
                                        '[website_title] klade velký důraz na tuto základní vzdělávací fázi a nabízí
                                        komplexní slabikář pro nováčky. Toto základní porozumění navíc vybavuje jednotlivce k
                                        tomu, aby dovedně vytyčili svůj směr ve spletitém investičním prostředí a zajistili, že
                                        každé rozhodnutí bude učiněno s jasností a vhledem.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                    </p>
                                <label for="howworks-checkbox0" class="text-decoration-underline fw-bold fs-5">Přečtěte si
                                    vše</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6  mb-4">
                    <div class="h-100 card border-0 shadow-lg border border-4 border-bottom border-primary">
                        <div class="card-body p-4">
                            <h3 class="fw-bold text-uppercase">{{aiTrans('Za hranicemi základů')}}</h3>
                            <input type="checkbox" id="howworks-checkbox1">
                            <div>
                                <p>{{aiTrans('Po zvládnutí základních základů se člověk vydává na cestu po složitějších územích vědění.')}}
                                </p>
                                <p>
                                    {{ aiTrans(
                                        'Investiční prostředí je rozsáhlé a mnohostranné a [website_title] slouží jako
                                        prostředník pro tuto hloubkovou exkurzi. Organizuje příležitosti pro nadšence, aby
                                        prošli nesčetnými aspekty investic, dešifrovali dynamiku trhů a rozpoznali vznikající
                                        trendy. S pomocí [website_title] mohou být i složitější segmenty srozumitelnější a
                                        přehlednější.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                    </p>
                                <label for="howworks-checkbox1" class="text-decoration-underline fw-bold fs-5">{{aiTrans('Přečtěte si vše')}}</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6  mb-4">
                    <div class="h-100 card border-0 shadow-lg border border-4 border-bottom border-primary">
                        <div class="card-body p-4">
                            <h3 class="fw-bold text-uppercase">{{aiTrans('Zůstaňte informováni')}}</h3>
                            <input type="checkbox" id="howworks-checkbox2">
                            <div>
                                <p>{{aiTrans('Svět financí je v neustálém pohybu. Nové vhledy, transformace a pokroky se objevují s
                                    každým východem slunce.')}}</p>
                                <p>
                                    {{ aiTrans(
                                        'S neochvějným závazkem k měně ve znalostech se tento portál zavazuje vyzbrojit své
                                        uživatele nejmodernější moudrostí. [website_title] spojuje své publikum s nově
                                        raženým vzdělávacím obsahem a zajišťuje, že každý jednotlivec je vybaven k tomu, aby
                                        mohl sebevědomě kráčet neustále se měnícím terénem investičního prostředí.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                    </p>
                                <label for="howworks-checkbox2" class="text-decoration-underline fw-bold fs-5">{{aiTrans('Přečtěte si vše')}}</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6  mb-4">
                    <div class="h-100 card border-0 shadow-lg border border-4 border-bottom border-primary">
                        <div class="card-body p-4">
                            <h3 class="fw-bold text-uppercase">
                                {{ aiTrans(
                                    'Odborné poradenství od [website_title]',
                                    $locale,
                                    ['website_title' => $website_title],
                                ) }}
                                </h3>
                            <input type="checkbox" id="howworks-checkbox3">
                            <div>
                                <p>{{aiTrans('Vydat se na cestu neprobádanými oblastmi se s obratným navigátorem po boku stane méně skličujícím.')}}</p>
                                <p>
                                    {{ aiTrans(
                                        '[website_title] ztělesňuje tento étos a překlenuje propast mezi těmi, kteří žízní
                                        po vědění, a prozíravými mentory, kteří prošlapávali cestu dříve. Tito znalci odborných
                                        znalostí přinášejí pokladnici důvtipu a postřehu a poskytují holistický a nuancovaný
                                        přehled o investičních strategiích.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                    </p>
                                <label for="howworks-checkbox3" class="text-decoration-underline fw-bold fs-5">{{aiTrans('Přečtěte si vše')}}</label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="text-center mt-3 mt-md-4">
                <button class="show-modal btn  text-white btn-primary btn-lg text-uppercase shadow-lg px-3 px-md-5 fs-4">
                    {{aiTrans('Víc se uč')}}
                </button>
            </div>
        </div>
    </section>

    <section class="py-5 bg-light">
        <div class="container">
            <div class="row flex-md-row flex-column-reverse ">
                <div class="col-md-4 d-flex align-items-center">
                    <picture>
                        <source
                            srcset="{{ asset('frontend/assets/cs/dist') }}/images/459_459__459_66a385020beab_Quantum Rox.webp"
                            type="image/webp">
                        <source srcset="{{ asset('frontend/assets/cs/dist') }}/images/_459_66a385020beab_Quantum Rox.jpeg"
                            type="image/jpeg">
                        <img src="{{ asset('frontend/assets/cs/dist') }}/images/_459_66a385020beab_Quantum Rox.jpeg"
                            loading="lazy" width="459" height="459" alt="">
                    </picture>
                </div>
                <div class="col-md-8">
                    <input type="checkbox" id="about2-checkbox">
                    <div>
                        <h3>{{aiTrans('Položení základů')}}</h3>
                        <p><strong>{{aiTrans('Ponořit se do investičního světa vyžaduje chytrá rozhodnutí utvářená nesčetnými faktory.
                                Člověk musí zvážit hodnotu společnosti, postavit vedle sebe rizika s potenciálními zisky a
                                bedlivě sledovat mezinárodní události, které ovlivňují trendy na trhu – což je skličující
                                vzdělávací vzestup.')}}</strong></p>
                        <p>
                            {{ aiTrans(
                                '[website_title] se objevuje jako maják uprostřed složitosti, odhodlaný demystifikovat
                                    investiční proces pro nováčky. Tento portál vytváří cesty mezi dychtivými mozky a významnými
                                    subjekty a poskytuje pokladnici relevantních zdrojů a instruktážního obsahu.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                        <p>
                            {{ aiTrans(
                                'Ve spojenectví se scholastickými těly otevírá [website_title] dveře moudrosti, kterou
                                předávají průmysloví mudrci. Vychází vstříc těm, kteří se vydávají na svou investiční odyseu,
                                nebo těm, kteří se chtějí ponořit hlouběji, a podporuje vaši vědeckou činnost a pomáhá vám
                                procházet mnohostranným terénem investiční domény.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                        <p>{{aiTrans('Investičních nástrojů je mnoho a jsou rozmanité, každý má svůj soubor pokynů a tržního chování.
                            Ať už se jedná o akcie, dluhopisy, nemovitosti nebo komodity, nepřeberné množství opcí je
                            rozsáhlé. Web se objevuje jako navigátor, který objasňuje tyto cesty a vede uživatele vírem
                            dat.')}}<!-- if--></p>
                        <p><strong>✔️ {{aiTrans('Vyplnění mezery ve vzdělání v investicích')}}</strong><br>{{aiTrans('Investiční kruhy zahrnují jak
                            důvtipné guru, tak horlivé zasvěcence.')}} </p>
                        <p>{{aiTrans('Zatímco adepti se snaží šířit svou bystrost, začátečníci často čelí přívalu otázek a oparu
                            nejistoty ohledně toho, kde najít důvěryhodné rady a rozeznat autentické informace.')}}</p>
                        <p><strong>✔️ {{aiTrans('Podpora spojení')}}</strong><br>
                            {{ aiTrans(
                                'V tom spočívá účel [website_title]. Funguje jako
                                prostředník, který vytváří vazby mezi těmi, kdo žízní po investičních znalostech, a ctihodnými
                                vzdělávacími zařízeními. ',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                        <p>{{aiTrans('Žádné vyšetřování není příliš primitivní nebo příliš složité, protože platforma se zavazuje
                            zajistit, aby se každý výslech setkal s komplexním vysvětlením, jednoduše tím, že organizuje
                            tyto vzdělávací aliance.')}}</p>
                        <p>
                            {{ aiTrans(
                                'Ať už vás zajímá rozluštění tržních oscilací nebo pochopení nuancí různých investičních tříd,
                                [website_title] se umisťuje jako vaše přední úložiště.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                        <p>
                            {{ aiTrans(
                                'Podstatou [website_title] je poskytnout brány pedagogům, kteří jsou proslulí svou
                                srozumitelností, mistrovským vysvětlováním a pedagogickou zdatností. Tyto akademie dovedně
                                rozebírají složitá investiční témata do stravitelných učení.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                        <p>{{aiTrans('Získat pomoc této platformy znamená pustit se do strukturovaného vzdělávacího úkolu. Nasměruje
                            vás od investičních základů k jeho složitosti a zaručí vaši snadnost a mistrovství v každém
                            okamžiku.')}}</p>
                        <label for="about2-checkbox" class="text-decoration-underline fw-bold fs-5">{{aiTrans('Přečtěte si vše')}}</label>
                    </div>
                    <div class="text-md-start text-center mt-3 mt-md-4 mb-4 mb-md-0">
                        <button class="show-modal btn  text-white btn-secondary btn-lg shadow-lg px-3 px-md-5 fs-4">{{aiTrans('Víc se uč')}}</button>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="py-5">
        <div class="container mb-5">
            <h2 class="display-5 text-center fw-bold mb-4">{{aiTrans('Navigace v investičním prostředí s jistotou')}}</h2>
            <div>
                <p><strong>
                    {{ aiTrans(
                        'Orientace v labyrintu investičního prostředí může být zdrcující úsilí, podobně jako rozluštění
                        složitého grafu neprobádaných území. S [website_title] jako neochvějným kompasem se však
                        odysea touto finanční doménou promění v hladký průchod.',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </strong></p>
                <p><strong>{{aiTrans('Tento portál, který funguje jako kanál ke klíčovým informacím, spolupracuje s váženými
                        vzdělávacími subjekty na odhalování složitosti investování. Vybavuje své uživatele nástroji, které
                        jim umožní procházet mnohostranným světem financí s bezkonkurenčním přehledem a
                        vyrovnaností.')}}</strong></p>
            </div>
        </div>

        <div class="container">
            <div class="row p-4 align-items-center rounded-3 border shadow mb-5">
                <div class="col-lg-7 ">
                    <h3 class=" fw-bold lh-1">{{aiTrans('Budování pevných základů')}}</h3>
                    <input type="checkbox" id="mustknow-checkbox0">
                    <div class="lead">
                        <p>
                            {{ aiTrans(
                                'Stejně jako budování pevného příbytku začíná pevným základem, tak i zahájení vaší cesty k
                                investičnímu vzdělávání na platformě [website_title]. Zajištění pevných základů je
                                klíčové.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                        <label for="mustknow-checkbox0" class="text-decoration-underline fw-bold fs-5">{{aiTrans('Přečtěte si vše')}}</label>
                    </div>
                </div>
                <div class="col-lg-4 offset-lg-1 p-0 overflow-hidden shadow h-100">
                    <picture>
                        <source
                            srcset="{{ asset('frontend/assets/cs/dist') }}/images/330_449__473_659eb34674076_img-4.webp"
                            type="image/webp">
                        <source srcset="{{ asset('frontend/assets/cs/dist') }}/images/_473_659eb34674076_img-4.jpg"
                            type="image/jpeg">
                        <img src="{{ asset('frontend/assets/cs/dist') }}/images/_473_659eb34674076_img-4.jpg"
                            loading="lazy" class="w-100 rounded-3" width="449" height="330" alt="">
                    </picture>
                </div>
            </div>
            <div class="row p-4 align-items-center rounded-3 border shadow mb-5">
                <div class="col-lg-7 ">
                    <h3 class=" fw-bold lh-1">{{aiTrans('Rozplétání složitých konceptů')}}</h3>
                    <input type="checkbox" id="mustknow-checkbox1">
                    <div class="lead">
                        <p>{{aiTrans('Oblast investic je protkána mnohostrannými otázkami, často záhadnými a obtížně rozluštitelnými.')}}
                        </p>
                        <p>
                            {{ aiTrans(
                                'V tomto okamžiku se [website_title] ukazuje jako zásadní hráč, který demystifikuje tato
                                hustá témata tím, že poskytuje bezproblémový přístup k ostříleným profesionálům v oboru.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                        <label for="mustknow-checkbox1" class="text-decoration-underline fw-bold fs-5">{{aiTrans('Přečtěte si vše')}}</label>
                    </div>
                </div>
                <div class="col-lg-4 offset-lg-1 p-0 overflow-hidden shadow h-100">
                    <picture>
                        <source
                            srcset="{{ asset('frontend/assets/cs/dist') }}/images/349_449__473_659eb36075b92_img-5.webp"
                            type="image/webp">
                        <source srcset="{{ asset('frontend/assets/cs/dist') }}/images/_473_659eb36075b92_img-5.jpg"
                            type="image/jpeg">
                        <img src="{{ asset('frontend/assets/cs/dist') }}/images/_473_659eb36075b92_img-5.jpg"
                            loading="lazy" class="w-100 rounded-3" width="449" height="349" alt="">
                    </picture>
                </div>
            </div>
            <div class="row p-4 align-items-center rounded-3 border shadow mb-5">
                <div class="col-lg-7 ">
                    <h3 class=" fw-bold lh-1">{{aiTrans('Přijetí neustálého učení a adaptace')}}</h3>
                    <input type="checkbox" id="mustknow-checkbox2">
                    <div class="lead">
                        <p>{{aiTrans('Oblast investic, která se v mnohém podobá dynamickému terénu technologií a krejčovských trendů,
                            je v neúprosném stavu transformace.')}}</p>
                        <p>
                            {{ aiTrans(
                                'Se změnou tržních proudů vyvstává zásadní potřeba udržovat nad tímto odvětvím ostražitou dohled.
                                [website_title] se ukazuje jako zásadní maják, který studentům umožňuje nejnovější pokroky
                                v investičních strategiích a obdařuje je příslušnou moudrostí a kritickou prozíravostí, aby
                                mohli vzkvétat v tak živém prostředí. Navštivte oficiální web [website_title],
                                prozkoumejte aplikaci [website_title] nebo si přečtěte recenzi [website_title],
                                abyste si udrželi náskok před platformou [website_title] v 2024.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                        <label for="mustknow-checkbox2" class="text-decoration-underline fw-bold fs-5">{{aiTrans('Přečtěte si vše')}}</label>
                    </div>
                </div>
                <div class="col-lg-4 offset-lg-1 p-0 overflow-hidden shadow h-100">
                    <picture>
                        <source
                            srcset="{{ asset('frontend/assets/cs/dist') }}/images/313_449__473_659eb374aa8ca_img-6.webp"
                            type="image/webp">
                        <source srcset="{{ asset('frontend/assets/cs/dist') }}/images/_473_659eb374aa8ca_img-6.jpg"
                            type="image/jpeg">
                        <img src="{{ asset('frontend/assets/cs/dist') }}/images/_473_659eb374aa8ca_img-6.jpg"
                            loading="lazy" class="w-100 rounded-3" width="449" height="313" alt="">
                    </picture>
                </div>
            </div>
            <div class="text-center mt-3 mt-md-4">
                <button class="show-modal btn  text-white btn-primary text-uppercase btn-lg shadow-lg px-3 px-md-5 fs-4">
                    {{ aiTrans(
                        'PROZKOUMAT [website_title]',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    
                </button>
            </div>
        </div>
    </section>

    <section class="py-5 bg-phone text-white">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <h2 class="display-5 fw-bold mb-4">
                        {{aiTrans('Top 3 BTC předpovědi!')}}
                    </h2>
                    <p class="fw-bold fs-4 test-uppercase">
                        {{ aiTrans(
                            'Můžete být obchodníkem s bitcoiny jako mnoho dalších po celém světě, když se zaregistrujete u
                            [website_title].',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        
                    </p>
                </div>
                <div class="col-lg-4 d-flex flex-column">
                    <div class="mb-4 position-relative px-5">
                        <div class="position-absolute start-0">
                            <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor"
                                class="bi bi-check-circle-fill text-success" viewBox="0 0 16 16">
                                <path
                                    d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-3.97-3.03a.75.75 0 0 0-1.08.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-.01-1.05z">
                                </path>
                            </svg>
                        </div>
                        <div>
                            <p>{{aiTrans('Bitcoin dosáhne příští rok 90% mainstreamové adopce - Matrixport')}}</p>
                        </div>
                    </div>
                    <div class="mb-4 position-relative px-5">
                        <div class="position-absolute start-0">
                            <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor"
                                class="bi bi-check-circle-fill text-success" viewBox="0 0 16 16">
                                <path
                                    d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-3.97-3.03a.75.75 0 0 0-1.08.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-.01-1.05z">
                                </path>
                            </svg>
                        </div>
                        <div>
                            <p>{{aiTrans('Očekávejte mimořádný nárůst v oblasti bitcoinů, přičemž prognózy naznačují pozoruhodný vzestup na 45 000 USD do 1. března.')}}</p>
                        </div>
                    </div>
                    <div class="mb-4 position-relative px-5">
                        <div class="position-absolute start-0">
                            <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor"
                                class="bi bi-check-circle-fill text-success" viewBox="0 0 16 16">
                                <path
                                    d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-3.97-3.03a.75.75 0 0 0-1.08.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-.01-1.05z">
                                </path>
                            </svg>
                        </div>
                        <div>
                            <p>{{aiTrans('Bitcoin dosáhne 130 000 $ do konce příštího roku – Cointelegraph')}}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="py-5">
        <div class="container">
            <h2 class="display-5 fw-bold mb-5 text-center">
                {{aiTrans('Nejčastější dotazy')}}
            </h2>
            <div class="row">
                <div class="accordion mx-auto">
                    <div class="accordion-item mb-4">
                        <h3 class="accordion-header" id="heading0">
                            <button class="accordion-button collapsed rounded-3 fs-4 shadow-lg p-4" type="button"
                                data-bs-toggle="collapse" data-bs-target="#collapse0" aria-expanded="false"
                                aria-controls="collapse0">

                                {{ aiTrans(
                                    'Potřebuji před použitím [website_title] předchozí znalosti?',
                                    $locale,
                                    ['website_title' => $website_title],
                                ) }}
                                
                            </button>
                        </h3>
                        <div id="collapse0" class="accordion-collapse collapse" aria-labelledby="heading0"
                            data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p>
                                    {{ aiTrans(
                                        '[website_title] je skutečně vytvořen tak, aby přivítal nováčky i ty, kteří mají
                                        špetku odborných znalostí.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                    </p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item mb-4">
                        <h3 class="accordion-header" id="heading1">
                            <button class="accordion-button collapsed rounded-3 fs-4 shadow-lg p-4" type="button"
                                data-bs-toggle="collapse" data-bs-target="#collapse1" aria-expanded="false"
                                aria-controls="collapse1">
                                {{aiTrans('Nabízí tato webová stránka investiční poradenství?')}}
                            </button>
                        </h3>
                        <div id="collapse1" class="accordion-collapse collapse" aria-labelledby="heading1"
                            data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p>
                                    {{ aiTrans(
                                        'Na rozdíl od služeb, které by se daly očekávat, se [website_title] zdržuje nabízení
                                        poradenství nebo služeb týkajících se investičních strategií. Místo toho je jeho hlavním
                                        posláním sloužit jako spojovací článek, který spojuje jednotlivce s váženými
                                        vzdělávacími zařízeními zaměřenými na předávání investiční prozíravosti.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                    </p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item mb-4">
                        <h3 class="accordion-header" id="heading2">
                            <button class="accordion-button collapsed rounded-3 fs-4 shadow-lg p-4" type="button"
                                data-bs-toggle="collapse" data-bs-target="#collapse2" aria-expanded="false"
                                aria-controls="collapse2">

                                {{ aiTrans(
                                    'Jak si [website_title] vybírá své partnerské vzdělávací firmy?',
                                    $locale,
                                    ['website_title' => $website_title],
                                ) }}
                                
                            </button>
                        </h3>
                        <div id="collapse2" class="accordion-collapse collapse" aria-labelledby="heading2"
                            data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p>
                                    {{ aiTrans(
                                        'Ve spojenectví s významnými vzdělávacími subjekty specializujícími se na investiční
                                        prozíravost zaručuje [website_title] svým uživatelům prvotřídní pedagogickou
                                        cestu. Od roku 2024 je [website_title] majákem pro ty, kteří hledají osvícení ve
                                        fiskálních záležitostech.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                    </p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item mb-4">
                        <h3 class="accordion-header" id="heading3">
                            <button class="accordion-button collapsed rounded-3 fs-4 shadow-lg p-4" type="button"
                                data-bs-toggle="collapse" data-bs-target="#collapse3" aria-expanded="false"
                                aria-controls="collapse3">
                                {{aiTrans('Je tato webová stránka zdarma?')}}
                            </button>
                        </h3>
                        <div id="collapse3" class="accordion-collapse collapse" aria-labelledby="heading3"
                            data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p>
                                    {{ aiTrans(
                                        'Základní cíl [website_title] se skutečně točí kolem vytváření cest k doplňkovým
                                        akademickým materiálům, které zajišťují, že uživatelům nevzniknou žádné náklady.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    ) }}
                                    </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="text-center mt-3 mt-md-4">
                <button class="show-modal btn  text-white btn-primary text-uppercase btn-lg shadow-lg px-3 px-md-5 fs-4">
                    {{aiTrans('Další informace o službách platformy')}}
                </button>
            </div>
        </div>
    </section>

    <section class="py-5">
        <div class="container">
            <h2 class="display-5 fw-bold mb-5 text-center">
                {{ aiTrans(
                    '[website_title] Přednosti',
                    $locale,
                    ['website_title' => $website_title],
                ) }}
            </h2>
            <div class="row">
                <figure class="table">
                    <table>
                        <tbody>
                            <tr>
                                <td><strong>🤖 {{aiTrans('Náklady na registraci')}}</strong></td>
                                <td><strong>{{aiTrans('Bez poplatku')}}</strong></td>
                            </tr>
                            <tr>
                                <td><strong>📋 {{aiTrans('Registrace')}}</strong></td>
                                <td><strong>{{aiTrans('Rychlý a přímočarý proces')}}</strong></td>
                            </tr>
                            <tr>
                                <td><strong>💰 {{aiTrans('Finanční poplatky')}}</strong></td>
                                <td><strong>{{aiTrans('Žádné další poplatky')}}</strong></td>
                            </tr>
                            <tr>
                                <td><strong>💱 {{aiTrans('Zaměření na vzdělávání')}}</strong></td>
                                <td><strong>{{aiTrans('Kryptoměny, forex, podílové fondy a další investice')}}</strong></td>
                            </tr>
                            <tr>
                                <td><strong>📊 {{aiTrans('Typ nástupiště')}}</strong></td>
                                <td><strong>{{aiTrans('Internetové, přístupné prostřednictvím libovolného webového prohlížeče')}}</strong>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>🌎 {{aiTrans('Země')}}</strong></td>
                                <td><strong>{{aiTrans('Většina zemí – kromě USA')}}</strong></td>
                            </tr>
                        </tbody>
                    </table>
                </figure>
            </div>
        </div>
    </section>
@endsection
